/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.exceptions;

import joptsimple.OptionException;
import org.apache.geode.management.internal.cli.exceptions.CliCommandOptionException;
import org.apache.geode.management.internal.cli.exceptions.CliCommandOptionHasMultipleValuesException;
import org.apache.geode.management.internal.cli.exceptions.CliCommandOptionMissingException;
import org.apache.geode.management.internal.cli.exceptions.CliCommandOptionNotApplicableException;
import org.apache.geode.management.internal.cli.exceptions.CliCommandOptionValueMissingException;
import org.apache.geode.management.internal.cli.parser.Option;

public class ExceptionGenerator {
    public static CliCommandOptionException generate(Option option, OptionException cause) {
        if (cause.getClass().getSimpleName().contains("MissingRequiredOptionException")) {
            return new CliCommandOptionMissingException(option, (Throwable)cause);
        }
        if (cause.getClass().getSimpleName().contains("OptionMissingRequiredArgumentException")) {
            return new CliCommandOptionValueMissingException(option, (Throwable)cause);
        }
        if (cause.getClass().getSimpleName().contains("UnrecognizedOptionException")) {
            return new CliCommandOptionNotApplicableException(option, (Throwable)cause);
        }
        if (cause.getClass().getSimpleName().contains("MultipleArgumentsForOptionException")) {
            return new CliCommandOptionHasMultipleValuesException(option, (Throwable)cause);
        }
        return new CliCommandOptionException(cause);
    }
}

