/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.converters;

import java.io.File;
import java.util.List;
import org.apache.geode.management.internal.cli.MultipleValueAdapter;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.MethodTarget;
import org.springframework.shell.support.util.FileUtils;
import org.springframework.util.Assert;

public class DirConverter
extends MultipleValueAdapter<String[]> {
    private static final String HOME_DIRECTORY_SYMBOL = "~";
    private static final String home = System.getProperty("user.home");

    @Override
    public String[] convertFromText(String[] values, Class<?> targetType, String context) {
        return values;
    }

    @Override
    public boolean getAllPossibleValues(List<Completion> completions, Class<?> targetType, String[] existingData, String context, MethodTarget target) {
        String adjustedUserInput = this.convertUserInputIntoAFullyQualifiedPath(existingData != null ? existingData[existingData.length - 1] : "");
        String directoryData = adjustedUserInput.substring(0, adjustedUserInput.lastIndexOf(File.separator) + 1);
        adjustedUserInput = adjustedUserInput.substring(adjustedUserInput.lastIndexOf(File.separator) + 1);
        this.populate(completions, adjustedUserInput, existingData != null ? existingData[existingData.length - 1] : "", directoryData);
        return true;
    }

    protected void populate(List<Completion> completions, String adjustedUserInput, String originalUserInput, String directoryData) {
        File directory = new File(directoryData);
        if (!directory.isDirectory()) {
            return;
        }
        for (File file : directory.listFiles()) {
            if (adjustedUserInput != null && adjustedUserInput.length() != 0 && !file.getName().toLowerCase().startsWith(adjustedUserInput.toLowerCase())) continue;
            String completion = "";
            if (directoryData.length() > 0) {
                completion = completion + directoryData;
            }
            completion = completion + file.getName();
            completion = this.convertCompletionBackIntoUserInputStyle(originalUserInput, completion);
            if (!file.isDirectory()) continue;
            completions.add(new Completion(completion + File.separator));
        }
    }

    private String convertCompletionBackIntoUserInputStyle(String originalUserInput, String completion) {
        if (FileUtils.denotesAbsolutePath((String)originalUserInput)) {
            return completion;
        }
        if (originalUserInput.startsWith(HOME_DIRECTORY_SYMBOL)) {
            Assert.notNull((Object)home, (String)"Home directory could not be determined from system properties");
            return HOME_DIRECTORY_SYMBOL + completion.substring(home.length());
        }
        return completion.substring(this.getWorkingDirectoryAsString().length());
    }

    private String convertUserInputIntoAFullyQualifiedPath(String userInput) {
        if (FileUtils.denotesAbsolutePath((String)userInput)) {
            return userInput;
        }
        if (userInput.startsWith(HOME_DIRECTORY_SYMBOL)) {
            Assert.notNull((Object)home, (String)"Home directory could not be determined from system properties");
            if (userInput.length() > 1) {
                return home + userInput.substring(1);
            }
        }
        String fullPath = this.getWorkingDirectoryAsString() + userInput;
        return fullPath;
    }

    private String getWorkingDirectoryAsString() {
        try {
            return this.getWorkingDirectory().getCanonicalPath() + File.separator;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private File getWorkingDirectory() {
        return Gfsh.getCurrentInstance().getHome();
    }

    public boolean supports(Class<?> type, String optionContext) {
        return String[].class.isAssignableFrom(type) && optionContext.equals("converter.hint.dirs");
    }
}

