/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.AbstractCommandsSupport;
import org.apache.geode.management.internal.cli.domain.AsyncEventQueueDetails;
import org.apache.geode.management.internal.cli.functions.AsyncEventQueueFunctionArgs;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.CreateAsyncEventQueueFunction;
import org.apache.geode.management.internal.cli.functions.ListAsyncEventQueuesFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResultException;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class QueueCommands
extends AbstractCommandsSupport {
    @CliCommand(value={"create async-event-queue"}, help="Create Async Event Queue.")
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public Result createAsyncEventQueue(@CliOption(key={"id"}, mandatory=true, help="ID of the queue to be created.") String id, @CliOption(key={"group"}, unspecifiedDefaultValue="__NULL__", optionContext="converter.hint.member.groups", help="Group(s) of members on which queue will be created. If no group is specified the queue will be created on all members.") String[] groups, @CliOption(key={"parallel"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether this queue is parallel.") Boolean parallel, @CliOption(key={"enable-batch-conflation"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether to enable batch conflation.") Boolean enableBatchConflation, @CliOption(key={"batch-size"}, unspecifiedDefaultValue="100", help="Maximum number of events that a batch can contain.") int batchSize, @CliOption(key={"batch-time-interval"}, unspecifiedDefaultValue="1000", help="Maximum amount of time, in ms, that can elapse before a batch is delivered.") int batchTimeInterval, @CliOption(key={"persistent"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether events should be persisted to a disk store.") boolean persistent, @CliOption(key={"disk-store"}, unspecifiedDefaultValue="__NULL__", help="Disk store to be used by this queue.") String diskStore, @CliOption(key={"disk-synchronous"}, unspecifiedDefaultValue="true", specifiedDefaultValue="true", help="Whether disk writes are synchronous.") Boolean diskSynchronous, @CliOption(key={"forward-expiration-destroy"}, unspecifiedDefaultValue="false", specifiedDefaultValue="false", help="Whether to forward expiration destroy events.") Boolean ignoreEvictionAndExpiration, @CliOption(key={"max-queue-memory"}, unspecifiedDefaultValue="100", help="Maximum amount of memory, in megabytes, that the queue can consume before overflowing to disk.") int maxQueueMemory, @CliOption(key={"dispatcher-threads"}, unspecifiedDefaultValue="1", help="Number of threads to use for sending events.") Integer dispatcherThreads, @CliOption(key={"order-policy"}, unspecifiedDefaultValue="KEY", help="Policy for dispatching events when --dispatcher-threads is > 1. Possible values are 'THREAD', 'KEY', 'PARTITION'.") String orderPolicy, @CliOption(key={"gateway-event-filter"}, help="List of fully qualified class names of GatewayEventFilters for this queue.  These classes filter events before dispatching to remote servers.") @CliMetaData(valueSeparator=",") String[] gatewayEventFilters, @CliOption(key={"gateway-event-substitution-filter"}, help="Fully qualified class name of the GatewayEventSubstitutionFilter for this queue.") String gatewaySubstitutionListener, @CliOption(key={"listener"}, mandatory=true, help="Fully qualified class name of the AsyncEventListener for this queue.") String listener, @CliOption(key={"listener-param"}, help="Parameter name for the AsyncEventListener.  Optionally, parameter names may be followed by # and a value for the parameter.  Example: --listener-param=loadAll --listener-param=maxRead#1024", optionContext="converter.hint.disable-string-converter") @CliMetaData(valueSeparator=",") String[] listenerParamsAndValues) {
        Properties listenerProperties = new Properties();
        try {
            Set<DistributedMember> targetMembers;
            if (listenerParamsAndValues != null) {
                for (int i = 0; i < listenerParamsAndValues.length; ++i) {
                    int hashPosition = listenerParamsAndValues[i].indexOf(35);
                    if (hashPosition == -1) {
                        listenerProperties.put(listenerParamsAndValues[i], "");
                        continue;
                    }
                    listenerProperties.put(listenerParamsAndValues[i].substring(0, hashPosition), listenerParamsAndValues[i].substring(hashPosition + 1));
                }
            }
            TabularResultData tabularData = ResultBuilder.createTabularResultData();
            boolean accumulatedData = false;
            try {
                targetMembers = CliUtil.findMembersOrThrow(groups, null);
            }
            catch (CommandResultException crex) {
                return crex.getResult();
            }
            AsyncEventQueueFunctionArgs aeqArgs = new AsyncEventQueueFunctionArgs(id, parallel, enableBatchConflation, batchSize, batchTimeInterval, persistent, diskStore, diskSynchronous, maxQueueMemory, dispatcherThreads, orderPolicy, gatewayEventFilters, gatewaySubstitutionListener, listener, listenerProperties, ignoreEvictionAndExpiration);
            ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)new CreateAsyncEventQueueFunction(), (Object)aeqArgs, targetMembers);
            List<CliFunctionResult> results = CliFunctionResult.cleanResults((List)rc.getResult());
            AtomicReference<XmlEntity> xmlEntity = new AtomicReference<XmlEntity>();
            for (CliFunctionResult result : results) {
                if (result.getThrowable() != null) {
                    tabularData.accumulate("Member", result.getMemberIdOrName());
                    tabularData.accumulate("Result", "ERROR: " + result.getThrowable().getClass().getName() + ": " + result.getThrowable().getMessage());
                    accumulatedData = true;
                    tabularData.setStatus(Result.Status.ERROR);
                    continue;
                }
                if (!result.isSuccessful()) continue;
                tabularData.accumulate("Member", result.getMemberIdOrName());
                tabularData.accumulate("Result", result.getMessage());
                accumulatedData = true;
                if (xmlEntity.get() != null) continue;
                xmlEntity.set(result.getXmlEntity());
            }
            if (!accumulatedData) {
                return ResultBuilder.createInfoResult("Unable to create async event queue(s).");
            }
            Result result = ResultBuilder.buildResult(tabularData);
            if (xmlEntity.get() != null) {
                this.persistClusterConfiguration(result, () -> this.getSharedConfiguration().addXmlEntity((XmlEntity)xmlEntity.get(), groups));
            }
            return result;
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            return ResultBuilder.createGemFireErrorResult(CliStrings.format("An error occurred while creating the queue: {0}", new Object[]{th.getMessage()}));
        }
    }

    @CliCommand(value={"list async-event-queues"}, help="Display the Async Event Queues for all members.")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result listAsyncEventQueues() {
        try {
            Set<DistributedMember> targetMembers;
            TabularResultData tabularData = ResultBuilder.createTabularResultData();
            boolean accumulatedData = false;
            try {
                targetMembers = CliUtil.findMembersOrThrow((String)null, (String)null);
            }
            catch (CommandResultException crex) {
                return crex.getResult();
            }
            ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)new ListAsyncEventQueuesFunction(), (Object)new Object[0], targetMembers);
            List<CliFunctionResult> results = CliFunctionResult.cleanResults((List)rc.getResult());
            for (CliFunctionResult result : results) {
                if (result.getThrowable() != null) {
                    tabularData.accumulate("Member", result.getMemberIdOrName());
                    tabularData.accumulate("Result", "ERROR: " + result.getThrowable().getClass().getName() + ": " + result.getThrowable().getMessage());
                    accumulatedData = true;
                    tabularData.setStatus(Result.Status.ERROR);
                    continue;
                }
                AsyncEventQueueDetails[] details = (AsyncEventQueueDetails[])result.getSerializables();
                for (int i = 0; i < details.length; ++i) {
                    tabularData.accumulate("Member", result.getMemberIdOrName());
                    tabularData.accumulate("ID", details[i].getId());
                    tabularData.accumulate("Batch Size", details[i].getBatchSize());
                    tabularData.accumulate("Persistent", details[i].isPersistent());
                    tabularData.accumulate("Disk Store", details[i].getDiskStoreName());
                    tabularData.accumulate("Max Memory", details[i].getMaxQueueMemory());
                    Properties listenerProperties = details[i].getListenerProperties();
                    if (listenerProperties == null || listenerProperties.size() == 0) {
                        tabularData.accumulate("Listener", details[i].getListener());
                    } else {
                        StringBuilder propsStringBuilder = new StringBuilder();
                        propsStringBuilder.append('(');
                        boolean firstProperty = true;
                        for (Map.Entry<Object, Object> property : listenerProperties.entrySet()) {
                            if (!firstProperty) {
                                propsStringBuilder.append(',');
                            } else {
                                firstProperty = false;
                            }
                            propsStringBuilder.append(property.getKey()).append('=').append(property.getValue());
                        }
                        propsStringBuilder.append(')');
                        tabularData.accumulate("Listener", details[i].getListener() + propsStringBuilder.toString());
                    }
                    accumulatedData = true;
                }
            }
            if (!accumulatedData) {
                return ResultBuilder.createInfoResult("No Async Event Queues Found");
            }
            return ResultBuilder.buildResult(tabularData);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            return ResultBuilder.createGemFireErrorResult(CliStrings.format("An error occurred while collecting queue information: \"{0}\"", new Object[]{th.getMessage()}));
        }
    }

    @CliAvailabilityIndicator(value={"create async-event-queue", "list async-event-queues"})
    public boolean queueCommandsAvailable() {
        boolean isAvailable = true;
        if (CliUtil.isGfshVM()) {
            isAvailable = QueueCommands.getGfsh() != null && QueueCommands.getGfsh().isConnectedAndReady();
        }
        return isAvailable;
    }
}

