/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.CacheServerMXBean;
import org.apache.geode.management.ClientHealthStatus;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.functions.ContunuousQueryFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ClientCommands
implements CommandMarker {
    private Gfsh getGfsh() {
        return Gfsh.getCurrentInstance();
    }

    @CliCommand(value={"list clients"}, help="Display list of connected clients")
    @CliMetaData(relatedTopic={"Display list of connected clients"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result listClient() {
        Result result = null;
        try {
            CompositeResultData compositeResultData = ResultBuilder.createCompositeResultData();
            CompositeResultData.SectionResultData section = compositeResultData.addSection("section1");
            TabularResultData resultTable = section.addTable("TableForClientList");
            String headerText = "ClientList";
            resultTable = resultTable.setHeader(headerText);
            Cache cache = CacheFactory.getAnyInstance();
            ManagementService service = ManagementService.getExistingManagementService(cache);
            ObjectName[] cacheServers = service.getDistributedSystemMXBean().listCacheServerObjectNames();
            if (cacheServers.length == 0) {
                return ResultBuilder.createGemFireErrorResult(CliStrings.format("No cache-servers were observed.", new Object[0]));
            }
            HashMap clientServerMap = new HashMap();
            for (ObjectName objName : cacheServers) {
                CacheServerMXBean serverMbean = service.getMBeanInstance(objName, CacheServerMXBean.class);
                String[] listOfClient = serverMbean.getClientIds();
                if (listOfClient == null || listOfClient.length == 0) continue;
                for (String clietName : listOfClient) {
                    String serverDetails = "member=" + objName.getKeyProperty("member") + ",port=" + objName.getKeyProperty("port");
                    if (clientServerMap.containsKey(clietName)) {
                        List listServers = (List)clientServerMap.get(clietName);
                        listServers.add(serverDetails);
                        continue;
                    }
                    ArrayList<String> listServer = new ArrayList<String>();
                    listServer.add(serverDetails);
                    clientServerMap.put(clietName, listServer);
                }
            }
            if (clientServerMap.size() == 0) {
                return ResultBuilder.createGemFireErrorResult(CliStrings.format("No clients were retrieved for cache-servers.", new Object[0]));
            }
            String memberSeparator = ";  ";
            for (Map.Entry pairs : clientServerMap.entrySet()) {
                String client = (String)pairs.getKey();
                List servers = (List)pairs.getValue();
                StringBuilder serverListForClient = new StringBuilder();
                int serversSize = servers.size();
                int i = 0;
                for (String server : servers) {
                    serverListForClient.append(server);
                    if (i < serversSize - 1) {
                        serverListForClient.append(memberSeparator);
                    }
                    ++i;
                }
                resultTable.accumulate("Client Name / ID", client);
                resultTable.accumulate("Server Name / ID", serverListForClient.toString());
            }
            result = ResultBuilder.buildResult(compositeResultData);
        }
        catch (Exception e) {
            LogWrapper.getInstance().warning("Error in list clients. stack trace" + CliUtil.stackTraceAsString(e));
            result = ResultBuilder.createGemFireErrorResult(CliStrings.format("Could not retrieve list of clients. Reason : {0}", (Object)e.getMessage()));
        }
        LogWrapper.getInstance().info("list client result " + result);
        return result;
    }

    @CliCommand(value={"describe client"}, help="Display details of specified client")
    @CliMetaData(relatedTopic={"Display list of connected clients"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result describeClient(@CliOption(key={"clientID"}, mandatory=true, help="ID of a client for which details are needed") String clientId) {
        Result result = null;
        if (clientId.startsWith("\"")) {
            clientId = clientId.substring(1);
        }
        if (clientId.endsWith("\"")) {
            clientId = clientId.substring(0, clientId.length() - 2);
        }
        if (clientId.endsWith("\";")) {
            clientId = clientId.substring(0, clientId.length() - 2);
        }
        try {
            CompositeResultData compositeResultData = ResultBuilder.createCompositeResultData();
            CompositeResultData.SectionResultData sectionResult = compositeResultData.addSection("InfoSection");
            Cache cache = CacheFactory.getAnyInstance();
            ManagementService service = ManagementService.getExistingManagementService(cache);
            ObjectName[] cacheServers = service.getDistributedSystemMXBean().listCacheServerObjectNames();
            if (cacheServers.length == 0) {
                return ResultBuilder.createGemFireErrorResult(CliStrings.format("No cache-servers were observed.", new Object[0]));
            }
            ClientHealthStatus clientHealthStatus = null;
            for (ObjectName objName : cacheServers) {
                CacheServerMXBean serverMbean = service.getMBeanInstance(objName, CacheServerMXBean.class);
                ArrayList<String> listOfClient = new ArrayList<String>(Arrays.asList(serverMbean.getClientIds()));
                if (!listOfClient.contains(clientId) || clientHealthStatus != null) continue;
                try {
                    clientHealthStatus = serverMbean.showClientStats(clientId);
                    if (clientHealthStatus != null) continue;
                    return ResultBuilder.createGemFireErrorResult(CliStrings.format("Could not retrieve stats for client : {0}", (Object)clientId));
                }
                catch (Exception eee) {
                    return ResultBuilder.createGemFireErrorResult(CliStrings.format("Could not retrieve stats for client : {0}. Reason : {1}", clientId, eee.getMessage()));
                }
            }
            if (clientHealthStatus == null) {
                return ResultBuilder.createGemFireErrorResult(CliStrings.format("Specified Client ID {0} not present", (Object)clientId));
            }
            Set<DistributedMember> dsMembers = CliUtil.getAllMembers(cache);
            String isDurable = null;
            ArrayList<String> primaryServers = new ArrayList<String>();
            ArrayList<String> secondaryServers = new ArrayList<String>();
            if (dsMembers.size() > 0) {
                ContunuousQueryFunction contunuousQueryFunction = new ContunuousQueryFunction();
                FunctionService.registerFunction(contunuousQueryFunction);
                List resultList = (List)CliUtil.executeFunction((Function)contunuousQueryFunction, (Object)clientId, dsMembers).getResult();
                for (int i = 0; i < resultList.size(); ++i) {
                    try {
                        Object object = resultList.get(i);
                        if (object instanceof Exception) {
                            LogWrapper.getInstance().warning("Exception in Describe Client " + ((Throwable)object).getMessage(), (Throwable)object);
                            continue;
                        }
                        if (object instanceof Throwable) {
                            LogWrapper.getInstance().warning("Exception in Describe Client " + ((Throwable)object).getMessage(), (Throwable)object);
                            continue;
                        }
                        if (object == null) continue;
                        ContunuousQueryFunction.ClientInfo objectResult = (ContunuousQueryFunction.ClientInfo)object;
                        isDurable = objectResult.isDurable;
                        if (objectResult.primaryServer != null && objectResult.primaryServer.length() > 0) {
                            if (primaryServers.size() == 0) {
                                primaryServers.add(objectResult.primaryServer);
                            } else {
                                primaryServers.add(" ,");
                                primaryServers.add(objectResult.primaryServer);
                            }
                        }
                        if (objectResult.secondaryServer == null || objectResult.secondaryServer.length() <= 0) continue;
                        if (secondaryServers.size() == 0) {
                            secondaryServers.add(objectResult.secondaryServer);
                            continue;
                        }
                        secondaryServers.add(" ,");
                        secondaryServers.add(objectResult.secondaryServer);
                        continue;
                    }
                    catch (Exception e) {
                        LogWrapper.getInstance().info("Error occured while fetching stats. Reason : {0} :: " + CliUtil.stackTraceAsString(e));
                        return ResultBuilder.createGemFireErrorResult(CliStrings.format("Error occured while fetching stats. Reason : {0}", (Object)e.getMessage()));
                    }
                }
            } else {
                return ResultBuilder.createGemFireErrorResult("DS has no members");
            }
            this.buildTableResult(sectionResult, clientHealthStatus, isDurable, primaryServers, secondaryServers);
            result = ResultBuilder.buildResult(compositeResultData);
        }
        catch (Exception e) {
            LogWrapper.getInstance().info("Error in decribe clients. stack trace" + CliUtil.stackTraceAsString(e));
            result = ResultBuilder.createGemFireErrorResult(CliStrings.format("Could not retrieve client. Reason : {0}", (Object)e.getMessage()));
        }
        LogWrapper.getInstance().info("decribe client result " + result);
        return result;
    }

    private void buildTableResult(CompositeResultData.SectionResultData sectionResult, ClientHealthStatus clientHealthStatus, String isDurable, List<String> primaryServers, List<String> secondaryServers) {
        StringBuilder primServers = new StringBuilder();
        for (String string : primaryServers) {
            primServers.append(string);
        }
        StringBuilder secondServers = new StringBuilder();
        for (String secondServer : secondaryServers) {
            secondServers.append(secondServer);
        }
        if (clientHealthStatus != null) {
            sectionResult.addSeparator('-');
            sectionResult.addData("Primary Servers", primServers);
            sectionResult.addData("Secondary Servers", secondServers);
            sectionResult.addData("CPU", clientHealthStatus.getCpus());
            sectionResult.addData("Number of Cache Listner Calls", clientHealthStatus.getNumOfCacheListenerCalls());
            sectionResult.addData("Number of Gets", clientHealthStatus.getNumOfGets());
            sectionResult.addData("Number of Misses", clientHealthStatus.getNumOfMisses());
            sectionResult.addData("Number of Puts", clientHealthStatus.getNumOfPuts());
            sectionResult.addData("Number of Threads", clientHealthStatus.getNumOfThreads());
            sectionResult.addData("Process CPU Time (nanoseconds)", clientHealthStatus.getProcessCpuTime());
            sectionResult.addData("Queue size", clientHealthStatus.getQueueSize());
            sectionResult.addData("UP Time (seconds)", clientHealthStatus.getUpTime());
            sectionResult.addData("Is Durable", isDurable);
            sectionResult.addSeparator('-');
            Map<String, String> map = clientHealthStatus.getPoolStats();
            if (map.size() > 0) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    TabularResultData poolStatsResultTable = sectionResult.addTable("Pool Stats For Pool Name = " + entry.getKey());
                    poolStatsResultTable.setHeader("Pool Stats For Pool Name = " + entry.getKey());
                    String poolStatsStr = entry.getValue();
                    String[] str = poolStatsStr.split(";");
                    LogWrapper.getInstance().info("decribe client clientHealthStatus min conn=" + str[0].substring(str[0].indexOf("=") + 1));
                    LogWrapper.getInstance().info("decribe client clientHealthStatus max conn =" + str[1].substring(str[1].indexOf("=") + 1));
                    LogWrapper.getInstance().info("decribe client clientHealthStatus redundancy =" + str[2].substring(str[2].indexOf("=") + 1));
                    LogWrapper.getInstance().info("decribe client clientHealthStatus CQs =" + str[3].substring(str[3].indexOf("=") + 1));
                    poolStatsResultTable.accumulate("Minimum Connections", str[0].substring(str[0].indexOf("=") + 1));
                    poolStatsResultTable.accumulate("Maximum Connections", str[1].substring(str[1].indexOf("=") + 1));
                    poolStatsResultTable.accumulate("Redudancy", str[2].substring(str[2].indexOf("=") + 1));
                    poolStatsResultTable.accumulate("Num of CQs", str[3].substring(str[3].indexOf("=") + 1));
                }
            }
        }
    }

    @CliAvailabilityIndicator(value={"list clients", "describe client"})
    public boolean clientCommandsAvailable() {
        boolean isAvailable = true;
        if (CliUtil.isGfshVM()) {
            isAvailable = this.getGfsh() != null && this.getGfsh().isConnectedAndReady();
        }
        return isAvailable;
    }
}

