/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.cli;

import java.util.Collections;
import java.util.Map;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.management.DependenciesNotFoundException;
import org.apache.geode.management.cli.CommandServiceException;
import org.apache.geode.management.cli.CommandStatement;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.remote.MemberCommandService;

public abstract class CommandService {
    protected static final Map<String, String> EMPTY_ENV = Collections.emptyMap();
    private static CommandService localCommandService;

    public abstract boolean isUsable();

    public abstract Result processCommand(String var1);

    protected abstract Result processCommand(String var1, Map<String, String> var2);

    public abstract CommandStatement createCommandStatement(String var1);

    protected abstract CommandStatement createCommandStatement(String var1, Map<String, String> var2);

    public static final CommandService createLocalCommandService(Cache cache) throws CommandServiceException {
        if (cache == null || cache.isClosed()) {
            throw new CacheClosedException("Can not create command service as cache doesn't exist or cache is closed.");
        }
        if (localCommandService == null || !localCommandService.isUsable()) {
            String nonExistingDependency = CliUtil.cliDependenciesExist(false);
            if (nonExistingDependency != null) {
                throw new DependenciesNotFoundException(LocalizedStrings.CommandServiceManager_COULD_NOT_FIND__0__LIB_NEEDED_FOR_CLI_GFSH.toLocalizedString(nonExistingDependency));
            }
            localCommandService = new MemberCommandService(cache);
        }
        return localCommandService;
    }

    public static final CommandService getUsableLocalCommandService() {
        if (localCommandService != null && localCommandService.isUsable()) {
            return localCommandService;
        }
        return null;
    }
}

