/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.tcp;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.MembershipManager;
import org.apache.geode.distributed.internal.membership.gms.mgr.GMSMembershipManager;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.SystemTimer;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingThreadGroup;
import org.apache.geode.internal.logging.log4j.AlertAppender;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.net.SocketCloser;
import org.apache.geode.internal.tcp.Connection;
import org.apache.geode.internal.tcp.ConnectionException;
import org.apache.geode.internal.tcp.ReenteredConnectException;
import org.apache.geode.internal.tcp.TCPConduit;
import org.apache.logging.log4j.Logger;

public class ConnectionTable {
    private static final Logger logger = LogService.getLogger();
    private static boolean ulimitWarningIssued;
    private static ThreadLocal threadWantsOwnResources;
    protected final Map orderedConnectionMap = new ConcurrentHashMap();
    private final ThreadLocal threadOrderedConnMap;
    private final List threadConnMaps;
    private SystemTimer idleConnTimer;
    private ConcurrentMap threadConnectionMap;
    protected final Map unorderedConnectionMap = new ConcurrentHashMap();
    private final List receivers = new ArrayList();
    protected final TCPConduit owner;
    private volatile boolean closed = false;
    private final Executor p2pReaderThreadPool;
    private static final long READER_POOL_KEEP_ALIVE_TIME;
    private final SocketCloser socketCloser;
    private static final AtomicReference lastInstance;
    private Map connectingSockets = new HashMap();

    public static void threadWantsSharedResources() {
        threadWantsOwnResources.set(Boolean.FALSE);
    }

    public static void threadWantsOwnResources() {
        threadWantsOwnResources.set(Boolean.TRUE);
    }

    boolean threadOwnsResources() {
        DM d = this.getDM();
        if (d != null) {
            return d.getSystem().threadOwnsResources() && !AlertAppender.isThreadAlerting();
        }
        return false;
    }

    public static Boolean getThreadOwnsResourcesRegistration() {
        return (Boolean)threadWantsOwnResources.get();
    }

    private ConnectionTable(TCPConduit c) throws IOException {
        this.owner = c;
        this.idleConnTimer = this.owner.idleConnectionTimeout != 0 ? new SystemTimer(c.getDM().getSystem(), true) : null;
        this.threadOrderedConnMap = new ThreadLocal();
        this.threadConnMaps = new ArrayList();
        this.threadConnectionMap = new ConcurrentHashMap();
        this.p2pReaderThreadPool = this.createThreadPoolForIO(c.getDM().getSystem().isShareSockets());
        this.socketCloser = new SocketCloser();
    }

    private Executor createThreadPoolForIO(boolean conserveSockets) {
        Executor executor = null;
        final LoggingThreadGroup connectionRWGroup = LoggingThreadGroup.createThreadGroup("P2P Reader Threads", logger);
        if (conserveSockets) {
            executor = new Executor(){

                @Override
                public void execute(Runnable command) {
                    Thread th = new Thread(connectionRWGroup, command);
                    th.setDaemon(true);
                    th.start();
                }
            };
        } else {
            SynchronousQueue<Runnable> synchronousQueue = new SynchronousQueue<Runnable>();
            ThreadFactory tf = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable command) {
                    Thread thread = new Thread(connectionRWGroup, command);
                    thread.setDaemon(true);
                    return thread;
                }
            };
            executor = new ThreadPoolExecutor(1, Integer.MAX_VALUE, READER_POOL_KEEP_ALIVE_TIME, TimeUnit.SECONDS, synchronousQueue, tf);
        }
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acceptConnection(Socket sock) throws IOException, ConnectionException {
        Object connection = null;
        InetAddress connAddress = sock.getInetAddress();
        boolean finishedConnecting = false;
        Connection conn = null;
        try {
            conn = Connection.createReceiver(this, sock);
            this.owner.getCancelCriterion().checkCancelInProgress(null);
            finishedConnecting = true;
        }
        catch (IOException ex) {
            this.owner.getCancelCriterion().checkCancelInProgress(ex);
            logger.warn(LocalizedMessage.create(LocalizedStrings.ConnectionTable_FAILED_TO_ACCEPT_CONNECTION_FROM_0_BECAUSE_1, new Object[]{connAddress != null ? connAddress : "unavailable address", ex}));
            throw ex;
        }
        catch (ConnectionException ex) {
            this.owner.getCancelCriterion().checkCancelInProgress(ex);
            logger.warn(LocalizedMessage.create(LocalizedStrings.ConnectionTable_FAILED_TO_ACCEPT_CONNECTION_FROM_0_BECAUSE_1, new Object[]{connAddress != null ? connAddress : "unavailable address", ex}));
            throw ex;
        }
        finally {
            if (conn != null && !finishedConnecting) {
                ConnectionTable.closeCon(LocalizedStrings.ConnectionTable_CANCEL_AFTER_ACCEPT.toLocalizedString(), conn);
                conn = null;
            }
        }
        if (conn != null) {
            List list = this.receivers;
            synchronized (list) {
                this.owner.stats.incReceivers();
                if (this.closed) {
                    ConnectionTable.closeCon(LocalizedStrings.ConnectionTable_CONNECTION_TABLE_NO_LONGER_IN_USE.toLocalizedString(), conn);
                    return;
                }
                this.receivers.add(conn);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Accepted {} myAddr={} theirAddr={}", (Object)conn, (Object)this.getConduit().getLocalAddress(), (Object)conn.remoteAddr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection handleNewPendingConnection(DistributedMember id, boolean sharedResource, boolean preserveOrder, Map m, PendingConnection pc, long startTime, long ackThreshold, long ackSAThreshold) throws IOException, DistributedSystemDisconnectedException {
        Map map;
        Connection con = null;
        try {
            con = Connection.createSender(this.owner.getMembershipManager(), this, preserveOrder, id, sharedResource, startTime, ackThreshold, ackSAThreshold);
            this.owner.stats.incSenders(sharedResource, preserveOrder);
        }
        finally {
            if (con == null) {
                this.owner.stats.incFailedConnect();
                map = m;
                synchronized (map) {
                    Object rmObj = m.remove(id);
                    if (rmObj != pc && rmObj != null) {
                        m.put(id, rmObj);
                    }
                }
                pc.notifyWaiters(null);
            }
        }
        map = m;
        synchronized (map) {
            Object e = m.get(id);
            if (e == pc) {
                m.put(id, con);
            } else if (e == null) {
                con.requestClose(LocalizedStrings.ConnectionTable_PENDING_CONNECTION_CANCELLED.toLocalizedString());
                con = null;
            } else if (e instanceof Connection) {
                Connection newCon = (Connection)e;
                if (!newCon.connected) {
                    if (con != null) {
                        con.requestClose(LocalizedStrings.ConnectionTable_PENDING_CONNECTION_CLOSED.toLocalizedString());
                        con = null;
                    }
                } else {
                    if (con != null) {
                        con.requestClose(LocalizedStrings.ConnectionTable_SOMEONE_ELSE_CREATED_THE_CONNECTION.toLocalizedString());
                    }
                    con = newCon;
                }
            }
        }
        pc.notifyWaiters(con);
        if (con != null && logger.isDebugEnabled()) {
            logger.debug("handleNewPendingConnection {} myAddr={} theirAddr={}", (Object)con, (Object)this.getConduit().getLocalAddress(), (Object)con.remoteAddr);
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getUnorderedOrConserveSockets(DistributedMember id, boolean threadOwnsResources, boolean preserveOrder, long startTime, long ackTimeout, long ackSATimeout) throws IOException, DistributedSystemDisconnectedException {
        Connection result = null;
        Map m = preserveOrder ? this.orderedConnectionMap : this.unorderedConnectionMap;
        PendingConnection pc = null;
        Object mEntry = null;
        Map map = m;
        synchronized (map) {
            mEntry = m.get(id);
            if (mEntry != null && mEntry instanceof Connection) {
                Connection existingCon = mEntry;
                if (!existingCon.connected) {
                    mEntry = null;
                }
            }
            if (mEntry == null) {
                pc = new PendingConnection(preserveOrder, id);
                m.put(id, pc);
            }
        }
        if (pc != null) {
            result = this.handleNewPendingConnection(id, true, preserveOrder, m, pc, startTime, ackTimeout, ackSATimeout);
            if (!preserveOrder && threadOwnsResources) {
                this.scheduleIdleTimeout(result);
            }
        } else if (mEntry instanceof PendingConnection) {
            if (AlertAppender.isThreadAlerting()) {
                throw new IOException("Cannot form connection to alert listener " + id);
            }
            result = ((PendingConnection)mEntry).waitForConnect(this.owner.getMembershipManager(), startTime, ackTimeout, ackSATimeout);
            if (logger.isDebugEnabled()) {
                if (result != null) {
                    logger.debug("getUnorderedOrConserveSockets {} myAddr={} theirAddr={}", (Object)result, (Object)this.getConduit().getLocalAddress(), (Object)result.remoteAddr);
                } else {
                    logger.debug("getUnorderedOrConserveSockets: Connect failed");
                }
            }
        } else {
            result = mEntry;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection getOrderedAndOwned(DistributedMember id, long startTime, long ackTimeout, long ackSATimeout) throws IOException, DistributedSystemDisconnectedException {
        ArrayList o;
        Object object;
        Connection result = null;
        HashMap<DistributedMember, Connection> m = (HashMap<DistributedMember, Connection>)this.threadOrderedConnMap.get();
        if (m == null) {
            m = new HashMap<DistributedMember, Connection>();
            object = this.threadConnMaps;
            synchronized (object) {
                if (this.closed) {
                    this.owner.getCancelCriterion().checkCancelInProgress(null);
                    throw new DistributedSystemDisconnectedException(LocalizedStrings.ConnectionTable_CONNECTION_TABLE_IS_CLOSED.toLocalizedString());
                }
                Iterator it = this.threadConnMaps.iterator();
                while (it.hasNext()) {
                    Reference r = (Reference)it.next();
                    if (r.get() != null) continue;
                    it.remove();
                }
                this.threadConnMaps.add(new WeakReference(m));
            }
            this.threadOrderedConnMap.set(m);
        } else {
            object = m;
            synchronized (object) {
                result = (Connection)m.get(id);
            }
            if (result != null && result.timedOut) {
                result = null;
            }
        }
        if (result != null) {
            return result;
        }
        result = Connection.createSender(this.owner.getMembershipManager(), this, true, id, false, startTime, ackTimeout, ackSATimeout);
        if (logger.isDebugEnabled()) {
            logger.debug("ConnectionTable: created an ordered connection: {}", (Object)result);
        }
        this.owner.stats.incSenders(false, true);
        if (this.threadConnectionMap == null) {
            ConnectionTable.closeCon(LocalizedStrings.ConnectionTable_CONNECTION_TABLE_BEING_DESTROYED.toLocalizedString(), result);
            return null;
        }
        ArrayList<Connection> al = (ArrayList<Connection>)this.threadConnectionMap.get(id);
        if (al == null && (o = this.threadConnectionMap.putIfAbsent(id, al = new ArrayList<Connection>())) != null) {
            al = o;
        }
        Cloneable cloneable = al;
        synchronized (cloneable) {
            al.add(result);
        }
        cloneable = m;
        synchronized (cloneable) {
            m.put(id, result);
        }
        this.scheduleIdleTimeout(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleIdleTimeout(Connection conn) {
        if (conn == null) {
            return;
        }
        if (this.owner.idleConnectionTimeout != 0) {
            try {
                ConnectionTable connectionTable = this;
                synchronized (connectionTable) {
                    if (!this.closed) {
                        IdleConnTT task = new IdleConnTT(conn);
                        conn.setIdleTimeoutTask(task);
                        this.getIdleConnTimer().scheduleAtFixedRate(task, this.owner.idleConnectionTimeout, this.owner.idleConnectionTimeout);
                    }
                }
            }
            catch (IllegalStateException e) {
                if (conn.isClosing()) {
                    return;
                }
                logger.debug("Got an illegal state exception: {}", (Object)e.getMessage(), (Object)e);
                this.owner.getCancelCriterion().checkCancelInProgress(null);
                Exception cause = this.owner.getShutdownCause();
                if (cause == null) {
                    cause = e;
                }
                throw new DistributedSystemDisconnectedException(LocalizedStrings.ConnectionTable_THE_DISTRIBUTED_SYSTEM_IS_SHUTTING_DOWN.toLocalizedString(), cause);
            }
        }
    }

    protected Connection get(DistributedMember id, boolean preserveOrder, long startTime, long ackTimeout, long ackSATimeout) throws IOException, DistributedSystemDisconnectedException {
        if (this.closed) {
            this.owner.getCancelCriterion().checkCancelInProgress(null);
            throw new DistributedSystemDisconnectedException(LocalizedStrings.ConnectionTable_CONNECTION_TABLE_IS_CLOSED.toLocalizedString());
        }
        Connection result = null;
        boolean threadOwnsResources = this.threadOwnsResources();
        result = !preserveOrder || !threadOwnsResources ? this.getUnorderedOrConserveSockets(id, threadOwnsResources, preserveOrder, startTime, ackTimeout, ackSATimeout) : this.getOrderedAndOwned(id, startTime, ackTimeout, ackSATimeout);
        if (result != null) {
            Assert.assertTrue(result.preserveOrder == preserveOrder);
        }
        return result;
    }

    protected synchronized void fileDescriptorsExhausted() {
        if (!ulimitWarningIssued) {
            ulimitWarningIssued = true;
            logger.fatal(LocalizedMessage.create(LocalizedStrings.ConnectionTable_OUT_OF_FILE_DESCRIPTORS_USING_SHARED_CONNECTION));
            InternalDistributedSystem.getAnyInstance().setShareSockets(true);
            threadWantsOwnResources = new ThreadLocal();
        }
    }

    protected TCPConduit getConduit() {
        return this.owner;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private static void closeCon(String reason, Object c) {
        ConnectionTable.closeCon(reason, c, false);
    }

    private static void closeCon(String reason, Object c, boolean beingSick) {
        if (c == null) {
            return;
        }
        if (c instanceof Connection) {
            ((Connection)c).closePartialConnect(reason, beingSick);
        } else {
            ((PendingConnection)c).notifyWaiters(null);
        }
    }

    protected synchronized SystemTimer getIdleConnTimer() {
        if (this.closed) {
            return null;
        }
        if (this.idleConnTimer == null) {
            this.idleConnTimer = new SystemTimer(this.getDM().getSystem(), true);
        }
        return this.idleConnTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        Executor localExec;
        Iterator<Object> it;
        if (this.closed) {
            return;
        }
        this.closed = true;
        Object object = this;
        synchronized (object) {
            if (this.idleConnTimer != null) {
                this.idleConnTimer.cancel();
            }
        }
        object = this.orderedConnectionMap;
        synchronized (object) {
            it = this.orderedConnectionMap.values().iterator();
            while (it.hasNext()) {
                ConnectionTable.closeCon(LocalizedStrings.ConnectionTable_CONNECTION_TABLE_BEING_DESTROYED.toLocalizedString(), it.next());
            }
            this.orderedConnectionMap.clear();
        }
        object = this.unorderedConnectionMap;
        synchronized (object) {
            it = this.unorderedConnectionMap.values().iterator();
            while (it.hasNext()) {
                ConnectionTable.closeCon(LocalizedStrings.ConnectionTable_CONNECTION_TABLE_BEING_DESTROYED.toLocalizedString(), it.next());
            }
            this.unorderedConnectionMap.clear();
        }
        if (this.threadConnectionMap != null) {
            this.threadConnectionMap = null;
        }
        if (this.threadConnMaps != null) {
            object = this.threadConnMaps;
            synchronized (object) {
                for (Reference r : this.threadConnMaps) {
                    Map m = (Map)r.get();
                    if (m == null) continue;
                    Map map = m;
                    synchronized (map) {
                        Iterator mit = m.values().iterator();
                        while (mit.hasNext()) {
                            ConnectionTable.closeCon(LocalizedStrings.ConnectionTable_CONNECTION_TABLE_BEING_DESTROYED.toLocalizedString(), mit.next());
                        }
                    }
                }
                this.threadConnMaps.clear();
            }
        }
        if ((localExec = this.p2pReaderThreadPool) != null && localExec instanceof ExecutorService) {
            ((ExecutorService)localExec).shutdown();
        }
        this.closeReceivers(false);
        Map m = (Map)this.threadOrderedConnMap.get();
        if (m != null) {
            Map map = m;
            synchronized (map) {
                m.clear();
            }
        }
        this.socketCloser.close();
    }

    public void executeCommand(Runnable runnable) {
        Executor local = this.p2pReaderThreadPool;
        if (local != null) {
            local.execute(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeReceivers(boolean beingSick) {
        List list = this.receivers;
        synchronized (list) {
            Iterator it = this.receivers.iterator();
            while (it.hasNext()) {
                Connection con = (Connection)it.next();
                if (beingSick && !con.preserveOrder) continue;
                ConnectionTable.closeCon(LocalizedStrings.ConnectionTable_CONNECTION_TABLE_BEING_DESTROYED.toLocalizedString(), con, beingSick);
                it.remove();
            }
            Map map = this.connectingSockets;
            synchronized (map) {
                Iterator it2 = this.connectingSockets.entrySet().iterator();
                while (it2.hasNext()) {
                    Map.Entry entry = it2.next();
                    try {
                        ((Socket)entry.getKey()).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    it2.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeReceiver(Object con) {
        List list = this.receivers;
        synchronized (list) {
            this.receivers.remove(con);
        }
    }

    protected boolean isEndpointShuttingDown(DistributedMember id) {
        return this.giveUpOnMember(this.owner.getDM().getMembershipManager(), id);
    }

    protected boolean giveUpOnMember(MembershipManager mgr, DistributedMember remoteAddr) {
        return !mgr.memberExists(remoteAddr) || mgr.isShunned(remoteAddr) || mgr.shutdownInProgress();
    }

    protected void removeEndpoint(DistributedMember stub, String reason) {
        this.removeEndpoint(stub, reason, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeEndpoint(DistributedMember memberID, String reason, boolean notifyDisconnect) {
        Object al;
        ConcurrentMap cm;
        if (this.closed) {
            return;
        }
        boolean needsRemoval = false;
        Map map = this.orderedConnectionMap;
        synchronized (map) {
            if (this.orderedConnectionMap.get(memberID) != null) {
                needsRemoval = true;
            }
        }
        if (!needsRemoval) {
            map = this.unorderedConnectionMap;
            synchronized (map) {
                if (this.unorderedConnectionMap.get(memberID) != null) {
                    needsRemoval = true;
                }
            }
        }
        if (!needsRemoval && (cm = this.threadConnectionMap) != null) {
            al = (ArrayList)cm.get(memberID);
            boolean bl = needsRemoval = al != null && ((ArrayList)al).size() > 0;
        }
        if (needsRemoval) {
            Object al2;
            Object c;
            InternalDistributedMember remoteAddress = null;
            al = this.orderedConnectionMap;
            synchronized (al) {
                c = this.orderedConnectionMap.remove(memberID);
                if (c instanceof Connection) {
                    remoteAddress = ((Connection)c).getRemoteAddress();
                }
                ConnectionTable.closeCon(reason, c);
            }
            al = this.unorderedConnectionMap;
            synchronized (al) {
                c = this.unorderedConnectionMap.remove(memberID);
                if (remoteAddress == null && c instanceof Connection) {
                    remoteAddress = ((Connection)c).getRemoteAddress();
                }
                ConnectionTable.closeCon(reason, c);
            }
            ConcurrentMap cm2 = this.threadConnectionMap;
            if (cm2 != null && (al2 = (ArrayList)cm2.remove(memberID)) != null) {
                ArrayList arrayList = al2;
                synchronized (arrayList) {
                    Iterator it2 = ((ArrayList)al2).iterator();
                    while (it2.hasNext()) {
                        Object c2 = it2.next();
                        if (remoteAddress == null && c2 instanceof Connection) {
                            remoteAddress = ((Connection)c2).getRemoteAddress();
                        }
                        ConnectionTable.closeCon(reason, c2);
                    }
                    ((ArrayList)al2).clear();
                }
            }
            HashSet<Object> toRemove = new HashSet<Object>();
            al2 = this.connectingSockets;
            synchronized (al2) {
                Iterator iterator = this.connectingSockets.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    ConnectingSocketInfo info = (ConnectingSocketInfo)entry.getValue();
                    if (!info.peerAddress.equals(((InternalDistributedMember)memberID).getInetAddress())) continue;
                    toRemove.add(entry.getKey());
                    iterator.remove();
                }
            }
            for (Socket socket : toRemove) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("caught exception while trying to close connecting socket for {}", (Object)memberID, (Object)e);
                }
            }
            toRemove.clear();
            List it3 = this.receivers;
            synchronized (it3) {
                Iterator iterator = this.receivers.iterator();
                while (iterator.hasNext()) {
                    Connection con = (Connection)iterator.next();
                    if (!memberID.equals(con.getRemoteAddress())) continue;
                    iterator.remove();
                    toRemove.add(con);
                }
            }
            for (Connection connection : toRemove) {
                ConnectionTable.closeCon(reason, connection);
            }
            if (notifyDisconnect && this.owner.getDM().shutdownInProgress()) {
                throw new DistributedSystemDisconnectedException("Shutdown in progress", this.owner.getDM().getMembershipManager().getShutdownCause());
            }
            if (remoteAddress != null) {
                this.socketCloser.releaseResourcesForAddress(remoteAddress.toString());
            }
        }
    }

    SocketCloser getSocketCloser() {
        return this.socketCloser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasReceiversFor(DistributedMember endPoint) {
        List list = this.receivers;
        synchronized (list) {
            for (Connection con : this.receivers) {
                if (!endPoint.equals(con.getRemoteAddress())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeFromThreadConMap(ConcurrentMap cm, DistributedMember stub, Connection c) {
        ArrayList al;
        if (cm != null && (al = (ArrayList)cm.get(stub)) != null) {
            ArrayList arrayList = al;
            synchronized (arrayList) {
                al.remove(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeThreadConnection(DistributedMember stub, Connection c) {
        ConnectionTable.removeFromThreadConMap(this.threadConnectionMap, stub, c);
        Map m = (Map)this.threadOrderedConnMap.get();
        if (m != null) {
            Map map = m;
            synchronized (map) {
                if (m.get(stub) == c) {
                    m.remove(stub);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSharedConnection(String reason, DistributedMember stub, boolean ordered, Connection c) {
        if (this.closed) {
            return;
        }
        if (ordered) {
            Map map = this.orderedConnectionMap;
            synchronized (map) {
                if (this.orderedConnectionMap.get(stub) == c) {
                    ConnectionTable.closeCon(reason, this.orderedConnectionMap.remove(stub));
                }
            }
        }
        Map map = this.unorderedConnectionMap;
        synchronized (map) {
            if (this.unorderedConnectionMap.get(stub) == c) {
                ConnectionTable.closeCon(reason, this.unorderedConnectionMap.remove(stub));
            }
        }
    }

    public static void loadEmergencyClasses() {
    }

    public static void emergencyClose() {
        ConnectionTable ct = (ConnectionTable)lastInstance.get();
        if (ct == null) {
            return;
        }
        lastInstance.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAndCloseThreadOwnedSockets() {
        Map m = (Map)this.threadOrderedConnMap.get();
        if (m != null) {
            Map map = m;
            synchronized (map) {
                Iterator it = m.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry me = it.next();
                    DistributedMember stub = (DistributedMember)me.getKey();
                    Connection c = (Connection)me.getValue();
                    ConnectionTable.removeFromThreadConMap(this.threadConnectionMap, stub, c);
                    it.remove();
                    ConnectionTable.closeCon(LocalizedStrings.ConnectionTable_THREAD_FINALIZATION.toLocalizedString(), c);
                }
            }
        }
    }

    public static void releaseThreadsSockets() {
        ConnectionTable ct = (ConnectionTable)lastInstance.get();
        if (ct == null) {
            return;
        }
        ct.removeAndCloseThreadOwnedSockets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getThreadOwnedOrderedConnectionState(DistributedMember member, Map result) {
        ArrayList al;
        ConcurrentMap cm = this.threadConnectionMap;
        if (cm != null && (al = (ArrayList)cm.get(member)) != null) {
            ArrayList arrayList = al;
            synchronized (arrayList) {
                al = new ArrayList(al);
            }
            for (Connection conn : al) {
                if (conn.isSharedResource() || !conn.getOriginatedHere() || !conn.getPreserveOrder()) continue;
                result.put(conn.getUniqueId(), conn.getMessagesSent());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForThreadOwnedOrderedConnectionState(DistributedMember member, Map connectionStates) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        ArrayList r = null;
        List list = this.receivers;
        synchronized (list) {
            r = new ArrayList(this.receivers);
        }
        for (Connection con : r) {
            Long state;
            if (con.stopped || con.isClosing() || con.getOriginatedHere() || !con.getPreserveOrder() || !member.equals(con.getRemoteAddress()) || (state = (Long)connectionStates.remove(con.getUniqueId())) == null) continue;
            long count = state;
            while (!con.stopped && !con.isClosing() && con.getMessagesReceived() < count) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Waiting for connection {}/{} currently={} need={}", (Object)con.getRemoteAddress(), (Object)con.getUniqueId(), (Object)con.getMessagesReceived(), (Object)count);
                }
                Thread.sleep(100L);
            }
        }
        if (connectionStates.size() > 0 && logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer(1000);
            sb.append("These connections from ");
            sb.append(member);
            sb.append("could not be located during waitForThreadOwnedOrderedConnectionState: ");
            Iterator it = connectionStates.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                sb.append(entry.getKey()).append('(').append(entry.getValue()).append(')');
                if (!it.hasNext()) continue;
                sb.append(',');
            }
            logger.debug(sb);
        }
    }

    protected DM getDM() {
        return this.owner.getDM();
    }

    public static ConnectionTable create(TCPConduit conduit) throws IOException {
        ConnectionTable ct = new ConnectionTable(conduit);
        lastInstance.set(ct);
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectingSocket(Socket socket, InetAddress addr) {
        Map map = this.connectingSockets;
        synchronized (map) {
            this.connectingSockets.put(socket, new ConnectingSocketInfo(addr));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectingSocket(Socket socket) {
        Map map = this.connectingSockets;
        synchronized (map) {
            this.connectingSockets.remove(socket);
        }
    }

    static {
        threadWantsOwnResources = new ThreadLocal();
        READER_POOL_KEEP_ALIVE_TIME = Long.getLong("p2p.READER_POOL_KEEP_ALIVE_TIME", 120L);
        lastInstance = new AtomicReference();
    }

    private static class ConnectingSocketInfo {
        InetAddress peerAddress;
        Thread connectingThread;

        public ConnectingSocketInfo(InetAddress addr) {
            this.peerAddress = addr;
            this.connectingThread = Thread.currentThread();
        }
    }

    private static class IdleConnTT
    extends SystemTimer.SystemTimerTask {
        private Connection c;

        IdleConnTT(Connection c) {
            this.c = c;
        }

        @Override
        public boolean cancel() {
            this.c = null;
            return super.cancel();
        }

        @Override
        public void run2() {
            Connection con = this.c;
            if (con != null && con.checkForIdleTimeout()) {
                this.cancel();
            }
        }
    }

    private class PendingConnection {
        private boolean pending = true;
        private Connection conn = null;
        private final boolean preserveOrder;
        private final DistributedMember id;
        private final Thread connectingThread;

        public PendingConnection(boolean preserveOrder, DistributedMember id) {
            this.preserveOrder = preserveOrder;
            this.id = id;
            this.connectingThread = Thread.currentThread();
        }

        public synchronized void notifyWaiters(Connection c) {
            if (!this.pending) {
                return;
            }
            this.conn = c;
            this.pending = false;
            if (logger.isDebugEnabled()) {
                logger.debug("Notifying waiters that pending {} connection to {} is ready; {}", (Object)(this.preserveOrder ? "ordered" : "unordered"), (Object)this.id, (Object)this);
            }
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Connection waitForConnect(MembershipManager mgr, long startTime, long ackTimeout, long ackSATimeout) throws IOException {
            if (this.connectingThread == Thread.currentThread()) {
                throw new ReenteredConnectException("This thread is already trying to connect");
            }
            Map m = this.preserveOrder ? ConnectionTable.this.orderedConnectionMap : ConnectionTable.this.unorderedConnectionMap;
            boolean severeAlertIssued = false;
            boolean suspected = false;
            DistributedMember targetMember = null;
            if (ackSATimeout > 0L) {
                targetMember = this.id;
            }
            while (this.pending) {
                Object e;
                ConnectionTable.this.getConduit().getCancelCriterion().checkCancelInProgress(null);
                boolean interrupted = Thread.interrupted();
                try {
                    this.wait(100L);
                }
                catch (InterruptedException ignore) {
                    interrupted = true;
                    ConnectionTable.this.getConduit().getCancelCriterion().checkCancelInProgress(ignore);
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (!this.pending) break;
                long now = System.currentTimeMillis();
                if (!severeAlertIssued && ackSATimeout > 0L && startTime + ackTimeout < now) {
                    if (startTime + ackTimeout + ackSATimeout < now) {
                        logger.fatal(LocalizedMessage.create(LocalizedStrings.ConnectionTable_UNABLE_TO_FORM_A_TCPIP_CONNECTION_TO_0_IN_OVER_1_SECONDS, new Object[]{targetMember, (ackSATimeout + ackTimeout) / 1000L}));
                        severeAlertIssued = true;
                    } else if (!suspected) {
                        logger.warn(LocalizedMessage.create(LocalizedStrings.ConnectionTable_UNABLE_TO_FORM_A_TCPIP_CONNECTION_TO_0_IN_OVER_1_SECONDS, new Object[]{this.id, ackTimeout / 1000L}));
                        ((GMSMembershipManager)mgr).suspectMember(targetMember, "Unable to form a TCP/IP connection in a reasonable amount of time");
                        suspected = true;
                    }
                }
                if ((e = m.get(this.id)) == this) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Waiting for pending connection to complete: {} connection to {}; {}", (Object)(this.preserveOrder ? "ordered" : "unordered"), (Object)this.id, (Object)this);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Pending connection changed to {} unexpectedly", e);
                }
                if (e == null) {
                    this.notifyWaiters(null);
                    break;
                }
                if (e instanceof Connection) {
                    this.notifyWaiters((Connection)e);
                    break;
                }
                return ((PendingConnection)e).waitForConnect(mgr, startTime, ackTimeout, ackSATimeout);
            }
            return this.conn;
        }
    }
}

