/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.ra.spi;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import org.apache.geode.LogWriter;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.ra.GFConnectionImpl;
import org.apache.geode.internal.ra.spi.JCALocalTransaction;
import org.apache.geode.internal.ra.spi.JCAManagedConnectionFactory;
import org.apache.geode.internal.ra.spi.JCAManagedConnectionMetaData;

public class JCAManagedConnection
implements ManagedConnection {
    private final List<ConnectionEventListener> listeners;
    private volatile TXManagerImpl gfTxMgr;
    private volatile GemFireCacheImpl cache;
    private volatile boolean initDone = false;
    private volatile PrintWriter logger;
    private JCAManagedConnectionFactory factory;
    private volatile Set<GFConnectionImpl> connections;
    private volatile JCALocalTransaction localTran;
    private static final boolean DEBUG = false;

    public JCAManagedConnection(JCAManagedConnectionFactory fact) {
        this.factory = fact;
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.localTran = new JCALocalTransaction();
        this.connections = Collections.synchronizedSet(new HashSet());
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void associateConnection(Object conn) throws ResourceException {
        if (!(conn instanceof GFConnectionImpl)) {
            throw new ResourceException("Connection is not of type GFConnection");
        }
        ((GFConnectionImpl)conn).resetManagedConnection(this);
        this.connections.add((GFConnectionImpl)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() throws ResourceException {
        Set<GFConnectionImpl> set = this.connections;
        synchronized (set) {
            Iterator<GFConnectionImpl> connsItr = this.connections.iterator();
            while (connsItr.hasNext()) {
                GFConnectionImpl conn = connsItr.next();
                conn.invalidate();
                connsItr.remove();
            }
        }
        if (this.localTran == null || this.localTran.transactionInProgress()) {
            this.localTran = this.initDone && !this.cache.isClosed() ? new JCALocalTransaction(this.cache, this.gfTxMgr) : new JCALocalTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws ResourceException {
        Set<GFConnectionImpl> set = this.connections;
        synchronized (set) {
            Iterator<GFConnectionImpl> connsItr = this.connections.iterator();
            while (connsItr.hasNext()) {
                GFConnectionImpl conn = connsItr.next();
                conn.invalidate();
                connsItr.remove();
            }
        }
        this.gfTxMgr = null;
        this.cache = null;
        this.localTran = null;
        this.listeners.clear();
    }

    @Override
    public Object getConnection(Subject arg0, ConnectionRequestInfo arg1) throws ResourceException {
        try {
            LogWriter logger;
            if (!this.initDone || this.cache.isClosed()) {
                this.init();
            }
            if ((logger = this.cache.getLogger()).fineEnabled()) {
                logger.fine("JCAManagedConnection:getConnection. Returning new Connection");
            }
            GFConnectionImpl conn = new GFConnectionImpl(this);
            this.connections.add(conn);
            return conn;
        }
        catch (SystemException e) {
            this.onError(e);
            throw new ResourceException("GemFire Resource unavailable", e);
        }
    }

    private void init() throws SystemException {
        this.cache = (GemFireCacheImpl)CacheFactory.getAnyInstance();
        LogWriter logger = this.cache.getLogger();
        if (logger.fineEnabled()) {
            logger.fine("JCAManagedConnection:init. Inside init");
        }
        this.gfTxMgr = this.cache.getTxManager();
        this.initDone = true;
    }

    @Override
    public LocalTransaction getLocalTransaction() throws ResourceException {
        return this.localTran;
    }

    @Override
    public PrintWriter getLogWriter() throws ResourceException {
        return this.logger;
    }

    @Override
    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        LogWriter logger;
        if (this.initDone && !this.cache.isClosed() && (logger = this.cache.getLogger()).fineEnabled()) {
            logger.fine("JCAManagedConnection:getMetaData");
        }
        return new JCAManagedConnectionMetaData(this.factory.getProductName(), this.factory.getVersion(), this.factory.getUserName());
    }

    @Override
    public XAResource getXAResource() throws ResourceException {
        throw new NotSupportedException("XA Transaction not supported");
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener arg0) {
        this.listeners.remove(arg0);
    }

    @Override
    public void setLogWriter(PrintWriter logger) throws ResourceException {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onError(Exception e) {
        this.localTran = null;
        Set<GFConnectionImpl> set = this.connections;
        synchronized (set) {
            Iterator<GFConnectionImpl> connsItr = this.connections.iterator();
            while (connsItr.hasNext()) {
                GFConnectionImpl conn = connsItr.next();
                conn.invalidate();
                List<ConnectionEventListener> list = this.listeners;
                synchronized (list) {
                    Iterator<ConnectionEventListener> itr = this.listeners.iterator();
                    ConnectionEvent ce = new ConnectionEvent(this, 5, e);
                    ce.setConnectionHandle(conn);
                    while (itr.hasNext()) {
                        itr.next().connectionErrorOccurred(ce);
                    }
                }
                connsItr.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(GFConnectionImpl conn) throws ResourceException {
        conn.invalidate();
        this.connections.remove(conn);
        List<ConnectionEventListener> list = this.listeners;
        synchronized (list) {
            Iterator<ConnectionEventListener> itr = this.listeners.iterator();
            ConnectionEvent ce = new ConnectionEvent(this, 1);
            ce.setConnectionHandle(conn);
            while (itr.hasNext()) {
                itr.next().connectionClosed(ce);
            }
        }
        if (this.connections.isEmpty()) {
            this.localTran = this.initDone && !this.cache.isClosed() ? new JCALocalTransaction(this.cache, this.gfTxMgr) : new JCALocalTransaction();
        }
    }
}

