/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import org.apache.geode.internal.io.TeeOutputStream;
import org.apache.geode.internal.io.TeePrintStream;
import org.apache.geode.internal.process.StartupStatus;
import org.apache.geode.internal.process.StartupStatusListener;

public final class ProcessLauncherContext {
    public static final String OVERRIDDEN_DEFAULTS_PREFIX = "gemfire.default.";
    private static final boolean REDIRECT_OUTPUT_DEFAULT = false;
    private static final Properties OVERRIDDEN_DEFAULTS_DEFAULT = new Properties();
    private static final ThreadLocal<ProcessLauncherContext> DATA = new ThreadLocal();
    private final boolean redirectOutput;
    private final Properties overriddenDefaults;
    private final StartupStatusListener startupListener;
    private PrintStream err;

    private static ProcessLauncherContext get() {
        return DATA.get();
    }

    public static boolean isRedirectingOutput() {
        ProcessLauncherContext context = ProcessLauncherContext.get();
        if (context == null) {
            return false;
        }
        return context.redirectOutput();
    }

    public static Properties getOverriddenDefaults() {
        ProcessLauncherContext context = ProcessLauncherContext.get();
        if (context == null) {
            return OVERRIDDEN_DEFAULTS_DEFAULT;
        }
        return context.overriddenDefaults();
    }

    public static StartupStatusListener getStartupListener() {
        ProcessLauncherContext context = ProcessLauncherContext.get();
        if (context == null) {
            return null;
        }
        return context.startupListener();
    }

    public static void set(boolean redirectOutput, Properties contingentProperties, StartupStatusListener startupListener) {
        DATA.set(new ProcessLauncherContext(redirectOutput, contingentProperties, startupListener));
        ProcessLauncherContext.installLogListener(startupListener);
    }

    public static void remove() {
        DATA.remove();
        ProcessLauncherContext.clearLogListener();
    }

    private static void installLogListener(StartupStatusListener startupListener) {
        if (startupListener != null) {
            StartupStatus.setListener(startupListener);
        }
    }

    private static void clearLogListener() {
        StartupStatus.clearListener();
    }

    private ProcessLauncherContext(boolean redirectOutput, Properties overriddenDefaults, StartupStatusListener startupListener) {
        this.redirectOutput = redirectOutput;
        this.overriddenDefaults = overriddenDefaults;
        this.startupListener = startupListener;
    }

    private boolean redirectOutput() {
        return this.redirectOutput;
    }

    private Properties overriddenDefaults() {
        return this.overriddenDefaults;
    }

    private StartupStatusListener startupListener() {
        return this.startupListener;
    }

    private void teeErrorStream() {
        FileOutputStream fdErr = new FileOutputStream(FileDescriptor.err);
        this.err = new PrintStream(new BufferedOutputStream(fdErr, 128), true);
        System.setErr(new TeePrintStream(new TeeOutputStream(new BufferedOutputStream(fdErr, 128))));
    }

    private void restoreErrorStream() {
        if (System.err instanceof TeePrintStream) {
            TeePrintStream tee = (TeePrintStream)System.err;
            OutputStream branch = tee.getTeeOutputStream().getBranchOutputStream();
            PrintStream newStdErr = null;
            newStdErr = branch == null ? this.err : (branch instanceof PrintStream ? (PrintStream)branch : new PrintStream(new BufferedOutputStream(branch, 128), true));
            System.setErr(newStdErr);
        }
    }
}

