/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.process.ProcessStreamReader;
import org.apache.geode.internal.process.ProcessUtils;
import org.apache.geode.internal.util.StopWatch;
import org.apache.logging.log4j.Logger;

public final class NonBlockingProcessStreamReader
extends ProcessStreamReader {
    private static final Logger logger = LogService.getLogger();
    private final long continueReadingMillis;

    protected NonBlockingProcessStreamReader(ProcessStreamReader.Builder builder) {
        super(builder);
        this.continueReadingMillis = builder.continueReadingMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("Running {}", (Object)this);
        }
        StopWatch continueReading = new StopWatch();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(this.inputStream));
            StringBuilder sb = new StringBuilder();
            boolean ready = false;
            int ch = 0;
            while (ch != -1) {
                while ((ready = reader.ready()) && (ch = reader.read()) != -1) {
                    sb.append((char)ch);
                    if ((char)ch != '\n') continue;
                    this.inputListener.notifyInputLine(sb.toString());
                    sb = new StringBuilder();
                }
                if (ready) continue;
                if (!ProcessUtils.isProcessAlive(this.process)) {
                    if (!continueReading.isRunning()) {
                        continueReading.start();
                    } else if (continueReading.elapsedTimeMillis() > this.continueReadingMillis) {
                        return;
                    }
                }
                Thread.sleep(10L);
            }
        }
        catch (IOException e) {
            if (isDebugEnabled) {
                logger.debug("Failure reading from buffered input stream: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        catch (InterruptedException e) {
            if (isDebugEnabled) {
                logger.debug("Interrupted reading from buffered input stream: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        finally {
            block29: {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    if (!isDebugEnabled) break block29;
                    logger.debug("Failure closing buffered input stream reader: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            if (isDebugEnabled) {
                logger.debug("Terminating {}", (Object)this);
            }
        }
    }
}

