/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.process.ControlFileWatchdog;
import org.apache.geode.internal.process.FileControllerParameters;
import org.apache.geode.internal.process.ProcessController;
import org.apache.geode.internal.process.UnableToControlProcessException;
import org.apache.geode.lang.AttachAPINotFoundException;
import org.apache.logging.log4j.Logger;

public class FileProcessController
implements ProcessController {
    private static final Logger logger = LogService.getLogger();
    public static final String STATUS_TIMEOUT_PROPERTY = "gemfire.FileProcessController.STATUS_TIMEOUT";
    private final long statusTimeoutMillis;
    private final FileControllerParameters arguments;
    private final int pid;

    public FileProcessController(FileControllerParameters arguments, int pid) {
        this(arguments, pid, Long.getLong(STATUS_TIMEOUT_PROPERTY, 60000L), TimeUnit.MILLISECONDS);
    }

    public FileProcessController(FileControllerParameters arguments, int pid, long timeout, TimeUnit units) {
        if (pid < 1) {
            throw new IllegalArgumentException("Invalid pid '" + pid + "' specified");
        }
        this.pid = pid;
        this.arguments = arguments;
        this.statusTimeoutMillis = units.toMillis(timeout);
    }

    @Override
    public int getProcessId() {
        return this.pid;
    }

    @Override
    public String status() throws UnableToControlProcessException, IOException, InterruptedException, TimeoutException {
        return this.status(this.arguments.getWorkingDirectory(), this.arguments.getProcessType().getStatusRequestFileName(), this.arguments.getProcessType().getStatusFileName());
    }

    @Override
    public void stop() throws UnableToControlProcessException, IOException {
        this.stop(this.arguments.getWorkingDirectory(), this.arguments.getProcessType().getStopRequestFileName());
    }

    @Override
    public void checkPidSupport() {
        throw new AttachAPINotFoundException(LocalizedStrings.Launcher_ATTACH_API_NOT_FOUND_ERROR_MESSAGE.toLocalizedString());
    }

    private void stop(File workingDir, String stopRequestFileName) throws UnableToControlProcessException, IOException {
        File stopRequestFile = new File(workingDir, stopRequestFileName);
        if (!stopRequestFile.exists()) {
            stopRequestFile.createNewFile();
        }
    }

    private String status(File workingDir, String statusRequestFileName, String statusFileName) throws UnableToControlProcessException, IOException, InterruptedException, TimeoutException {
        final File statusFile = new File(workingDir, statusFileName);
        final AtomicReference statusRef = new AtomicReference();
        ControlFileWatchdog.ControlRequestHandler statusHandler = new ControlFileWatchdog.ControlRequestHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleRequest() throws IOException {
                BufferedReader reader = new BufferedReader(new FileReader(statusFile));
                StringBuilder lines = new StringBuilder();
                try {
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        lines.append(line);
                    }
                }
                finally {
                    statusRef.set(lines.toString());
                    reader.close();
                }
            }
        };
        ControlFileWatchdog statusFileWatchdog = new ControlFileWatchdog(workingDir, statusFileName, statusHandler, true);
        statusFileWatchdog.start();
        File statusRequestFile = new File(workingDir, statusRequestFileName);
        if (!statusRequestFile.exists()) {
            statusRequestFile.createNewFile();
        }
        long start = System.currentTimeMillis();
        while (statusFileWatchdog.isAlive()) {
            Thread.sleep(10L);
            if (System.currentTimeMillis() < start + this.statusTimeoutMillis) continue;
            TimeoutException te = new TimeoutException("Timed out waiting for process to create " + statusFile);
            try {
                statusFileWatchdog.stop();
            }
            catch (InterruptedException e) {
                logger.info("Interrupted while stopping status file watchdog.", (Throwable)e);
            }
            catch (RuntimeException e) {
                logger.info("Unexpected failure while stopping status file watchdog.", (Throwable)e);
            }
            throw te;
        }
        String lines = (String)statusRef.get();
        if (null == lines || lines.trim().isEmpty()) {
            throw new IllegalStateException("Failed to read status file");
        }
        return lines;
    }
}

