/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogWriterImpl;

public class PureLogWriter
extends LogWriterImpl {
    private final String connectionName;
    private volatile boolean closed;
    protected volatile int level;
    private long bytesLogged = 0L;
    private PrintWriter logWriter;

    public PureLogWriter(int level) {
        this(level, System.out);
    }

    public PureLogWriter(int level, PrintStream logWriter) {
        this(level, new PrintWriter(logWriter, true), null);
    }

    public PureLogWriter(int level, PrintStream logWriter, String connectionName) {
        this(level, new PrintWriter(logWriter, true), connectionName);
    }

    public PureLogWriter(int level, PrintWriter logWriter, String connectionName) {
        this.setLevel(level);
        this.logWriter = logWriter;
        this.connectionName = connectionName;
    }

    @Override
    public int getLogWriterLevel() {
        return this.level;
    }

    public void setLevel(int newLevel) {
        this.level = newLevel;
    }

    @Override
    public void setLogWriterLevel(int newLevel) {
        this.setLevel(newLevel);
    }

    protected String getThreadName() {
        return Thread.currentThread().getName();
    }

    protected long getThreadId() {
        return Thread.currentThread().getId();
    }

    @Override
    public void put(int msgLevel, String msg, Throwable ex) {
        String exceptionText = null;
        if (ex != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.close();
            try {
                sw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            exceptionText = sw.toString();
        }
        this.put(msgLevel, new Date(), this.connectionName, this.getThreadName(), this.getThreadId(), msg, exceptionText);
    }

    @Override
    public void put(int msgLevel, StringId msgId, Object[] params, Throwable ex) {
        String msg = msgId.toLocalizedString(params);
        this.put(msgLevel, msg, ex);
    }

    protected String formatLogLine(int msgLevel, Date msgDate, String connectionName, String threadName, long tid, String msg, String exceptionText) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.printHeader(pw, msgLevel, msgDate, connectionName, threadName, tid);
        if (msg != null) {
            try {
                PureLogWriter.formatText(pw, msg, 40);
            }
            catch (RuntimeException e) {
                pw.println(msg);
                pw.println(LocalizedStrings.PureLogWriter_IGNORING_EXCEPTION.toLocalizedString());
                e.printStackTrace(pw);
            }
        } else {
            pw.println();
        }
        if (exceptionText != null) {
            pw.print(exceptionText);
        }
        pw.close();
        try {
            sw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    protected void printHeader(PrintWriter pw, int msgLevel, Date msgDate, String connectionName, String threadName, long tid) {
        pw.println();
        pw.print('[');
        pw.print(PureLogWriter.levelToString(msgLevel));
        pw.print(' ');
        pw.print(this.formatDate(msgDate));
        if (connectionName != null) {
            pw.print(' ');
            pw.print(connectionName);
        }
        if (threadName != null) {
            pw.print(" <");
            pw.print(threadName);
            pw.print(">");
        }
        pw.print(" tid=0x");
        pw.print(Long.toHexString(tid));
        pw.print("] ");
    }

    public String put(int msgLevel, Date msgDate, String connectionName, String threadName, long tid, String msg, String exceptionText) {
        String result = this.formatLogLine(msgLevel, msgDate, connectionName, threadName, tid, msg, exceptionText);
        this.writeFormattedMessage(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFormattedMessage(String s) {
        PureLogWriter pureLogWriter = this;
        synchronized (pureLogWriter) {
            this.bytesLogged += (long)s.length();
            this.logWriter.print(s);
            this.logWriter.flush();
        }
    }

    public long getBytesLogged() {
        return this.bytesLogged;
    }

    public PrintWriter setTarget(PrintWriter logWriter) {
        return this.setTarget(logWriter, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintWriter setTarget(PrintWriter logWriter, long targetLength) {
        PureLogWriter pureLogWriter = this;
        synchronized (pureLogWriter) {
            PrintWriter result = this.logWriter;
            this.bytesLogged = targetLength;
            this.logWriter = logWriter;
            return result;
        }
    }

    public final void close() {
        this.closed = true;
        try {
            if (this.logWriter != null) {
                this.logWriter.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public String getConnectionName() {
        return this.connectionName;
    }

    public PrintWriter getPrintWriter() {
        return this.logWriter;
    }
}

