/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.util.logging.Level;
import org.apache.geode.i18n.LogWriterI18n;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class GemFireLevel
extends Level {
    private static final long serialVersionUID = -8123818329485173242L;
    public static final Level ERROR = new GemFireLevel("error", 950);

    public static Level create(int code) {
        switch (code) {
            case -2147483648: {
                return ALL;
            }
            case 300: {
                return FINEST;
            }
            case 400: {
                return FINER;
            }
            case 500: {
                return FINE;
            }
            case 700: {
                return CONFIG;
            }
            case 800: {
                return INFO;
            }
            case 900: {
                return WARNING;
            }
            case 950: {
                return ERROR;
            }
            case 1000: {
                return SEVERE;
            }
            case 0x7FFFFFFF: {
                return OFF;
            }
        }
        throw new IllegalArgumentException(LocalizedStrings.GemFireLevel_UNEXPECTED_LEVEL_CODE_0.toLocalizedString(code));
    }

    public static Level create(LogWriterI18n log) {
        if (log.finestEnabled()) {
            return FINEST;
        }
        if (log.finerEnabled()) {
            return FINER;
        }
        if (log.fineEnabled()) {
            return FINE;
        }
        if (log.configEnabled()) {
            return CONFIG;
        }
        if (log.infoEnabled()) {
            return INFO;
        }
        if (log.warningEnabled()) {
            return WARNING;
        }
        if (log.errorEnabled()) {
            return ERROR;
        }
        if (log.severeEnabled()) {
            return SEVERE;
        }
        return OFF;
    }

    private GemFireLevel(String name, int code) {
        super(name, code);
    }

    protected Object readResolve() {
        return GemFireLevel.create(this.intValue());
    }
}

