/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.lang;

import java.io.PrintWriter;
import java.io.StringWriter;

public abstract class ThreadUtils {
    public static String getThreadName(Thread thread) {
        return thread == null ? null : thread.getName();
    }

    public static void interrupt(Thread thread) {
        if (thread != null) {
            thread.interrupt();
        }
    }

    public static boolean isAlive(Thread thread) {
        return thread != null && thread.isAlive();
    }

    public static boolean isWaiting(Thread thread) {
        return thread != null && thread.getState().equals((Object)Thread.State.WAITING);
    }

    public static long sleep(long milliseconds) {
        long t0 = System.nanoTime();
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
        return (System.nanoTime() - t0) / 1000L;
    }

    public static String stackTraceToString(Throwable throwable, boolean expectNull) {
        if (throwable == null) {
            if (expectNull) {
                return null;
            }
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }
}

