/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.datasource;

import java.util.ArrayList;
import java.util.List;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.geode.internal.datasource.ConfiguredDataSourceProperties;
import org.apache.geode.internal.datasource.ConnectionPoolCache;
import org.apache.geode.internal.datasource.ManagedPoolCacheImpl;
import org.apache.geode.internal.datasource.PoolException;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.jndi.JNDIInvoker;
import org.apache.geode.internal.jta.TransactionManagerImpl;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;

public class FacetsJCAConnectionManagerImpl
implements ConnectionManager,
ConnectionEventListener,
Synchronization {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 2454746064736724758L;
    protected transient TransactionManager transManager;
    protected ConnectionPoolCache mannPoolCache;
    protected ConnectionRequestInfo conReqInfo = null;
    protected Subject subject = null;
    protected boolean isActive = true;
    private transient ThreadLocal xalistThreadLocal = new ThreadLocal(){

        protected Object initialValue() {
            return new ArrayList();
        }
    };

    public FacetsJCAConnectionManagerImpl(ManagedConnectionFactory mcf, ConfiguredDataSourceProperties configs) {
        try {
            this.isActive = true;
            this.mannPoolCache = new ManagedPoolCacheImpl(mcf, null, null, this, configs);
        }
        catch (Exception ex) {
            logger.fatal(LocalizedMessage.create(LocalizedStrings.FacetsJCAConnectionManagerImpl_FACETSJCACONNECTIONMANAGERIMPL_CONSTRUCTOR_AN_EXCEPTION_WAS_CAUGHT_WHILE_INITIALIZING_DUE_TO_0, ex.getMessage()), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo reqInfo) throws ResourceException {
        if (!this.isActive) {
            throw new ResourceException(LocalizedStrings.FacetsJCAConnectionManagerImpl_FACETSJCACONNECTIONMANAGERIMPLALLOCATECONNECTIONNO_VALID_CONNECTION_AVAILABLE.toLocalizedString());
        }
        ManagedConnection conn = null;
        try {
            conn = (ManagedConnection)this.mannPoolCache.getPooledConnectionFromPool();
        }
        catch (PoolException ex) {
            ex.printStackTrace();
            throw new ResourceException(LocalizedStrings.FacetsJCAConnectionManagerImpl_FACETSJCACONNECTIONMANAGERIMPL_ALLOCATECONNECTION_IN_GETTING_CONNECTION_FROM_POOL_DUE_TO_0.toLocalizedString(ex.getMessage()), ex);
        }
        try {
            FacetsJCAConnectionManagerImpl ex = this;
            synchronized (ex) {
                if (this.transManager == null) {
                    this.transManager = JNDIInvoker.getTransactionManager();
                }
            }
            Transaction txn = this.transManager.getTransaction();
            if (txn != null) {
                XAResource xar = conn.getXAResource();
                txn.enlistResource(xar);
                List resList = (List)this.xalistThreadLocal.get();
                if (resList.size() == 0) {
                    txn.registerSynchronization(this);
                }
                resList.add(conn);
            }
        }
        catch (RollbackException ex) {
            String exception = LocalizedStrings.FacetsJCAConnectionManagerImpl_FACETSJCACONNECTIONMANAGERIMPL_AN_EXCEPTION_WAS_CAUGHT_WHILE_ALLOCATING_A_CONNECTION_DUE_TO_0.toLocalizedString(ex.getMessage());
            throw new ResourceException(exception, ex);
        }
        catch (SystemException ex) {
            throw new ResourceException(LocalizedStrings.FacetsJCAConnectionManagerImpl_FACETSJCACONNECTIONMANAGERIMPL_ALLOCATECONNECTION_SYSTEM_EXCEPTION_DUE_TO_0.toLocalizedString(ex.getMessage()), ex);
        }
        return conn.getConnection(this.subject, reqInfo);
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        block6: {
            if (this.isActive) {
                ManagedConnection conn = (ManagedConnection)event.getSource();
                ((List)this.xalistThreadLocal.get()).remove(conn);
                TransactionManagerImpl transManager = TransactionManagerImpl.getTransactionManager();
                try {
                    Transaction txn = transManager.getTransaction();
                    if (txn == null) {
                        this.mannPoolCache.returnPooledConnectionToPool(conn);
                    }
                }
                catch (Exception se) {
                    se.printStackTrace();
                }
                try {
                    this.mannPoolCache.expirePooledConnection(conn);
                }
                catch (Exception ex) {
                    String exception = "FacetsJCAConnectionManagerImpl::connectionErrorOccured: Exception occured due to " + ex.getMessage();
                    if (!logger.isDebugEnabled()) break block6;
                    logger.debug(exception, (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        block4: {
            if (this.isActive) {
                ManagedConnection conn = (ManagedConnection)event.getSource();
                TransactionManagerImpl transManager = TransactionManagerImpl.getTransactionManager();
                try {
                    Transaction txn = transManager.getTransaction();
                    if (txn == null) {
                        this.mannPoolCache.returnPooledConnectionToPool(conn);
                    }
                }
                catch (Exception se) {
                    String exception = "FacetsJCAConnectionManagerImpl::connectionClosed: Exception occured due to " + se.getMessage();
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug(exception, (Throwable)se);
                }
            }
        }
    }

    @Override
    public void localTransactionCommitted(ConnectionEvent arg0) {
    }

    @Override
    public void localTransactionRolledback(ConnectionEvent arg0) {
    }

    @Override
    public void localTransactionStarted(ConnectionEvent arg0) {
    }

    public void clearUp() {
        this.isActive = false;
        this.mannPoolCache.clearUp();
    }

    @Override
    public void afterCompletion(int arg0) {
        ArrayList lsConn = (ArrayList)this.xalistThreadLocal.get();
        for (ManagedConnection conn : lsConn) {
            this.mannPoolCache.returnPooledConnectionToPool(conn);
        }
        lsConn.clear();
    }

    @Override
    public void beforeCompletion() {
    }
}

