/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.datasource;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.geode.internal.datasource.ConfiguredDataSourceProperties;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;

public abstract class AbstractDataSource
implements Serializable,
DataSource {
    private static final org.apache.logging.log4j.Logger logger = LogService.getLogger();
    protected transient PrintWriter dataSourcePW;
    protected int loginTimeOut;
    protected String user;
    protected String password;
    protected String serverName;
    protected String url;
    protected String jdbcDriver;
    protected ConfiguredDataSourceProperties configProps;
    protected boolean isActive = true;

    public AbstractDataSource(ConfiguredDataSourceProperties configs) throws SQLException {
        this.loginTimeOut = configs.getLoginTimeOut();
        this.user = configs.getUser();
        this.password = configs.getPassword();
        this.url = configs.getURL();
        this.jdbcDriver = configs.getJDBCDriver();
        this.dataSourcePW = configs.getPrintWriter();
        this.isActive = true;
    }

    @Override
    public abstract Connection getConnection() throws SQLException;

    @Override
    public abstract Connection getConnection(String var1, String var2) throws SQLException;

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSourcePW;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeOut;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSourcePW = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeOut = seconds;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    protected boolean validateConnection(Connection conn) {
        try {
            return !conn.isClosed();
        }
        catch (SQLException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("AbstractDataSource::validateConnection:exception in validating connection", (Throwable)e);
            }
            return false;
        }
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getJDBCDriver() {
        return this.jdbcDriver;
    }

    public void setUser(String usr) {
        this.user = usr;
    }

    public void setPassword(String passwd) {
        this.password = passwd;
    }

    public void setJDBCDriver(String confDriver) {
        this.jdbcDriver = confDriver;
    }

    public void checkCredentials(String clUser, String clPass) throws SQLException {
        if (clUser == null || !clUser.equals(this.user) || clPass == null || !clPass.equals(this.password)) {
            String error = LocalizedStrings.AbstractDataSource_CANNOT_CREATE_A_CONNECTION_WITH_THE_USER_0_AS_IT_DOESNT_MATCH_THE_EXISTING_USER_NAMED_1_OR_THE_PASSWORD_WAS_INCORRECT.toLocalizedString(clUser, clPass);
            throw new SQLException(error);
        }
    }

    public void clearUp() {
        this.isActive = false;
    }
}

