/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.xmlcache;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.Instantiator;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;

public class SerializerCreation {
    private static final Logger logger = LogService.getLogger();
    private final Vector<Class> serializerReg = new Vector();
    private final HashMap<Class, Integer> instantiatorReg = new HashMap();

    public void registerSerializer(Class c) {
        this.serializerReg.add(c);
    }

    public void registerInstantiator(Class c, Integer id) {
        this.instantiatorReg.put(c, id);
    }

    public void create() {
        boolean isDebugEnabled = logger.isDebugEnabled();
        for (Class clazz : this.serializerReg) {
            if (isDebugEnabled) {
                logger.debug("Registering serializer: {}", (Object)clazz.getName());
            }
            DataSerializer.register(clazz);
        }
        for (Map.Entry entry : this.instantiatorReg.entrySet()) {
            Class k = (Class)entry.getKey();
            if (isDebugEnabled) {
                logger.debug("Registering instantiator: {}", (Object)k.getName());
            }
            Instantiator.register(new InstantiatorImpl(k, (Integer)entry.getValue()));
        }
    }

    public Vector<Class> getSerializerRegistrations() {
        return this.serializerReg;
    }

    public HashMap<Class, Integer> getInstantiatorRegistrations() {
        return this.instantiatorReg;
    }

    public static class InstantiatorImpl
    extends Instantiator {
        private Class m_class;

        public InstantiatorImpl(Class<? extends DataSerializable> c, int classId) {
            super(c, classId);
            this.m_class = c;
        }

        @Override
        public DataSerializable newInstance() {
            try {
                return (DataSerializable)this.m_class.newInstance();
            }
            catch (Exception ex) {
                logger.error(LocalizedMessage.create(LocalizedStrings.SerializerCreation_A_0_INSTANTIATION_FAILED, new Object[]{this.m_class.getName()}), (Throwable)ex);
                return null;
            }
        }
    }
}

