/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan.parallel;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.BucketRegionQueue;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.WaitUntilGatewaySenderFlushedCoordinator;
import org.apache.geode.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderQueue;

public class WaitUntilParallelGatewaySenderFlushedCoordinator
extends WaitUntilGatewaySenderFlushedCoordinator {
    public WaitUntilParallelGatewaySenderFlushedCoordinator(AbstractGatewaySender sender, long timeout, TimeUnit unit, boolean initiator) {
        super(sender, timeout, unit, initiator);
    }

    @Override
    public boolean waitUntilFlushed() throws Throwable {
        boolean remoteResult = true;
        boolean localResult = true;
        Throwable exceptionToThrow = null;
        ConcurrentParallelGatewaySenderQueue prq = (ConcurrentParallelGatewaySenderQueue)this.sender.getQueue();
        PartitionedRegion pr = (PartitionedRegion)prq.getRegion();
        List<WaitUntilBucketRegionQueueFlushedCallable> callables = this.buildWaitUntilBucketRegionQueueFlushedCallables(pr);
        ExecutorService service = this.sender.getDistributionManager().getWaitingThreadPool();
        ArrayList callableFutures = new ArrayList();
        for (Callable callable : callables) {
            callableFutures.add(service.submit(callable));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("WaitUntilParallelGatewaySenderFlushedCoordinator: Created and submitted " + callables.size() + " callables=" + callables);
        }
        if (this.initiator) {
            remoteResult = false;
            try {
                remoteResult = this.waitUntilFlushedOnRemoteMembers(pr);
            }
            catch (Throwable t) {
                exceptionToThrow = t;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("WaitUntilParallelGatewaySenderFlushedCoordinator: Processed remote result=" + remoteResult + "; exceptionToThrow=" + exceptionToThrow);
            }
        }
        for (Future future : callableFutures) {
            boolean singleBucketResult = false;
            try {
                singleBucketResult = (Boolean)future.get();
            }
            catch (ExecutionException e) {
                exceptionToThrow = e.getCause();
            }
            localResult = localResult && singleBucketResult;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("WaitUntilParallelGatewaySenderFlushedCoordinator: Processed local result=" + localResult + "; exceptionToThrow=" + exceptionToThrow);
        }
        if (exceptionToThrow == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("WaitUntilParallelGatewaySenderFlushedCoordinator: Returning full result=" + (remoteResult && localResult));
            }
            return remoteResult && localResult;
        }
        throw exceptionToThrow;
    }

    protected List<WaitUntilBucketRegionQueueFlushedCallable> buildWaitUntilBucketRegionQueueFlushedCallables(PartitionedRegion pr) {
        ArrayList<WaitUntilBucketRegionQueueFlushedCallable> callables = new ArrayList<WaitUntilBucketRegionQueueFlushedCallable>();
        if (pr.isDataStore()) {
            for (BucketRegion br : pr.getDataStore().getAllLocalBucketRegions()) {
                callables.add(new WaitUntilBucketRegionQueueFlushedCallable((BucketRegionQueue)br, this.timeout, this.unit));
            }
        }
        return callables;
    }

    protected boolean waitUntilFlushedOnRemoteMembers(PartitionedRegion pr) throws Throwable {
        boolean result = true;
        DM dm = this.sender.getDistributionManager();
        Set<InternalDistributedMember> recipients = pr.getRegionAdvisor().adviseDataStore();
        if (!recipients.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("WaitUntilParallelGatewaySenderFlushedCoordinator: About to send message recipients=" + recipients);
            }
            WaitUntilGatewaySenderFlushedReplyProcessor processor = new WaitUntilGatewaySenderFlushedReplyProcessor(dm, recipients);
            WaitUntilGatewaySenderFlushedMessage message = new WaitUntilGatewaySenderFlushedMessage(recipients, processor.getProcessorId(), this.sender.getId(), this.timeout, this.unit);
            dm.putOutgoing(message);
            if (logger.isDebugEnabled()) {
                logger.debug("WaitUntilParallelGatewaySenderFlushedCoordinator: Sent message recipients=" + recipients);
            }
            try {
                processor.waitForReplies();
                result = processor.getCombinedResult();
            }
            catch (ReplyException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("WaitUntilParallelGatewaySenderFlushedCoordinator: Caught e=" + e + "; cause=" + e.getCause());
                }
                throw e.getCause();
            }
            catch (InterruptedException e) {
                dm.getCancelCriterion().checkCancelInProgress(e);
                Thread.currentThread().interrupt();
                result = false;
            }
        }
        return result;
    }

    public static class WaitUntilGatewaySenderFlushedMessage
    extends PooledDistributionMessage
    implements MessageWithReply {
        private int processorId;
        private String gatewaySenderId;
        private long timeout;
        private TimeUnit unit;

        public WaitUntilGatewaySenderFlushedMessage() {
        }

        protected WaitUntilGatewaySenderFlushedMessage(Collection recipients, int processorId, String gatewaySenderId, long timeout, TimeUnit unit) {
            this.setRecipients(recipients);
            this.processorId = processorId;
            this.gatewaySenderId = gatewaySenderId;
            this.timeout = timeout;
            this.unit = unit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void process(DistributionManager dm) {
            ReplyMessage replyMsg;
            boolean result = false;
            ReplyException replyException = null;
            try {
                AbstractGatewaySender sender;
                GemFireCacheImpl cache;
                if (logger.isDebugEnabled()) {
                    logger.debug("WaitUntilGatewaySenderFlushedMessage: Processing gatewaySenderId=" + this.gatewaySenderId + "; timeout=" + this.timeout + "; unit=" + (Object)((Object)this.unit));
                }
                if ((cache = GemFireCacheImpl.getInstance()) != null && (sender = (AbstractGatewaySender)cache.getGatewaySender(this.gatewaySenderId)) != null) {
                    try {
                        WaitUntilParallelGatewaySenderFlushedCoordinator coordinator = new WaitUntilParallelGatewaySenderFlushedCoordinator(sender, this.timeout, this.unit, false);
                        result = coordinator.waitUntilFlushed();
                    }
                    catch (Throwable e) {
                        replyException = new ReplyException(e);
                    }
                }
                replyMsg = new ReplyMessage();
            }
            catch (Throwable throwable) {
                ReplyMessage replyMsg2 = new ReplyMessage();
                replyMsg2.setRecipient(this.getSender());
                replyMsg2.setProcessorId(this.processorId);
                if (replyException == null) {
                    replyMsg2.setReturnValue(result);
                } else {
                    replyMsg2.setException(replyException);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("WaitUntilGatewaySenderFlushedMessage: Sending reply returnValue=" + replyMsg2.getReturnValue() + "; exception=" + replyMsg2.getException());
                }
                dm.putOutgoing(replyMsg2);
                throw throwable;
            }
            replyMsg.setRecipient(this.getSender());
            replyMsg.setProcessorId(this.processorId);
            if (replyException == null) {
                replyMsg.setReturnValue(result);
            } else {
                replyMsg.setException(replyException);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("WaitUntilGatewaySenderFlushedMessage: Sending reply returnValue=" + replyMsg.getReturnValue() + "; exception=" + replyMsg.getException());
            }
            dm.putOutgoing(replyMsg);
        }

        @Override
        public int getDSFID() {
            return 2177;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.processorId);
            DataSerializer.writeString(this.gatewaySenderId, out);
            out.writeLong(this.timeout);
            DataSerializer.writeEnum(this.unit, out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.processorId = in.readInt();
            this.gatewaySenderId = DataSerializer.readString(in);
            this.timeout = in.readLong();
            this.unit = DataSerializer.readEnum(TimeUnit.class, in);
        }
    }

    public static class WaitUntilGatewaySenderFlushedReplyProcessor
    extends ReplyProcessor21 {
        private Map<DistributedMember, Boolean> responses;

        public WaitUntilGatewaySenderFlushedReplyProcessor(DM dm, Collection initMembers) {
            super(dm, initMembers);
            this.initializeResponses();
        }

        private void initializeResponses() {
            this.responses = new ConcurrentHashMap<DistributedMember, Boolean>();
            for (InternalDistributedMember member : this.getMembers()) {
                this.responses.put(member, false);
            }
        }

        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof ReplyMessage) {
                    ReplyMessage reply = (ReplyMessage)msg;
                    if (logger.isDebugEnabled()) {
                        logger.debug("WaitUntilGatewaySenderFlushedReplyProcessor: Processing reply from sender=" + reply.getSender() + "; returnValue=" + reply.getReturnValue() + "; exception=" + reply.getException());
                    }
                    if (reply.getException() == null) {
                        this.responses.put(reply.getSender(), (Boolean)reply.getReturnValue());
                    } else {
                        reply.getException().printStackTrace();
                    }
                }
            }
            finally {
                super.process(msg);
            }
        }

        public boolean getCombinedResult() {
            boolean combinedResult = true;
            for (boolean singleMemberResult : this.responses.values()) {
                combinedResult = combinedResult && singleMemberResult;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("WaitUntilGatewaySenderFlushedReplyProcessor: Returning combinedResult=" + combinedResult);
            }
            return combinedResult;
        }
    }

    public static class WaitUntilBucketRegionQueueFlushedCallable
    implements Callable<Boolean> {
        private BucketRegionQueue brq;
        private long timeout;
        private TimeUnit unit;

        public WaitUntilBucketRegionQueueFlushedCallable(BucketRegionQueue brq, long timeout, TimeUnit unit) {
            this.brq = brq;
            this.timeout = timeout;
            this.unit = unit;
        }

        @Override
        public Boolean call() throws Exception {
            return this.brq.waitUntilFlushed(this.timeout, this.unit);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + "brq=" + this.brq.getId() + "]";
        }
    }
}

