/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan.parallel;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.TransactionDataNotColocatedException;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewayQueueEvent;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.cache.BucketRegionQueue;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class ParallelQueueBatchRemovalMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private Map<Integer, List> bucketToTailKey;

    public ParallelQueueBatchRemovalMessage() {
    }

    public ParallelQueueBatchRemovalMessage(Set<InternalDistributedMember> recipient, int regionId, ReplyProcessor21 processor, Map bucketToTailKey) {
        super(recipient, regionId, processor);
        this.bucketToTailKey = bucketToTailKey;
    }

    @Override
    public int getDSFID() {
        return 2140;
    }

    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion pr, long startTime) throws CacheException {
        for (Integer bucketId : this.bucketToTailKey.keySet()) {
            if (!pr.getRegionAdvisor().getBucketAdvisor(bucketId).isHosting()) continue;
            List dispatchedKeys = this.bucketToTailKey.get(bucketId);
            try {
                BucketRegionQueue bucketRegionQueue = (BucketRegionQueue)pr.getDataStore().getInitializedBucketForId(null, bucketId);
                for (Object key : dispatchedKeys) {
                    try {
                        for (GatewayEventFilter filter : pr.getParallelGatewaySender().getGatewayEventFilters()) {
                            GatewayQueueEvent eventForFilter = (GatewayQueueEvent)bucketRegionQueue.get(key);
                            try {
                                if (eventForFilter == null) continue;
                                filter.afterAcknowledgement(eventForFilter);
                            }
                            catch (Exception e) {
                                logger.fatal(LocalizedMessage.create(LocalizedStrings.GatewayEventFilter_EXCEPTION_OCCURED_WHILE_HANDLING_CALL_TO_0_AFTER_ACKNOWLEDGEMENT_FOR_EVENT_1, new Object[]{filter.toString(), eventForFilter}), (Throwable)e);
                            }
                        }
                        bucketRegionQueue.destroyKey(key);
                    }
                    catch (EntryNotFoundException e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("WARNING! Got EntryNotFoundException while destroying the key {} for bucket {}", key, (Object)bucketId);
                    }
                }
            }
            catch (ForceReattemptException fe) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Got ForceReattemptException while getting bucket {} to destroyLocally the keys.", (Object)bucketId);
            }
        }
        BatchRemovalReplyMessage.sendWithException(this.getSender(), this.getProcessorId(), dm, null);
        return false;
    }

    public static ParallelQueueBatchRemovalResponse send(Set<InternalDistributedMember> recipients, PartitionedRegion pr, Map<Integer, List> bucketToTailKey) {
        Assert.assertTrue(recipients != null, "BatchRemovalResponse NULL recipient");
        ParallelQueueBatchRemovalResponse response = new ParallelQueueBatchRemovalResponse(pr.getSystem(), recipients, pr);
        ParallelQueueBatchRemovalMessage msg = new ParallelQueueBatchRemovalMessage(recipients, pr.getPRId(), response, bucketToTailKey);
        Set failures = pr.getDistributionManager().putOutgoing(msg);
        if (failures != null && failures.size() > 0) {
            return null;
        }
        pr.getPrStats().incPartitionMessagesSent();
        return response;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.bucketToTailKey, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bucketToTailKey = (Map)DataSerializer.readObject(in);
    }

    public static class ParallelQueueBatchRemovalResponse
    extends PartitionMessage.PartitionResponse {
        public ParallelQueueBatchRemovalResponse(InternalDistributedSystem dm, Set<InternalDistributedMember> recipients) {
            super(dm, recipients);
        }

        public ParallelQueueBatchRemovalResponse(InternalDistributedSystem ds, Set<InternalDistributedMember> recipients, PartitionedRegion theRegion) {
            super(ds, recipients);
        }

        @Override
        public void process(DistributionMessage msg) {
            super.process(msg);
        }

        public void waitForResponse() throws ForceReattemptException {
            try {
                this.waitForCacheException();
            }
            catch (EntryNotFoundException enfe) {
                throw enfe;
            }
            catch (ForceReattemptException e) {
                String msg = "GetResponse got ForceReattemptException; rethrowing";
                logger.debug("GetResponse got ForceReattemptException; rethrowing", (Throwable)e);
                throw e;
            }
            catch (TransactionDataNotColocatedException e) {
                throw e;
            }
        }
    }

    public static final class BatchRemovalReplyMessage
    extends ReplyMessage {
        public BatchRemovalReplyMessage() {
        }

        public BatchRemovalReplyMessage(DataInput in) throws IOException, ClassNotFoundException {
            this.fromData(in);
        }

        private BatchRemovalReplyMessage(int processorId, ReplyException re) {
            this.setProcessorId(processorId);
            this.setException(re);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.debug("BatchRemovalReplyMessage process invoking reply processor with processorId: {}", (Object)this.processorId);
            }
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.debug("BatchRemovalReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (logger.isDebugEnabled()) {
                logger.debug("{} processed {}", (Object)processor, (Object)this);
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        private static void sendWithException(InternalDistributedMember recipient, int processorId, DM dm, ReplyException re) {
            Assert.assertTrue(recipient != null, "BecomePrimaryBucketReplyMessage NULL recipient");
            BatchRemovalReplyMessage m = new BatchRemovalReplyMessage(processorId, re);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
        }

        @Override
        public int getDSFID() {
            return 2141;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("BatchRemovalReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender());
            return sb.toString();
        }
    }
}

