/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.client.internal.locator.wan.LocatorMembershipListener;
import org.apache.geode.cache.wan.GatewayReceiverFactory;
import org.apache.geode.cache.wan.GatewaySenderFactory;
import org.apache.geode.distributed.internal.WanLocatorDiscoverer;
import org.apache.geode.internal.cache.wan.spi.WANFactory;

public class WANServiceProvider {
    private static final WANFactory factory;

    public static GatewaySenderFactory createGatewaySenderFactory(Cache cache) {
        if (factory == null) {
            throw new IllegalStateException("WAN service is not available.");
        }
        return factory.createGatewaySenderFactory(cache);
    }

    public static GatewayReceiverFactory createGatewayReceiverFactory(Cache cache) {
        if (factory == null) {
            throw new IllegalStateException("WAN service is not available.");
        }
        return factory.createGatewayReceiverFactory(cache);
    }

    public static WanLocatorDiscoverer createLocatorDiscoverer() {
        if (factory == null) {
            return null;
        }
        return factory.createLocatorDiscoverer();
    }

    public static LocatorMembershipListener createLocatorMembershipListener() {
        if (factory == null) {
            return null;
        }
        return factory.createLocatorMembershipListener();
    }

    private WANServiceProvider() {
    }

    static {
        ServiceLoader<WANFactory> loader = ServiceLoader.load(WANFactory.class);
        Iterator<WANFactory> itr = loader.iterator();
        if (!itr.hasNext()) {
            factory = null;
        } else {
            factory = itr.next();
            factory.initialize();
        }
    }
}

