/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.versions;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.persistence.DiskStoreID;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.versions.VersionTag;

public class DiskVersionTag
extends VersionTag<DiskStoreID> {
    @Override
    public void setMemberID(DiskStoreID memberID) {
        assert (memberID == null || memberID instanceof DiskStoreID);
        super.setMemberID(memberID);
    }

    @Override
    public void replaceNullIDs(VersionSource memberID) {
        if (this.getMemberID() == null) {
            throw new AssertionError((Object)"Member id should not be null for persistent version tags");
        }
    }

    @Override
    public int getDSFID() {
        return 2131;
    }

    @Override
    public void writeMember(DiskStoreID member, DataOutput out) throws IOException {
        out.writeLong(member.getMostSignificantBits());
        out.writeLong(member.getLeastSignificantBits());
    }

    @Override
    public DiskStoreID readMember(DataInput in) throws IOException {
        long mostSignificantBits = in.readLong();
        long leastSignificantBits = in.readLong();
        DiskStoreID member = new DiskStoreID(mostSignificantBits, leastSignificantBits);
        return member;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

