/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.command.Put65;
import org.apache.geode.internal.cache.versions.VersionTag;

public class Put70
extends Put65 {
    private static final Put70 singleton = new Put70();

    public static Command getCommand() {
        return singleton;
    }

    private Put70() {
    }

    @Override
    protected void writeReply(Message origMsg, ServerConnection servConn, boolean sendOldValue, boolean oldValueIsObject, Object oldValue, VersionTag versionTag) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        int flags = 0;
        int parts = 2;
        if (sendOldValue) {
            flags |= 1;
            if (oldValueIsObject) {
                flags |= 2;
            }
            ++parts;
        }
        if (versionTag != null) {
            flags |= 4;
            ++parts;
        }
        replyMsg.setNumberOfParts(parts);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(OK_BYTES);
        replyMsg.addIntPart(flags);
        if (sendOldValue) {
            replyMsg.addObjPart(oldValue);
        }
        if (versionTag != null) {
            replyMsg.addObjPart(versionTag);
        }
        replyMsg.send(servConn);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl tx: {} parts={}", (Object)servConn.getName(), (Object)origMsg.getTransactionId(), (Object)replyMsg.getNumberOfParts());
        }
    }

    @Override
    protected void writeReplyWithRefreshMetadata(Message origMsg, ServerConnection servConn, PartitionedRegion pr, boolean sendOldValue, boolean oldValueIsObject, Object oldValue, byte nwHopType, VersionTag versionTag) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        int flags = 0;
        int parts = 1;
        ++parts;
        if (sendOldValue) {
            flags |= 1;
            if (oldValueIsObject) {
                flags |= 2;
            }
            ++parts;
        }
        if (versionTag != null) {
            flags |= 4;
            ++parts;
        }
        replyMsg.setNumberOfParts(parts);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(new byte[]{pr.getMetadataVersion(), nwHopType});
        replyMsg.addIntPart(flags);
        if (sendOldValue) {
            replyMsg.addObjPart(oldValue);
        }
        if (versionTag != null) {
            replyMsg.addObjPart(versionTag);
        }
        replyMsg.send(servConn);
        pr.getPrStats().incPRMetaDataSentCount();
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl with REFRESH_METADAT tx: {} parts={}", (Object)servConn.getName(), (Object)origMsg.getTransactionId(), (Object)replyMsg.getNumberOfParts());
        }
    }
}

