/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.security.NotAuthorizedException;

public class CreateRegion
extends BaseCommand {
    private static final CreateRegion singleton = new CreateRegion();

    public static Command getCommand() {
        return singleton;
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        Region<Object, Object> region;
        Part regionNamePart = null;
        String regionName = null;
        servConn.setAsTrue(2);
        Part parentRegionNamePart = msg.getPart(0);
        String parentRegionName = parentRegionNamePart.getString();
        regionNamePart = msg.getPart(1);
        regionName = regionNamePart.getString();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received create region request ({} bytes) from {} for parent region {} region {}", (Object)servConn.getName(), (Object)msg.getPayloadLength(), (Object)servConn.getSocketString(), (Object)parentRegionName, (Object)regionName);
        }
        if (parentRegionName == null || regionName == null) {
            String errMessage = "";
            if (parentRegionName == null) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.CreateRegion_0_THE_INPUT_PARENT_REGION_NAME_FOR_THE_CREATE_REGION_REQUEST_IS_NULL, servConn.getName()));
                errMessage = LocalizedStrings.CreateRegion_THE_INPUT_PARENT_REGION_NAME_FOR_THE_CREATE_REGION_REQUEST_IS_NULL.toLocalizedString();
            }
            if (regionName == null) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.CreateRegion_0_THE_INPUT_REGION_NAME_FOR_THE_CREATE_REGION_REQUEST_IS_NULL, servConn.getName()));
                errMessage = LocalizedStrings.CreateRegion_THE_INPUT_REGION_NAME_FOR_THE_CREATE_REGION_REQUEST_IS_NULL.toLocalizedString();
            }
            CreateRegion.writeErrorResponse(msg, 30, errMessage, servConn);
            servConn.setAsTrue(1);
            return;
        }
        Region parentRegion = servConn.getCache().getRegion(parentRegionName);
        if (parentRegion == null) {
            String reason = LocalizedStrings.CreateRegion__0_WAS_NOT_FOUND_DURING_SUBREGION_CREATION_REQUEST.toLocalizedString(parentRegionName);
            CreateRegion.writeRegionDestroyedEx(msg, parentRegionName, reason, servConn);
            servConn.setAsTrue(1);
            return;
        }
        try {
            this.securityService.authorizeDataManage();
        }
        catch (NotAuthorizedException ex) {
            CreateRegion.writeException(msg, ex, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        AuthorizeRequest authzRequest = servConn.getAuthzRequest();
        if (authzRequest != null) {
            try {
                authzRequest.createRegionAuthorize(parentRegionName + '/' + regionName);
            }
            catch (NotAuthorizedException ex) {
                CreateRegion.writeException(msg, ex, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
        }
        if ((region = parentRegion.getSubregion(regionName)) == null) {
            AttributesFactory factory = new AttributesFactory(parentRegion.getAttributes());
            region = parentRegion.createSubregion(regionName, factory.create());
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Created region {}", (Object)servConn.getName(), (Object)region);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("{}: Retrieved region {}", (Object)servConn.getName(), (Object)region);
        }
        this.writeReply(msg, servConn);
        servConn.setAsTrue(1);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sent create region response for parent region {} region {}", (Object)servConn.getName(), (Object)parentRegionName, (Object)regionName);
        }
    }
}

