/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.geode.cache.operations.RegionClearOperationContext;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.AuthorizeRequest;

public class ClearRegion
extends BaseCommand {
    private static final ClearRegion singleton = new ClearRegion();

    private ClearRegion() {
    }

    public static Command getCommand() {
        return singleton;
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        Part regionNamePart = null;
        Part callbackArgPart = null;
        String regionName = null;
        Object callbackArg = null;
        Part eventPart = null;
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        servConn.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadClearRegionRequestTime(start - oldStart);
        regionNamePart = msg.getPart(0);
        eventPart = msg.getPart(1);
        if (msg.getNumberOfParts() > 2) {
            callbackArgPart = msg.getPart(2);
            try {
                callbackArg = callbackArgPart.getObject();
            }
            catch (Exception e) {
                ClearRegion.writeException(msg, e, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
        }
        regionName = regionNamePart.getString();
        if (logger.isDebugEnabled()) {
            logger.debug(servConn.getName() + ": Received clear region request (" + msg.getPayloadLength() + " bytes) from " + servConn.getSocketString() + " for region " + regionName);
        }
        if (regionName == null) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.ClearRegion_0_THE_INPUT_REGION_NAME_FOR_THE_CLEAR_REGION_REQUEST_IS_NULL, servConn.getName()));
            String errMessage = LocalizedStrings.ClearRegion_THE_INPUT_REGION_NAME_FOR_THE_CLEAR_REGION_REQUEST_IS_NULL.toLocalizedString();
            ClearRegion.writeErrorResponse(msg, 37, errMessage, servConn);
            servConn.setAsTrue(1);
            return;
        }
        LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
        if (region == null) {
            String reason = LocalizedStrings.ClearRegion_WAS_NOT_FOUND_DURING_CLEAR_REGION_REGUEST.toLocalizedString();
            ClearRegion.writeRegionDestroyedEx(msg, regionName, reason, servConn);
            servConn.setAsTrue(1);
            return;
        }
        ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
        long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
        long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
        EventID eventId = new EventID(servConn.getEventMemberIDByteArray(), threadId, sequenceId);
        try {
            this.securityService.authorizeRegionWrite(regionName);
            AuthorizeRequest authzRequest = servConn.getAuthzRequest();
            if (authzRequest != null) {
                RegionClearOperationContext clearContext = authzRequest.clearAuthorize(regionName, callbackArg);
                callbackArg = clearContext.getCallbackArg();
            }
            region.basicBridgeClear(callbackArg, servConn.getProxyID(), true, eventId);
        }
        catch (Exception e) {
            ClearRegion.checkForInterrupt(servConn, e);
            ClearRegion.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        long oldStart2 = start;
        start = DistributionStats.getStatTime();
        stats.incProcessClearRegionTime(start - oldStart2);
        this.writeReply(msg, servConn);
        servConn.setAsTrue(1);
        if (logger.isDebugEnabled()) {
            logger.debug(servConn.getName() + ": Sent clear region response for region " + regionName);
        }
        stats.incWriteClearRegionResponseTime(DistributionStats.getStatTime() - start);
    }
}

