/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.Conflatable;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.lru.Sizeable;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ClientUpdateMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientUpdateMessageImpl;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class HAEventWrapper
implements Conflatable,
DataSerializableFixedID,
Sizeable {
    private static final long serialVersionUID = 5874226899495609988L;
    private static final Logger logger = LogService.getLogger();
    private String regionName;
    private Object keyOfInterest;
    private boolean shouldConflate = false;
    private EventID eventIdentifier;
    private Map haContainer;
    private volatile long referenceCount;
    private static final AtomicLongFieldUpdater<HAEventWrapper> rcUpdater = AtomicLongFieldUpdater.newUpdater(HAEventWrapper.class, "referenceCount");
    private transient boolean putInProgress = false;
    private transient boolean isRefFromHAContainer = false;
    private ClientUpdateMessage clientUpdateMessage = null;
    private ClientUpdateMessageImpl.ClientCqConcurrentMap clientCqs = null;

    public HAEventWrapper(ClientUpdateMessage event) {
        this.regionName = event.getRegionName();
        this.keyOfInterest = event.getKeyOfInterest();
        this.shouldConflate = event.shouldBeConflated();
        this.eventIdentifier = event.getEventId();
        rcUpdater.set(this, 0L);
        this.clientUpdateMessage = event;
        this.clientCqs = ((ClientUpdateMessageImpl)event).getClientCqs();
    }

    public HAEventWrapper(EventID eventId) {
        this.eventIdentifier = eventId;
        this.clientUpdateMessage = new ClientUpdateMessageImpl(EnumListenerEvent.AFTER_CREATE, new ClientProxyMembershipID(), eventId);
        rcUpdater.set(this, 0L);
    }

    public HAEventWrapper() {
    }

    @Override
    public EventID getEventId() {
        return this.eventIdentifier;
    }

    @Override
    public Object getKeyToConflate() {
        return this.keyOfInterest;
    }

    @Override
    public String getRegionToConflate() {
        return this.regionName;
    }

    @Override
    public Object getValueToConflate() {
        return null;
    }

    @Override
    public void setLatestValue(Object value) {
    }

    @Override
    public boolean shouldBeConflated() {
        return this.shouldConflate;
    }

    public void setClientUpdateMessage(ClientUpdateMessage cum) {
        this.clientUpdateMessage = cum;
    }

    public ClientUpdateMessage getClientUpdateMessage() {
        return this.clientUpdateMessage;
    }

    public ClientUpdateMessageImpl.ClientCqConcurrentMap getClientCqs() {
        return this.clientCqs;
    }

    public void setPutInProgress(boolean inProgress) {
        this.putInProgress = inProgress;
    }

    public boolean getPutInProgress() {
        return this.putInProgress;
    }

    public void setIsRefFromHAContainer(boolean bool) {
        this.isRefFromHAContainer = bool;
    }

    public boolean getIsRefFromHAContainer() {
        return this.isRefFromHAContainer;
    }

    public void setHAContainer(Map container) {
        this.haContainer = container;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof HAEventWrapper)) {
            return false;
        }
        return this == other || this.getEventId().equals(((HAEventWrapper)other).getEventId());
    }

    public int hashCode() {
        return this.getEventId().hashCode();
    }

    public String toString() {
        if (this.clientUpdateMessage != null) {
            return "HAEventWrapper[refCount=" + this.getReferenceCount() + "; msg=" + this.clientUpdateMessage + "]";
        }
        return "HAEventWrapper[region=" + this.regionName + "; key=" + this.keyOfInterest + "; refCount=" + this.getReferenceCount() + "; inContainer=" + this.isRefFromHAContainer + "; putInProgress=" + this.putInProgress + "; event=" + this.eventIdentifier + (this.clientUpdateMessage == null ? "; no message" : ";with message") + (this.clientUpdateMessage == null ? "" : "; op=" + this.clientUpdateMessage.getOperation()) + (this.clientUpdateMessage == null ? "" : "; version=" + this.clientUpdateMessage.getVersionTag()) + "]";
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        ClientUpdateMessageImpl cum = (ClientUpdateMessageImpl)this.haContainer.get(this);
        if (cum != null) {
            DataSerializer.writePrimitiveBoolean(true, out);
            DataSerializer.writeObject(cum.getEventId(), out);
        } else {
            DataSerializer.writePrimitiveBoolean(false, out);
            DataSerializer.writeObject(new EventID(), out);
            cum = new ClientUpdateMessageImpl(EnumListenerEvent.AFTER_CREATE, new ClientProxyMembershipID(), null);
        }
        InternalDataSerializer.invokeToData(cum, out);
        if (cum.hasCqs()) {
            DataSerializer.writeConcurrentHashMap(cum.getClientCqs(), out);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        if (DataSerializer.readPrimitiveBoolean(in)) {
            this.eventIdentifier = (EventID)DataSerializer.readObject(in);
            this.clientUpdateMessage = new ClientUpdateMessageImpl();
            InternalDataSerializer.invokeFromData(this.clientUpdateMessage, in);
            ((ClientUpdateMessageImpl)this.clientUpdateMessage).setEventIdentifier(this.eventIdentifier);
            if (this.clientUpdateMessage.hasCqs()) {
                ClientUpdateMessageImpl.ClientCqConcurrentMap cqMap;
                int size = InternalDataSerializer.readArrayLength(in);
                if (size == -1) {
                    cqMap = null;
                } else {
                    cqMap = new ClientUpdateMessageImpl.ClientCqConcurrentMap(size, 1.0f, 1);
                    for (int i = 0; i < size; ++i) {
                        ClientUpdateMessageImpl.CqNameToOp value;
                        ClientProxyMembershipID key = (ClientProxyMembershipID)DataSerializer.readObject(in);
                        byte typeByte = in.readByte();
                        if (typeByte == 67) {
                            int cqNamesSize = InternalDataSerializer.readArrayLength(in);
                            if (cqNamesSize == -1) {
                                throw new IllegalStateException("The value of a ConcurrentHashMap is not allowed to be null.");
                            }
                            if (cqNamesSize == 1) {
                                String cqNamesKey = (String)DataSerializer.readObject(in);
                                Integer cqNamesValue = (Integer)DataSerializer.readObject(in);
                                value = new ClientUpdateMessageImpl.CqNameToOpSingleEntry(cqNamesKey, cqNamesValue);
                            } else if (cqNamesSize == 0) {
                                value = new ClientUpdateMessageImpl.CqNameToOpSingleEntry(null, 0);
                            } else {
                                value = new ClientUpdateMessageImpl.CqNameToOpHashMap(cqNamesSize);
                                for (int j = 0; j < cqNamesSize; ++j) {
                                    String cqNamesKey = (String)DataSerializer.readObject(in);
                                    Integer cqNamesValue = (Integer)DataSerializer.readObject(in);
                                    value.add(cqNamesKey, cqNamesValue);
                                }
                            }
                        } else {
                            if (typeByte == 41) {
                                throw new IllegalStateException("The value of a ConcurrentHashMap is not allowed to be null.");
                            }
                            throw new IllegalStateException("Expected DSCODE.NULL or DSCODE.HASH_MAP but read " + typeByte);
                        }
                        cqMap.put(key, value);
                    }
                }
                this.clientCqs = cqMap;
                ((ClientUpdateMessageImpl)this.clientUpdateMessage).setClientCqs(this.clientCqs);
            }
            this.regionName = this.clientUpdateMessage.getRegionName();
            this.keyOfInterest = this.clientUpdateMessage.getKeyOfInterest();
            this.shouldConflate = this.clientUpdateMessage.shouldBeConflated();
            rcUpdater.set(this, 0L);
        } else {
            DataSerializer.readObject(in);
            InternalDataSerializer.invokeFromData(new ClientUpdateMessageImpl(), in);
            if (logger.isDebugEnabled()) {
                logger.debug("HAEventWrapper.fromData(): The event has already been sent to the client by the primary server.");
            }
        }
    }

    @Override
    public int getDSFID() {
        return 115;
    }

    @Override
    public int getSizeInBytes() {
        return 0;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    public long getReferenceCount() {
        return rcUpdater.get(this);
    }

    public long incAndGetReferenceCount() {
        return rcUpdater.incrementAndGet(this);
    }

    public long decAndGetReferenceCount() {
        return rcUpdater.decrementAndGet(this);
    }
}

