/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.Instantiator;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.InterestRegistrationEvent;
import org.apache.geode.cache.InterestRegistrationListener;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.UnsupportedVersionException;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.cache.query.internal.cq.ServerCQ;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.internal.ClassLoadUtil;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.InternalInstantiator;
import org.apache.geode.internal.SystemTimer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.VersionedDataInputStream;
import org.apache.geode.internal.VersionedDataOutputStream;
import org.apache.geode.internal.cache.CacheClientStatus;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.ClientRegionEventImpl;
import org.apache.geode.internal.cache.ClientServerObserver;
import org.apache.geode.internal.cache.ClientServerObserverHolder;
import org.apache.geode.internal.cache.Conflatable;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.FilterProfile;
import org.apache.geode.internal.cache.FilterRoutingInfo;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCacheEvent;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RegionEventImpl;
import org.apache.geode.internal.cache.ha.HAContainerMap;
import org.apache.geode.internal.cache.ha.HAContainerRegion;
import org.apache.geode.internal.cache.ha.HAContainerWrapper;
import org.apache.geode.internal.cache.ha.HARegionQueue;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifierStats;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ClientBlacklistProcessor;
import org.apache.geode.internal.cache.tier.sockets.ClientHealthMonitor;
import org.apache.geode.internal.cache.tier.sockets.ClientInterestMessageImpl;
import org.apache.geode.internal.cache.tier.sockets.ClientPingMessageImpl;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ClientTombstoneMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientUpdateMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientUpdateMessageImpl;
import org.apache.geode.internal.cache.tier.sockets.ConnectionListener;
import org.apache.geode.internal.cache.tier.sockets.HAEventWrapper;
import org.apache.geode.internal.cache.tier.sockets.HandShake;
import org.apache.geode.internal.cache.tier.sockets.RemoveClientFromBlacklistMessage;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.net.SocketCloser;
import org.apache.geode.internal.statistics.DummyStatisticsFactory;
import org.apache.geode.security.AccessControl;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.AuthenticationRequiredException;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.subject.Subject;

public class CacheClientNotifier {
    private static final Logger logger = LogService.getLogger();
    private static volatile CacheClientNotifier ccnSingleton;
    protected static final String ALL_HOSTS = "ALL_HOSTS";
    protected static final int ALL_PORTS = -1;
    private final ConcurrentMap _clientProxies = new ConcurrentHashMap();
    private final ConcurrentMap _initClientProxies = new ConcurrentHashMap();
    private final HashSet<ClientProxyMembershipID> timedOutDurableClientProxies = new HashSet();
    private GemFireCacheImpl _cache;
    private InternalLogWriter logWriter;
    private InternalLogWriter securityLogWriter;
    private int maximumMessageCount;
    private int messageTimeToLive;
    private ConnectionListener _connectionListener;
    private CacheServerStats acceptorStats;
    private volatile HAContainerWrapper haContainer;
    private static final int socketBufferSize;
    protected final CacheClientNotifierStats _statistics;
    private final Set writableInterestRegistrationListeners = new CopyOnWriteArraySet();
    private final Set readableInterestRegistrationListeners = Collections.unmodifiableSet(this.writableInterestRegistrationListeners);
    public static final String MAX_QUEUE_LOG_FREQUENCY = "gemfire.logFrequency.clientQueueReachedMaxLimit";
    public static final long DEFAULT_LOG_FREQUENCY = 1000L;
    public static final String EVENT_ENQUEUE_WAIT_TIME_NAME = "gemfire.subscription.EVENT_ENQUEUE_WAIT_TIME";
    public static final int DEFAULT_EVENT_ENQUEUE_WAIT_TIME = 100;
    public static int eventEnqueueWaitTime;
    private long logFrequency = 1000L;
    private final ConcurrentHashMap<String, DefaultQuery> compiledQueries = new ConcurrentHashMap();
    private volatile boolean isCompiledQueryCleanupThreadStarted = false;
    private final Object lockIsCompiledQueryCleanupThreadStarted = new Object();
    private SystemTimer.SystemTimerTask clientPingTask;
    private final SocketCloser socketCloser;
    private static final long CLIENT_PING_TASK_PERIOD;
    private static final long CLIENT_PING_TASK_COUNTER;
    private final Set blackListedClients = new CopyOnWriteArraySet();

    public static synchronized CacheClientNotifier getInstance(Cache cache, CacheServerStats acceptorStats, int maximumMessageCount, int messageTimeToLive, ConnectionListener listener, List overflowAttributesList, boolean isGatewayReceiver) {
        if (ccnSingleton == null) {
            ccnSingleton = new CacheClientNotifier(cache, acceptorStats, maximumMessageCount, messageTimeToLive, listener, overflowAttributesList, isGatewayReceiver);
        }
        if (!isGatewayReceiver && ccnSingleton.getHaContainer() == null) {
            ccnSingleton.initHaContainer(overflowAttributesList);
        }
        return ccnSingleton;
    }

    public static CacheClientNotifier getInstance() {
        return ccnSingleton;
    }

    private void writeMessage(DataOutputStream dos, byte type, String p_msg, Version clientVersion) throws IOException {
        this.writeMessage(dos, type, p_msg, clientVersion, (byte)0, 0);
    }

    private void writeMessage(DataOutputStream dos, byte type, String p_msg, Version clientVersion, byte epType, int qSize) throws IOException {
        String msg = p_msg;
        dos.writeByte(type);
        dos.writeByte(epType);
        dos.writeInt(qSize);
        if (msg == null) {
            msg = "";
        }
        dos.writeUTF(msg);
        if (clientVersion != null && clientVersion.compareTo(Version.GFE_61) >= 0) {
            Instantiator[] instantiators = InternalInstantiator.getInstantiators();
            HashMap instantiatorMap = new HashMap();
            if (instantiators != null && instantiators.length > 0) {
                for (Instantiator instantiator : instantiators) {
                    ArrayList<String> instantiatorAttributes = new ArrayList<String>();
                    instantiatorAttributes.add(instantiator.getClass().toString().substring(6));
                    instantiatorAttributes.add(instantiator.getInstantiatedClass().toString().substring(6));
                    instantiatorMap.put(instantiator.getId(), instantiatorAttributes);
                }
            }
            DataSerializer.writeHashMap(instantiatorMap, dos);
            DataSerializer[] dataSerializers = InternalDataSerializer.getSerializers();
            HashMap dsToSupportedClasses = new HashMap();
            HashMap<Integer, String> dataSerializersMap = new HashMap<Integer, String>();
            if (dataSerializers != null && dataSerializers.length > 0) {
                for (DataSerializer dataSerializer : dataSerializers) {
                    dataSerializersMap.put(dataSerializer.getId(), dataSerializer.getClass().toString().substring(6));
                    if (clientVersion.compareTo(Version.GFE_6516) < 0) continue;
                    ArrayList<String> supportedClassNames = new ArrayList<String>();
                    for (Class<?> clazz : dataSerializer.getSupportedClasses()) {
                        supportedClassNames.add(clazz.getName());
                    }
                    dsToSupportedClasses.put(dataSerializer.getId(), supportedClassNames);
                }
            }
            DataSerializer.writeHashMap(dataSerializersMap, dos);
            if (clientVersion.compareTo(Version.GFE_6516) >= 0) {
                DataSerializer.writeHashMap(dsToSupportedClasses, dos);
            }
        }
        dos.flush();
    }

    private void writeException(DataOutputStream dos, byte type, Exception ex, Version clientVersion) throws IOException {
        this.writeMessage(dos, type, ex.toString(), clientVersion);
    }

    public void registerClient(Socket socket, boolean isPrimary, long acceptorId, boolean notifyBySubscription) throws IOException {
        long startTime = this._statistics.startTime();
        DataInputStream dis = new DataInputStream(socket.getInputStream());
        DataOutputStream dos = new DataOutputStream(socket.getOutputStream());
        short clientVersionOrdinal = Version.readOrdinal(dis);
        Version clientVersion = null;
        try {
            clientVersion = Version.fromOrdinal(clientVersionOrdinal, true);
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Registering client with version: {}", (Object)this, (Object)clientVersion);
            }
        }
        catch (UnsupportedVersionException e) {
            SocketAddress sa = socket.getRemoteSocketAddress();
            UnsupportedVersionException uve = e;
            if (sa != null) {
                String sInfo = " Client: " + sa.toString() + ".";
                uve = new UnsupportedVersionException(e.getMessage() + sInfo);
            }
            logger.warn(LocalizedMessage.create(LocalizedStrings.CacheClientNotifier_CACHECLIENTNOTIFIER_CAUGHT_EXCEPTION_ATTEMPTING_TO_CLIENT), (Throwable)uve);
            this.writeException(dos, (byte)106, uve, clientVersion);
            return;
        }
        dis.readByte();
        if (Version.GFE_57.compareTo(clientVersion) <= 0) {
            if (Version.CURRENT.compareTo(clientVersion) > 0) {
                dis = new VersionedDataInputStream(dis, clientVersion);
                dos = new VersionedDataOutputStream(dos, clientVersion);
            }
        } else {
            e = new UnsupportedVersionException(clientVersionOrdinal);
            throw new IOException(e.toString());
        }
        this.registerGFEClient(dis, dos, socket, isPrimary, startTime, clientVersion, acceptorId, notifyBySubscription);
    }

    protected void registerGFEClient(DataInputStream dis, DataOutputStream dos, Socket socket, boolean isPrimary, long startTime, Version clientVersion, long acceptorId, boolean notifyBySubscription) throws IOException {
        int numberOfPorts = dis.readInt();
        for (int i = 0; i < numberOfPorts; ++i) {
            dis.readInt();
        }
        ClientProxyMembershipID proxyID = null;
        AccessControl authzCallback = null;
        byte clientConflation = 0;
        try {
            proxyID = ClientProxyMembershipID.readCanonicalized(dis);
            if (this.getBlacklistedClient().contains(proxyID)) {
                this.writeException(dos, (byte)61, new Exception("This client is blacklisted by server"), clientVersion);
                return;
            }
            CacheClientProxy proxy = this.getClientProxy(proxyID);
            DistributedMember member = proxyID.getDistributedMember();
            DistributedSystem system = this.getCache().getDistributedSystem();
            Properties sysProps = system.getProperties();
            String authenticator = sysProps.getProperty("security-client-authenticator");
            if (clientVersion.compareTo(Version.GFE_603) >= 0) {
                byte[] overrides = HandShake.extractOverrides(new byte[]{(byte)dis.read()});
                clientConflation = overrides[0];
            } else {
                clientConflation = (byte)dis.read();
            }
            switch (clientConflation) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    this.writeException(dos, (byte)61, new IllegalArgumentException("Invalid conflation byte"), clientVersion);
                    return;
                }
            }
            proxy = this.registerClient(socket, proxyID, proxy, isPrimary, clientConflation, clientVersion, acceptorId, notifyBySubscription);
            Properties credentials = HandShake.readCredentials(dis, dos, system);
            if (credentials != null && proxy != null) {
                Object subject;
                if (this.securityLogWriter.fineEnabled()) {
                    this.securityLogWriter.fine("CacheClientNotifier: verifying credentials for proxyID: " + proxyID);
                }
                if ((subject = HandShake.verifyCredentials(authenticator, credentials, system.getSecurityProperties(), this.logWriter, this.securityLogWriter, member)) instanceof Principal) {
                    String postAuthzFactoryName;
                    Principal principal = (Principal)subject;
                    if (this.securityLogWriter.fineEnabled()) {
                        this.securityLogWriter.fine("CacheClientNotifier: successfully verified credentials for proxyID: " + proxyID + " having principal: " + principal.getName());
                    }
                    if ((postAuthzFactoryName = sysProps.getProperty("security-client-accessor-pp")) != null && postAuthzFactoryName.length() > 0) {
                        if (principal == null) {
                            this.securityLogWriter.warning(LocalizedStrings.CacheClientNotifier_CACHECLIENTNOTIFIER_POST_PROCESS_AUTHORIZATION_CALLBACK_ENABLED_BUT_AUTHENTICATION_CALLBACK_0_RETURNED_WITH_NULL_CREDENTIALS_FOR_PROXYID_1, new Object[]{"security-client-authenticator", proxyID});
                        }
                        Method authzMethod = ClassLoadUtil.methodFromName(postAuthzFactoryName);
                        authzCallback = (AccessControl)authzMethod.invoke(null, (Object[])null);
                        authzCallback.init(principal, member, this.getCache());
                    }
                    proxy.setPostAuthzCallback(authzCallback);
                } else if (subject instanceof Subject) {
                    proxy.setSubject((Subject)subject);
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException(LocalizedStrings.CacheClientNotifier_CLIENTPROXYMEMBERSHIPID_OBJECT_COULD_NOT_BE_CREATED_EXCEPTION_OCCURRED_WAS_0.toLocalizedString(e));
        }
        catch (AuthenticationRequiredException ex) {
            this.securityLogWriter.warning(LocalizedStrings.CacheClientNotifier_AN_EXCEPTION_WAS_THROWN_FOR_CLIENT_0_1, new Object[]{proxyID, ex});
            this.writeException(dos, (byte)62, ex, clientVersion);
            return;
        }
        catch (AuthenticationFailedException ex) {
            this.securityLogWriter.warning(LocalizedStrings.CacheClientNotifier_AN_EXCEPTION_WAS_THROWN_FOR_CLIENT_0_1, new Object[]{proxyID, ex});
            this.writeException(dos, (byte)63, ex, clientVersion);
            return;
        }
        catch (CacheException e) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.CacheClientNotifier_0_REGISTERCLIENT_EXCEPTION_ENCOUNTERED_IN_REGISTRATION_1, new Object[]{this, e}), (Throwable)e);
            IOException io = new IOException(LocalizedStrings.CacheClientNotifier_EXCEPTION_OCCURRED_WHILE_TRYING_TO_REGISTER_INTEREST_DUE_TO_0.toLocalizedString(e.getMessage()));
            io.initCause(e);
            throw io;
        }
        catch (Exception ex) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.CacheClientNotifier_AN_EXCEPTION_WAS_THROWN_FOR_CLIENT_0_1, new Object[]{proxyID, ""}), (Throwable)ex);
            this.writeException(dos, (byte)106, ex, clientVersion);
            return;
        }
        this._statistics.endClientRegistration(startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private CacheClientProxy registerClient(Socket socket, ClientProxyMembershipID proxyId, CacheClientProxy proxy, boolean isPrimary, byte clientConflation, Version clientVersion, long acceptorId, boolean notifyBySubscription) throws IOException, CacheException {
        l_proxy = proxy;
        socket.setTcpNoDelay(true);
        socket.setSendBufferSize(CacheClientNotifier.socketBufferSize);
        socket.setReceiveBufferSize(CacheClientNotifier.socketBufferSize);
        if (CacheClientNotifier.logger.isDebugEnabled()) {
            CacheClientNotifier.logger.debug("CacheClientNotifier: Initialized server-to-client socket with send buffer size: {} bytes and receive buffer size: {} bytes", (Object)socket.getSendBufferSize(), (Object)socket.getReceiveBufferSize());
        }
        responseByte = 105;
        unsuccessfulMsg = null;
        successful = true;
        clientIsDurable = proxyId.isDurable();
        if (CacheClientNotifier.logger.isDebugEnabled()) {
            if (clientIsDurable) {
                CacheClientNotifier.logger.debug("CacheClientNotifier: Attempting to register durable client: {}", (Object)proxyId.getDurableId());
            } else {
                CacheClientNotifier.logger.debug("CacheClientNotifier: Attempting to register non-durable client");
            }
        }
        epType = 0;
        qSize = 0;
        if (clientIsDurable) {
            if (l_proxy == null) {
                qSize = this.isTimedOut(proxyId) != false ? -1 : -2;
                if (CacheClientNotifier.logger.isDebugEnabled()) {
                    CacheClientNotifier.logger.debug("CacheClientNotifier: No proxy exists for durable client with id {}. It must be created.", (Object)proxyId.getDurableId());
                }
                l_proxy = new CacheClientProxy(this, socket, proxyId, isPrimary, clientConflation, clientVersion, acceptorId, notifyBySubscription);
                successful = this.initializeProxy(l_proxy);
            } else {
                epType = proxy.isPrimary() != false ? 2 : 1;
                qSize = proxy.getQueueSize();
                if (l_proxy.isPaused()) {
                    if (CacheClientProxy.testHook != null) {
                        CacheClientProxy.testHook.doTestHook("CLIENT_PRE_RECONNECT");
                    }
                    if (l_proxy.lockDrain()) {
                        try {
                            if (CacheClientNotifier.logger.isDebugEnabled()) {
                                CacheClientNotifier.logger.debug("CacheClientNotifier: A proxy exists for durable client with id {}. This proxy will be reinitialized: {}", (Object)proxyId.getDurableId(), (Object)l_proxy);
                            }
                            this._statistics.incDurableReconnectionCount();
                            l_proxy.getProxyID().updateDurableTimeout(proxyId.getDurableTimeout());
                            l_proxy.reinitialize(socket, proxyId, this.getCache(), isPrimary, clientConflation, clientVersion);
                            l_proxy.setMarkerEnqueued(true);
                            if (CacheClientProxy.testHook == null) ** GOTO lbl74
                            CacheClientProxy.testHook.doTestHook("CLIENT_RECONNECTED");
                        }
                        finally {
                            l_proxy.unlockDrain();
                        }
                    } else {
                        unsuccessfulMsg = LocalizedStrings.CacheClientNotifier_COULD_NOT_CONNECT_DUE_TO_CQ_BEING_DRAINED.toLocalizedString();
                        CacheClientNotifier.logger.warn(unsuccessfulMsg);
                        responseByte = 60;
                        if (CacheClientProxy.testHook != null) {
                            CacheClientProxy.testHook.doTestHook("CLIENT_REJECTED_DUE_TO_CQ_BEING_DRAINED");
                        }
                    }
                } else {
                    unsuccessfulMsg = LocalizedStrings.CacheClientNotifier_CACHECLIENTNOTIFIER_THE_REQUESTED_DURABLE_CLIENT_HAS_THE_SAME_IDENTIFIER__0__AS_AN_EXISTING_DURABLE_CLIENT__1__DUPLICATE_DURABLE_CLIENTS_ARE_NOT_ALLOWED.toLocalizedString(new Object[]{proxyId.getDurableId(), proxy});
                    CacheClientNotifier.logger.warn(unsuccessfulMsg);
                    responseByte = 64;
                }
            }
        } else {
            staleClientProxy = this.getClientProxy(proxyId);
            toCreateNewProxy = true;
            if (staleClientProxy != null) {
                if (staleClientProxy.isConnected() && staleClientProxy.getSocket().isConnected()) {
                    successful = false;
                    toCreateNewProxy = false;
                } else {
                    if (CacheClientNotifier.logger.isDebugEnabled()) {
                        CacheClientNotifier.logger.debug("CacheClientNotifier: A proxy exists for this non-durable client. It must be closed.");
                    }
                    if (staleClientProxy.startRemoval()) {
                        staleClientProxy.waitRemoval();
                    } else {
                        staleClientProxy.close(false, false);
                        this.removeClientProxy(staleClientProxy);
                    }
                }
            }
            if (toCreateNewProxy) {
                l_proxy = new CacheClientProxy(this, socket, proxyId, isPrimary, clientConflation, clientVersion, acceptorId, notifyBySubscription);
                successful = this.initializeProxy(l_proxy);
            }
        }
lbl74:
        // 8 sources

        if (!successful) {
            l_proxy = null;
            responseByte = 60;
            unsuccessfulMsg = LocalizedStrings.CacheClientNotifier_CACHECLIENTNOTIFIER_A_PREVIOUS_CONNECTION_ATTEMPT_FROM_THIS_CLIENT_IS_STILL_BEING_PROCESSED__0.toLocalizedString(new Object[]{proxyId});
        }
        try {
            dos = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            this.writeMessage(dos, (byte)responseByte, unsuccessfulMsg, clientVersion, epType, qSize);
        }
        catch (IOException ioe) {
            if (l_proxy != null && !(keepProxy = l_proxy.close(false, false))) {
                this.removeClientProxy(l_proxy);
            }
            throw ioe;
        }
        if (unsuccessfulMsg != null && CacheClientNotifier.logger.isDebugEnabled()) {
            CacheClientNotifier.logger.debug(unsuccessfulMsg);
        }
        if (!clientIsDurable && l_proxy != null && responseByte == 105) {
            l_proxy.startOrResumeMessageDispatcher(false);
        }
        if (responseByte == 105) {
            if (CacheClientNotifier.logger.isDebugEnabled()) {
                CacheClientNotifier.logger.debug("CacheClientNotifier: Successfully registered {}", (Object)l_proxy);
            }
        } else {
            CacheClientNotifier.logger.warn(LocalizedMessage.create(LocalizedStrings.CacheClientNotifier_CACHECLIENTNOTIFIER_UNSUCCESSFULLY_REGISTERED_CLIENT_WITH_IDENTIFIER__0, proxyId));
        }
        return l_proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initializeProxy(CacheClientProxy l_proxy) throws IOException, CacheException {
        boolean status = false;
        if (!this.isProxyInInitializationMode(l_proxy)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Initializing proxy: {}", (Object)l_proxy);
            }
            try {
                this.addClientInitProxy(l_proxy);
                l_proxy.initializeMessageDispatcher();
                this.addClientProxy(l_proxy);
                boolean bl = true;
                return bl;
            }
            catch (RegionExistsException ree) {
                if (logger.isDebugEnabled()) {
                    String name = ree.getRegion() != null ? ree.getRegion().getFullPath() : "null region";
                    logger.debug("Found RegionExistsException while initializing proxy. Region name: {}", (Object)name);
                }
            }
            finally {
                this.removeClientInitProxy(l_proxy);
            }
        }
        return status;
    }

    public void makePrimary(ClientProxyMembershipID proxyId, boolean isClientReady) {
        CacheClientProxy proxy = this.getClientProxy(proxyId);
        if (proxy != null) {
            proxy.setPrimary(true);
            if (isClientReady || !proxy.isDurable()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("CacheClientNotifier: Notifying proxy to start dispatcher for: {}", (Object)proxy);
                }
                proxy.startOrResumeMessageDispatcher(false);
            }
        } else {
            throw new InternalGemFireError("No cache client proxy on this node for proxyId " + proxyId);
        }
    }

    public boolean processDispatchedMessage(ClientProxyMembershipID proxyId, EventID eid) {
        boolean success = false;
        CacheClientProxy proxy = this.getClientProxy(proxyId);
        if (proxy != null) {
            HARegionQueue harq = proxy.getHARegionQueue();
            harq.addDispatchedMessage(new ThreadIdentifier(eid.getMembershipID(), eid.getThreadID()), eid.getSequenceID());
            success = true;
        }
        return success;
    }

    public void setKeepAlive(ClientProxyMembershipID membershipID, boolean keepAlive) {
        CacheClientProxy proxy;
        if (logger.isDebugEnabled()) {
            logger.debug("CacheClientNotifier: setKeepAlive client: {}", (Object)membershipID);
        }
        if ((proxy = this.getClientProxy(membershipID)) != null) {
            proxy.setKeepAlive(keepAlive);
        }
    }

    public void unregisterClient(ClientProxyMembershipID memberId, boolean normalShutdown) {
        CacheClientProxy proxy;
        if (logger.isDebugEnabled()) {
            logger.debug("CacheClientNotifier: Unregistering all clients with member id: {}", (Object)memberId);
        }
        if ((proxy = this.getClientProxy(memberId)) != null) {
            boolean isTraceEnabled = logger.isTraceEnabled();
            if (isTraceEnabled) {
                logger.trace("CacheClientNotifier: Potential client: {}", (Object)proxy);
            }
            if (!proxy.startRemoval()) {
                if (isTraceEnabled) {
                    logger.trace("CacheClientNotifier: Potential client: {} matches {}", (Object)proxy, (Object)memberId);
                }
                this.closeDeadProxies(Collections.singletonList(proxy), normalShutdown);
            }
        }
    }

    public void readyForEvents(ClientProxyMembershipID proxyId) {
        CacheClientProxy proxy = this.getClientProxy(proxyId);
        if (proxy != null) {
            proxy.startOrResumeMessageDispatcher(false);
        }
    }

    private ClientUpdateMessageImpl constructClientMessage(InternalCacheEvent event) {
        ClientUpdateMessageImpl clientMessage = null;
        EnumListenerEvent operation = event.getEventType();
        try {
            clientMessage = this.initializeMessage(operation, event);
        }
        catch (Exception e) {
            logger.fatal(LocalizedMessage.create(LocalizedStrings.CacheClientNotifier_CANNOT_NOTIFY_CLIENTS_TO_PERFORM_OPERATION_0_ON_EVENT_1, new Object[]{operation, event}), (Throwable)e);
        }
        return clientMessage;
    }

    public static void notifyClients(InternalCacheEvent event) {
        CacheClientNotifier instance = ccnSingleton;
        if (instance != null) {
            instance.singletonNotifyClients(event, null);
        }
    }

    public static void notifyClients(InternalCacheEvent event, ClientUpdateMessage cmsg) {
        CacheClientNotifier instance = ccnSingleton;
        if (instance != null) {
            instance.singletonNotifyClients(event, cmsg);
        }
    }

    private void singletonNotifyClients(InternalCacheEvent event, ClientUpdateMessage cmsg) {
        CacheClientProxy ccp;
        Set<ClientProxyMembershipID> ids;
        Set rawIDs;
        boolean isDebugEnabled = logger.isDebugEnabled();
        boolean isTraceEnabled = logger.isTraceEnabled();
        FilterRoutingInfo.FilterInfo filterInfo = event.getLocalFilterInfo();
        FilterProfile regionProfile = ((LocalRegion)event.getRegion()).getFilterProfile();
        if (filterInfo != null && isTraceEnabled) {
            logger.trace("Event isOriginRemote={}", (Object)event.isOriginRemote());
        }
        if (filterInfo == null || filterInfo.getCQs() == null && filterInfo.getInterestedClients() == null && filterInfo.getInterestedClientsInv() == null) {
            return;
        }
        long startTime = this._statistics.startTime();
        ClientUpdateMessageImpl clientMessage = cmsg == null ? this.constructClientMessage(event) : (ClientUpdateMessageImpl)cmsg;
        if (clientMessage == null) {
            return;
        }
        HashSet<ClientProxyMembershipID> filterClients = new HashSet<ClientProxyMembershipID>();
        if (filterInfo.getCQs() != null) {
            for (Map.Entry<Long, Integer> e : filterInfo.getCQs().entrySet()) {
                ServerCQ cq;
                Long cqID = e.getKey();
                String cqName = regionProfile.getRealCqID(cqID);
                if (cqName == null || (cq = regionProfile.getCq(cqName)) == null) continue;
                Object id = cq.getClientProxyId();
                filterClients.add((ClientProxyMembershipID)id);
                if (isDebugEnabled) {
                    logger.debug("Adding cq routing info to message for id: {} and cq: {}", id, (Object)cqName);
                }
                clientMessage.addClientCq((ClientProxyMembershipID)id, cq.getName(), e.getValue());
            }
        }
        if (filterInfo.getInterestedClientsInv() != null) {
            rawIDs = regionProfile.getRealClientIDs(filterInfo.getInterestedClientsInv());
            ids = this.getProxyIDs(rawIDs, true);
            if (ids.remove(event.getContext()) && (ccp = this.getClientProxy(event.getContext())) != null) {
                ccp.getStatistics().incMessagesNotQueuedOriginator();
            }
            if (!ids.isEmpty()) {
                if (isTraceEnabled) {
                    logger.trace("adding invalidation routing to message for {}" + ids);
                }
                clientMessage.addClientInterestList(ids, false);
                filterClients.addAll(ids);
            }
        }
        if (filterInfo.getInterestedClients() != null) {
            rawIDs = regionProfile.getRealClientIDs(filterInfo.getInterestedClients());
            ids = this.getProxyIDs(rawIDs, true);
            if (ids.remove(event.getContext()) && (ccp = this.getClientProxy(event.getContext())) != null) {
                ccp.getStatistics().incMessagesNotQueuedOriginator();
            }
            if (!ids.isEmpty()) {
                if (isTraceEnabled) {
                    logger.trace("adding routing to message for {}", (Object)ids);
                }
                clientMessage.addClientInterestList(ids, true);
                filterClients.addAll(ids);
            }
        }
        DataSerializableFixedID conflatable = null;
        if (clientMessage instanceof ClientTombstoneMessage) {
            Object[] objects;
            conflatable = clientMessage;
            for (Object id : objects = filterClients.toArray()) {
                CacheClientProxy ccp2 = this.getClientProxy((ClientProxyMembershipID)id, true);
                if (ccp2 == null || ccp2.getVersion().compareTo(Version.GFE_70) >= 0) continue;
                filterClients.remove(id);
            }
        } else {
            HAEventWrapper wrapper = new HAEventWrapper(clientMessage);
            wrapper.setPutInProgress(true);
            conflatable = wrapper;
        }
        this.singletonRouteClientMessage((Conflatable)((Object)conflatable), (Collection<ClientProxyMembershipID>)filterClients);
        this._statistics.endEvent(startTime);
        if (filterInfo.filterProcessedLocally) {
            this.removeDestroyTokensFromCqResultKeys(event, filterInfo);
        }
    }

    private void removeDestroyTokensFromCqResultKeys(InternalCacheEvent event, FilterRoutingInfo.FilterInfo filterInfo) {
        FilterProfile regionProfile = ((LocalRegion)event.getRegion()).getFilterProfile();
        if (event.getOperation().isEntry() && filterInfo.getCQs() != null) {
            EntryEventImpl entryEvent = (EntryEventImpl)event;
            for (Map.Entry<Long, Integer> e : filterInfo.getCQs().entrySet()) {
                ServerCQ cq;
                Long cqID = e.getKey();
                String cqName = regionProfile.getRealCqID(cqID);
                if (cqName == null || (cq = regionProfile.getCq(cqName)) == null || !e.getValue().equals(16)) continue;
                cq.removeFromCqResultKeys(entryEvent.getKey(), true);
            }
        }
    }

    public static void routeClientMessage(Conflatable clientMessage) {
        CacheClientNotifier instance = ccnSingleton;
        if (instance != null) {
            instance.singletonRouteClientMessage(clientMessage, instance._clientProxies.keySet());
        }
    }

    public static void routeSingleClientMessage(ClientUpdateMessage clientMessage, ClientProxyMembershipID clientProxyMembershipId) {
        CacheClientNotifier instance = ccnSingleton;
        if (instance != null) {
            instance.singletonRouteClientMessage(clientMessage, Collections.singleton(clientProxyMembershipId));
        }
    }

    private void singletonRouteClientMessage(Conflatable conflatable, Collection<ClientProxyMembershipID> filterClients) {
        this._cache.getCancelCriterion().checkCancelInProgress(null);
        ArrayList<CacheClientProxy> deadProxies = null;
        for (ClientProxyMembershipID clientId : filterClients) {
            CacheClientProxy proxy = this.getClientProxy(clientId, true);
            if (proxy == null) continue;
            if (proxy.isAlive() || proxy.isPaused() || proxy.isConnected() || proxy.isDurable()) {
                proxy.deliverMessage(conflatable);
            } else {
                proxy.getStatistics().incMessagesFailedQueued();
                if (deadProxies == null) {
                    deadProxies = new ArrayList<CacheClientProxy>();
                }
                deadProxies.add(proxy);
            }
            this.blackListSlowReciever(proxy);
        }
        this.checkAndRemoveFromClientMsgsRegion(conflatable);
        if (deadProxies != null) {
            this.closeDeadProxies(deadProxies, false);
        }
    }

    public Set<ClientProxyMembershipID> getProxyIDs(Set mixedDurableAndNonDurableIDs) {
        return this.getProxyIDs(mixedDurableAndNonDurableIDs, false);
    }

    public Set<ClientProxyMembershipID> getProxyIDs(Set mixedDurableAndNonDurableIDs, boolean proxyInInitMode) {
        HashSet<ClientProxyMembershipID> result = new HashSet<ClientProxyMembershipID>();
        for (Object id : mixedDurableAndNonDurableIDs) {
            if (id instanceof String) {
                CacheClientProxy clientProxy = this.getClientProxy((String)id, true);
                if (clientProxy == null) continue;
                result.add(clientProxy.getProxyID());
                continue;
            }
            CacheClientProxy proxy = this.getClientProxy((ClientProxyMembershipID)id, true);
            if (proxy == null) continue;
            result.add(proxy.getProxyID());
        }
        return result;
    }

    private void blackListSlowReciever(CacheClientProxy clientProxy) {
        final CacheClientProxy proxy = clientProxy;
        if (proxy.getHARegionQueue() != null && proxy.getHARegionQueue().isClientSlowReciever() && !this.blackListedClients.contains(proxy.getProxyID())) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.CacheClientNotifier_CLIENT_0_IS_A_SLOW_RECEIVER, new Object[]{proxy.getProxyID()}));
            this.addToBlacklistedClient(proxy.getProxyID());
            InternalDistributedSystem ids = (InternalDistributedSystem)this.getCache().getDistributedSystem();
            final DM dm = ids.getDistributionManager();
            dm.getWaitingThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    CacheDistributionAdvisor advisor = proxy.getHARegionQueue().getRegion().getCacheDistributionAdvisor();
                    Set members = advisor.adviseCacheOp();
                    ClientBlacklistProcessor.sendBlacklistedClient(proxy.getProxyID(), dm, members);
                    proxy.close(false, false);
                    CacheClientNotifier.this.removeClientProxy(proxy);
                    if (PoolImpl.AFTER_QUEUE_DESTROY_MESSAGE_FLAG) {
                        ClientServerObserver bo = ClientServerObserverHolder.getInstance();
                        bo.afterQueueDestroyMessage();
                    }
                    RemoveClientFromBlacklistMessage rcm = new RemoveClientFromBlacklistMessage();
                    rcm.setProxyID(proxy.getProxyID());
                    dm.putOutgoing(rcm);
                    CacheClientNotifier.this.blackListedClients.remove(proxy.getProxyID());
                }
            });
        }
    }

    private ClientUpdateMessageImpl initializeMessage(EnumListenerEvent operation, CacheEvent event) throws Exception {
        EventID eventIdentifier;
        if (!this.supportsOperation(operation)) {
            throw new Exception(LocalizedStrings.CacheClientNotifier_THE_CACHE_CLIENT_NOTIFIER_DOES_NOT_SUPPORT_OPERATIONS_OF_TYPE_0.toLocalizedString(operation));
        }
        Object keyOfInterest = null;
        ClientProxyMembershipID membershipID = null;
        boolean isNetLoad = false;
        Object callbackArgument = null;
        byte[] delta = null;
        VersionTag versionTag = null;
        if (event.getOperation().isEntry()) {
            EntryEventImpl entryEvent = (EntryEventImpl)event;
            versionTag = entryEvent.getVersionTag();
            delta = entryEvent.getDeltaBytes();
            callbackArgument = entryEvent.getRawCallbackArgument();
            if (entryEvent.isBridgeEvent()) {
                membershipID = entryEvent.getContext();
            }
            keyOfInterest = entryEvent.getKey();
            eventIdentifier = entryEvent.getEventId();
            isNetLoad = entryEvent.isNetLoad();
        } else {
            RegionEventImpl regionEvent = (RegionEventImpl)event;
            callbackArgument = regionEvent.getRawCallbackArgument();
            eventIdentifier = regionEvent.getEventId();
            if (event instanceof ClientRegionEventImpl) {
                ClientRegionEventImpl bridgeEvent = (ClientRegionEventImpl)event;
                membershipID = bridgeEvent.getContext();
            }
        }
        ClientUpdateMessageImpl clientUpdateMsg = new ClientUpdateMessageImpl(operation, (LocalRegion)event.getRegion(), keyOfInterest, null, delta, 1, callbackArgument, membershipID, eventIdentifier, versionTag);
        if (event.getOperation().isEntry()) {
            EntryEventImpl entryEvent = (EntryEventImpl)event;
            entryEvent.exportNewValue(clientUpdateMsg);
        }
        if (isNetLoad) {
            clientUpdateMsg.setIsNetLoad(isNetLoad);
        }
        return clientUpdateMsg;
    }

    protected boolean supportsOperation(EnumListenerEvent operation) {
        return operation == EnumListenerEvent.AFTER_CREATE || operation == EnumListenerEvent.AFTER_UPDATE || operation == EnumListenerEvent.AFTER_DESTROY || operation == EnumListenerEvent.AFTER_INVALIDATE || operation == EnumListenerEvent.AFTER_REGION_DESTROY || operation == EnumListenerEvent.AFTER_REGION_CLEAR || operation == EnumListenerEvent.AFTER_REGION_INVALIDATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClientInterest(String regionName, Object keyOfInterest, ClientProxyMembershipID membershipID, int interestType2, boolean isDurable, boolean sendUpdatesAsInvalidates, boolean manageEmptyRegions, int regionDataPolicy, boolean flushState) throws IOException, RegionDestroyedException {
        CacheClientProxy proxy = this.getClientProxy(membershipID, true);
        if (logger.isDebugEnabled()) {
            logger.debug("CacheClientNotifier: Client {} registering interest in: {} -> {} (an instance of {})", (Object)proxy, (Object)regionName, keyOfInterest, (Object)keyOfInterest.getClass().getName());
        }
        if (proxy == null) {
            throw new IOException(LocalizedStrings.CacheClientNotifier_CACHECLIENTPROXY_FOR_THIS_CLIENT_IS_NO_LONGER_ON_THE_SERVER_SO_REGISTERINTEREST_OPERATION_IS_UNSUCCESSFUL.toLocalizedString());
        }
        boolean done = false;
        try {
            proxy.registerClientInterest(regionName, keyOfInterest, interestType2, isDurable, sendUpdatesAsInvalidates, flushState);
            if (manageEmptyRegions) {
                this.updateMapOfEmptyRegions(proxy.getRegionsWithEmptyDataPolicy(), regionName, regionDataPolicy);
            }
            done = true;
        }
        finally {
            if (!done) {
                proxy.unregisterClientInterest(regionName, keyOfInterest, interestType2, false);
            }
        }
    }

    public void updateMapOfEmptyRegions(Map regionsWithEmptyDataPolicy, String regionName, int regionDataPolicy) {
        if (regionDataPolicy == 0 && !regionsWithEmptyDataPolicy.containsKey(regionName)) {
            regionsWithEmptyDataPolicy.put(regionName, 0);
        }
    }

    public void unregisterClientInterest(String regionName, Object keyOfInterest, int interestType2, boolean isClosing, ClientProxyMembershipID membershipID, boolean keepalive) {
        CacheClientProxy proxy;
        if (logger.isDebugEnabled()) {
            logger.debug("CacheClientNotifier: Client {} unregistering interest in: {} -> {} (an instance of {})", (Object)membershipID, (Object)regionName, keyOfInterest, (Object)keyOfInterest.getClass().getName());
        }
        if ((proxy = this.getClientProxy(membershipID)) != null) {
            proxy.setKeepAlive(keepalive);
            proxy.unregisterClientInterest(regionName, keyOfInterest, interestType2, isClosing);
        }
    }

    public void registerClientInterest(String regionName, List keysOfInterest, ClientProxyMembershipID membershipID, boolean isDurable, boolean sendUpdatesAsInvalidates, boolean manageEmptyRegions, int regionDataPolicy, boolean flushState) throws IOException, RegionDestroyedException {
        CacheClientProxy proxy = this.getClientProxy(membershipID, true);
        if (logger.isDebugEnabled()) {
            logger.debug("CacheClientNotifier: Client {} registering interest in: {} -> {}", (Object)proxy, (Object)regionName, (Object)keysOfInterest);
        }
        if (proxy == null) {
            throw new IOException(LocalizedStrings.CacheClientNotifier_CACHECLIENTPROXY_FOR_THIS_CLIENT_IS_NO_LONGER_ON_THE_SERVER_SO_REGISTERINTEREST_OPERATION_IS_UNSUCCESSFUL.toLocalizedString());
        }
        proxy.registerClientInterestList(regionName, keysOfInterest, isDurable, sendUpdatesAsInvalidates, flushState);
        if (manageEmptyRegions) {
            this.updateMapOfEmptyRegions(proxy.getRegionsWithEmptyDataPolicy(), regionName, regionDataPolicy);
        }
    }

    public void unregisterClientInterest(String regionName, List keysOfInterest, boolean isClosing, ClientProxyMembershipID membershipID, boolean keepalive) {
        CacheClientProxy proxy;
        if (logger.isDebugEnabled()) {
            logger.debug("CacheClientNotifier: Client {} unregistering interest in: {} -> {}", (Object)membershipID, (Object)regionName, (Object)keysOfInterest);
        }
        if ((proxy = this.getClientProxy(membershipID)) != null) {
            proxy.setKeepAlive(keepalive);
            proxy.unregisterClientInterest(regionName, keysOfInterest, isClosing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndRemoveFromClientMsgsRegion(Conflatable conflatable) {
        if (this.haContainer == null) {
            return;
        }
        if (conflatable instanceof HAEventWrapper) {
            HAEventWrapper wrapper = (HAEventWrapper)conflatable;
            if (!wrapper.getIsRefFromHAContainer()) {
                if ((wrapper = (HAEventWrapper)this.haContainer.getKey(wrapper)) != null && !wrapper.getPutInProgress()) {
                    HAEventWrapper hAEventWrapper = wrapper;
                    synchronized (hAEventWrapper) {
                        if (wrapper.getReferenceCount() == 0L) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Removing event from haContainer: {}", (Object)wrapper);
                            }
                            this.haContainer.remove(wrapper);
                        }
                    }
                }
            } else {
                wrapper.setClientUpdateMessage(null);
                wrapper.setPutInProgress(false);
                HAEventWrapper hAEventWrapper = wrapper;
                synchronized (hAEventWrapper) {
                    if (wrapper.getReferenceCount() == 0L) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Removing event from haContainer: {}", (Object)wrapper);
                        }
                        this.haContainer.remove(wrapper);
                    }
                }
            }
        }
    }

    public CacheClientProxy getClientProxy(ClientProxyMembershipID membershipID) {
        return (CacheClientProxy)this._clientProxies.get(membershipID);
    }

    public CacheClientProxy getClientProxy(ClientProxyMembershipID membershipID, boolean proxyInInitMode) {
        CacheClientProxy proxy = this.getClientProxy(membershipID);
        if (proxyInInitMode && proxy == null) {
            proxy = (CacheClientProxy)this._initClientProxies.get(membershipID);
        }
        return proxy;
    }

    public CacheClientProxy getClientProxy(String durableClientId) {
        return this.getClientProxy(durableClientId, false);
    }

    public CacheClientProxy getClientProxy(String durableClientId, boolean proxyInInitMode) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        boolean isTraceEnabled = logger.isTraceEnabled();
        if (isDebugEnabled) {
            logger.debug("CacheClientNotifier: Determining client for {}", (Object)durableClientId);
        }
        CacheClientProxy proxy = null;
        for (CacheClientProxy clientProxy : this.getClientProxies()) {
            if (isTraceEnabled) {
                logger.trace("CacheClientNotifier: Checking client {}", (Object)clientProxy);
            }
            if (!clientProxy.getDurableId().equals(durableClientId)) continue;
            proxy = clientProxy;
            if (!isDebugEnabled) break;
            logger.debug("CacheClientNotifier: {} represents the durable client {}", (Object)proxy, (Object)durableClientId);
            break;
        }
        if (proxy == null && proxyInInitMode) {
            for (CacheClientProxy clientProxy : this._initClientProxies.values()) {
                if (isTraceEnabled) {
                    logger.trace("CacheClientNotifier: Checking initializing client {}", (Object)clientProxy);
                }
                if (!clientProxy.getDurableId().equals(durableClientId)) continue;
                proxy = clientProxy;
                if (!isDebugEnabled) break;
                logger.debug("CacheClientNotifier: initializing client {} represents the durable client {}", (Object)proxy, (Object)durableClientId);
                break;
            }
        }
        return proxy;
    }

    public CacheClientProxy getClientProxySameDS(ClientProxyMembershipID membershipID) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("{}::getClientProxySameDS(), Determining client for host {}", (Object)this, (Object)membershipID);
            logger.debug("{}::getClientProxySameDS(), Number of proxies in the Cache Clinet Notifier: {}", (Object)this, (Object)this.getClientProxies().size());
        }
        CacheClientProxy proxy = null;
        for (CacheClientProxy clientProxy : this.getClientProxies()) {
            if (isDebugEnabled) {
                logger.debug("CacheClientNotifier: Checking client {}", (Object)clientProxy);
            }
            if (!clientProxy.isSameDSMember(membershipID)) continue;
            proxy = clientProxy;
            if (!isDebugEnabled) break;
            logger.debug("CacheClientNotifier: {} represents the client running on host {}", (Object)proxy, (Object)membershipID);
            break;
        }
        return proxy;
    }

    protected synchronized void shutdown(long acceptorId) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("At cache server shutdown time, the number of cache servers in the cache is {}", (Object)this.getCache().getCacheServers().size());
        }
        Iterator it = this._clientProxies.values().iterator();
        while (it.hasNext()) {
            CacheClientProxy proxy = (CacheClientProxy)it.next();
            if (proxy.getAcceptorId() != acceptorId) continue;
            it.remove();
            try {
                if (isDebugEnabled) {
                    logger.debug("CacheClientNotifier: Closing {}", (Object)proxy);
                }
                proxy.terminateDispatching(true);
            }
            catch (Exception ignore) {
                if (!isDebugEnabled) continue;
                logger.debug("{}: Exception in closing down the CacheClientProxy", (Object)this, (Object)ignore);
            }
        }
        if (this.noActiveServer() && ccnSingleton != null) {
            ccnSingleton = null;
            if (this.haContainer != null) {
                this.haContainer.cleanUp();
                if (isDebugEnabled) {
                    logger.debug("haContainer ({}) is now cleaned up.", (Object)this.haContainer.getName());
                }
            }
            this.clearCompiledQueries();
            this.blackListedClients.clear();
            this.clientPingTask.cancel();
            this._statistics.close();
            this.socketCloser.close();
        }
    }

    private boolean noActiveServer() {
        for (CacheServer server : this.getCache().getCacheServers()) {
            if (!server.isRunning()) continue;
            return false;
        }
        return true;
    }

    protected void addClientProxy(CacheClientProxy proxy) throws IOException {
        ClientHealthMonitor chm;
        this.getCache();
        this._clientProxies.put(proxy.getProxyID(), proxy);
        this.removeClientInitProxy(proxy);
        this._connectionListener.queueAdded(proxy.getProxyID());
        if (proxy.clientConflation != 1 && (chm = ClientHealthMonitor.getInstance()) != null) {
            chm.numOfClientsPerVersion.incrementAndGet(proxy.getVersion().ordinal());
        }
        this.timedOutDurableClientProxies.remove(proxy.getProxyID());
    }

    protected void addClientInitProxy(CacheClientProxy proxy) throws IOException {
        this._initClientProxies.put(proxy.getProxyID(), proxy);
    }

    protected void removeClientInitProxy(CacheClientProxy proxy) throws IOException {
        this._initClientProxies.remove(proxy.getProxyID());
    }

    protected boolean isProxyInInitializationMode(CacheClientProxy proxy) throws IOException {
        return this._initClientProxies.containsKey(proxy.getProxyID());
    }

    public Set getActiveClients() {
        HashSet<ClientProxyMembershipID> clients = new HashSet<ClientProxyMembershipID>();
        for (CacheClientProxy proxy : this.getClientProxies()) {
            if (!proxy.hasRegisteredInterested()) continue;
            ClientProxyMembershipID proxyID = proxy.getProxyID();
            clients.add(proxyID);
        }
        return clients;
    }

    public Map getAllClients() {
        HashMap<ClientProxyMembershipID, CacheClientStatus> clients = new HashMap<ClientProxyMembershipID, CacheClientStatus>();
        for (CacheClientProxy proxy : this._clientProxies.values()) {
            ClientProxyMembershipID proxyID = proxy.getProxyID();
            clients.put(proxyID, new CacheClientStatus(proxyID));
        }
        return clients;
    }

    public boolean hasDurableClient(String durableId) {
        for (CacheClientProxy proxy : this._clientProxies.values()) {
            ClientProxyMembershipID proxyID = proxy.getProxyID();
            if (!durableId.equals(proxyID.getDurableId())) continue;
            return true;
        }
        return false;
    }

    public boolean hasPrimaryForDurableClient(String durableId) {
        for (CacheClientProxy proxy : this._clientProxies.values()) {
            ClientProxyMembershipID proxyID = proxy.getProxyID();
            if (!durableId.equals(proxyID.getDurableId())) continue;
            return proxy.isPrimary();
        }
        return false;
    }

    public Map getClientQueueSizes() {
        HashMap<ClientProxyMembershipID, Integer> queueSizes = new HashMap<ClientProxyMembershipID, Integer>();
        for (CacheClientProxy proxy : this._clientProxies.values()) {
            queueSizes.put(proxy.getProxyID(), proxy.getQueueSize());
        }
        return queueSizes;
    }

    public int getDurableClientHAQueueSize(String durableClientId) {
        CacheClientProxy ccp = this.getClientProxy(durableClientId);
        if (ccp == null) {
            return -1;
        }
        return ccp.getQueueSizeStat();
    }

    public boolean closeClientCq(String durableClientId, String clientCQName) throws CqException {
        CacheClientProxy proxy = this.getClientProxy(durableClientId);
        if (proxy != null) {
            return proxy.closeClientCq(clientCQName);
        }
        return false;
    }

    protected void removeClientProxy(CacheClientProxy proxy) {
        ClientHealthMonitor chm;
        ClientProxyMembershipID client = proxy.getProxyID();
        this._clientProxies.remove(client);
        this._connectionListener.queueRemoved();
        ((GemFireCacheImpl)this.getCache()).cleanupForClient(this, client);
        if (proxy.clientConflation != 1 && (chm = ClientHealthMonitor.getInstance()) != null) {
            chm.numOfClientsPerVersion.decrementAndGet(proxy.getVersion().ordinal());
        }
    }

    void durableClientTimedOut(ClientProxyMembershipID client) {
        this.timedOutDurableClientProxies.add(client);
    }

    public boolean isTimedOut(ClientProxyMembershipID client) {
        return this.timedOutDurableClientProxies.contains(client);
    }

    public Collection<CacheClientProxy> getClientProxies() {
        return Collections.unmodifiableCollection(this._clientProxies.values());
    }

    private void closeAllClientCqs(CacheClientProxy proxy) {
        block4: {
            CqService cqService = proxy.getCache().getCqService();
            if (cqService != null) {
                boolean isDebugEnabled = logger.isDebugEnabled();
                try {
                    if (isDebugEnabled) {
                        logger.debug("CacheClientNotifier: Closing client CQs: {}", (Object)proxy);
                    }
                    cqService.closeClientCqs(proxy.getProxyID());
                }
                catch (CqException e1) {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.CacheClientNotifier_UNABLE_TO_CLOSE_CQS_FOR_THE_CLIENT__0, proxy.getProxyID()));
                    if (!isDebugEnabled) break block4;
                    e1.printStackTrace();
                }
            }
        }
    }

    public boolean closeDurableClientProxy(String durableClientId) throws CacheException {
        CacheClientProxy ccp = this.getClientProxy(durableClientId);
        if (ccp == null) {
            return false;
        }
        if (ccp.isPaused() && !ccp.isConnected()) {
            ccp.setKeepAlive(false);
            this.closeDeadProxies(Collections.singletonList(ccp), true);
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Cannot close running durable client: {}", (Object)durableClientId);
        }
        throw new CacheException("Cannot close a running durable client : " + durableClientId){};
    }

    private void closeDeadProxies(List deadProxies, boolean stoppedNormally) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        for (CacheClientProxy proxy : deadProxies) {
            if (isDebugEnabled) {
                logger.debug("CacheClientNotifier: Closing dead client: {}", (Object)proxy);
            }
            boolean keepProxy = false;
            try {
                keepProxy = proxy.close(false, stoppedNormally);
            }
            catch (CancelException e) {
                throw e;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (keepProxy) {
                logger.info(LocalizedMessage.create(LocalizedStrings.CacheClientNotifier_CACHECLIENTNOTIFIER_KEEPING_PROXY_FOR_DURABLE_CLIENT_NAMED_0_FOR_1_SECONDS_2, new Object[]{proxy.getDurableId(), proxy.getDurableTimeout(), proxy}));
            } else {
                this.closeAllClientCqs(proxy);
                if (isDebugEnabled) {
                    logger.debug("CacheClientNotifier: Not keeping proxy for non-durable client: {}", (Object)proxy);
                }
                this.removeClientProxy(proxy);
            }
            proxy.notifyRemoval();
        }
    }

    public void registerInterestRegistrationListener(InterestRegistrationListener listener) {
        this.writableInterestRegistrationListeners.add(listener);
    }

    public void unregisterInterestRegistrationListener(InterestRegistrationListener listener) {
        this.writableInterestRegistrationListeners.remove(listener);
    }

    public Set getInterestRegistrationListeners() {
        return this.readableInterestRegistrationListeners;
    }

    protected boolean containsInterestRegistrationListeners() {
        return !this.writableInterestRegistrationListeners.isEmpty();
    }

    protected void notifyInterestRegistrationListeners(InterestRegistrationEvent event) {
        for (InterestRegistrationListener listener : this.writableInterestRegistrationListeners) {
            if (event.isRegister()) {
                listener.afterRegisterInterest(event);
                continue;
            }
            listener.afterUnregisterInterest(event);
        }
    }

    public CacheClientNotifierStats getStats() {
        return this._statistics;
    }

    protected Cache getCache() {
        GemFireCacheImpl cache;
        if (this._cache != null && this._cache.isClosed() && (cache = GemFireCacheImpl.getInstance()) != null) {
            this._cache = cache;
            this.logWriter = cache.getInternalLogWriter();
            this.securityLogWriter = cache.getSecurityInternalLogWriter();
        }
        return this._cache;
    }

    protected int getMaximumMessageCount() {
        return this.maximumMessageCount;
    }

    protected int getMessageTimeToLive() {
        return this.messageTimeToLive;
    }

    protected void handleInterestEvent(InterestRegistrationEvent event) {
        LocalRegion region = (LocalRegion)event.getRegion();
        region.handleInterestEvent(event);
    }

    private CacheClientNotifier(Cache cache, CacheServerStats acceptorStats, int maximumMessageCount, int messageTimeToLive, ConnectionListener listener, List overflowAttributesList, boolean isGatewayReceiver) {
        this.setCache((GemFireCacheImpl)cache);
        this.acceptorStats = acceptorStats;
        this.socketCloser = new SocketCloser(1, 50L);
        this.logWriter = (InternalLogWriter)cache.getLogger();
        this._connectionListener = listener;
        this.securityLogWriter = (InternalLogWriter)cache.getSecurityLogger();
        this.maximumMessageCount = maximumMessageCount;
        this.messageTimeToLive = messageTimeToLive;
        StatisticsFactory factory = isGatewayReceiver ? new DummyStatisticsFactory() : this.getCache().getDistributedSystem();
        this._statistics = new CacheClientNotifierStats(factory);
        try {
            this.logFrequency = Long.valueOf(System.getProperty(MAX_QUEUE_LOG_FREQUENCY));
            if (this.logFrequency <= 0L) {
                this.logFrequency = 1000L;
            }
        }
        catch (Exception e) {
            this.logFrequency = 1000L;
        }
        eventEnqueueWaitTime = Integer.getInteger(EVENT_ENQUEUE_WAIT_TIME_NAME, 100);
        if (eventEnqueueWaitTime < 0) {
            eventEnqueueWaitTime = 100;
        }
        this.scheduleClientPingTask();
    }

    protected void deliverInterestChange(ClientProxyMembershipID proxyID, ClientInterestMessageImpl message) {
        DM dm = ((InternalDistributedSystem)this.getCache().getDistributedSystem()).getDistributionManager();
        ServerInterestRegistrationMessage.sendInterestChange(dm, proxyID, message);
    }

    public CacheServerStats getAcceptorStats() {
        return this.acceptorStats;
    }

    public SocketCloser getSocketCloser() {
        return this.socketCloser;
    }

    public void addCompiledQuery(DefaultQuery query) {
        if (this.compiledQueries.putIfAbsent(query.getQueryString(), query) == null) {
            this._statistics.incCompiledQueryCount(1L);
            if (logger.isDebugEnabled()) {
                logger.debug("Added compiled query into ccn.compliedQueries list. Query: {}. Total compiled queries: {}", (Object)query.getQueryString(), (Object)this._statistics.getCompiledQueryCount());
            }
            this.startCompiledQueryCleanupThread();
        }
    }

    public Query getCompiledQuery(String queryString) {
        return this.compiledQueries.get(queryString);
    }

    private void clearCompiledQueries() {
        if (this.compiledQueries.size() > 0) {
            this._statistics.incCompiledQueryCount(-this.compiledQueries.size());
            this.compiledQueries.clear();
            if (logger.isDebugEnabled()) {
                logger.debug("Removed all compiled queries from ccn.compliedQueries list. Total compiled queries: {}", (Object)this._statistics.getCompiledQueryCount());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCompiledQueryCleanupThread() {
        if (this.isCompiledQueryCleanupThreadStarted) {
            return;
        }
        SystemTimer.SystemTimerTask task = new SystemTimer.SystemTimerTask(){

            @Override
            public void run2() {
                boolean isDebugEnabled = logger.isDebugEnabled();
                for (Map.Entry e : CacheClientNotifier.this.compiledQueries.entrySet()) {
                    DefaultQuery q = (DefaultQuery)e.getValue();
                    if (q.getLastUsed()) {
                        q.setLastUsed(false);
                        continue;
                    }
                    if (CacheClientNotifier.this.compiledQueries.remove(e.getKey()) == null) continue;
                    CacheClientNotifier.this._statistics.incCompiledQueryCount(-1L);
                    if (!isDebugEnabled) continue;
                    logger.debug("Removed compiled query from ccn.compliedQueries list. Query: " + q.getQueryString() + ". Total compiled queries are : " + CacheClientNotifier.this._statistics.getCompiledQueryCount());
                }
            }
        };
        Object object = this.lockIsCompiledQueryCleanupThreadStarted;
        synchronized (object) {
            if (!this.isCompiledQueryCleanupThreadStarted) {
                long period = DefaultQuery.TEST_COMPILED_QUERY_CLEAR_TIME > 0 ? (long)DefaultQuery.TEST_COMPILED_QUERY_CLEAR_TIME : (long)DefaultQuery.COMPILED_QUERY_CLEAR_TIME;
                this._cache.getCCPTimer().scheduleAtFixedRate(task, period, period);
            }
            this.isCompiledQueryCleanupThreadStarted = true;
        }
    }

    protected void scheduleClientPingTask() {
        this.clientPingTask = new SystemTimer.SystemTimerTask(){

            @Override
            public void run2() {
                if (CacheClientNotifier.this._clientProxies.isEmpty()) {
                    return;
                }
                ClientPingMessageImpl message = new ClientPingMessageImpl();
                for (CacheClientProxy proxy : CacheClientNotifier.this.getClientProxies()) {
                    logger.debug("Checking whether to ping {}", (Object)proxy);
                    if (proxy.getVersion().compareTo(Version.GFE_6622) >= 0) {
                        if ((long)proxy.incrementAndGetPingCounter() >= CLIENT_PING_TASK_COUNTER) {
                            logger.debug("Pinging {}", (Object)proxy);
                            proxy.sendMessageDirectly(message);
                            logger.debug("Done pinging {}", (Object)proxy);
                            continue;
                        }
                        logger.debug("Not pinging because not idle: {}", (Object)proxy);
                        continue;
                    }
                    logger.debug("Ignoring because of version: {}", (Object)proxy);
                }
            }
        };
        if (logger.isDebugEnabled()) {
            logger.debug("Scheduling client ping task with period={} ms", (Object)CLIENT_PING_TASK_PERIOD);
        }
        this._cache.getCCPTimer().scheduleAtFixedRate(this.clientPingTask, CLIENT_PING_TASK_PERIOD, CLIENT_PING_TASK_PERIOD);
    }

    public long getLogFrequency() {
        return this.logFrequency;
    }

    public Map getHaContainer() {
        return this.haContainer;
    }

    public void initHaContainer(List overflowAttributesList) {
        this.haContainer = overflowAttributesList != null && !"none".equals(overflowAttributesList.get(0)) ? new HAContainerRegion(this._cache.getRegion("/" + CacheServerImpl.clientMessagesRegion(this._cache, (String)overflowAttributesList.get(0), (Integer)overflowAttributesList.get(1), (Integer)overflowAttributesList.get(2), (String)overflowAttributesList.get(3), (Boolean)overflowAttributesList.get(4)))) : new HAContainerMap(new ConcurrentHashMap());
        assert (this.haContainer != null);
        if (logger.isDebugEnabled()) {
            logger.debug("ha container ({}) has been created.", (Object)this.haContainer.getName());
        }
    }

    public void addToBlacklistedClient(ClientProxyMembershipID proxyID) {
        this.blackListedClients.add(proxyID);
        this.getCache();
        new ScheduledThreadPoolExecutor(1).schedule(new ExpireBlackListTask(proxyID), 120L, TimeUnit.SECONDS);
    }

    public Set getBlacklistedClient() {
        return this.blackListedClients;
    }

    private void setCache(GemFireCacheImpl _cache) {
        this._cache = _cache;
    }

    static {
        socketBufferSize = Integer.getInteger("BridgeServer.SOCKET_BUFFER_SIZE", 32768);
        CLIENT_PING_TASK_PERIOD = Long.getLong("gemfire.serverToClientPingPeriod", 60000L);
        CLIENT_PING_TASK_COUNTER = Long.getLong("gemfire.serverToClientPingCounter", 3L);
    }

    private class ExpireBlackListTask
    extends PoolImpl.PoolTask {
        private ClientProxyMembershipID proxyID;

        public ExpireBlackListTask(ClientProxyMembershipID proxyID) {
            this.proxyID = proxyID;
        }

        @Override
        public void run2() {
            if (CacheClientNotifier.this.blackListedClients.remove(this.proxyID) && logger.isDebugEnabled()) {
                logger.debug("{} client is no longer blacklisted", (Object)this.proxyID);
            }
        }
    }

    public static class ServerInterestRegistrationMessage
    extends HighPriorityDistributionMessage
    implements MessageWithReply {
        ClientProxyMembershipID clientId;
        ClientInterestMessageImpl clientMessage;
        int processorId;

        ServerInterestRegistrationMessage(ClientProxyMembershipID clientID, ClientInterestMessageImpl msg) {
            this.clientId = clientID;
            this.clientMessage = msg;
        }

        public ServerInterestRegistrationMessage() {
        }

        static void sendInterestChange(DM dm, ClientProxyMembershipID clientID, ClientInterestMessageImpl msg) {
            ServerInterestRegistrationMessage smsg = new ServerInterestRegistrationMessage(clientID, msg);
            Set recipients = dm.getOtherDistributionManagerIds();
            smsg.setRecipients(recipients);
            ReplyProcessor21 rp = new ReplyProcessor21(dm, (Collection)recipients);
            smsg.processorId = rp.getProcessorId();
            dm.putOutgoing(smsg);
            try {
                rp.waitForReplies();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void process(DistributionManager dm) {
            try {
                CacheClientProxy proxy;
                CacheClientNotifier ccn = CacheClientNotifier.getInstance();
                if (ccn != null && (proxy = ccn.getClientProxy(this.clientId)) != null) {
                    proxy.processInterestMessage(this.clientMessage);
                }
            }
            finally {
                ReplyMessage reply = new ReplyMessage();
                reply.setProcessorId(this.processorId);
                reply.setRecipient(this.getSender());
                try {
                    dm.putOutgoing(reply);
                }
                catch (CancelException cancelException) {}
            }
        }

        @Override
        public int getDSFID() {
            return -117;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.processorId);
            InternalDataSerializer.invokeToData(this.clientId, out);
            InternalDataSerializer.invokeToData(this.clientMessage, out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.processorId = in.readInt();
            this.clientId = new ClientProxyMembershipID();
            InternalDataSerializer.invokeFromData(this.clientId, in);
            this.clientMessage = new ClientInterestMessageImpl();
            InternalDataSerializer.invokeFromData(this.clientMessage, in);
        }
    }
}

