/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.regex.Pattern;
import org.apache.geode.CancelException;
import org.apache.geode.CopyException;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.SerializationException;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheLoaderException;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.cache.persistence.PartitionOfflineException;
import org.apache.geode.cache.query.types.CollectionType;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EntrySnapshot;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.FindVersionTagOperation;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.VersionTagHolder;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.MessageTooLargeException;
import org.apache.geode.internal.cache.tier.sockets.OldClientSupportService;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.versions.VersionStamp;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.offheap.OffHeapHelper;
import org.apache.geode.internal.security.IntegratedSecurityService;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.sequencelog.EntryLogger;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.logging.log4j.Logger;

public abstract class BaseCommand
implements Command {
    protected static final Logger logger = LogService.getLogger();
    protected static final boolean zipValues = false;
    protected static final boolean APPLY_RETRIES = Boolean.getBoolean("gemfire.gateway.ApplyRetries");
    public static final byte[] OK_BYTES = new byte[]{0};
    public static final int maximumChunkSize = Integer.getInteger("BridgeServer.MAXIMUM_CHUNK_SIZE", 100);
    private static boolean suppressIOExceptionLogging = Boolean.getBoolean("gemfire.bridge.suppressIOExceptionLogging");
    private static final int MAX_INCOMING_DATA = Integer.getInteger("BridgeServer.MAX_INCOMING_DATA", -1);
    private static final int MAX_INCOMING_MSGS = Integer.getInteger("BridgeServer.MAX_INCOMING_MSGS", -1);
    private static final Semaphore incomingDataLimiter;
    private static final Semaphore incomingMsgLimiter;
    protected SecurityService securityService = IntegratedSecurityService.getSecurityService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void execute(Message msg, ServerConnection servConn) {
        block20: {
            long start = DistributionStats.getStatTime();
            if (EntryLogger.isEnabled() && servConn != null) {
                EntryLogger.setSource(servConn.getMembershipID(), "c2s");
            }
            boolean shouldMasquerade = this.shouldMasqueradeForTx(msg, servConn);
            try {
                if (shouldMasquerade) {
                    GemFireCacheImpl cache = (GemFireCacheImpl)servConn.getCache();
                    InternalDistributedMember member = (InternalDistributedMember)servConn.getProxyID().getDistributedMember();
                    TXManagerImpl txMgr = cache.getTxManager();
                    TXStateProxy tx = null;
                    try {
                        tx = txMgr.masqueradeAs(msg, member, false);
                        this.cmdExecute(msg, servConn, start);
                        tx.updateProxyServer(txMgr.getMemberId());
                        txMgr.unmasquerade(tx);
                        break block20;
                    }
                    catch (Throwable throwable) {
                        txMgr.unmasquerade(tx);
                        throw throwable;
                    }
                }
                this.cmdExecute(msg, servConn, start);
            }
            catch (CopyException | SerializationException | CacheLoaderException | CacheWriterException | TransactionException | PartitionOfflineException | MessageTooLargeException | GemFireSecurityException e) {
                BaseCommand.handleExceptionNoDisconnect(msg, servConn, e);
            }
            catch (EOFException eof) {
                BaseCommand.handleEOFException(msg, servConn, eof);
            }
            catch (InterruptedIOException e) {
                BaseCommand.handleInterruptedIOException(msg, servConn, e);
            }
            catch (IOException e) {
                BaseCommand.handleIOException(msg, servConn, e);
            }
            catch (DistributedSystemDisconnectedException e) {
                BaseCommand.handleShutdownException(msg, servConn, e);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable e) {
                BaseCommand.handleThrowable(msg, servConn, e);
            }
            finally {
                EntryLogger.clearSource();
            }
        }
    }

    protected boolean shouldMasqueradeForTx(Message msg, ServerConnection servConn) {
        return servConn.getClientVersion().compareTo(Version.GFE_66) >= 0 && msg.getTransactionId() > -1;
    }

    public boolean recoverVersionTagForRetriedOperation(EntryEventImpl clientEvent) {
        LocalRegion r = clientEvent.getRegion();
        VersionTag tag = null;
        tag = clientEvent.getVersionTag() != null && clientEvent.getVersionTag().isGatewayTag() ? r.findVersionTagForGatewayEvent(clientEvent.getEventId()) : r.findVersionTagForClientEvent(clientEvent.getEventId());
        if (tag == null && (r instanceof DistributedRegion || r instanceof PartitionedRegion)) {
            tag = FindVersionTagOperation.findVersionTag(r, clientEvent.getEventId(), false);
        }
        if (tag != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("recovered version tag {} for replayed operation {}", (Object)tag, (Object)clientEvent.getEventId());
            }
            clientEvent.setVersionTag(tag);
        }
        return tag != null;
    }

    protected VersionTag findVersionTagsForRetriedBulkOp(LocalRegion r, EventID eventID) {
        VersionTag tag = r.findVersionTagForClientBulkOp(eventID);
        if (tag != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("recovered version tag {} for replayed bulk operation {}", (Object)tag, (Object)eventID);
            }
            return tag;
        }
        if (r instanceof DistributedRegion || r instanceof PartitionedRegion) {
            tag = FindVersionTagOperation.findVersionTag(r, eventID, true);
        }
        if (tag != null && logger.isDebugEnabled()) {
            logger.debug("recovered version tag {} for replayed bulk operation {}", (Object)tag, (Object)eventID);
        }
        return tag;
    }

    public abstract void cmdExecute(Message var1, ServerConnection var2, long var3) throws IOException, ClassNotFoundException, InterruptedException;

    protected void writeReply(Message origMsg, ServerConnection servConn) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        replyMsg.setNumberOfParts(1);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(OK_BYTES);
        replyMsg.send(servConn);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl tx: {}", (Object)servConn.getName(), (Object)origMsg.getTransactionId());
        }
    }

    protected void writeReplyWithRefreshMetadata(Message origMsg, ServerConnection servConn, PartitionedRegion pr, byte nwHop) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        replyMsg.setNumberOfParts(1);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(new byte[]{pr.getMetadataVersion(), nwHop});
        replyMsg.send(servConn);
        pr.getPrStats().incPRMetaDataSentCount();
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl with REFRESH_METADAT tx: {}", (Object)servConn.getName(), (Object)origMsg.getTransactionId());
        }
    }

    private static void handleEOFException(Message msg, ServerConnection servConn, Exception eof) {
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        boolean potentialModification = servConn.getPotentialModification();
        if (!crHelper.isShutdown()) {
            if (potentialModification) {
                stats.incAbandonedWriteRequests();
            } else {
                stats.incAbandonedReadRequests();
            }
            if (!suppressIOExceptionLogging) {
                if (potentialModification) {
                    int transId = msg != null ? msg.getTransactionId() : Integer.MIN_VALUE;
                    logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_EOFEXCEPTION_DURING_A_WRITE_OPERATION_ON_REGION__1_KEY_2_MESSAGEID_3, new Object[]{servConn.getName(), servConn.getModRegion(), servConn.getModKey(), transId}));
                } else {
                    logger.debug("EOF exception", (Throwable)eof);
                    logger.info(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_CONNECTION_DISCONNECT_DETECTED_BY_EOF, servConn.getName()));
                }
            }
        }
        servConn.setFlagProcessMessagesAsFalse();
        servConn.setClientDisconnectedException(eof);
    }

    private static void handleInterruptedIOException(Message msg, ServerConnection servConn, Exception e) {
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        if (!crHelper.isShutdown() && servConn.isOpen() && !suppressIOExceptionLogging && logger.isDebugEnabled()) {
            logger.debug("Aborted message due to interrupt: {}", (Object)e.getMessage(), (Object)e);
        }
        servConn.setFlagProcessMessagesAsFalse();
        servConn.setClientDisconnectedException(e);
    }

    private static void handleIOException(Message msg, ServerConnection servConn, Exception e) {
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        boolean potentialModification = servConn.getPotentialModification();
        if (!crHelper.isShutdown() && servConn.isOpen() && !suppressIOExceptionLogging) {
            if (potentialModification) {
                int transId = msg != null ? msg.getTransactionId() : Integer.MIN_VALUE;
                logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_IOEXCEPTION_DURING_OPERATION_FOR_REGION_1_KEY_2_MESSID_3, new Object[]{servConn.getName(), servConn.getModRegion(), servConn.getModKey(), transId}), (Throwable)e);
            } else {
                logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_IOEXCEPTION, servConn.getName()), (Throwable)e);
            }
        }
        servConn.setFlagProcessMessagesAsFalse();
        servConn.setClientDisconnectedException(e);
    }

    private static void handleShutdownException(Message msg, ServerConnection servConn, Exception e) {
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        boolean potentialModification = servConn.getPotentialModification();
        if (!crHelper.isShutdown()) {
            if (potentialModification) {
                int transId = msg != null ? msg.getTransactionId() : Integer.MIN_VALUE;
                logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_SHUTDOWNEXCEPTION_DURING_OPERATION_ON_REGION_1_KEY_2_MESSAGEID_3, new Object[]{servConn.getName(), servConn.getModRegion(), servConn.getModKey(), transId}), (Throwable)e);
            } else {
                logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_SHUTDOWNEXCEPTION, servConn.getName()), (Throwable)e);
            }
        }
        servConn.setFlagProcessMessagesAsFalse();
        servConn.setClientDisconnectedException(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleExceptionNoDisconnect(Message msg, ServerConnection servConn, Exception e) {
        block22: {
            boolean requiresResponse = servConn.getTransientFlag(2);
            boolean responded = servConn.getTransientFlag(1);
            boolean requiresChunkedResponse = servConn.getTransientFlag(3);
            boolean potentialModification = servConn.getPotentialModification();
            boolean wroteExceptionResponse = false;
            try {
                block21: {
                    int transId;
                    try {
                        if (requiresResponse && !responded) {
                            if (requiresChunkedResponse) {
                                BaseCommand.writeChunkedException(msg, e, false, servConn);
                            } else {
                                BaseCommand.writeException(msg, e, false, servConn);
                            }
                            wroteExceptionResponse = true;
                            servConn.setAsTrue(1);
                        }
                        if (!potentialModification) break block21;
                        int n = transId = msg != null ? msg.getTransactionId() : Integer.MIN_VALUE;
                    }
                    catch (Throwable throwable) {
                        if (potentialModification) {
                            int transId2;
                            int n = transId2 = msg != null ? msg.getTransactionId() : Integer.MIN_VALUE;
                            if (!wroteExceptionResponse) {
                                logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_EXCEPTION_DURING_OPERATION_ON_REGION_1_KEY_2_MESSAGEID_3, new Object[]{servConn.getName(), servConn.getModRegion(), servConn.getModKey(), transId2}), (Throwable)e);
                            } else if (logger.isDebugEnabled()) {
                                logger.debug("{}: Exception during operation on region: {} key: {} messageId: {}", (Object)servConn.getName(), (Object)servConn.getModRegion(), servConn.getModKey(), (Object)transId2, (Object)e);
                            }
                        } else if (!wroteExceptionResponse) {
                            logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_EXCEPTION, servConn.getName()), (Throwable)e);
                        } else if (logger.isDebugEnabled()) {
                            logger.debug("{}: Exception: {}", (Object)servConn.getName(), (Object)e.getMessage(), (Object)e);
                        }
                        throw throwable;
                    }
                    if (!wroteExceptionResponse) {
                        logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_EXCEPTION_DURING_OPERATION_ON_REGION_1_KEY_2_MESSAGEID_3, new Object[]{servConn.getName(), servConn.getModRegion(), servConn.getModKey(), transId}), (Throwable)e);
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("{}: Exception during operation on region: {} key: {} messageId: {}", (Object)servConn.getName(), (Object)servConn.getModRegion(), servConn.getModKey(), (Object)transId, (Object)e);
                    }
                    break block22;
                }
                if (!wroteExceptionResponse) {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_EXCEPTION, servConn.getName()), (Throwable)e);
                } else if (logger.isDebugEnabled()) {
                    logger.debug("{}: Exception: {}", (Object)servConn.getName(), (Object)e.getMessage(), (Object)e);
                }
            }
            catch (IOException ioe) {
                if (!logger.isDebugEnabled()) break block22;
                logger.debug("{}: Unexpected IOException writing exception: {}", (Object)servConn.getName(), (Object)ioe.getMessage(), (Object)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleThrowable(Message msg, ServerConnection servConn, Throwable th) {
        boolean requiresResponse = servConn.getTransientFlag(2);
        boolean responded = servConn.getTransientFlag(1);
        boolean requiresChunkedResponse = servConn.getTransientFlag(3);
        boolean potentialModification = servConn.getPotentialModification();
        try {
            block20: {
                try {
                    if (th instanceof Error) {
                        logger.fatal(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_ERROR_ON_SERVER, servConn.getName()), th);
                    }
                    if (!requiresResponse || responded) break block20;
                    if (requiresChunkedResponse) {
                        BaseCommand.writeChunkedException(msg, th, false, servConn);
                    } else {
                        BaseCommand.writeException(msg, th, false, servConn);
                    }
                    servConn.setAsTrue(1);
                }
                catch (Throwable throwable) {
                    if (!(th instanceof Error) && !(th instanceof CancelException)) {
                        if (potentialModification) {
                            int transId = msg != null ? msg.getTransactionId() : Integer.MIN_VALUE;
                            logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_EXCEPTION_DURING_OPERATION_ON_REGION_1_KEY_2_MESSAGEID_3, new Object[]{servConn.getName(), servConn.getModRegion(), servConn.getModKey(), transId}), th);
                        } else {
                            logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_EXCEPTION, servConn.getName()), th);
                        }
                    }
                    throw throwable;
                }
            }
            if (th instanceof Error) {
            } else if (th instanceof CancelException) {
            } else if (potentialModification) {
                int transId = msg != null ? msg.getTransactionId() : Integer.MIN_VALUE;
                logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_EXCEPTION_DURING_OPERATION_ON_REGION_1_KEY_2_MESSAGEID_3, new Object[]{servConn.getName(), servConn.getModRegion(), servConn.getModKey(), transId}), th);
            } else {
                logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_EXCEPTION, servConn.getName()), th);
            }
        }
        catch (IOException ioe) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Unexpected IOException writing exception: {}", (Object)servConn.getName(), (Object)ioe.getMessage(), (Object)ioe);
            }
        }
        finally {
            servConn.setFlagProcessMessagesAsFalse();
            servConn.setClientDisconnectedException(th);
        }
    }

    protected static void writeChunkedException(Message origMsg, Throwable e, boolean isSevere, ServerConnection servConn) throws IOException {
        BaseCommand.writeChunkedException(origMsg, e, isSevere, servConn, servConn.getChunkedResponseMessage());
    }

    protected static void writeChunkedException(Message origMsg, Throwable e, boolean isSevere, ServerConnection servConn, ChunkedMessage originalReponse) throws IOException {
        BaseCommand.writeChunkedException(origMsg, e, isSevere, servConn, originalReponse, 2);
    }

    protected static void writeChunkedException(Message origMsg, Throwable exception, boolean isSevere, ServerConnection servConn, ChunkedMessage originalReponse, int numOfParts) throws IOException {
        Throwable e = BaseCommand.getClientException(servConn, exception);
        ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
        chunkedResponseMsg.setServerConnection(servConn);
        if (originalReponse.headerHasBeenSent()) {
            chunkedResponseMsg.setNumberOfParts(numOfParts);
            chunkedResponseMsg.setLastChunkAndNumParts(true, numOfParts);
            chunkedResponseMsg.addObjPart(e);
            if (numOfParts == 2) {
                chunkedResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending exception chunk while reply in progress: {}", (Object)servConn.getName(), (Object)e.getMessage(), (Object)e);
            }
        } else {
            chunkedResponseMsg.setMessageType(2);
            chunkedResponseMsg.setNumberOfParts(numOfParts);
            chunkedResponseMsg.setLastChunkAndNumParts(true, numOfParts);
            chunkedResponseMsg.setTransactionId(origMsg.getTransactionId());
            chunkedResponseMsg.sendHeader();
            chunkedResponseMsg.addObjPart(e);
            if (numOfParts == 2) {
                chunkedResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending exception chunk: {}", (Object)servConn.getName(), (Object)e.getMessage(), (Object)e);
            }
        }
        chunkedResponseMsg.sendChunk(servConn);
    }

    public static String getExceptionTrace(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    protected static void writeException(Message origMsg, Throwable e, boolean isSevere, ServerConnection servConn) throws IOException {
        BaseCommand.writeException(origMsg, 2, e, isSevere, servConn);
    }

    private static Throwable getClientException(ServerConnection servConn, Throwable e) {
        InternalCache icache;
        OldClientSupportService svc;
        Cache cache = servConn.getCache();
        if (cache instanceof InternalCache && (svc = (icache = (InternalCache)servConn.getCache()).getService(OldClientSupportService.class)) != null) {
            return svc.getThrowable(e, servConn.getClientVersion());
        }
        return e;
    }

    protected static void writeException(Message origMsg, int msgType, Throwable e, boolean isSevere, ServerConnection servConn) throws IOException {
        Throwable theException = BaseCommand.getClientException(servConn, e);
        Message errorMsg = servConn.getErrorResponseMessage();
        errorMsg.setMessageType(msgType);
        errorMsg.setNumberOfParts(2);
        errorMsg.setTransactionId(origMsg.getTransactionId());
        if (isSevere) {
            String msg = theException.getMessage();
            if (msg == null) {
                msg = theException.toString();
            }
            logger.fatal(LocalizedMessage.create(LocalizedStrings.BaseCommand_SEVERE_CACHE_EXCEPTION_0, msg));
        }
        errorMsg.addObjPart(theException);
        errorMsg.addStringPart(BaseCommand.getExceptionTrace(theException));
        errorMsg.send(servConn);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Wrote exception: {}", (Object)servConn.getName(), (Object)e.getMessage(), (Object)e);
        }
        if (e instanceof MessageTooLargeException) {
            throw (IOException)e;
        }
    }

    protected static void writeErrorResponse(Message origMsg, int messageType2, ServerConnection servConn) throws IOException {
        Message errorMsg = servConn.getErrorResponseMessage();
        errorMsg.setMessageType(messageType2);
        errorMsg.setNumberOfParts(1);
        errorMsg.setTransactionId(origMsg.getTransactionId());
        errorMsg.addStringPart(LocalizedStrings.BaseCommand_INVALID_DATA_RECEIVED_PLEASE_SEE_THE_CACHE_SERVER_LOG_FILE_FOR_ADDITIONAL_DETAILS.toLocalizedString());
        errorMsg.send(servConn);
    }

    protected static void writeErrorResponse(Message origMsg, int messageType2, String msg, ServerConnection servConn) throws IOException {
        Message errorMsg = servConn.getErrorResponseMessage();
        errorMsg.setMessageType(messageType2);
        errorMsg.setNumberOfParts(1);
        errorMsg.setTransactionId(origMsg.getTransactionId());
        errorMsg.addStringPart(msg);
        errorMsg.send(servConn);
    }

    protected static void writeRegionDestroyedEx(Message msg, String regionName, String title, ServerConnection servConn) throws IOException {
        String reason = servConn.getName() + ": Region named " + regionName + title;
        RegionDestroyedException ex = new RegionDestroyedException(reason, regionName);
        if (servConn.getTransientFlag(3)) {
            BaseCommand.writeChunkedException(msg, ex, false, servConn);
        } else {
            BaseCommand.writeException(msg, ex, false, servConn);
        }
    }

    protected static void writeResponse(Object data, Object callbackArg, Message origMsg, boolean isObject, ServerConnection servConn) throws IOException {
        Message responseMsg = servConn.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setTransactionId(origMsg.getTransactionId());
        if (callbackArg == null) {
            responseMsg.setNumberOfParts(1);
        } else {
            responseMsg.setNumberOfParts(2);
        }
        if (data instanceof byte[]) {
            responseMsg.addRawPart((byte[])data, isObject);
        } else {
            Assert.assertTrue(isObject, "isObject should be true when value is not a byte[]");
            responseMsg.addObjPart(data, false);
        }
        if (callbackArg != null) {
            responseMsg.addObjPart(callbackArg);
        }
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        responseMsg.send(servConn);
        origMsg.clearParts();
    }

    protected static void writeResponseWithRefreshMetadata(Object data, Object callbackArg, Message origMsg, boolean isObject, ServerConnection servConn, PartitionedRegion pr, byte nwHop) throws IOException {
        Message responseMsg = servConn.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setTransactionId(origMsg.getTransactionId());
        if (callbackArg == null) {
            responseMsg.setNumberOfParts(2);
        } else {
            responseMsg.setNumberOfParts(3);
        }
        if (data instanceof byte[]) {
            responseMsg.addRawPart((byte[])data, isObject);
        } else {
            Assert.assertTrue(isObject, "isObject should be true when value is not a byte[]");
            responseMsg.addObjPart(data, false);
        }
        if (callbackArg != null) {
            responseMsg.addObjPart(callbackArg);
        }
        responseMsg.addBytesPart(new byte[]{pr.getMetadataVersion(), nwHop});
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        responseMsg.send(servConn);
        origMsg.clearParts();
    }

    protected static void writeResponseWithFunctionAttribute(byte[] data, Message origMsg, ServerConnection servConn) throws IOException {
        Message responseMsg = servConn.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setTransactionId(origMsg.getTransactionId());
        responseMsg.setNumberOfParts(1);
        responseMsg.addBytesPart(data);
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        responseMsg.send(servConn);
        origMsg.clearParts();
    }

    protected static void checkForInterrupt(ServerConnection servConn, Exception e) throws InterruptedException, InterruptedIOException {
        servConn.getCachedRegionHelper().checkCancelInProgress(e);
        if (e instanceof InterruptedException) {
            throw (InterruptedException)e;
        }
        if (e instanceof InterruptedIOException) {
            throw (InterruptedIOException)e;
        }
    }

    protected static void writeQueryResponseChunk(Object queryResponseChunk, CollectionType collectionType, boolean lastChunk, ServerConnection servConn) throws IOException {
        ChunkedMessage queryResponseMsg = servConn.getQueryResponseMessage();
        queryResponseMsg.setNumberOfParts(2);
        queryResponseMsg.setLastChunk(lastChunk);
        queryResponseMsg.addObjPart(collectionType, false);
        queryResponseMsg.addObjPart(queryResponseChunk, false);
        queryResponseMsg.sendChunk(servConn);
    }

    protected static void writeQueryResponseException(Message origMsg, Throwable exception, boolean isSevere, ServerConnection servConn) throws IOException {
        Throwable e = BaseCommand.getClientException(servConn, exception);
        ChunkedMessage queryResponseMsg = servConn.getQueryResponseMessage();
        ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
        if (queryResponseMsg.headerHasBeenSent()) {
            queryResponseMsg.setServerConnection(servConn);
            queryResponseMsg.setNumberOfParts(2);
            queryResponseMsg.setLastChunkAndNumParts(true, 2);
            queryResponseMsg.addObjPart(e);
            queryResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending exception chunk while reply in progress: {}", (Object)servConn.getName(), (Object)e.getMessage(), (Object)e);
            }
            queryResponseMsg.sendChunk(servConn);
        } else {
            chunkedResponseMsg.setServerConnection(servConn);
            chunkedResponseMsg.setMessageType(2);
            chunkedResponseMsg.setNumberOfParts(2);
            chunkedResponseMsg.setLastChunkAndNumParts(true, 2);
            chunkedResponseMsg.setTransactionId(origMsg.getTransactionId());
            chunkedResponseMsg.sendHeader();
            chunkedResponseMsg.addObjPart(e);
            chunkedResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending exception chunk: {}", (Object)servConn.getName(), (Object)e.getMessage(), (Object)e);
            }
            chunkedResponseMsg.sendChunk(servConn);
        }
    }

    protected static void writeChunkedErrorResponse(Message origMsg, int messageType2, String message, ServerConnection servConn) throws IOException {
        ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
        if (logger.isDebugEnabled()) {
            logger.debug(servConn.getName() + ": Sending error message header type: " + messageType2 + " transaction: " + origMsg.getTransactionId());
        }
        chunkedResponseMsg.setMessageType(messageType2);
        chunkedResponseMsg.setTransactionId(origMsg.getTransactionId());
        chunkedResponseMsg.sendHeader();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending error message chunk: {}", (Object)servConn.getName(), (Object)message);
        }
        chunkedResponseMsg.setNumberOfParts(1);
        chunkedResponseMsg.setLastChunk(true);
        chunkedResponseMsg.addStringPart(message);
        chunkedResponseMsg.sendChunk(servConn);
    }

    protected static void writeFunctionResponseException(Message origMsg, int messageType2, String message, ServerConnection servConn, Throwable exception) throws IOException {
        Throwable e = BaseCommand.getClientException(servConn, exception);
        ChunkedMessage functionResponseMsg = servConn.getFunctionResponseMessage();
        ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
        if (functionResponseMsg.headerHasBeenSent()) {
            functionResponseMsg.setServerConnection(servConn);
            functionResponseMsg.setNumberOfParts(2);
            functionResponseMsg.setLastChunkAndNumParts(true, 2);
            functionResponseMsg.addObjPart(e);
            functionResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending exception chunk while reply in progress: {}", (Object)servConn.getName(), (Object)e.getMessage(), (Object)e);
            }
            functionResponseMsg.sendChunk(servConn);
        } else {
            chunkedResponseMsg.setServerConnection(servConn);
            chunkedResponseMsg.setMessageType(messageType2);
            chunkedResponseMsg.setNumberOfParts(2);
            chunkedResponseMsg.setLastChunkAndNumParts(true, 2);
            chunkedResponseMsg.setTransactionId(origMsg.getTransactionId());
            chunkedResponseMsg.sendHeader();
            chunkedResponseMsg.addObjPart(e);
            chunkedResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending exception chunk: {}", (Object)servConn.getName(), (Object)e.getMessage(), (Object)e);
            }
            chunkedResponseMsg.sendChunk(servConn);
        }
    }

    protected static void writeFunctionResponseError(Message origMsg, int messageType2, String message, ServerConnection servConn) throws IOException {
        ChunkedMessage functionResponseMsg = servConn.getFunctionResponseMessage();
        ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
        if (functionResponseMsg.headerHasBeenSent()) {
            functionResponseMsg.setNumberOfParts(1);
            functionResponseMsg.setLastChunk(true);
            functionResponseMsg.addStringPart(message);
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending Error chunk while reply in progress: {}", (Object)servConn.getName(), (Object)message);
            }
            functionResponseMsg.sendChunk(servConn);
        } else {
            chunkedResponseMsg.setMessageType(messageType2);
            chunkedResponseMsg.setNumberOfParts(1);
            chunkedResponseMsg.setLastChunk(true);
            chunkedResponseMsg.setTransactionId(origMsg.getTransactionId());
            chunkedResponseMsg.sendHeader();
            chunkedResponseMsg.addStringPart(message);
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending Error chunk: {}", (Object)servConn.getName(), (Object)message);
            }
            chunkedResponseMsg.sendChunk(servConn);
        }
    }

    protected static void writeKeySetErrorResponse(Message origMsg, int messageType2, String message, ServerConnection servConn) throws IOException {
        ChunkedMessage chunkedResponseMsg = servConn.getKeySetResponseMessage();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending error message header type: {} transaction: {}", (Object)servConn.getName(), (Object)messageType2, (Object)origMsg.getTransactionId());
        }
        chunkedResponseMsg.setMessageType(messageType2);
        chunkedResponseMsg.setTransactionId(origMsg.getTransactionId());
        chunkedResponseMsg.sendHeader();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending error message chunk: {}", (Object)servConn.getName(), (Object)message);
        }
        chunkedResponseMsg.setNumberOfParts(1);
        chunkedResponseMsg.setLastChunk(true);
        chunkedResponseMsg.addStringPart(message);
        chunkedResponseMsg.sendChunk(servConn);
    }

    static Message readRequest(ServerConnection servConn) {
        Message requestMsg = null;
        try {
            requestMsg = servConn.getRequestMessage();
            requestMsg.recv(servConn, MAX_INCOMING_DATA, incomingDataLimiter, incomingMsgLimiter);
            return requestMsg;
        }
        catch (EOFException eof) {
            BaseCommand.handleEOFException(null, servConn, eof);
        }
        catch (InterruptedIOException e) {
            BaseCommand.handleInterruptedIOException(null, servConn, e);
        }
        catch (IOException e) {
            BaseCommand.handleIOException(null, servConn, e);
        }
        catch (DistributedSystemDisconnectedException e) {
            BaseCommand.handleShutdownException(null, servConn, e);
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable e) {
            SystemFailure.checkFailure();
            BaseCommand.handleThrowable(null, servConn, e);
        }
        return requestMsg;
    }

    protected static void fillAndSendRegisterInterestResponseChunks(LocalRegion region, Object riKey, int interestType2, InterestResultPolicy policy, ServerConnection servConn) throws IOException {
        BaseCommand.fillAndSendRegisterInterestResponseChunks(region, riKey, interestType2, false, policy, servConn);
    }

    protected static void fillAndSendRegisterInterestResponseChunks(LocalRegion region, Object riKey, int interestType2, boolean serializeValues, InterestResultPolicy policy, ServerConnection servConn) throws IOException {
        if (policy.isNone()) {
            BaseCommand.sendRegisterInterestResponseChunk(region, riKey, new ArrayList(), true, servConn);
            return;
        }
        if (policy.isKeysValues() && servConn.getClientVersion().compareTo(Version.GFE_80) >= 0) {
            BaseCommand.handleKeysValuesPolicy(region, riKey, interestType2, serializeValues, servConn);
            return;
        }
        if (riKey instanceof List) {
            BaseCommand.handleList(region, (List)riKey, policy, servConn);
            return;
        }
        if (!(riKey instanceof String)) {
            BaseCommand.handleSingleton(region, riKey, policy, servConn);
            return;
        }
        switch (interestType2) {
            case 3: {
                throw new InternalGemFireError(LocalizedStrings.BaseCommand_NOT_YET_SUPPORTED.toLocalizedString());
            }
            case 2: {
                throw new InternalGemFireError(LocalizedStrings.BaseCommand_NOT_YET_SUPPORTED.toLocalizedString());
            }
            case 1: {
                String regEx = (String)riKey;
                if (regEx.equals(".*")) {
                    BaseCommand.handleAllKeys(region, policy, servConn);
                    break;
                }
                BaseCommand.handleRegEx(region, regEx, policy, servConn);
                break;
            }
            case 0: {
                if (riKey.equals("ALL_KEYS")) {
                    BaseCommand.handleAllKeys(region, policy, servConn);
                    break;
                }
                BaseCommand.handleSingleton(region, riKey, policy, servConn);
                break;
            }
            default: {
                throw new InternalGemFireError(LocalizedStrings.BaseCommand_UNKNOWN_INTEREST_TYPE.toLocalizedString());
            }
        }
    }

    private static void handleKeysValuesPolicy(LocalRegion region, Object riKey, int interestType2, boolean serializeValues, ServerConnection servConn) throws IOException {
        if (riKey instanceof List) {
            BaseCommand.handleKVList(region, (List)riKey, serializeValues, servConn);
            return;
        }
        if (!(riKey instanceof String)) {
            BaseCommand.handleKVSingleton(region, riKey, serializeValues, servConn);
            return;
        }
        switch (interestType2) {
            case 3: {
                throw new InternalGemFireError(LocalizedStrings.BaseCommand_NOT_YET_SUPPORTED.toLocalizedString());
            }
            case 2: {
                throw new InternalGemFireError(LocalizedStrings.BaseCommand_NOT_YET_SUPPORTED.toLocalizedString());
            }
            case 1: {
                String regEx = (String)riKey;
                if (regEx.equals(".*")) {
                    BaseCommand.handleKVAllKeys(region, null, serializeValues, servConn);
                    break;
                }
                BaseCommand.handleKVAllKeys(region, regEx, serializeValues, servConn);
                break;
            }
            case 0: {
                if (riKey.equals("ALL_KEYS")) {
                    BaseCommand.handleKVAllKeys(region, null, serializeValues, servConn);
                    break;
                }
                BaseCommand.handleKVSingleton(region, riKey, serializeValues, servConn);
                break;
            }
            default: {
                throw new InternalGemFireError(LocalizedStrings.BaseCommand_UNKNOWN_INTEREST_TYPE.toLocalizedString());
            }
        }
    }

    protected static void sendRegisterInterestResponseChunk(Region region, Object riKey, ArrayList list, boolean lastChunk, ServerConnection servConn) throws IOException {
        String regionName;
        ChunkedMessage chunkedResponseMsg = servConn.getRegisterInterestResponseMessage();
        chunkedResponseMsg.setNumberOfParts(1);
        chunkedResponseMsg.setLastChunk(lastChunk);
        chunkedResponseMsg.addObjPart(list, false);
        String string = regionName = region == null ? " null " : region.getFullPath();
        if (logger.isDebugEnabled()) {
            String str = servConn.getName() + ": Sending" + (lastChunk ? " last " : " ") + "register interest response chunk for region: " + regionName + " for keys: " + riKey + " chunk=<" + chunkedResponseMsg + ">";
            logger.debug(str);
        }
        chunkedResponseMsg.sendChunk(servConn);
    }

    private static boolean sendTombstonesInRIResults(ServerConnection servConn, InterestResultPolicy policy) {
        return policy == InterestResultPolicy.KEYS_VALUES && servConn.getClientVersion().compareTo(Version.GFE_80) >= 0;
    }

    private static void handleList(LocalRegion region, List keyList, InterestResultPolicy policy, ServerConnection servConn) throws IOException {
        if (region instanceof PartitionedRegion) {
            BaseCommand.handleListPR((PartitionedRegion)region, keyList, policy, servConn);
            return;
        }
        ArrayList newKeyList = new ArrayList(maximumChunkSize);
        if (region != null) {
            for (Object entryKey : keyList) {
                if (!region.containsKey(entryKey) && (!BaseCommand.sendTombstonesInRIResults(servConn, policy) || !region.containsTombstone(entryKey))) continue;
                BaseCommand.appendInterestResponseKey(region, keyList, entryKey, newKeyList, "list", servConn);
            }
        }
        BaseCommand.sendRegisterInterestResponseChunk(region, keyList, newKeyList, true, servConn);
    }

    @SuppressWarnings(value={"NP_NULL_PARAM_DEREF"}, justification="Null value handled in sendNewRegisterInterestResponseChunk()")
    private static void handleKVSingleton(LocalRegion region, Object entryKey, boolean serializeValues, ServerConnection servConn) throws IOException {
        VersionedObjectList values = new VersionedObjectList(maximumChunkSize, true, region == null ? true : region.getAttributes().getConcurrencyChecksEnabled(), serializeValues);
        if (region != null && (region.containsKey(entryKey) || region.containsTombstone(entryKey))) {
            VersionTagHolder versionHolder = new VersionTagHolder();
            ClientProxyMembershipID id = servConn == null ? null : servConn.getProxyID();
            Object data = region.get(entryKey, null, true, true, true, id, versionHolder, true);
            VersionTag vt = versionHolder.getVersionTag();
            BaseCommand.updateValues(values, entryKey, data, vt);
        }
        BaseCommand.sendNewRegisterInterestResponseChunk(region, entryKey, values, true, servConn);
    }

    private static void handleSingleton(LocalRegion region, Object entryKey, InterestResultPolicy policy, ServerConnection servConn) throws IOException {
        ArrayList keyList = new ArrayList(1);
        if (region != null && (region.containsKey(entryKey) || BaseCommand.sendTombstonesInRIResults(servConn, policy) && region.containsTombstone(entryKey))) {
            BaseCommand.appendInterestResponseKey(region, entryKey, entryKey, keyList, "individual", servConn);
        }
        BaseCommand.sendRegisterInterestResponseChunk(region, entryKey, keyList, true, servConn);
    }

    private static void handleAllKeys(LocalRegion region, InterestResultPolicy policy, ServerConnection servConn) throws IOException {
        ArrayList keyList = new ArrayList(maximumChunkSize);
        if (region != null) {
            Iterator it = region.keySet(BaseCommand.sendTombstonesInRIResults(servConn, policy)).iterator();
            while (it.hasNext()) {
                BaseCommand.appendInterestResponseKey(region, "ALL_KEYS", it.next(), keyList, "ALL_KEYS", servConn);
            }
        }
        BaseCommand.sendRegisterInterestResponseChunk(region, "ALL_KEYS", keyList, true, servConn);
    }

    private static void handleKVAllKeys(LocalRegion region, String regex, boolean serializeValues, ServerConnection servConn) throws IOException {
        if (region != null && region instanceof PartitionedRegion) {
            BaseCommand.handleKVKeysPR((PartitionedRegion)region, regex, serializeValues, servConn);
            return;
        }
        VersionedObjectList values = new VersionedObjectList(maximumChunkSize, true, region == null ? true : region.getAttributes().getConcurrencyChecksEnabled(), serializeValues);
        if (region != null) {
            VersionTag versionTag = null;
            Object data = null;
            Pattern keyPattern = null;
            if (regex != null) {
                keyPattern = Pattern.compile(regex);
            }
            for (Object key : region.keySet(true)) {
                VersionTagHolder versionHolder = new VersionTagHolder();
                if (keyPattern != null && (!(key instanceof String) || !keyPattern.matcher((String)key).matches())) continue;
                ClientProxyMembershipID id = servConn == null ? null : servConn.getProxyID();
                data = region.get(key, null, true, true, true, id, versionHolder, true);
                versionTag = versionHolder.getVersionTag();
                BaseCommand.updateValues(values, key, data, versionTag);
                if (values.size() != maximumChunkSize) continue;
                BaseCommand.sendNewRegisterInterestResponseChunk(region, regex != null ? regex : "ALL_KEYS", values, false, servConn);
                values.clear();
            }
        }
        BaseCommand.sendNewRegisterInterestResponseChunk(region, regex != null ? regex : "ALL_KEYS", values, true, servConn);
    }

    private static void handleKVKeysPR(PartitionedRegion region, Object keyInfo, boolean serializeValues, ServerConnection servConn) throws IOException {
        int id = 0;
        HashMap<Integer, HashSet> bucketKeys = null;
        VersionedObjectList values = new VersionedObjectList(maximumChunkSize, true, region.getConcurrencyChecksEnabled(), serializeValues);
        if (keyInfo != null && keyInfo instanceof List) {
            bucketKeys = new HashMap<Integer, HashSet>();
            for (Object key : (List)keyInfo) {
                id = PartitionedRegionHelper.getHashKey(region, null, key, null, null);
                if (bucketKeys.containsKey(id)) {
                    bucketKeys.get(id).add(key);
                    continue;
                }
                HashSet keys = new HashSet();
                keys.add(key);
                bucketKeys.put(id, keys);
            }
            region.fetchEntries(bucketKeys, values, servConn);
        } else {
            region.fetchEntries((String)keyInfo, values, servConn);
        }
        BaseCommand.sendNewRegisterInterestResponseChunk(region, keyInfo != null ? keyInfo : "ALL_KEYS", values, true, servConn);
    }

    private static void updateValues(VersionedObjectList values, Object key, Object value, VersionTag versionTag) {
        boolean keyNotPresent;
        boolean isObject = true;
        boolean wasInvalid = false;
        if (value instanceof CachedDeserializable) {
            value = ((CachedDeserializable)value).getValue();
        } else if (value == Token.REMOVED_PHASE1 || value == Token.REMOVED_PHASE2 || value == Token.DESTROYED || value == Token.TOMBSTONE) {
            value = null;
        } else if (value == Token.INVALID || value == Token.LOCAL_INVALID) {
            value = null;
            wasInvalid = true;
        } else if (value instanceof byte[]) {
            isObject = false;
        }
        boolean bl = keyNotPresent = !wasInvalid && (value == null || value == Token.TOMBSTONE);
        if (keyNotPresent) {
            values.addObjectPartForAbsentKey(key, value, versionTag);
        } else {
            values.addObjectPart(key, value, isObject, versionTag);
        }
    }

    public static void appendNewRegisterInterestResponseChunkFromLocal(LocalRegion region, VersionedObjectList values, Object riKeys, Set keySet, ServerConnection servConn) throws IOException {
        Object key2 = null;
        VersionTagHolder versionHolder = null;
        ClientProxyMembershipID requestingClient = servConn == null ? null : servConn.getProxyID();
        for (Object key2 : keySet) {
            versionHolder = new VersionTagHolder();
            Object value = region.get(key2, null, true, true, true, requestingClient, versionHolder, true);
            BaseCommand.updateValues(values, key2, value, versionHolder.getVersionTag());
            if (values.size() != maximumChunkSize) continue;
            BaseCommand.sendNewRegisterInterestResponseChunk(region, riKeys != null ? riKeys : "ALL_KEYS", values, false, servConn);
            values.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendNewRegisterInterestResponseChunk(LocalRegion region, VersionedObjectList values, Object riKeys, Set set, ServerConnection servConn) throws IOException {
        for (Map.Entry entry : set) {
            if (entry instanceof Region.Entry) {
                VersionTag vt = null;
                Object key = null;
                Object value = null;
                if (entry instanceof EntrySnapshot) {
                    vt = ((EntrySnapshot)entry).getVersionTag();
                    key = ((EntrySnapshot)entry).getRegionEntry().getKey();
                    value = ((EntrySnapshot)entry).getRegionEntry().getValue(null);
                    BaseCommand.updateValues(values, key, value, vt);
                } else {
                    VersionStamp vs = ((LocalRegion.NonTXEntry)entry).getRegionEntry().getVersionStamp();
                    vt = vs == null ? null : vs.asVersionTag();
                    key = entry.getKey();
                    value = ((LocalRegion.NonTXEntry)entry).getRegionEntry()._getValueRetain(region, true);
                    try {
                        BaseCommand.updateValues(values, key, value, vt);
                    }
                    finally {
                        OffHeapHelper.release(value);
                    }
                }
            } else {
                ArrayList list = (ArrayList)entry.getValue();
                Object value = list.get(0);
                VersionTag tag = (VersionTag)list.get(1);
                BaseCommand.updateValues(values, entry.getKey(), value, tag);
            }
            if (values.size() != maximumChunkSize) continue;
            BaseCommand.sendNewRegisterInterestResponseChunk(region, riKeys != null ? riKeys : "ALL_KEYS", values, false, servConn);
            values.clear();
        }
    }

    public static void sendNewRegisterInterestResponseChunk(LocalRegion region, Object riKey, VersionedObjectList list, boolean lastChunk, ServerConnection servConn) throws IOException {
        String regionName;
        ChunkedMessage chunkedResponseMsg = servConn.getRegisterInterestResponseMessage();
        chunkedResponseMsg.setNumberOfParts(1);
        chunkedResponseMsg.setLastChunk(lastChunk);
        chunkedResponseMsg.addObjPart(list, false);
        String string = regionName = region == null ? " null " : region.getFullPath();
        if (logger.isDebugEnabled()) {
            String str = servConn.getName() + ": Sending" + (lastChunk ? " last " : " ") + "register interest response chunk for region: " + regionName + " for keys: " + riKey + " chunk=<" + chunkedResponseMsg + ">";
            logger.debug(str);
        }
        chunkedResponseMsg.sendChunk(servConn);
    }

    private static void handleRegEx(LocalRegion region, String regex, InterestResultPolicy policy, ServerConnection servConn) throws IOException {
        if (region instanceof PartitionedRegion) {
            BaseCommand.handleRegExPR((PartitionedRegion)region, regex, policy, servConn);
            return;
        }
        ArrayList keyList = new ArrayList(maximumChunkSize);
        Pattern keyPattern = Pattern.compile(regex);
        if (region != null) {
            for (Object entryKey : region.keySet(BaseCommand.sendTombstonesInRIResults(servConn, policy))) {
                if (!(entryKey instanceof String) || !keyPattern.matcher((String)entryKey).matches()) continue;
                BaseCommand.appendInterestResponseKey(region, regex, entryKey, keyList, "regex", servConn);
            }
        }
        BaseCommand.sendRegisterInterestResponseChunk(region, regex, keyList, true, servConn);
    }

    private static void handleRegExPR(final PartitionedRegion region, final String regex, InterestResultPolicy policy, final ServerConnection servConn) throws IOException {
        final ArrayList keyList = new ArrayList(maximumChunkSize);
        region.getKeysWithRegEx(regex, BaseCommand.sendTombstonesInRIResults(servConn, policy), new PartitionedRegion.SetCollector(){

            @Override
            public void receiveSet(Set theSet) throws IOException {
                BaseCommand.appendInterestResponseKeys(region, regex, theSet, keyList, "regex", servConn);
            }
        });
        BaseCommand.sendRegisterInterestResponseChunk(region, regex, keyList, true, servConn);
    }

    private static void handleListPR(final PartitionedRegion region, final List keyList, InterestResultPolicy policy, final ServerConnection servConn) throws IOException {
        final ArrayList newKeyList = new ArrayList(maximumChunkSize);
        region.getKeysWithList(keyList, BaseCommand.sendTombstonesInRIResults(servConn, policy), new PartitionedRegion.SetCollector(){

            @Override
            public void receiveSet(Set theSet) throws IOException {
                BaseCommand.appendInterestResponseKeys(region, keyList, theSet, newKeyList, "list", servConn);
            }
        });
        BaseCommand.sendRegisterInterestResponseChunk(region, keyList, newKeyList, true, servConn);
    }

    private static void handleKVList(LocalRegion region, List keyList, boolean serializeValues, ServerConnection servConn) throws IOException {
        if (region != null && region instanceof PartitionedRegion) {
            BaseCommand.handleKVKeysPR((PartitionedRegion)region, keyList, serializeValues, servConn);
            return;
        }
        VersionedObjectList values = new VersionedObjectList(maximumChunkSize, true, region == null ? true : region.getAttributes().getConcurrencyChecksEnabled(), serializeValues);
        if (region != null) {
            VersionTag versionTag = null;
            Object data = null;
            for (Object key : keyList) {
                if (!region.containsKey(key) && !region.containsTombstone(key)) continue;
                VersionTagHolder versionHolder = new VersionTagHolder();
                ClientProxyMembershipID id = servConn == null ? null : servConn.getProxyID();
                data = region.get(key, null, true, true, true, id, versionHolder, true);
                versionTag = versionHolder.getVersionTag();
                BaseCommand.updateValues(values, key, data, versionTag);
                if (values.size() != maximumChunkSize) continue;
                BaseCommand.sendNewRegisterInterestResponseChunk(region, keyList, values, false, servConn);
                values.clear();
            }
        }
        BaseCommand.sendNewRegisterInterestResponseChunk(region, keyList, values, true, servConn);
    }

    private static void appendInterestResponseKey(LocalRegion region, Object riKey, Object entryKey, ArrayList list, String kind, ServerConnection servConn) throws IOException {
        list.add(entryKey);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: appendInterestResponseKey <{}>; list size was {}; region: {}", (Object)servConn.getName(), entryKey, (Object)list.size(), (Object)region.getFullPath());
        }
        if (list.size() == maximumChunkSize) {
            BaseCommand.sendRegisterInterestResponseChunk(region, riKey, list, false, servConn);
            list.clear();
        }
    }

    protected static void appendInterestResponseKeys(LocalRegion region, Object riKey, Collection entryKeys, ArrayList collector, String riDescr, ServerConnection servConn) throws IOException {
        Iterator it = entryKeys.iterator();
        while (it.hasNext()) {
            BaseCommand.appendInterestResponseKey(region, riKey, it.next(), collector, riDescr, servConn);
        }
    }

    static {
        Semaphore tmp = MAX_INCOMING_DATA > 0 ? new Semaphore(MAX_INCOMING_DATA, true) : null;
        incomingDataLimiter = tmp;
        tmp = MAX_INCOMING_MSGS > 0 ? new Semaphore(MAX_INCOMING_MSGS, false) : null;
        incomingMsgLimiter = tmp;
    }
}

