/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.snapshot;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.snapshot.SnapshotOptions;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.snapshot.LocalExporter;
import org.apache.geode.internal.cache.snapshot.RegionSnapshotServiceImpl;
import org.apache.geode.internal.cache.snapshot.SnapshotPacket;

public class ClientExporter<K, V>
implements RegionSnapshotServiceImpl.Exporter<K, V> {
    private final Pool pool;

    public ClientExporter(Pool p) {
        this.pool = p;
    }

    @Override
    public long export(Region<K, V> region, RegionSnapshotServiceImpl.ExportSink sink, SnapshotOptions<K, V> options) throws IOException {
        try {
            ClientArgs<K, V> args = new ClientArgs<K, V>(region.getFullPath(), this.pool.getPRSingleHopEnabled(), options);
            ClientExportCollector results = new ClientExportCollector(sink);
            Execution exec = this.pool.getPRSingleHopEnabled() ? FunctionService.onRegion(region) : FunctionService.onServer(this.pool);
            ResultCollector<?, ?> rc = exec.withArgs(args).withCollector(results).execute(new ProxyExportFunction());
            return (Long)rc.getResult();
        }
        catch (FunctionException e) {
            throw new IOException(e);
        }
    }

    private static class ClientExportCollector
    implements ResultCollector<Object, Long> {
        private final AtomicLong count;
        private final RegionSnapshotServiceImpl.ExportSink sink;
        private volatile Exception error;

        public ClientExportCollector(RegionSnapshotServiceImpl.ExportSink sink) {
            this.sink = sink;
            this.count = new AtomicLong(0L);
        }

        @Override
        public Long getResult() throws FunctionException {
            if (this.error != null) {
                throw new FunctionException(this.error);
            }
            return this.count.get();
        }

        @Override
        public Long getResult(long timeout, TimeUnit unit) throws FunctionException, InterruptedException {
            return this.getResult();
        }

        @Override
        public void addResult(DistributedMember memberID, Object result) {
            if (result instanceof Long) {
                this.count.addAndGet((Long)result);
            } else if (result instanceof Exception) {
                this.error = (Exception)result;
            } else {
                try {
                    this.sink.write((SnapshotPacket.SnapshotRecord[])result);
                }
                catch (IOException e) {
                    this.error = e;
                }
            }
        }

        @Override
        public void endResults() {
        }

        @Override
        public void clearResults() {
        }
    }

    private static class ProxyExportFunction<K, V>
    implements Function {
        private static final long serialVersionUID = 1L;

        private ProxyExportFunction() {
        }

        @Override
        public boolean hasResult() {
            return true;
        }

        @Override
        public void execute(FunctionContext context) {
            ClientArgs args = (ClientArgs)context.getArguments();
            ResultSender<SnapshotPacket.SnapshotRecord[]> rs = context.getResultSender();
            RegionSnapshotServiceImpl.ResultSenderSink sink = new RegionSnapshotServiceImpl.ResultSenderSink(rs);
            Region region = GemFireCacheImpl.getExisting("Exporting snapshot").getRegion(args.getRegion());
            RegionSnapshotServiceImpl.Exporter exp = args.isPRSingleHop() ? new LocalExporter() : RegionSnapshotServiceImpl.createExporter(region, args.options);
            try {
                long count = exp.export(region, sink, args.getOptions());
                rs.lastResult((SnapshotPacket.SnapshotRecord[])count);
            }
            catch (IOException e) {
                rs.sendException(e);
            }
        }

        @Override
        public String getId() {
            return "org.apache.geode.cache.snapshot.ClientExport";
        }

        @Override
        public boolean optimizeForWrite() {
            return false;
        }

        @Override
        public boolean isHA() {
            return false;
        }
    }

    private static class ClientArgs<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String region;
        private final boolean prSingleHop;
        private final SnapshotOptions<K, V> options;

        public ClientArgs(String region, boolean prSingleHop, SnapshotOptions<K, V> options) {
            this.region = region;
            this.prSingleHop = prSingleHop;
            this.options = options;
        }

        public String getRegion() {
            return this.region;
        }

        public boolean isPRSingleHop() {
            return this.prSingleHop;
        }

        public SnapshotOptions<K, V> getOptions() {
            return this.options;
        }
    }
}

