/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned.rebalance;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.geode.cache.partition.PartitionMemberInfo;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.FixedPartitionAttributesImpl;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.InternalPartitionDetails;
import org.apache.geode.internal.cache.partitioned.OfflineMemberDetails;
import org.apache.geode.internal.cache.partitioned.PRLoad;
import org.apache.geode.internal.cache.partitioned.PartitionMemberInfoImpl;
import org.apache.geode.internal.cache.partitioned.rebalance.BucketOperator;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;

public class PartitionedRegionLoadModel {
    private static Logger logger = LogService.getLogger();
    private static final Comparator<Bucket> REDUNDANCY_COMPARATOR = new Comparator<Bucket>(){

        @Override
        public int compare(Bucket o1, Bucket o2) {
            int result = o1.getRedundancy() - o2.getRedundancy();
            if (result == 0) {
                result = Float.compare(o2.getLoad(), o1.getLoad());
            }
            if (result == 0) {
                result = o1.getId() - o2.getId();
            }
            return result;
        }
    };
    private static final long MEGABYTES = 0x100000L;
    final MemberRollup INVALID_MEMBER = new MemberRollup(null, false, false);
    private final BucketRollup[] buckets;
    private final Map<InternalDistributedMember, MemberRollup> members = new HashMap<InternalDistributedMember, MemberRollup>();
    private final Set<String> allColocatedRegions = new HashSet<String>();
    private SortedSet<BucketRollup> lowRedundancyBuckets = null;
    private SortedSet<BucketRollup> overRedundancyBuckets = null;
    private final Collection<Move> attemptedPrimaryMoves = new HashSet<Move>();
    private final Collection<Move> attemptedBucketMoves = new HashSet<Move>();
    private final Collection<Move> attemptedBucketCreations = new HashSet<Move>();
    private final Collection<Move> attemptedBucketRemoves = new HashSet<Move>();
    private final BucketOperator operator;
    private final int requiredRedundancy;
    private float primaryAverage = -1.0f;
    private float averageLoad = -1.0f;
    private double minPrimaryImprovement = -1.0;
    private double minImprovement = -1.0;
    private final AddressComparor addressComparor;
    private final Set<InternalDistributedMember> criticalMembers;
    private final PartitionedRegion partitionedRegion;

    public PartitionedRegionLoadModel(BucketOperator operator, int redundancyLevel, int numBuckets, AddressComparor addressComparor, Set<InternalDistributedMember> criticalMembers, PartitionedRegion region) {
        this.operator = operator;
        this.requiredRedundancy = redundancyLevel;
        this.buckets = new BucketRollup[numBuckets];
        this.addressComparor = addressComparor;
        this.criticalMembers = criticalMembers;
        this.partitionedRegion = region;
    }

    public void addRegion(String region, Collection<? extends InternalPartitionDetails> memberDetailSet, OfflineMemberDetails offlineDetails, boolean enforceLocalMaxMemory) {
        InternalDistributedMember memberId;
        this.allColocatedRegions.add(region);
        HashMap<InternalDistributedMember, Member> regionMember = new HashMap<InternalDistributedMember, Member>();
        Bucket[] regionBuckets = new Bucket[this.buckets.length];
        for (InternalPartitionDetails internalPartitionDetails : memberDetailSet) {
            memberId = (InternalDistributedMember)internalPartitionDetails.getDistributedMember();
            boolean isCritical = this.criticalMembers.contains(memberId);
            Member member = new Member(memberId, internalPartitionDetails.getPRLoad().getWeight(), internalPartitionDetails.getConfiguredMaxMemory(), isCritical, enforceLocalMaxMemory);
            regionMember.put(memberId, member);
            PRLoad load = internalPartitionDetails.getPRLoad();
            for (int i = 0; i < regionBuckets.length; ++i) {
                if (!(load.getReadLoad(i) > 0.0f)) continue;
                Bucket bucket = regionBuckets[i];
                if (bucket == null) {
                    Set<PersistentMemberID> offlineMembers = offlineDetails.getOfflineMembers(i);
                    regionBuckets[i] = bucket = new Bucket(i, load.getReadLoad(i), internalPartitionDetails.getBucketSize(i), offlineMembers);
                }
                bucket.addMember(member);
                if (!(load.getWriteLoad(i) > 0.0f)) continue;
                if (bucket.getPrimary() == null) {
                    bucket.setPrimary(member, load.getWriteLoad(i));
                    continue;
                }
                if (bucket.getPrimary().equals(member)) continue;
                bucket.setPrimary(this.INVALID_MEMBER, 1.0f);
            }
        }
        for (Member member : regionMember.values()) {
            memberId = member.getDistributedMember();
            MemberRollup memberSum = this.members.get(memberId);
            boolean isCritical = this.criticalMembers.contains(memberId);
            if (memberSum == null) {
                memberSum = new MemberRollup(memberId, isCritical, enforceLocalMaxMemory);
                this.members.put(memberId, memberSum);
            }
            memberSum.addColocatedMember(region, member);
        }
        for (int i = 0; i < this.buckets.length; ++i) {
            if (regionBuckets[i] == null) {
                this.buckets[i] = null;
                continue;
            }
            if (this.buckets[i] == null) {
                this.buckets[i] = new BucketRollup(i);
            }
            for (Member member : regionBuckets[i].getMembersHosting()) {
                InternalDistributedMember memberId2 = member.getDistributedMember();
                this.buckets[i].addMember(this.members.get(memberId2));
            }
            if (regionBuckets[i].getPrimary() != null) {
                if (this.buckets[i].getPrimary() == null) {
                    InternalDistributedMember internalDistributedMember = regionBuckets[i].getPrimary().getDistributedMember();
                    this.buckets[i].setPrimary(this.members.get(internalDistributedMember), 0.0f);
                } else if (this.buckets[i].getPrimary() != this.INVALID_MEMBER && !this.buckets[i].getPrimary().getDistributedMember().equals(regionBuckets[i].getPrimary().getDistributedMember())) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("PartitionedRegionLoadModel - Setting bucket {} to INVALID because it is the primary on two members.This could just be a race in the collocation of data. member1={} member2={}", (Object)this.buckets[i], (Object)this.buckets[i].getPrimary(), (Object)regionBuckets[i].getPrimary());
                    }
                    this.buckets[i].setPrimary(this.INVALID_MEMBER, 0.0f);
                }
            }
            this.buckets[i].addColocatedBucket(region, regionBuckets[i]);
        }
        Iterator<Map.Entry<InternalDistributedMember, MemberRollup>> itr = this.members.entrySet().iterator();
        while (itr.hasNext()) {
            MemberRollup memberRollup = itr.next().getValue();
            if (memberRollup.getColocatedMembers().keySet().equals(this.allColocatedRegions)) continue;
            itr.remove();
            if (logger.isDebugEnabled()) {
                logger.debug("PartitionedRegionLoadModel - removing member {} from the consideration because it doesn't have all of the colocated regions. Expected={}, was={}", (Object)memberRollup, (Object)this.allColocatedRegions, (Object)memberRollup.getColocatedMembers());
            }
            if (!memberRollup.getBuckets().isEmpty()) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.PartitionedRegionLoadModel_INCOMPLETE_COLOCATION, new Object[]{memberRollup, this.allColocatedRegions, memberRollup.getColocatedMembers().keySet(), memberRollup.getBuckets()}));
            }
            for (Bucket bucket : new HashSet<Bucket>(memberRollup.getBuckets())) {
                bucket.removeMember(memberRollup);
            }
        }
    }

    public void initialize() {
        this.resetAverages();
        this.initOverRedundancyBuckets();
        this.initLowRedundancyBuckets();
    }

    public SortedSet<BucketRollup> getLowRedundancyBuckets() {
        return this.lowRedundancyBuckets;
    }

    public SortedSet<BucketRollup> getOverRedundancyBuckets() {
        return this.overRedundancyBuckets;
    }

    public void setOverRedundancyBuckets(SortedSet<BucketRollup> overRedundancyBuckets) {
        this.overRedundancyBuckets = overRedundancyBuckets;
    }

    public boolean enforceUniqueZones() {
        return this.addressComparor.enforceUniqueZones();
    }

    public void ignoreLowRedundancyBucket(BucketRollup first) {
        this.lowRedundancyBuckets.remove(first);
    }

    public void ignoreOverRedundancyBucket(BucketRollup first) {
        this.overRedundancyBuckets.remove(first);
    }

    public MemberRollup getMember(InternalDistributedMember target) {
        return this.members.get(target);
    }

    public BucketRollup[] getBuckets() {
        return this.buckets;
    }

    public String getName() {
        return this.getPartitionedRegion().getFullPath();
    }

    public PartitionedRegion getPartitionedRegion() {
        return this.partitionedRegion;
    }

    private Map<String, Long> getColocatedRegionSizes(BucketRollup bucket) {
        HashMap<String, Long> colocatedRegionSizes = new HashMap<String, Long>();
        for (Map.Entry<String, Bucket> entry : bucket.getColocatedBuckets().entrySet()) {
            colocatedRegionSizes.put(entry.getKey(), entry.getValue().getBytes());
        }
        return colocatedRegionSizes;
    }

    public void createRedundantBucket(final BucketRollup bucket, final Member targetMember) {
        Map<String, Long> colocatedRegionSizes = this.getColocatedRegionSizes(bucket);
        final Move move = new Move(null, targetMember, bucket);
        this.lowRedundancyBuckets.remove(bucket);
        bucket.addMember(targetMember);
        if (bucket.getRedundancy() < this.requiredRedundancy) {
            this.lowRedundancyBuckets.add(bucket);
        }
        this.resetAverages();
        this.operator.createRedundantBucket(targetMember.getMemberId(), bucket.getId(), colocatedRegionSizes, new BucketOperator.Completion(){

            @Override
            public void onSuccess() {
            }

            @Override
            public void onFailure() {
                PartitionedRegionLoadModel.this.attemptedBucketCreations.add(move);
                PartitionedRegionLoadModel.this.lowRedundancyBuckets.remove(bucket);
                bucket.removeMember(targetMember);
                if (bucket.getRedundancy() < PartitionedRegionLoadModel.this.requiredRedundancy) {
                    PartitionedRegionLoadModel.this.lowRedundancyBuckets.add(bucket);
                }
                PartitionedRegionLoadModel.this.resetAverages();
            }
        });
    }

    protected void remoteOverRedundancyBucket(BucketRollup bucket, Member targetMember) {
        Move bestMove = new Move(null, targetMember, bucket);
        Map<String, Long> colocatedRegionSizes = this.getColocatedRegionSizes(bucket);
        if (!this.operator.removeBucket(targetMember.getMemberId(), bucket.getId(), colocatedRegionSizes)) {
            this.attemptedBucketRemoves.add(bestMove);
        } else {
            this.overRedundancyBuckets.remove(bucket);
            bucket.removeMember(targetMember);
            if (bucket.getOnlineRedundancy() > this.requiredRedundancy) {
                this.overRedundancyBuckets.add(bucket);
            }
            this.resetAverages();
        }
    }

    private void initLowRedundancyBuckets() {
        this.lowRedundancyBuckets = new TreeSet<Bucket>(REDUNDANCY_COMPARATOR);
        for (BucketRollup b : this.buckets) {
            if (b == null || b.getRedundancy() < 0 || b.getRedundancy() >= this.requiredRedundancy) continue;
            this.lowRedundancyBuckets.add(b);
        }
    }

    private void initOverRedundancyBuckets() {
        this.overRedundancyBuckets = new TreeSet<Bucket>(REDUNDANCY_COMPARATOR);
        for (BucketRollup b : this.buckets) {
            if (b == null || b.getOnlineRedundancy() <= this.requiredRedundancy) continue;
            this.overRedundancyBuckets.add(b);
        }
    }

    public Move findBestTarget(Bucket bucket, boolean checkIPAddress) {
        float leastCost = Float.MAX_VALUE;
        Move bestMove = null;
        for (Member member : this.members.values()) {
            Move move;
            float cost;
            if (!member.willAcceptBucket(bucket, null, checkIPAddress).willAccept() || !((cost = (member.getTotalLoad() + bucket.getLoad()) / member.getWeight()) < leastCost) || this.attemptedBucketCreations.contains(move = new Move(null, member, bucket))) continue;
            leastCost = cost;
            bestMove = move;
        }
        return bestMove;
    }

    public Move findBestRemove(Bucket bucket) {
        float mostLoaded = Float.MIN_VALUE;
        Move bestMove = null;
        for (Member member : bucket.getMembersHosting()) {
            Move move;
            float newLoad = (member.getTotalLoad() - bucket.getLoad()) / member.getWeight();
            if (!(newLoad > mostLoaded) || member.equals(bucket.getPrimary()) || this.attemptedBucketRemoves.contains(move = new Move(null, member, bucket))) continue;
            mostLoaded = newLoad;
            bestMove = move;
        }
        return bestMove;
    }

    public Move findBestTargetForFPR(Bucket bucket, boolean checkIPAddress) {
        Move noMove = null;
        InternalDistributedMember targetMemberID = null;
        Member targetMember = null;
        List<FixedPartitionAttributesImpl> fpas = this.partitionedRegion.getFixedPartitionAttributesImpl();
        if (fpas != null) {
            for (FixedPartitionAttributesImpl fpaImpl : fpas) {
                if (!fpaImpl.hasBucket(bucket.getId()) || !this.members.containsKey(targetMemberID = this.partitionedRegion.getDistributionManager().getDistributionManagerId()) || !(targetMember = (Member)this.members.get(targetMemberID)).willAcceptBucket(bucket, null, checkIPAddress).willAccept()) continue;
                return new Move(null, targetMember, bucket);
            }
        }
        return noMove;
    }

    protected boolean movePrimary(Move bestMove) {
        Member bestSource = bestMove.getSource();
        Member bestTarget = bestMove.getTarget();
        Bucket bestBucket = bestMove.getBucket();
        boolean successfulMove = this.operator.movePrimary(bestSource.getDistributedMember(), bestTarget.getDistributedMember(), bestBucket.getId());
        if (successfulMove) {
            bestBucket.setPrimary(bestTarget, bestBucket.getPrimaryLoad());
        }
        boolean entryAdded = this.attemptedPrimaryMoves.add(bestMove);
        Assert.assertTrue(entryAdded, "PartitionedRegionLoadModel.movePrimarys - excluded set is not growing, so we probably would have an infinite loop here");
        return successfulMove;
    }

    public Move findBestPrimaryMove() {
        Move bestMove = null;
        double bestImprovement = 0.0;
        for (Member member : this.members.values()) {
            for (Bucket bucket : member.getPrimaryBuckets()) {
                for (Member target : bucket.getMembersHosting()) {
                    Move move;
                    double improvement;
                    if (member.equals(target) || !((improvement = this.improvement(member.getPrimaryLoad(), member.getWeight(), target.getPrimaryLoad(), target.getWeight(), bucket.getPrimaryLoad(), this.getPrimaryAverage())) > bestImprovement) || !(improvement > this.getMinPrimaryImprovement()) || this.attemptedPrimaryMoves.contains(move = new Move(member, target, bucket))) continue;
                    bestImprovement = improvement;
                    bestMove = move;
                }
            }
        }
        return bestMove;
    }

    private void makeFPRPrimaryForThisNode() {
        List<FixedPartitionAttributesImpl> FPAs = this.partitionedRegion.getFixedPartitionAttributesImpl();
        InternalDistributedMember targetId = this.partitionedRegion.getDistributionManager().getId();
        Member target = this.members.get(targetId);
        HashSet<BucketRollup> unsuccessfulAttempts = new HashSet<BucketRollup>();
        for (BucketRollup bucket : this.buckets) {
            if (bucket == null) continue;
            for (FixedPartitionAttributesImpl fpa : FPAs) {
                InternalDistributedMember srcDM;
                if (!fpa.hasBucket(((Bucket)bucket).id) || !fpa.isPrimary()) continue;
                Member source = ((Bucket)bucket).primary;
                bucket.getPrimary();
                if (source == target) continue;
                InternalDistributedMember internalDistributedMember = srcDM = source == null || source == this.INVALID_MEMBER ? target.getDistributedMember() : source.getDistributedMember();
                if (logger.isDebugEnabled()) {
                    logger.debug("PRLM#movePrimariesForFPR: For Bucket#{}, moving primary from source {} to target {}", (Object)bucket.getId(), (Object)((Bucket)bucket).primary, (Object)target);
                }
                boolean successfulMove = this.operator.movePrimary(srcDM, target.getDistributedMember(), bucket.getId());
                unsuccessfulAttempts.add(bucket);
                Assert.assertTrue(successfulMove, " Fixed partitioned region not able to move the primary!");
                if (!successfulMove) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("PRLM#movePrimariesForFPR: For Bucket#{}, moving primary source {} to target {}", (Object)bucket.getId(), (Object)source, (Object)target);
                }
                ((Bucket)bucket).setPrimary(target, bucket.getPrimaryLoad());
            }
        }
    }

    private float getPrimaryAverage() {
        if (this.primaryAverage == -1.0f) {
            float totalWeight = 0.0f;
            float totalPrimaryCount = 0.0f;
            for (Member member : this.members.values()) {
                totalPrimaryCount += member.getPrimaryLoad();
                totalWeight += member.getWeight();
            }
            this.primaryAverage = totalPrimaryCount / totalWeight;
        }
        return this.primaryAverage;
    }

    private float getAverageLoad() {
        if (this.averageLoad == -1.0f) {
            float totalWeight = 0.0f;
            float totalLoad = 0.0f;
            for (Member member : this.members.values()) {
                totalLoad += member.getTotalLoad();
                totalWeight += member.getWeight();
            }
            this.averageLoad = totalLoad / totalWeight;
        }
        return this.averageLoad;
    }

    private double getMinPrimaryImprovement() {
        if (this.minPrimaryImprovement + 1.0 < 1.0E-7) {
            float largestWeight = 0.0f;
            float smallestBucket = 0.0f;
            for (Member member : this.members.values()) {
                if (member.getWeight() > largestWeight) {
                    largestWeight = member.getWeight();
                }
                for (Bucket bucket : member.getPrimaryBuckets()) {
                    if (!(bucket.getPrimaryLoad() < smallestBucket) && smallestBucket != 0.0f) continue;
                    smallestBucket = bucket.getPrimaryLoad();
                }
            }
            double before = this.variance(this.getPrimaryAverage() * largestWeight + smallestBucket, largestWeight, this.getPrimaryAverage());
            double after = this.variance(this.getPrimaryAverage() * largestWeight, largestWeight, this.getPrimaryAverage());
            this.minPrimaryImprovement = (before - after) / (double)smallestBucket;
        }
        return this.minPrimaryImprovement;
    }

    private double getMinImprovement() {
        if (this.minImprovement + 1.0 < 1.0E-7) {
            float largestWeight = 0.0f;
            float smallestBucket = 0.0f;
            for (Member member : this.members.values()) {
                if (member.getWeight() > largestWeight) {
                    largestWeight = member.getWeight();
                }
                for (Bucket bucket : member.getBuckets()) {
                    if (smallestBucket != 0.0f && (!(bucket.getLoad() < smallestBucket) || bucket.getBytes() <= 0L)) continue;
                    smallestBucket = bucket.getLoad();
                }
            }
            double before = this.variance(this.getAverageLoad() * largestWeight + smallestBucket, largestWeight, this.getAverageLoad());
            double after = this.variance(this.getAverageLoad() * largestWeight, largestWeight, this.getAverageLoad());
            this.minImprovement = (before - after) / (double)smallestBucket;
        }
        return this.minImprovement;
    }

    private void resetAverages() {
        this.primaryAverage = -1.0f;
        this.averageLoad = -1.0f;
        this.minPrimaryImprovement = -1.0;
        this.minImprovement = -1.0;
    }

    private double improvement(float sLoad, float sWeight, float tLoad, float tWeight, float bucketSize, float average) {
        double vSourceBefore = this.variance(sLoad, sWeight, average);
        double vSourceAfter = this.variance(sLoad - bucketSize, sWeight, average);
        double vTargetBefore = this.variance(tLoad, tWeight, average);
        double vTargetAfter = this.variance(tLoad + bucketSize, tWeight, average);
        double improvement = vSourceBefore - vSourceAfter + vTargetBefore - vTargetAfter;
        return improvement / (double)bucketSize;
    }

    private double variance(double load, double weight, double average) {
        double deviation = load / weight - average;
        return deviation * deviation;
    }

    public Move findBestBucketMove() {
        Move bestMove = null;
        double bestImprovement = 0.0;
        for (Member member : this.members.values()) {
            for (Bucket bucket : member.getBuckets()) {
                for (Member member2 : this.members.values()) {
                    Move move;
                    double improvement;
                    if (bucket.getMembersHosting().contains(member2) || !member2.willAcceptBucket(bucket, member, true).willAccept() || !((improvement = this.improvement(member.getTotalLoad(), member.getWeight(), member2.getTotalLoad(), member2.getWeight(), bucket.getLoad(), this.getAverageLoad())) > bestImprovement) || !(improvement > this.getMinImprovement()) || this.attemptedBucketMoves.contains(move = new Move(member, member2, bucket))) continue;
                    bestImprovement = improvement;
                    bestMove = move;
                }
            }
        }
        return bestMove;
    }

    protected boolean moveBucket(Move bestMove) {
        Member bestSource = bestMove.getSource();
        Member bestTarget = bestMove.getTarget();
        BucketRollup bestBucket = (BucketRollup)bestMove.getBucket();
        Map<String, Long> colocatedRegionSizes = this.getColocatedRegionSizes(bestBucket);
        boolean successfulMove = this.operator.moveBucket(bestSource.getDistributedMember(), bestTarget.getDistributedMember(), bestBucket.getId(), colocatedRegionSizes);
        if (successfulMove) {
            bestBucket.addMember(bestTarget);
            if (bestSource.equals(bestBucket.getPrimary())) {
                bestBucket.setPrimary(bestTarget, bestBucket.getPrimaryLoad());
            }
            bestBucket.removeMember(bestSource);
        }
        boolean entryAdded = this.attemptedBucketMoves.add(bestMove);
        Assert.assertTrue(entryAdded, "PartitionedRegionLoadModel.moveBuckets - excluded set is not growing, so we probably would have an infinite loop here");
        return successfulMove;
    }

    public Set<PartitionMemberInfo> getPartitionedMemberDetails(String region) {
        TreeSet<PartitionMemberInfo> result = new TreeSet<PartitionMemberInfo>();
        for (MemberRollup member : this.members.values()) {
            Member colocatedMember = member.getColocatedMember(region);
            if (colocatedMember == null) continue;
            result.add(new PartitionMemberInfoImpl(colocatedMember.getDistributedMember(), colocatedMember.getConfiguredMaxMemory(), colocatedMember.getSize(), colocatedMember.getBucketCount(), colocatedMember.getPrimaryCount()));
        }
        return result;
    }

    public float getVarianceForTest() {
        float variance = 0.0f;
        for (Member member : this.members.values()) {
            variance = (float)((double)variance + this.variance(member.getTotalLoad(), member.getWeight(), this.getAverageLoad()));
        }
        return variance;
    }

    public float getPrimaryVarianceForTest() {
        float variance = 0.0f;
        for (Member member : this.members.values()) {
            variance = (float)((double)variance + this.variance(member.getPrimaryLoad(), member.getWeight(), this.getPrimaryAverage()));
        }
        return variance;
    }

    public void waitForOperations() {
        this.operator.waitForOperations();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        TreeSet<Bucket> allBucketIds = new TreeSet<Bucket>(new Comparator<Bucket>(){

            @Override
            public int compare(Bucket o1, Bucket o2) {
                return o1.getId() - o2.getId();
            }
        });
        if (this.members.isEmpty()) {
            return "";
        }
        int longestMemberId = 0;
        for (Member member : this.members.values()) {
            allBucketIds.addAll(member.getBuckets());
            int memberIdLength = member.getDistributedMember().toString().length();
            if (longestMemberId >= memberIdLength) continue;
            longestMemberId = memberIdLength;
        }
        result.append(String.format("%" + longestMemberId + "s primaries size(MB)  max(MB)", "MemberId"));
        for (Bucket bucket : allBucketIds) {
            result.append(String.format("%4s", bucket.getId()));
        }
        for (Member member : this.members.values()) {
            result.append(String.format("\n%" + longestMemberId + "s %9.0f %8.2f %8.2f", member.getDistributedMember(), Float.valueOf(member.getPrimaryLoad()), Float.valueOf((float)member.getSize() / 1048576.0f), Float.valueOf((float)member.getConfiguredMaxMemory() / 1048576.0f)));
            for (Bucket bucket : allBucketIds) {
                char symbol = member.getPrimaryBuckets().contains(bucket) ? (char)'P' : (member.getBuckets().contains(bucket) ? (char)'R' : 'X');
                result.append("   ").append(symbol);
            }
        }
        result.append(String.format("\n%" + longestMemberId + "s                            ", "#offline", 0, 0, 0));
        for (Bucket bucket : allBucketIds) {
            result.append(String.format("%4s", bucket.getOfflineMembers().size()));
        }
        return result.toString();
    }

    public static enum RefusalReason {
        NONE,
        ALREADY_HOSTING,
        UNITIALIZED_MEMBER,
        SAME_ZONE,
        LOCAL_MAX_MEMORY_FULL,
        CRITICAL_HEAP;


        public boolean willAccept() {
            return this == NONE;
        }

        public String formatMessage(Member source, Member target, Bucket bucket) {
            switch (this) {
                case NONE: {
                    return "No reason, the move should be allowed.";
                }
                case ALREADY_HOSTING: {
                    return "Target member " + target.getMemberId() + " is already hosting bucket " + bucket.getId();
                }
                case UNITIALIZED_MEMBER: {
                    return "Target member " + target.getMemberId() + " is not fully initialized";
                }
                case SAME_ZONE: {
                    return "Target member " + target.getMemberId() + " is in the same redundancy zone as other members hosting bucket " + bucket.getId() + ": " + bucket.getMembersHosting();
                }
                case LOCAL_MAX_MEMORY_FULL: {
                    return "Target member " + target.getMemberId() + " does not have space within it's local max memory for bucket " + bucket.getId() + ". Bucket Size " + bucket.getBytes() + " local max memory: " + target.localMaxMemory + " remaining: " + target.totalBytes;
                }
                case CRITICAL_HEAP: {
                    return "Target member " + target.getMemberId() + " has reached its critical heap percentage, and cannot accept more data";
                }
            }
            return this.toString();
        }
    }

    public static interface AddressComparor {
        public boolean enforceUniqueZones();

        public boolean areSameZone(InternalDistributedMember var1, InternalDistributedMember var2);
    }

    protected static class Move {
        private final Member source;
        private final Member target;
        private final Bucket bucket;

        public Move(Member source, Member target, Bucket bucket) {
            this.source = source;
            this.target = target;
            this.bucket = bucket;
        }

        public Member getSource() {
            return this.source;
        }

        public Member getTarget() {
            return this.target;
        }

        public Bucket getBucket() {
            return this.bucket;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bucket == null ? 0 : this.bucket.hashCode());
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Move other = (Move)obj;
            if (this.bucket == null ? other.bucket != null : !this.bucket.equals(other.bucket)) {
                return false;
            }
            if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
                return false;
            }
            return !(this.target == null ? other.target != null : !this.target.equals(other.target));
        }
    }

    protected class Bucket
    implements Comparable<Bucket> {
        protected long bytes;
        private final int id;
        protected float load;
        protected float primaryLoad;
        private int redundancy = -1;
        private final Set<Member> membersHosting = new TreeSet<Member>();
        private Member primary;
        protected Set<PersistentMemberID> offlineMembers = new HashSet<PersistentMemberID>();

        public Bucket(int id) {
            this.id = id;
        }

        public Bucket(int id, float load, long bytes, Set<PersistentMemberID> offlineMembers) {
            this(id);
            this.load = load;
            this.bytes = bytes;
            this.offlineMembers = offlineMembers;
        }

        public void setPrimary(Member member, float primaryLoad) {
            if (this.primary == PartitionedRegionLoadModel.this.INVALID_MEMBER) {
                return;
            }
            if (this.primary != null) {
                this.primary.removePrimary(this);
            }
            this.primary = member;
            this.primaryLoad = primaryLoad;
            if (this.primary != PartitionedRegionLoadModel.this.INVALID_MEMBER && this.primary != null) {
                this.addMember(this.primary);
                member.addPrimary(this);
            }
        }

        public boolean addMember(Member targetMember) {
            if (this.getMembersHosting().add(targetMember)) {
                ++this.redundancy;
                targetMember.addBucket(this);
                return true;
            }
            return false;
        }

        public boolean removeMember(Member targetMember) {
            if (this.getMembersHosting().remove(targetMember)) {
                if (targetMember == this.primary) {
                    this.setPrimary(null, 0.0f);
                }
                --this.redundancy;
                targetMember.removeBucket(this);
                return true;
            }
            return false;
        }

        public int getRedundancy() {
            return this.redundancy + this.offlineMembers.size();
        }

        public int getOnlineRedundancy() {
            return this.redundancy;
        }

        public float getLoad() {
            return this.load;
        }

        public int getId() {
            return this.id;
        }

        public long getBytes() {
            return this.bytes;
        }

        public String toString() {
            return "Bucket(id=" + this.getId() + ",load=" + this.load + ")";
        }

        public float getPrimaryLoad() {
            return this.primaryLoad;
        }

        public Set<Member> getMembersHosting() {
            return this.membersHosting;
        }

        public Member getPrimary() {
            return this.primary;
        }

        public Collection<? extends PersistentMemberID> getOfflineMembers() {
            return this.offlineMembers;
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Bucket)) {
                return false;
            }
            Bucket o = (Bucket)other;
            return this.id == o.id;
        }

        @Override
        public int compareTo(Bucket other) {
            if (this.id < other.id) {
                return -1;
            }
            if (this.id > other.id) {
                return 1;
            }
            return 0;
        }
    }

    protected class Member
    implements Comparable<Member> {
        private final InternalDistributedMember memberId;
        protected float weight;
        protected float totalLoad;
        protected float totalPrimaryLoad;
        protected long totalBytes;
        protected long localMaxMemory;
        private final Set<Bucket> buckets = new TreeSet<Bucket>();
        private final Set<Bucket> primaryBuckets = new TreeSet<Bucket>();
        private final boolean isCritical;
        private final boolean enforceLocalMaxMemory;

        public Member(InternalDistributedMember memberId, boolean isCritical, boolean enforceLocalMaxMemory) {
            this.memberId = memberId;
            this.isCritical = isCritical;
            this.enforceLocalMaxMemory = enforceLocalMaxMemory;
        }

        public Member(InternalDistributedMember memberId, float weight, long localMaxMemory, boolean isCritical, boolean enforceLocalMaxMemory) {
            this(memberId, isCritical, enforceLocalMaxMemory);
            this.weight = weight;
            this.localMaxMemory = localMaxMemory;
        }

        public RefusalReason willAcceptBucket(Bucket bucket, Member sourceMember, boolean checkZone) {
            if (this.getBuckets().contains(bucket)) {
                return RefusalReason.ALREADY_HOSTING;
            }
            if (checkZone) {
                boolean sourceIsEquivalent;
                boolean bl = sourceIsEquivalent = sourceMember != null && PartitionedRegionLoadModel.this.addressComparor.areSameZone(this.getMemberId(), sourceMember.getDistributedMember());
                if (sourceMember == null || !sourceIsEquivalent) {
                    for (Member hostingMember : bucket.getMembersHosting()) {
                        if (hostingMember.equals(sourceMember) && !PartitionedRegionLoadModel.this.addressComparor.enforceUniqueZones() || !PartitionedRegionLoadModel.this.addressComparor.areSameZone(this.getMemberId(), hostingMember.getDistributedMember())) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Member {} would prefer not to host {} because it is already on another member with the same redundancy zone", (Object)this, (Object)bucket);
                        }
                        return RefusalReason.SAME_ZONE;
                    }
                }
            }
            if (this.enforceLocalMaxMemory && this.totalBytes + bucket.getBytes() > this.localMaxMemory) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Member {} won't host bucket {} because it doesn't have enough space", (Object)this, (Object)bucket);
                }
                return RefusalReason.LOCAL_MAX_MEMORY_FULL;
            }
            if (this.isCritical) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Member {} won't host bucket {} because it's heap is critical", (Object)this, (Object)bucket);
                }
                return RefusalReason.CRITICAL_HEAP;
            }
            return RefusalReason.NONE;
        }

        public boolean addBucket(Bucket bucket) {
            if (this.getBuckets().add(bucket)) {
                bucket.addMember(this);
                this.totalBytes += bucket.getBytes();
                this.totalLoad += bucket.getLoad();
                return true;
            }
            return false;
        }

        public boolean removeBucket(Bucket bucket) {
            if (this.getBuckets().remove(bucket)) {
                bucket.removeMember(this);
                this.totalBytes -= bucket.getBytes();
                this.totalLoad -= bucket.getLoad();
                return true;
            }
            return false;
        }

        public boolean removePrimary(Bucket bucket) {
            if (this.getPrimaryBuckets().remove(bucket)) {
                this.totalPrimaryLoad -= bucket.getPrimaryLoad();
                return true;
            }
            return false;
        }

        public boolean addPrimary(Bucket bucket) {
            if (this.getPrimaryBuckets().add(bucket)) {
                this.totalPrimaryLoad += bucket.getPrimaryLoad();
                return true;
            }
            return false;
        }

        public int getBucketCount() {
            return this.getBuckets().size();
        }

        public long getConfiguredMaxMemory() {
            return this.localMaxMemory;
        }

        public InternalDistributedMember getDistributedMember() {
            return this.getMemberId();
        }

        public int getPrimaryCount() {
            int primaryCount = 0;
            for (Bucket bucket : this.getBuckets()) {
                if (!this.equals(bucket.primary)) continue;
                ++primaryCount;
            }
            return primaryCount;
        }

        public long getSize() {
            return this.totalBytes;
        }

        public float getTotalLoad() {
            return this.totalLoad;
        }

        public float getWeight() {
            return this.weight;
        }

        public String toString() {
            return "Member(id=" + this.getMemberId() + ")";
        }

        public float getPrimaryLoad() {
            return this.totalPrimaryLoad;
        }

        protected Set<Bucket> getBuckets() {
            return this.buckets;
        }

        private InternalDistributedMember getMemberId() {
            return this.memberId;
        }

        private Set<Bucket> getPrimaryBuckets() {
            return this.primaryBuckets;
        }

        public int hashCode() {
            return this.memberId.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof Member)) {
                return false;
            }
            Member o = (Member)other;
            return this.memberId.equals(o.memberId);
        }

        @Override
        public int compareTo(Member other) {
            return this.memberId.compareTo(other.memberId);
        }
    }

    protected class BucketRollup
    extends Bucket {
        private final Map<String, Bucket> colocatedBuckets;

        public BucketRollup(int id) {
            super(id);
            this.colocatedBuckets = new HashMap<String, Bucket>();
        }

        public boolean addColocatedBucket(String region, Bucket b) {
            if (!this.getColocatedBuckets().containsKey(region)) {
                this.getColocatedBuckets().put(region, b);
                this.load += b.getLoad();
                this.primaryLoad += b.getPrimaryLoad();
                this.bytes += b.getBytes();
                this.offlineMembers.addAll(b.getOfflineMembers());
                for (Member member : this.getMembersHosting()) {
                    MemberRollup rollup = (MemberRollup)member;
                    float primaryLoad = 0.0f;
                    if (this.getPrimary() == member) {
                        primaryLoad = b.getPrimaryLoad();
                    }
                    rollup.updateLoad(b.getLoad(), primaryLoad, b.getBytes());
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean addMember(Member targetMember) {
            if (super.addMember(targetMember)) {
                MemberRollup memberRollup = (MemberRollup)targetMember;
                for (Map.Entry<String, Bucket> entry : this.getColocatedBuckets().entrySet()) {
                    String region = entry.getKey();
                    Bucket bucket = entry.getValue();
                    Member member = memberRollup.getColocatedMembers().get(region);
                    if (member == null) continue;
                    bucket.addMember(member);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean removeMember(Member targetMember) {
            if (super.removeMember(targetMember)) {
                MemberRollup memberRollup = (MemberRollup)targetMember;
                for (Map.Entry<String, Bucket> entry : this.getColocatedBuckets().entrySet()) {
                    String region = entry.getKey();
                    Bucket bucket = entry.getValue();
                    Member member = memberRollup.getColocatedMembers().get(region);
                    if (member == null) continue;
                    bucket.removeMember(member);
                }
                return true;
            }
            return false;
        }

        @Override
        public void setPrimary(Member targetMember, float primaryLoad) {
            super.setPrimary(targetMember, primaryLoad);
            if (targetMember != null) {
                MemberRollup memberRollup = (MemberRollup)targetMember;
                for (Map.Entry<String, Bucket> entry : this.getColocatedBuckets().entrySet()) {
                    String region = entry.getKey();
                    Bucket bucket = entry.getValue();
                    Member member = memberRollup.getColocatedMembers().get(region);
                    if (member == null) continue;
                    bucket.setPrimary(member, primaryLoad);
                }
            }
        }

        Map<String, Bucket> getColocatedBuckets() {
            return this.colocatedBuckets;
        }
    }

    private class MemberRollup
    extends Member {
        private final Map<String, Member> colocatedMembers;
        private final boolean invalid = false;

        public MemberRollup(InternalDistributedMember memberId, boolean isCritical, boolean enforceLocalMaxMemory) {
            super(memberId, isCritical, enforceLocalMaxMemory);
            this.colocatedMembers = new HashMap<String, Member>();
            this.invalid = false;
        }

        public boolean isInvalid() {
            return false;
        }

        public boolean addColocatedMember(String region, Member member) {
            if (!this.getColocatedMembers().containsKey(region)) {
                this.getColocatedMembers().put(region, member);
                this.weight += member.weight;
                this.localMaxMemory += member.localMaxMemory;
                return true;
            }
            return false;
        }

        public Member getColocatedMember(String region) {
            return this.getColocatedMembers().get(region);
        }

        public void updateLoad(float load, float primaryLoad, float bytes) {
            this.totalLoad += load;
            this.totalPrimaryLoad += primaryLoad;
            this.totalBytes = (long)((float)this.totalBytes + bytes);
        }

        @Override
        public boolean addBucket(Bucket bucket) {
            if (super.addBucket(bucket)) {
                BucketRollup bucketRollup = (BucketRollup)bucket;
                for (Map.Entry<String, Member> entry : this.getColocatedMembers().entrySet()) {
                    String region = entry.getKey();
                    Member member = entry.getValue();
                    Bucket colocatedBucket = bucketRollup.getColocatedBuckets().get(region);
                    if (colocatedBucket == null) continue;
                    member.addBucket(colocatedBucket);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean removeBucket(Bucket bucket) {
            if (super.removeBucket(bucket)) {
                BucketRollup bucketRollup = (BucketRollup)bucket;
                for (Map.Entry<String, Member> entry : this.getColocatedMembers().entrySet()) {
                    String region = entry.getKey();
                    Member member = entry.getValue();
                    Bucket colocatedBucket = bucketRollup.getColocatedBuckets().get(region);
                    if (colocatedBucket == null) continue;
                    member.removeBucket(colocatedBucket);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean addPrimary(Bucket bucket) {
            if (super.addPrimary(bucket)) {
                BucketRollup bucketRollup = (BucketRollup)bucket;
                for (Map.Entry<String, Member> entry : this.getColocatedMembers().entrySet()) {
                    String region = entry.getKey();
                    Member member = entry.getValue();
                    Bucket colocatedBucket = bucketRollup.getColocatedBuckets().get(region);
                    if (colocatedBucket == null) continue;
                    member.addPrimary(colocatedBucket);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean removePrimary(Bucket bucket) {
            if (super.removePrimary(bucket)) {
                BucketRollup bucketRollup = (BucketRollup)bucket;
                for (Map.Entry<String, Member> entry : this.getColocatedMembers().entrySet()) {
                    String region = entry.getKey();
                    Member member = entry.getValue();
                    Bucket colocatedBucket = bucketRollup.getColocatedBuckets().get(region);
                    if (colocatedBucket == null) continue;
                    member.removePrimary(colocatedBucket);
                }
                return true;
            }
            return false;
        }

        @Override
        public RefusalReason willAcceptBucket(Bucket bucket, Member source, boolean checkIPAddress) {
            RefusalReason reason = super.willAcceptBucket(bucket, source, checkIPAddress);
            if (reason.willAccept()) {
                BucketRollup bucketRollup = (BucketRollup)bucket;
                MemberRollup sourceRollup = (MemberRollup)source;
                for (Map.Entry<String, Member> entry : this.getColocatedMembers().entrySet()) {
                    Member colocatedSource;
                    String region = entry.getKey();
                    Member member = entry.getValue();
                    Bucket colocatedBucket = bucketRollup.getColocatedBuckets().get(region);
                    Member member2 = colocatedSource = sourceRollup == null ? null : sourceRollup.getColocatedMembers().get(region);
                    if (colocatedBucket == null || (reason = member.willAcceptBucket(colocatedBucket, colocatedSource, checkIPAddress)).willAccept()) continue;
                    return reason;
                }
                return RefusalReason.NONE;
            }
            return reason;
        }

        Map<String, Member> getColocatedMembers() {
            return this.colocatedMembers;
        }
    }
}

