/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.EntryExistsException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.ByteArrayDataInput;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.DataLocationException;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRemoveAllOperation;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.PutAllPartialResultException;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.cache.partitioned.PartitionMessageWithDirectReply;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.versions.ConcurrentCacheModificationException;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public final class RemoveAllPRMessage
extends PartitionMessageWithDirectReply {
    private static final Logger logger = LogService.getLogger();
    private DistributedRemoveAllOperation.RemoveAllEntryData[] removeAllPRData;
    private int removeAllPRDataSize = 0;
    private Integer bucketId;
    ClientProxyMembershipID bridgeContext;
    private boolean skipCallbacks;
    private Object callbackArg;
    protected static final short HAS_BRIDGE_CONTEXT = 4096;
    protected static final short SKIP_CALLBACKS = 8192;
    private transient InternalDistributedSystem internalDs;
    private transient boolean directAck = false;
    transient boolean result = false;
    transient VersionedObjectList versions = null;

    public RemoveAllPRMessage() {
    }

    public RemoveAllPRMessage(int bucketId, int size, boolean notificationOnly, boolean posDup, boolean skipCallbacks, Object callbackArg) {
        this.bucketId = bucketId;
        this.removeAllPRData = new DistributedRemoveAllOperation.RemoveAllEntryData[size];
        this.notificationOnly = notificationOnly;
        this.posDup = posDup;
        this.skipCallbacks = skipCallbacks;
        this.callbackArg = callbackArg;
        this.initTxMemberId();
    }

    public void addEntry(DistributedRemoveAllOperation.RemoveAllEntryData entry) {
        this.removeAllPRData[this.removeAllPRDataSize++] = entry;
    }

    public void initMessage(PartitionedRegion r, Set recipients, boolean notifyOnly, DirectReplyProcessor p) {
        this.setInternalDs(r.getSystem());
        this.setDirectAck(false);
        this.resetRecipients();
        if (recipients != null) {
            this.setRecipients(recipients);
        }
        this.regionId = r.getPRId();
        this.processor = p;
        int n = this.processorId = p == null ? 0 : p.getProcessorId();
        if (p != null && this.isSevereAlertCompatible()) {
            p.enableSevereAlertProcessing();
        }
        this.notificationOnly = notifyOnly;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    public void setPossibleDuplicate(boolean posDup) {
        this.posDup = posDup;
    }

    public int getSize() {
        return this.removeAllPRDataSize;
    }

    public Set getKeys() {
        HashSet<Object> keys = new HashSet<Object>(this.getSize());
        for (int i = 0; i < this.removeAllPRData.length; ++i) {
            if (this.removeAllPRData[i] == null) continue;
            keys.add(this.removeAllPRData[i].getKey());
        }
        return keys;
    }

    public PartitionMessage.PartitionResponse send(DistributedMember recipient, PartitionedRegion r) throws ForceReattemptException {
        Set failures;
        Set<DistributedMember> recipients = Collections.singleton(recipient);
        RemoveAllResponse p = new RemoveAllResponse(r.getSystem(), recipients);
        this.initMessage(r, recipients, false, p);
        this.setTransactionDistributed(r.getCache().getTxManager().isDistributed());
        if (logger.isDebugEnabled()) {
            logger.debug("RemoveAllPRMessage.send: recipient is {}, msg is {}", (Object)recipient, (Object)this);
        }
        if ((failures = r.getDistributionManager().putOutgoing(this)) != null && failures.size() > 0) {
            throw new ForceReattemptException("Failed sending <" + this + ">");
        }
        return p;
    }

    public void setBridgeContext(ClientProxyMembershipID contx) {
        Assert.assertTrue(contx != null);
        this.bridgeContext = contx;
    }

    @Override
    public int getDSFID() {
        return -9;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bucketId = (int)InternalDataSerializer.readSignedVL(in);
        if ((this.flags & 0x1000) != 0) {
            this.bridgeContext = (ClientProxyMembershipID)DataSerializer.readObject(in);
        }
        Version sourceVersion = InternalDataSerializer.getVersionForDataStream(in);
        this.callbackArg = DataSerializer.readObject(in);
        this.removeAllPRDataSize = (int)InternalDataSerializer.readUnsignedVL(in);
        this.removeAllPRData = new DistributedRemoveAllOperation.RemoveAllEntryData[this.removeAllPRDataSize];
        if (this.removeAllPRDataSize > 0) {
            Version version = InternalDataSerializer.getVersionForDataStreamOrNull(in);
            ByteArrayDataInput bytesIn = new ByteArrayDataInput();
            for (int i = 0; i < this.removeAllPRDataSize; ++i) {
                this.removeAllPRData[i] = new DistributedRemoveAllOperation.RemoveAllEntryData(in, null, i, version, bytesIn);
            }
            boolean hasTags = in.readBoolean();
            if (hasTags) {
                DistributedPutAllOperation.EntryVersionsList versionTags = DistributedPutAllOperation.EntryVersionsList.create(in);
                for (int i = 0; i < this.removeAllPRDataSize; ++i) {
                    this.removeAllPRData[i].versionTag = (VersionTag)versionTags.get(i);
                }
            }
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        if (this.bucketId == null) {
            InternalDataSerializer.writeSignedVL(-1L, out);
        } else {
            InternalDataSerializer.writeSignedVL(this.bucketId.intValue(), out);
        }
        if (this.bridgeContext != null) {
            DataSerializer.writeObject(this.bridgeContext, out);
        }
        DataSerializer.writeObject(this.callbackArg, out);
        InternalDataSerializer.writeUnsignedVL(this.removeAllPRDataSize, out);
        if (this.removeAllPRDataSize > 0) {
            DistributedPutAllOperation.EntryVersionsList versionTags = new DistributedPutAllOperation.EntryVersionsList(this.removeAllPRDataSize);
            boolean hasTags = false;
            for (int i = 0; i < this.removeAllPRDataSize; ++i) {
                if (!hasTags && this.removeAllPRData[i].versionTag != null) {
                    hasTags = true;
                }
                VersionTag tag = this.removeAllPRData[i].versionTag;
                versionTags.add(tag);
                this.removeAllPRData[i].versionTag = null;
                this.removeAllPRData[i].toData(out);
                this.removeAllPRData[i].versionTag = tag;
            }
            out.writeBoolean(hasTags);
            if (hasTags) {
                InternalDataSerializer.invokeToData(versionTags, out);
            }
        }
    }

    @Override
    protected short computeCompressedShort(short s) {
        s = super.computeCompressedShort(s);
        if (this.bridgeContext != null) {
            s = (short)(s | 0x1000);
        }
        if (this.skipCallbacks) {
            s = (short)(s | 0x2000);
        }
        return s;
    }

    @Override
    protected void setBooleans(short s, DataInput in) throws IOException, ClassNotFoundException {
        super.setBooleans(s, in);
        this.skipCallbacks = (s & 0x2000) != 0;
    }

    @Override
    public EventID getEventID() {
        if (this.removeAllPRData.length > 0) {
            return this.removeAllPRData[0].getEventID();
        }
        return null;
    }

    @Override
    protected final boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion r, long startTime) throws EntryExistsException, ForceReattemptException, DataLocationException {
        boolean sendReply = true;
        InternalDistributedMember eventSender = this.getSender();
        try {
            this.result = this.doLocalRemoveAll(r, eventSender, true);
        }
        catch (ForceReattemptException fre) {
            this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(fre), r, startTime);
            return false;
        }
        if (sendReply) {
            this.sendReply(this.getSender(), this.getProcessorId(), dm, null, r, startTime);
        }
        return false;
    }

    public EntryEventImpl getFirstEvent(PartitionedRegion r) {
        if (this.removeAllPRDataSize == 0) {
            return null;
        }
        EntryEventImpl ev = EntryEventImpl.create((LocalRegion)r, this.removeAllPRData[0].getOp(), this.removeAllPRData[0].getKey(), null, this.callbackArg, false, (DistributedMember)this.getSender(), true, this.removeAllPRData[0].getEventID());
        return ev;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"IMSE_DONT_CATCH_IMSE"})
    public final boolean doLocalRemoveAll(PartitionedRegion r, InternalDistributedMember eventSender, boolean cacheWrite) throws EntryExistsException, ForceReattemptException, DataLocationException {
        block55: {
            boolean didRemove = false;
            long clientReadTimeOut = 10000L;
            if (r.hasServerProxy()) {
                clientReadTimeOut = r.getServerProxy().getPool().getReadTimeout();
                if (logger.isDebugEnabled()) {
                    logger.debug("RemoveAllPRMessage: doLocalRemoveAll: clientReadTimeOut is {}", (Object)clientReadTimeOut);
                }
            }
            DistributedRemoveAllOperation op = null;
            EntryEventImpl baseEvent = null;
            BucketRegion bucketRegion = null;
            PartitionedRegionDataStore ds = r.getDataStore();
            InternalDistributedMember myId = r.getDistributionManager().getDistributionManagerId();
            try {
                int i;
                if (!this.notificationOnly) {
                    bucketRegion = ds.getInitializedBucketForId(null, this.bucketId);
                    this.versions = new VersionedObjectList(this.removeAllPRDataSize, true, bucketRegion.getAttributes().getConcurrencyChecksEnabled());
                    baseEvent = EntryEventImpl.create((LocalRegion)bucketRegion, Operation.REMOVEALL_DESTROY, null, null, this.callbackArg, true, (DistributedMember)eventSender, !this.skipCallbacks, true);
                    baseEvent.setEventId(this.removeAllPRData[0].getEventID());
                    if (this.bridgeContext != null) {
                        baseEvent.setContext(this.bridgeContext);
                    }
                    baseEvent.setPossibleDuplicate(this.posDup);
                    if (logger.isDebugEnabled()) {
                        logger.debug("RemoveAllPRMessage.doLocalRemoveAll: eventSender is {}, baseEvent is {}, msg is {}", (Object)eventSender, (Object)baseEvent, (Object)this);
                    }
                    op = new DistributedRemoveAllOperation(baseEvent, this.removeAllPRDataSize, false);
                }
                Object[] keys = new Object[this.removeAllPRDataSize];
                for (i = 0; i < this.removeAllPRDataSize; ++i) {
                    keys[i] = this.removeAllPRData[i].getKey();
                }
                if (!this.notificationOnly) {
                    try {
                        if (this.removeAllPRData.length > 0) {
                            if (this.posDup && bucketRegion.getConcurrencyChecksEnabled()) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("attempting to locate version tags for retried event");
                                }
                                for (i = 0; i < this.removeAllPRDataSize; ++i) {
                                    if (this.removeAllPRData[i].versionTag != null) continue;
                                    this.removeAllPRData[i].versionTag = bucketRegion.findVersionTagForClientBulkOp(this.removeAllPRData[i].getEventID());
                                    if (this.removeAllPRData[i].versionTag == null) continue;
                                    this.removeAllPRData[i].versionTag.replaceNullIDs(bucketRegion.getVersionMember());
                                }
                            }
                            EventID eventID = this.removeAllPRData[0].getEventID();
                            ThreadIdentifier membershipID = new ThreadIdentifier(eventID.getMembershipID(), eventID.getThreadID());
                            bucketRegion.recordBulkOpStart(membershipID);
                        }
                        bucketRegion.waitUntilLocked(keys);
                        boolean lockedForPrimary = false;
                        ArrayList<Object> succeeded = new ArrayList<Object>();
                        PutAllPartialResultException.PutAllPartialResult partialKeys = new PutAllPartialResultException.PutAllPartialResult(this.removeAllPRDataSize);
                        Object key = keys[0];
                        try {
                            bucketRegion.doLockForPrimary(false);
                            lockedForPrimary = true;
                            for (int i2 = 0; i2 < this.removeAllPRDataSize; ++i2) {
                                EntryEventImpl ev = RemoveAllPRMessage.getEventFromEntry(r, myId, eventSender, i2, this.removeAllPRData, this.notificationOnly, this.bridgeContext, this.posDup, this.skipCallbacks);
                                try {
                                    block52: {
                                        key = ev.getKey();
                                        ev.setRemoveAllOperation(op);
                                        try {
                                            r.getDataView().destroyOnRemote(ev, cacheWrite, null);
                                            didRemove = true;
                                            if (logger.isDebugEnabled()) {
                                                logger.debug("RemoveAllPRMessage.doLocalRemoveAll:removeLocally success for " + ev);
                                            }
                                        }
                                        catch (EntryNotFoundException ignore) {
                                            didRemove = true;
                                            if (ev.getVersionTag() == null && logger.isDebugEnabled()) {
                                                logger.debug("doLocalRemoveAll:RemoveAll encoutered EntryNotFoundException: event={}", (Object)ev);
                                            }
                                        }
                                        catch (ConcurrentCacheModificationException e) {
                                            didRemove = true;
                                            if (!logger.isDebugEnabled()) break block52;
                                            logger.debug("RemoveAllPRMessage.doLocalRemoveAll:removeLocally encountered concurrent cache modification for " + ev);
                                        }
                                    }
                                    this.removeAllPRData[i2].setTailKey(ev.getTailKey());
                                    if (!didRemove) {
                                        r.checkReadiness();
                                        ForceReattemptException fre = new ForceReattemptException("unable to perform remove in RemoveAllPR, but operation should not fail");
                                        fre.setHash(ev.getKey().hashCode());
                                        throw fre;
                                    }
                                    succeeded.add(this.removeAllPRData[i2].getKey());
                                    this.versions.addKeyAndVersion(this.removeAllPRData[i2].getKey(), ev.getVersionTag());
                                    continue;
                                }
                                finally {
                                    ev.release();
                                }
                            }
                        }
                        catch (IllegalMonitorStateException ex) {
                            ForceReattemptException fre = new ForceReattemptException("unable to get lock for primary, retrying... ");
                            throw fre;
                        }
                        catch (CacheWriterException cwe) {
                            partialKeys.saveFailedKey(key, cwe);
                        }
                        finally {
                            try {
                                op.setUseFakeEventId(true);
                                r.checkReadiness();
                                bucketRegion.getDataView().postRemoveAll(op, this.versions, bucketRegion);
                            }
                            finally {
                                if (lockedForPrimary) {
                                    bucketRegion.doUnlockForPrimary();
                                }
                            }
                        }
                        if (partialKeys.hasFailure()) {
                            partialKeys.addKeysAndVersions(this.versions);
                            if (logger.isDebugEnabled()) {
                                logger.debug("RemoveAllPRMessage: partial keys applied, map to bucket {}'s keys:{}. Applied {}", (Object)this.bucketId, (Object)Arrays.toString(keys), (Object)succeeded);
                            }
                            throw new PutAllPartialResultException(partialKeys);
                        }
                        break block55;
                    }
                    catch (RegionDestroyedException e) {
                        ds.checkRegionDestroyedOnBucket(bucketRegion, true, e);
                        break block55;
                    }
                    finally {
                        bucketRegion.removeAndNotifyKeys(keys);
                    }
                }
                for (i = 0; i < this.removeAllPRDataSize; ++i) {
                    EntryEventImpl ev = RemoveAllPRMessage.getEventFromEntry(r, myId, eventSender, i, this.removeAllPRData, this.notificationOnly, this.bridgeContext, this.posDup, this.skipCallbacks);
                    try {
                        ev.setOriginRemote(true);
                        if (this.callbackArg != null) {
                            ev.setCallbackArgument(this.callbackArg);
                        }
                        r.invokeDestroyCallbacks(EnumListenerEvent.AFTER_DESTROY, ev, r.isInitialized(), true);
                        continue;
                    }
                    finally {
                        ev.release();
                    }
                }
            }
            finally {
                if (baseEvent != null) {
                    baseEvent.release();
                }
                if (op != null) {
                    op.freeOffHeapResources();
                }
            }
        }
        return true;
    }

    public VersionedObjectList getVersions() {
        return this.versions;
    }

    @Override
    public boolean canStartRemoteTransaction() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntryEventImpl getEventFromEntry(LocalRegion r, InternalDistributedMember myId, InternalDistributedMember eventSender, int idx, DistributedRemoveAllOperation.RemoveAllEntryData[] data, boolean notificationOnly, ClientProxyMembershipID bridgeContext, boolean posDup, boolean skipCallbacks) {
        DistributedRemoveAllOperation.RemoveAllEntryData dataItem = data[idx];
        EntryEventImpl ev = EntryEventImpl.create(r, dataItem.getOp(), dataItem.getKey(), null, null, false, (DistributedMember)eventSender, !skipCallbacks, dataItem.getEventID());
        boolean evReturned = false;
        try {
            ev.setOldValue(dataItem.getOldValue());
            if (bridgeContext != null) {
                ev.setContext(bridgeContext);
            }
            ev.setInvokePRCallbacks(!notificationOnly);
            ev.setPossibleDuplicate(posDup);
            if (dataItem.filterRouting != null) {
                ev.setLocalFilterInfo(dataItem.filterRouting.getFilterInfo(myId));
            }
            if (dataItem.versionTag != null) {
                dataItem.versionTag.replaceNullIDs(eventSender);
                ev.setVersionTag(dataItem.versionTag);
            }
            if (notificationOnly) {
                ev.setTailKey(-1L);
            } else {
                ev.setTailKey(dataItem.getTailKey());
            }
            evReturned = true;
            EntryEventImpl entryEventImpl = ev;
            return entryEventImpl;
        }
        finally {
            if (!evReturned) {
                ev.release();
            }
        }
    }

    PartitionMessage.PartitionResponse createReplyProcessor(PartitionedRegion r, Set recipients, Object key) {
        return new RemoveAllResponse(r.getSystem(), recipients);
    }

    @Override
    protected void sendReply(InternalDistributedMember member, int procId, DM dm, ReplyException ex, PartitionedRegion pr, long startTime) {
        if (pr != null) {
            if (startTime > 0L) {
                pr.getPrStats().endPartitionMessagesProcessing(startTime);
            }
            if (!pr.getConcurrencyChecksEnabled() && this.versions != null) {
                this.versions.clear();
            }
        }
        RemoveAllReplyMessage.send(member, procId, this.getReplySender(dm), this.result, this.versions, ex);
    }

    @Override
    protected final void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; removeAllPRDataSize=").append(this.removeAllPRDataSize).append("; bucketId=").append(this.bucketId);
        if (this.bridgeContext != null) {
            buff.append("; bridgeContext=").append(this.bridgeContext);
        }
        buff.append("; directAck=").append(this.directAck);
        for (int i = 0; i < this.removeAllPRDataSize; ++i) {
            buff.append("; entry" + i + ":").append(this.removeAllPRData[i].getKey()).append(",").append(this.removeAllPRData[i].versionTag);
        }
    }

    public final InternalDistributedSystem getInternalDs() {
        return this.internalDs;
    }

    public final void setInternalDs(InternalDistributedSystem internalDs) {
        this.internalDs = internalDs;
    }

    public final void setDirectAck(boolean directAck) {
        this.directAck = directAck;
    }

    @Override
    protected boolean mayAddToMultipleSerialGateways(DistributionManager dm) {
        return this._mayAddToMultipleSerialGateways(dm);
    }

    public static class RemoveAllResult {
        public boolean returnValue;
        public VersionedObjectList versions;

        public RemoveAllResult(boolean flag, VersionedObjectList versions) {
            this.returnValue = flag;
            this.versions = versions;
        }

        public String toString() {
            return "RemoveAllResult(" + this.returnValue + ", " + this.versions + ")";
        }
    }

    public static class RemoveAllResponse
    extends PartitionMessage.PartitionResponse {
        private volatile boolean returnValue;
        private VersionedObjectList versions;

        public RemoveAllResponse(InternalDistributedSystem ds, Set recipients) {
            super(ds, recipients, false);
        }

        public void setResponse(RemoveAllReplyMessage response) {
            this.returnValue = response.result;
            if (response.versions != null) {
                this.versions = response.versions;
                this.versions.replaceNullIDs(response.getSender());
            }
        }

        public RemoveAllResult waitForResult() throws CacheException, ForceReattemptException {
            this.waitForCacheException();
            return new RemoveAllResult(this.returnValue, this.versions);
        }
    }

    public static final class RemoveAllReplyMessage
    extends ReplyMessage {
        boolean result;
        VersionedObjectList versions;

        @Override
        public boolean getInlineProcess() {
            return true;
        }

        public RemoveAllReplyMessage() {
        }

        private RemoveAllReplyMessage(int processorId, boolean result, VersionedObjectList versions, ReplyException ex) {
            this.versions = versions;
            this.result = result;
            this.setProcessorId(processorId);
            this.setException(ex);
        }

        public static void send(InternalDistributedMember recipient, int processorId, ReplySender dm, boolean result, VersionedObjectList versions, ReplyException ex) {
            Assert.assertTrue(recipient != null, "RemoveAllReplyMessage NULL reply message");
            RemoveAllReplyMessage m = new RemoveAllReplyMessage(processorId, result, versions, ex);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 rp) {
            long startTime = this.getTimestamp();
            if (rp == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "{}: processor not found", (Object)this);
                }
                return;
            }
            if (rp instanceof RemoveAllResponse) {
                RemoveAllResponse processor = (RemoveAllResponse)rp;
                processor.setResponse(this);
            }
            rp.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} Processed {}", (Object)rp, (Object)this);
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        @Override
        public int getDSFID() {
            return -7;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.result = in.readBoolean();
            this.versions = (VersionedObjectList)DataSerializer.readObject(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeBoolean(this.result);
            DataSerializer.writeObject(this.versions, out);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("RemoveAllReplyMessage ").append("processorid=").append(this.processorId).append(" returning ").append(this.result).append(" exception=").append(this.getException()).append(" versions= ").append(this.versions);
            return sb.toString();
        }
    }
}

