/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.CancelException;
import org.apache.geode.cache.partition.PartitionMemberInfo;
import org.apache.geode.cache.partition.PartitionRebalanceInfo;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.BucketAdvisor;
import org.apache.geode.internal.cache.ColocationHelper;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.control.PartitionRebalanceDetailsImpl;
import org.apache.geode.internal.cache.control.ResourceManagerStats;
import org.apache.geode.internal.cache.partitioned.BecomePrimaryBucketMessage;
import org.apache.geode.internal.cache.partitioned.InternalPRInfo;
import org.apache.geode.internal.cache.partitioned.InternalPartitionDetails;
import org.apache.geode.internal.cache.partitioned.LoadProbe;
import org.apache.geode.internal.cache.partitioned.MoveBucketMessage;
import org.apache.geode.internal.cache.partitioned.OfflineMemberDetails;
import org.apache.geode.internal.cache.partitioned.RemoveBucketMessage;
import org.apache.geode.internal.cache.partitioned.rebalance.BucketOperator;
import org.apache.geode.internal.cache.partitioned.rebalance.BucketOperatorImpl;
import org.apache.geode.internal.cache.partitioned.rebalance.BucketOperatorWrapper;
import org.apache.geode.internal.cache.partitioned.rebalance.ParallelBucketOperator;
import org.apache.geode.internal.cache.partitioned.rebalance.PartitionedRegionLoadModel;
import org.apache.geode.internal.cache.partitioned.rebalance.RebalanceDirector;
import org.apache.geode.internal.cache.partitioned.rebalance.SimulatedBucketOperator;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;

public class PartitionedRegionRebalanceOp {
    private static final Logger logger = LogService.getLogger();
    private static final int MAX_PARALLEL_OPERATIONS = Integer.getInteger("gemfire.MAX_PARALLEL_BUCKET_RECOVERIES", 8);
    private final boolean DEBUG = Boolean.getBoolean("gemfire.LOG_REBALANCE");
    private final boolean simulate;
    private final boolean replaceOfflineData;
    private final PartitionedRegion leaderRegion;
    private final PartitionedRegion targetRegion;
    private Collection<PartitionedRegion> colocatedRegions;
    private final AtomicBoolean cancelled;
    private final ResourceManagerStats stats;
    private final boolean isRebalance;
    private volatile boolean membershipChange = false;
    private final RebalanceDirector director;

    public PartitionedRegionRebalanceOp(PartitionedRegion region, boolean simulate, RebalanceDirector director, boolean replaceOfflineData, boolean isRebalance) {
        this(region, simulate, director, replaceOfflineData, isRebalance, new AtomicBoolean(), null);
    }

    public PartitionedRegionRebalanceOp(PartitionedRegion region, boolean simulate, RebalanceDirector director, boolean replaceOfflineData, boolean isRebalance, AtomicBoolean cancelled, ResourceManagerStats stats) {
        PartitionedRegion leader = ColocationHelper.getLeaderRegion(region);
        Assert.assertTrue(leader != null);
        this.leaderRegion = leader;
        this.targetRegion = region;
        this.simulate = simulate;
        this.director = director;
        this.cancelled = cancelled;
        this.replaceOfflineData = replaceOfflineData;
        this.isRebalance = isRebalance;
        this.stats = simulate ? null : stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PartitionRebalanceInfo> execute() {
        long start = System.nanoTime();
        InternalResourceManager resourceManager = InternalResourceManager.getInternalResourceManager(this.leaderRegion.getCache());
        MembershipChangeListener listener = new MembershipChangeListener();
        if (this.isRebalance) {
            InternalResourceManager.getResourceObserver().rebalancingStarted(this.targetRegion);
        } else {
            InternalResourceManager.getResourceObserver().recoveryStarted(this.targetRegion);
        }
        PartitionedRegion.RecoveryLock lock = null;
        try {
            if (!this.checkAndSetColocatedRegions()) {
                Set<PartitionRebalanceInfo> set = Collections.emptySet();
                return set;
            }
            if (!this.isRebalanceNecessary()) {
                Set<PartitionRebalanceInfo> set = Collections.emptySet();
                return set;
            }
            if (!this.simulate) {
                lock = this.leaderRegion.getRecoveryLock();
                lock.lock();
            }
            if (!this.isRebalanceNecessary()) {
                Set<PartitionRebalanceInfo> set = Collections.emptySet();
                return set;
            }
            this.leaderRegion.getRegionAdvisor().addMembershipListener(listener);
            PartitionedRegionLoadModel model = null;
            GemFireCacheImpl cache = this.leaderRegion.getCache();
            Map<PartitionedRegion, InternalPRInfo> detailsMap = this.fetchDetails(cache);
            BucketOperatorWrapper serialOperator = this.getBucketOperator(detailsMap);
            ParallelBucketOperator parallelOperator = new ParallelBucketOperator(MAX_PARALLEL_OPERATIONS, cache.getDistributionManager().getWaitingThreadPool(), serialOperator);
            model = this.buildModel(parallelOperator, detailsMap, resourceManager);
            for (PartitionRebalanceDetailsImpl details : serialOperator.getDetailSet()) {
                details.setPartitionMemberDetailsBefore(model.getPartitionedMemberDetails(details.getRegionPath()));
            }
            this.director.initialize(model);
            do {
                if (this.cancelled.get()) {
                    Set set = Collections.emptySet();
                    return set;
                }
                if (this.membershipChange) {
                    this.membershipChange = false;
                    this.debug("Rebalancing {} detected membership changes. Refetching details", this.leaderRegion);
                    if (this.stats != null) {
                        this.stats.incRebalanceMembershipChanges(1);
                    }
                    model.waitForOperations();
                    detailsMap = this.fetchDetails(cache);
                    model = this.buildModel(parallelOperator, detailsMap, resourceManager);
                    this.director.membershipChanged(model);
                }
                this.leaderRegion.checkClosed();
                cache.getCancelCriterion().checkCancelInProgress(null);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Rebalancing {} Model:{}\n", (Object)this.leaderRegion, (Object)model);
            } while (this.director.nextStep());
            this.debug("Rebalancing {} complete. Model:{}\n", this.leaderRegion, model);
            long end = System.nanoTime();
            for (PartitionRebalanceDetailsImpl details : serialOperator.getDetailSet()) {
                if (!this.simulate) {
                    details.setTime(end - start);
                }
                details.setPartitionMemberDetailsAfter(model.getPartitionedMemberDetails(details.getRegionPath()));
            }
            Set<PartitionRebalanceDetailsImpl> set = Collections.unmodifiableSet(serialOperator.getDetailSet());
            return set;
        }
        finally {
            if (lock != null) {
                try {
                    lock.unlock();
                }
                catch (CancelException cancelException) {
                }
                catch (Exception e) {
                    logger.error(LocalizedMessage.create(LocalizedStrings.PartitionedRegionRebalanceOp_UNABLE_TO_RELEASE_RECOVERY_LOCK), (Throwable)e);
                }
            }
            try {
                if (this.isRebalance) {
                    InternalResourceManager.getResourceObserver().rebalancingFinished(this.targetRegion);
                } else {
                    InternalResourceManager.getResourceObserver().recoveryFinished(this.targetRegion);
                }
            }
            catch (Exception e) {
                logger.error(LocalizedMessage.create(LocalizedStrings.PartitionedRegionRebalanceOp_ERROR_IN_RESOURCE_OBSERVER), (Throwable)e);
            }
            try {
                this.leaderRegion.getRegionAdvisor().removeMembershipListener(listener);
            }
            catch (Exception e) {
                logger.error(LocalizedMessage.create(LocalizedStrings.PartitionedRegionRebalanceOp_ERROR_IN_RESOURCE_OBSERVER), (Throwable)e);
            }
        }
    }

    protected boolean checkAndSetColocatedRegions() {
        if (!ColocationHelper.checkMembersColocation(this.leaderRegion, this.leaderRegion.getDistributionManager().getDistributionManagerId())) {
            return false;
        }
        Map<String, PartitionedRegion> colocatedRegionsMap = ColocationHelper.getAllColocationRegions(this.targetRegion);
        colocatedRegionsMap.put(this.targetRegion.getFullPath(), this.targetRegion);
        LinkedList<PartitionedRegion> colocatedRegions = new LinkedList<PartitionedRegion>();
        for (PartitionedRegion colocatedRegion : colocatedRegionsMap.values()) {
            if (!colocatedRegion.isInitialized()) {
                return false;
            }
            if (colocatedRegion.getColocatedWith() == null) {
                colocatedRegions.addFirst(colocatedRegion);
                continue;
            }
            colocatedRegions.addLast(colocatedRegion);
        }
        this.colocatedRegions = colocatedRegions;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PartitionRebalanceInfo> executeFPA() {
        if (logger.isDebugEnabled()) {
            logger.debug("Rebalancing buckets for fixed partitioned region {}", (Object)this.targetRegion);
        }
        long start = System.nanoTime();
        GemFireCacheImpl cache = this.leaderRegion.getCache();
        InternalResourceManager resourceManager = InternalResourceManager.getInternalResourceManager(cache);
        InternalResourceManager.getResourceObserver().recoveryStarted(this.targetRegion);
        try {
            if (!this.checkAndSetColocatedRegions()) {
                Set<PartitionRebalanceInfo> set = Collections.emptySet();
                return set;
            }
            PartitionedRegionLoadModel model = null;
            Map<PartitionedRegion, InternalPRInfo> detailsMap = this.fetchDetails(cache);
            BucketOperatorWrapper operator = this.getBucketOperator(detailsMap);
            model = this.buildModel(operator, detailsMap, resourceManager);
            for (PartitionRebalanceDetailsImpl details : operator.getDetailSet()) {
                details.setPartitionMemberDetailsBefore(model.getPartitionedMemberDetails(details.getRegionPath()));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Rebalancing FPR {} Model:{}\n", (Object)this.leaderRegion, (Object)model);
            }
            this.director.initialize(model);
            this.director.nextStep();
            if (logger.isDebugEnabled()) {
                logger.debug("Rebalancing FPR {} complete. Model:{}\n", (Object)this.leaderRegion, (Object)model);
            }
            long end = System.nanoTime();
            for (PartitionRebalanceDetailsImpl details : operator.getDetailSet()) {
                if (!this.simulate) {
                    details.setTime(end - start);
                }
                details.setPartitionMemberDetailsAfter(model.getPartitionedMemberDetails(details.getRegionPath()));
            }
            Set<PartitionRebalanceDetailsImpl> set = Collections.unmodifiableSet(operator.getDetailSet());
            return set;
        }
        finally {
            try {
                InternalResourceManager.getResourceObserver().recoveryFinished(this.targetRegion);
            }
            catch (Exception e) {
                logger.debug(LocalizedMessage.create(LocalizedStrings.PartitionedRegionRebalanceOp_ERROR_IN_RESOURCE_OBSERVER), (Throwable)e);
            }
        }
    }

    private Map<PartitionedRegion, InternalPRInfo> fetchDetails(GemFireCacheImpl cache) {
        LoadProbe probe = cache.getResourceManager().getLoadProbe();
        LinkedHashMap<PartitionedRegion, InternalPRInfo> detailsMap = new LinkedHashMap<PartitionedRegion, InternalPRInfo>(this.colocatedRegions.size());
        for (PartitionedRegion colocatedRegion : this.colocatedRegions) {
            if (!ColocationHelper.isColocationComplete(colocatedRegion)) continue;
            InternalPRInfo info = colocatedRegion.getRedundancyProvider().buildPartitionedRegionInfo(true, probe);
            detailsMap.put(colocatedRegion, info);
        }
        return detailsMap;
    }

    private BucketOperatorWrapper getBucketOperator(Map<PartitionedRegion, InternalPRInfo> detailsMap) {
        HashSet<PartitionRebalanceDetailsImpl> rebalanceDetails = new HashSet<PartitionRebalanceDetailsImpl>(detailsMap.size());
        for (Map.Entry<PartitionedRegion, InternalPRInfo> entry : detailsMap.entrySet()) {
            rebalanceDetails.add(new PartitionRebalanceDetailsImpl(entry.getKey()));
        }
        BucketOperator operator = this.simulate ? new SimulatedBucketOperator() : new BucketOperatorImpl(this);
        BucketOperatorWrapper wrapper = new BucketOperatorWrapper(operator, rebalanceDetails, this.stats, this.leaderRegion);
        return wrapper;
    }

    private PartitionedRegionLoadModel buildModel(BucketOperator operator, Map<PartitionedRegion, InternalPRInfo> detailsMap, InternalResourceManager resourceManager) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        final DM dm = this.leaderRegion.getDistributionManager();
        PartitionedRegionLoadModel.AddressComparor comparor = new PartitionedRegionLoadModel.AddressComparor(){

            @Override
            public boolean areSameZone(InternalDistributedMember member1, InternalDistributedMember member2) {
                return dm.areInSameZone(member1, member2);
            }

            @Override
            public boolean enforceUniqueZones() {
                return dm.enforceUniqueZone();
            }
        };
        int redundantCopies = this.leaderRegion.getRedundantCopies();
        int totalNumberOfBuckets = this.leaderRegion.getTotalNumberOfBuckets();
        Set<InternalDistributedMember> criticalMembers = resourceManager.getResourceAdvisor().adviseCritialMembers();
        boolean removeOverRedundancy = true;
        this.debug("Building Model for rebalancing " + this.leaderRegion + ". redundantCopies=" + redundantCopies + ", totalNumBuckets=" + totalNumberOfBuckets + ", criticalMembers=" + criticalMembers + ", simulate=" + this.simulate, new Object[0]);
        PartitionedRegionLoadModel model = new PartitionedRegionLoadModel(operator, redundantCopies, totalNumberOfBuckets, comparor, criticalMembers, this.leaderRegion);
        for (Map.Entry<PartitionedRegion, InternalPRInfo> entry : detailsMap.entrySet()) {
            PartitionedRegion region = entry.getKey();
            InternalPRInfo details = entry.getValue();
            OfflineMemberDetails offlineDetails = this.replaceOfflineData ? OfflineMemberDetails.EMPTY_DETAILS : details.getOfflineMembers();
            boolean enforceLocalMaxMemory = !region.isEntryEvictionPossible();
            this.debug("Added Region to model region=" + region + ", offlineDetails=" + offlineDetails + ", enforceLocalMaxMemory=" + enforceLocalMaxMemory, new Object[0]);
            for (PartitionMemberInfo memberDetails : details.getPartitionMemberInfo()) {
                this.debug("For Region: " + region + ", Member: " + memberDetails.getDistributedMember() + "LOAD=" + ((InternalPartitionDetails)memberDetails).getPRLoad() + ", equivalentMembers=" + dm.getMembersInSameZone((InternalDistributedMember)memberDetails.getDistributedMember()), new Object[0]);
            }
            Set<InternalPartitionDetails> memberDetailSet = details.getInternalPartitionDetails();
            model.addRegion(region.getFullPath(), memberDetailSet, offlineDetails, enforceLocalMaxMemory);
        }
        model.initialize();
        this.debug("Rebalancing {} starting. Model:\n{}", this.leaderRegion, model);
        return model;
    }

    private void debug(String message, Object ... params) {
        if (logger.isDebugEnabled()) {
            logger.debug(message, params);
        } else if (logger.isInfoEnabled() && this.DEBUG) {
            logger.info(message, params);
        }
    }

    public boolean createRedundantBucketForRegion(InternalDistributedMember target, int bucketId) {
        return this.getLeaderRegion().getRedundancyProvider().createBackupBucketOnMember(bucketId, target, this.isRebalance, this.replaceOfflineData, null, true);
    }

    public boolean removeRedundantBucketForRegion(InternalDistributedMember target, int bucketId) {
        boolean removed = false;
        if (this.getLeaderRegion().getDistributionManager().getId().equals(target)) {
            removed = this.getLeaderRegion().getDataStore().removeBucket(bucketId, false);
        } else {
            RemoveBucketMessage.RemoveBucketResponse response = RemoveBucketMessage.send(target, this.getLeaderRegion(), bucketId, false);
            if (response != null) {
                removed = response.waitForResponse();
            }
        }
        return removed;
    }

    public boolean movePrimaryBucketForRegion(InternalDistributedMember target, int bucketId) {
        boolean movedPrimary = false;
        if (this.getLeaderRegion().getDistributionManager().getId().equals(target)) {
            BucketAdvisor bucketAdvisor = this.getLeaderRegion().getRegionAdvisor().getBucketAdvisor(bucketId);
            if (bucketAdvisor.isHosting()) {
                movedPrimary = bucketAdvisor.becomePrimary(this.isRebalance);
            }
        } else {
            BecomePrimaryBucketMessage.BecomePrimaryBucketResponse response = BecomePrimaryBucketMessage.send(target, this.getLeaderRegion(), bucketId, this.isRebalance);
            if (response != null) {
                movedPrimary = response.waitForResponse();
            }
        }
        return movedPrimary;
    }

    public boolean moveBucketForRegion(InternalDistributedMember source, InternalDistributedMember target, int bucketId) {
        boolean movedBucket = false;
        if (this.getLeaderRegion().getDistributionManager().getId().equals(target)) {
            movedBucket = this.getLeaderRegion().getDataStore().moveBucket(bucketId, source, false);
        } else {
            MoveBucketMessage.MoveBucketResponse response = MoveBucketMessage.send(target, this.getLeaderRegion(), bucketId, source);
            if (response != null) {
                movedBucket = response.waitForResponse();
            }
        }
        return movedBucket;
    }

    private boolean isRebalanceNecessary() {
        return this.isRebalance || this.director.isRebalanceNecessary(this.leaderRegion.getRedundancyProvider().isRedundancyImpaired(), this.leaderRegion.getDataPolicy().withPersistence());
    }

    public PartitionedRegion getLeaderRegion() {
        return this.leaderRegion;
    }

    private class MembershipChangeListener
    implements MembershipListener {
        private MembershipChangeListener() {
        }

        @Override
        public void memberDeparted(InternalDistributedMember id, boolean crashed) {
            if (logger.isDebugEnabled()) {
                logger.debug("PartitionedRegionRebalanceOP - membership changed, restarting rebalancing for region {}", (Object)PartitionedRegionRebalanceOp.this.targetRegion);
            }
            PartitionedRegionRebalanceOp.this.membershipChange = true;
        }

        @Override
        public void memberJoined(InternalDistributedMember id) {
            if (logger.isDebugEnabled()) {
                logger.debug("PartitionedRegionRebalanceOP - membership changed, restarting rebalancing for region {}", (Object)PartitionedRegionRebalanceOp.this.targetRegion);
            }
            PartitionedRegionRebalanceOp.this.membershipChange = true;
        }

        @Override
        public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
        }

        @Override
        public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
        }
    }
}

