/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.DataLocationException;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.PrimaryBucketException;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.cache.partitioned.PartitionMessageWithDirectReply;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class PRUpdateEntryVersionMessage
extends PartitionMessageWithDirectReply {
    private static final Logger logger = LogService.getLogger();
    private Object key;
    private Operation op;
    private EventID eventId;
    protected VersionTag versionTag;

    public PRUpdateEntryVersionMessage() {
    }

    public PRUpdateEntryVersionMessage(Collection<InternalDistributedMember> recipients, int regionId, DirectReplyProcessor processor) {
        super(recipients, regionId, processor);
    }

    public PRUpdateEntryVersionMessage(Set recipients, int regionId, DirectReplyProcessor processor, EntryEventImpl event) {
        super(recipients, regionId, processor, event);
        this.key = event.getKey();
        this.op = event.getOperation();
        this.eventId = event.getEventId();
        this.versionTag = event.getVersionTag();
    }

    @Override
    public int getDSFID() {
        return 159;
    }

    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion pr, long startTime) throws CacheException, QueryException, DataLocationException, InterruptedException, IOException {
        EntryEventImpl event = EntryEventImpl.create((LocalRegion)pr, this.getOperation(), this.getKey(), null, null, false, (DistributedMember)this.getSender(), false, false);
        event.disallowOffHeapValues();
        Assert.assertTrue(this.eventId != null);
        if (this.versionTag != null) {
            event.setVersionTag(this.versionTag);
        }
        event.setEventId(this.eventId);
        event.setPossibleDuplicate(this.posDup);
        event.setInvokePRCallbacks(false);
        event.setCausedByMessage(this);
        boolean sendReply = true;
        if (!this.notificationOnly) {
            PartitionedRegionDataStore ds = pr.getDataStore();
            Assert.assertTrue(ds != null, "This process should have storage for an item in " + this.toString());
            try {
                Integer bucket = PartitionedRegionHelper.getHashKey(event);
                pr.getDataView().updateEntryVersion(event);
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.debug("{}: updateEntryVersionLocally in bucket: {}, key: {}", (Object)this.getClass().getName(), (Object)bucket, this.key);
                }
            }
            catch (EntryNotFoundException eee) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: operateOnRegion caught EntryNotFoundException", (Object)this.getClass().getName());
                }
                this.sendReply(this.getSender(), this.getProcessorId(), dm, null, pr, startTime);
                sendReply = false;
            }
            catch (PrimaryBucketException pbe) {
                this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(pbe), pr, startTime);
                return false;
            }
        }
        return sendReply;
    }

    private Operation getOperation() {
        return this.op;
    }

    private Object getKey() {
        return this.key;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.key = DataSerializer.readObject(in);
        this.op = Operation.fromOrdinal(in.readByte());
        this.eventId = (EventID)DataSerializer.readObject(in);
        this.versionTag = (VersionTag)DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.getKey(), out);
        out.writeByte(this.op.ordinal);
        DataSerializer.writeObject(this.eventId, out);
        DataSerializer.writeObject(this.versionTag, out);
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; key=").append(this.getKey());
        buff.append("; op=").append(this.op);
        if (this.eventId != null) {
            buff.append("; eventId=").append(this.eventId);
        }
        if (this.versionTag != null) {
            buff.append("; version=").append(this.versionTag);
        }
    }

    public static UpdateEntryVersionResponse send(InternalDistributedMember recipient, PartitionedRegion r, EntryEventImpl event) throws ForceReattemptException {
        Set<InternalDistributedMember> recipients = Collections.singleton(recipient);
        UpdateEntryVersionResponse p = new UpdateEntryVersionResponse(r.getSystem(), recipient, event.getKey());
        PRUpdateEntryVersionMessage m = new PRUpdateEntryVersionMessage(recipients, r.getPRId(), p, event);
        Set failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException(LocalizedStrings.UpdateEntryVersionMessage_FAILED_SENDING_0.toLocalizedString(m));
        }
        return p;
    }

    public static final class UpdateEntryVersionResponse
    extends PartitionMessage.PartitionResponse {
        private volatile boolean versionUpdated;
        private final Object key;

        public UpdateEntryVersionResponse(InternalDistributedSystem dm, InternalDistributedMember member, Object k) {
            super(dm, member);
            this.key = k;
        }

        public UpdateEntryVersionResponse(InternalDistributedSystem dm, Set recipients, Object k) {
            super(dm, recipients, false);
            this.key = k;
        }

        public void setResponse(ReplyMessage msg) {
            this.versionUpdated = true;
        }

        public void waitForResult() throws CacheException, ForceReattemptException {
            try {
                this.waitForCacheException();
            }
            catch (ForceReattemptException e) {
                e.checkKey(this.key);
                throw e;
            }
            if (!this.versionUpdated && logger.isDebugEnabled()) {
                logger.debug("UpdateEntryVersionResponse: Update entry version failed for key: {}", this.key);
            }
        }
    }
}

