/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.locks;

import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.locks.DLockBatch;
import org.apache.geode.distributed.internal.locks.DLockGrantor;
import org.apache.geode.distributed.internal.locks.DLockLessorDepartureHandler;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.locks.TXLockBatch;
import org.apache.geode.internal.cache.locks.TXLockService;
import org.apache.geode.internal.cache.locks.TXLockServiceImpl;
import org.apache.geode.internal.cache.locks.TXOriginatorRecoveryProcessor;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class TXLessorDepartureHandler
implements DLockLessorDepartureHandler {
    private static final Logger logger = LogService.getLogger();

    @Override
    public void handleDepartureOf(InternalDistributedMember owner, DLockGrantor grantor) {
        TXLockService dtls = TXLockService.getDTLS();
        if (dtls == null) {
            return;
        }
        try {
            if (!dtls.isLockGrantor()) {
                logger.debug("This member is not lock grantor; exiting TXLessorDepartureHandler");
                return;
            }
            DLockService dlock = ((TXLockServiceImpl)dtls).getInternalDistributedLockService();
            if (grantor == null || grantor.isDestroyed()) {
                logger.debug("Lock grantor does not exist or has been destroyed; exiting TXLessorDepartureHandler");
                return;
            }
            DLockBatch[] batches = grantor.getLockBatches(owner);
            if (batches.length == 0) {
                logger.debug("{} has no active lock batches; exiting TXLessorDepartureHandler", (Object)owner);
                return;
            }
            this.sendRecoveryMsgs(dlock.getDistributionManager(), batches, owner, grantor);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void sendRecoveryMsgs(final DM dm, final DLockBatch[] batches, final InternalDistributedMember owner, final DLockGrantor grantor) {
        block2: {
            try {
                dm.getWaitingThreadPool().execute(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < batches.length; ++i) {
                            TXLockBatch batch = (TXLockBatch)batches[i];
                            Set participants = batch.getParticipants();
                            TXOriginatorRecoveryProcessor.sendMessage(participants, owner, batch.getTXLockId(), grantor, dm);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Rejected sending recovery messages for departure of tx originator {}", (Object)owner, (Object)e);
            }
        }
    }
}

