/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.control;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.CancelCriterion;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.control.RebalanceFactory;
import org.apache.geode.cache.control.RebalanceOperation;
import org.apache.geode.cache.control.ResourceManager;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.OverflowQueueWithDMStats;
import org.apache.geode.distributed.internal.SerialQueuedExecutorWithDMStats;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.control.FilterByPath;
import org.apache.geode.internal.cache.control.HeapMemoryMonitor;
import org.apache.geode.internal.cache.control.OffHeapMemoryMonitor;
import org.apache.geode.internal.cache.control.RebalanceOperationImpl;
import org.apache.geode.internal.cache.control.ResourceAdvisor;
import org.apache.geode.internal.cache.control.ResourceEvent;
import org.apache.geode.internal.cache.control.ResourceListener;
import org.apache.geode.internal.cache.control.ResourceManagerStats;
import org.apache.geode.internal.cache.control.ResourceMonitor;
import org.apache.geode.internal.cache.partitioned.LoadProbe;
import org.apache.geode.internal.cache.partitioned.SizedBasedLoadProbe;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingThreadGroup;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;

public class InternalResourceManager
implements ResourceManager {
    private static final Logger logger = LogService.getLogger();
    final int MAX_RESOURCE_MANAGER_EXE_THREADS = Integer.getInteger("gemfire.resource.manager.threads", 1);
    private Map<ResourceType, Set<ResourceListener>> listeners = new HashMap<ResourceType, Set<ResourceListener>>();
    private final ScheduledExecutorService scheduledExecutor;
    private final ExecutorService notifyExecutor;
    private final Set<RebalanceOperation> inProgressOperations = new HashSet<RebalanceOperation>();
    private final Object inProgressOperationsLock = new Object();
    final GemFireCacheImpl cache;
    private LoadProbe loadProbe;
    private final ResourceManagerStats stats;
    private final ResourceAdvisor resourceAdvisor;
    private boolean closed = true;
    private final Map<ResourceType, ResourceMonitor> resourceMonitors;
    private static ResourceObserver observer = new ResourceObserverAdapter();
    private static String PR_LOAD_PROBE_CLASS = System.getProperty("gemfire.ResourceManager.PR_LOAD_PROBE_CLASS", SizedBasedLoadProbe.class.getName());

    public static InternalResourceManager getInternalResourceManager(Cache cache) {
        return (InternalResourceManager)cache.getResourceManager();
    }

    public static InternalResourceManager createResourceManager(GemFireCacheImpl cache) {
        return new InternalResourceManager(cache);
    }

    private InternalResourceManager(GemFireCacheImpl cache) {
        this.cache = cache;
        this.resourceAdvisor = (ResourceAdvisor)cache.getDistributionAdvisor();
        this.stats = new ResourceManagerStats(cache.getDistributedSystem());
        final LoggingThreadGroup threadGroup = LoggingThreadGroup.createThreadGroup("ResourceManagerThreadGroup", logger);
        ThreadFactory tf = new ThreadFactory(){
            AtomicInteger ai = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                int tId = this.ai.getAndIncrement();
                Thread thread = new Thread(threadGroup, r, "ResourceManagerRecoveryThread " + tId);
                thread.setDaemon(true);
                return thread;
            }
        };
        int nThreads = this.MAX_RESOURCE_MANAGER_EXE_THREADS;
        this.scheduledExecutor = new ScheduledThreadPoolExecutor(nThreads, tf);
        try {
            Class<?> loadProbeClass = ClassPathLoader.getLatest().forName(PR_LOAD_PROBE_CLASS);
            this.loadProbe = (LoadProbe)loadProbeClass.newInstance();
        }
        catch (Exception e) {
            throw new InternalGemFireError("Unable to instantiate " + PR_LOAD_PROBE_CLASS, e);
        }
        final LoggingThreadGroup listenerInvokerthrdGrp = LoggingThreadGroup.createThreadGroup("ResourceListenerInvokerThreadGroup", logger);
        ThreadFactory eventProcessorFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(listenerInvokerthrdGrp, r, "Notification Handler");
                thread.setDaemon(true);
                thread.setPriority(10);
                return thread;
            }
        };
        OverflowQueueWithDMStats threadQ = new OverflowQueueWithDMStats(this.stats.getResourceEventQueueStatHelper());
        this.notifyExecutor = new SerialQueuedExecutorWithDMStats(threadQ, this.stats.getResourceEventPoolStatHelper(), eventProcessorFactory);
        HashMap<ResourceType, ResourceMonitor> tempMonitors = new HashMap<ResourceType, ResourceMonitor>();
        tempMonitors.put(ResourceType.HEAP_MEMORY, new HeapMemoryMonitor(this, cache, this.stats));
        tempMonitors.put(ResourceType.OFFHEAP_MEMORY, new OffHeapMemoryMonitor(this, cache, cache.getOffHeapStore(), this.stats));
        this.resourceMonitors = Collections.unmodifiableMap(tempMonitors);
        for (ResourceType resourceType : new ResourceType[]{ResourceType.HEAP_MEMORY, ResourceType.OFFHEAP_MEMORY}) {
            CopyOnWriteArraySet emptySet = new CopyOnWriteArraySet();
            this.listeners.put(resourceType, emptySet);
        }
        this.closed = false;
    }

    public void close() {
        for (ResourceMonitor monitor : this.resourceMonitors.values()) {
            monitor.stopMonitoring();
        }
        this.stopExecutor(this.scheduledExecutor);
        this.stopExecutor(this.notifyExecutor);
        this.stats.close();
        this.closed = true;
    }

    boolean isClosed() {
        return this.closed;
    }

    public void fillInProfile(DistributionAdvisor.Profile profile) {
        assert (profile instanceof ResourceAdvisor.ResourceManagerProfile);
        for (ResourceMonitor monitor : this.resourceMonitors.values()) {
            monitor.fillInProfile((ResourceAdvisor.ResourceManagerProfile)profile);
        }
    }

    public void addResourceListener(ResourceListener listener) {
        this.addResourceListener(ResourceType.ALL, listener);
    }

    public void addResourceListener(ResourceType resourceType, ResourceListener listener) {
        for (Map.Entry<ResourceType, Set<ResourceListener>> mapEntry : this.listeners.entrySet()) {
            if ((mapEntry.getKey().id & resourceType.id) == 0) continue;
            mapEntry.getValue().add(listener);
        }
    }

    public void removeResourceListener(ResourceListener listener) {
        this.removeResourceListener(ResourceType.ALL, listener);
    }

    public void removeResourceListener(ResourceType resourceType, ResourceListener listener) {
        for (Map.Entry<ResourceType, Set<ResourceListener>> mapEntry : this.listeners.entrySet()) {
            if ((mapEntry.getKey().id & resourceType.id) == 0) continue;
            mapEntry.getValue().remove(listener);
        }
    }

    public Set<ResourceListener> getResourceListeners(ResourceType resourceType) {
        return this.listeners.get((Object)resourceType);
    }

    public void deliverEventFromRemote(final ResourceEvent event) {
        assert (!event.isLocal());
        if (this.cache.getLoggerI18n().fineEnabled()) {
            this.cache.getLoggerI18n().fine("New remote event to deliver for member " + event.getMember() + ": event=" + event);
        }
        if (this.cache.getLoggerI18n().fineEnabled()) {
            this.cache.getLoggerI18n().fine("Remote event to deliver for member " + event.getMember() + ":" + event);
        }
        this.runWithNotifyExecutor(new Runnable(){

            @Override
            public void run() {
                InternalResourceManager.this.deliverLocalEvent(event);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deliverLocalEvent(ResourceEvent event) {
        Map<ResourceType, Set<ResourceListener>> map = this.listeners;
        synchronized (map) {
            this.resourceMonitors.get((Object)event.getType()).notifyListeners(this.listeners.get((Object)event.getType()), event);
        }
        this.stats.incResourceEventsDelivered();
    }

    public HeapMemoryMonitor getHeapMonitor() {
        return (HeapMemoryMonitor)this.resourceMonitors.get((Object)ResourceType.HEAP_MEMORY);
    }

    public OffHeapMemoryMonitor getOffHeapMonitor() {
        return (OffHeapMemoryMonitor)this.resourceMonitors.get((Object)ResourceType.OFFHEAP_MEMORY);
    }

    void runWithNotifyExecutor(Runnable runnable) {
        block2: {
            try {
                this.notifyExecutor.execute(runnable);
            }
            catch (RejectedExecutionException e) {
                if (this.isClosed()) break block2;
                this.cache.getLoggerI18n().warning(LocalizedStrings.ResourceManager_REJECTED_EXECUTION_CAUSE_NOHEAP_EVENTS);
            }
        }
    }

    @Override
    public RebalanceFactory createRebalanceFactory() {
        return new RebalanceFactoryImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<RebalanceOperation> getRebalanceOperations() {
        Object object = this.inProgressOperationsLock;
        synchronized (object) {
            return new HashSet<RebalanceOperation>(this.inProgressOperations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInProgressRebalance(RebalanceOperation op) {
        Object object = this.inProgressOperationsLock;
        synchronized (object) {
            this.inProgressOperations.add(op);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInProgressRebalance(RebalanceOperation op) {
        Object object = this.inProgressOperationsLock;
        synchronized (object) {
            this.inProgressOperations.remove(op);
        }
    }

    void stopExecutor(ExecutorService executor) {
        if (executor == null) {
            return;
        }
        executor.shutdown();
        int secToWait = Integer.getInteger("gemfire.prrecovery-close-timeout", 120);
        try {
            executor.awaitTermination(secToWait, TimeUnit.SECONDS);
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
            logger.debug("Failed in interrupting the Resource Manager Thread due to interrupt");
        }
        if (!executor.isTerminated()) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.ResourceManager_FAILED_TO_STOP_RESOURCE_MANAGER_THREADS, new Object[]{secToWait}));
        }
    }

    public ScheduledExecutorService getExecutor() {
        return this.scheduledExecutor;
    }

    public ResourceManagerStats getStats() {
        return this.stats;
    }

    public static void setResourceObserver(ResourceObserver observer) {
        if (observer == null) {
            observer = new ResourceObserverAdapter();
        }
        InternalResourceManager.observer = observer;
    }

    public static ResourceObserver getResourceObserver() {
        return observer;
    }

    public CancelCriterion getCancelCriterion() {
        return this.cache.getCancelCriterion();
    }

    public ResourceAdvisor getResourceAdvisor() {
        return this.resourceAdvisor;
    }

    public LoadProbe getLoadProbe() {
        return this.loadProbe;
    }

    public LoadProbe setLoadProbe(LoadProbe probe) {
        LoadProbe old = this.loadProbe;
        this.loadProbe = probe;
        return old;
    }

    @Override
    public void setCriticalOffHeapPercentage(float offHeapPercentage) {
        this.getOffHeapMonitor().setCriticalThreshold(offHeapPercentage);
    }

    @Override
    public float getCriticalOffHeapPercentage() {
        return this.getOffHeapMonitor().getCriticalThreshold();
    }

    @Override
    public void setEvictionOffHeapPercentage(float offHeapPercentage) {
        this.getOffHeapMonitor().setEvictionThreshold(offHeapPercentage);
    }

    @Override
    public float getEvictionOffHeapPercentage() {
        return this.getOffHeapMonitor().getEvictionThreshold();
    }

    @Override
    public void setCriticalHeapPercentage(float heapPercentage) {
        this.getHeapMonitor().setCriticalThreshold(heapPercentage);
    }

    @Override
    public float getCriticalHeapPercentage() {
        return this.getHeapMonitor().getCriticalThreshold();
    }

    @Override
    public void setEvictionHeapPercentage(float heapPercentage) {
        this.getHeapMonitor().setEvictionThreshold(heapPercentage);
    }

    @Override
    public float getEvictionHeapPercentage() {
        return this.getHeapMonitor().getEvictionThreshold();
    }

    public static class ResourceObserverAdapter
    implements ResourceObserver {
        @Override
        public void rebalancingFinished(Region region) {
            this.rebalancingOrRecoveryFinished(region);
        }

        @Override
        public void rebalancingStarted(Region region) {
            this.rebalancingOrRecoveryStarted(region);
        }

        @Override
        public void recoveryFinished(Region region) {
            this.rebalancingOrRecoveryFinished(region);
        }

        @Override
        public void recoveryStarted(Region region) {
            this.rebalancingOrRecoveryStarted(region);
        }

        public void rebalancingOrRecoveryStarted(Region region) {
        }

        public void rebalancingOrRecoveryFinished(Region region) {
        }

        @Override
        public void recoveryConflated(PartitionedRegion region) {
        }

        @Override
        public void movingBucket(Region region, int bucketId, DistributedMember source, DistributedMember target) {
        }

        @Override
        public void movingPrimary(Region region, int bucketId, DistributedMember source, DistributedMember target) {
        }
    }

    public static interface ResourceObserver {
        public void rebalancingStarted(Region var1);

        public void rebalancingFinished(Region var1);

        public void recoveryStarted(Region var1);

        public void recoveryFinished(Region var1);

        public void recoveryConflated(PartitionedRegion var1);

        public void movingBucket(Region var1, int var2, DistributedMember var3, DistributedMember var4);

        public void movingPrimary(Region var1, int var2, DistributedMember var3, DistributedMember var4);
    }

    class RebalanceFactoryImpl
    implements RebalanceFactory {
        private Set<String> includedRegions;
        private Set<String> excludedRegions;

        RebalanceFactoryImpl() {
        }

        @Override
        public RebalanceOperation simulate() {
            FilterByPath filter = new FilterByPath(this.includedRegions, this.excludedRegions);
            RebalanceOperationImpl op = new RebalanceOperationImpl(InternalResourceManager.this.cache, true, filter);
            op.start();
            return op;
        }

        @Override
        public RebalanceOperation start() {
            FilterByPath filter = new FilterByPath(this.includedRegions, this.excludedRegions);
            RebalanceOperationImpl op = new RebalanceOperationImpl(InternalResourceManager.this.cache, false, filter);
            op.start();
            return op;
        }

        @Override
        public RebalanceFactory excludeRegions(Set<String> regions) {
            this.excludedRegions = regions;
            return this;
        }

        @Override
        public RebalanceFactory includeRegions(Set<String> regions) {
            this.includedRegions = regions;
            return this;
        }
    }

    public static enum ResourceType {
        HEAP_MEMORY(1),
        OFFHEAP_MEMORY(2),
        MEMORY(3),
        ALL(-1);

        int id;

        private ResourceType(int id) {
            this.id = id;
        }
    }
}

