/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.UUID;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.VersionedThinDiskLRURegionEntry;
import org.apache.geode.internal.cache.VersionedThinDiskLRURegionEntryHeapIntKey;
import org.apache.geode.internal.cache.VersionedThinDiskLRURegionEntryHeapLongKey;
import org.apache.geode.internal.cache.VersionedThinDiskLRURegionEntryHeapObjectKey;
import org.apache.geode.internal.cache.VersionedThinDiskLRURegionEntryHeapStringKey1;
import org.apache.geode.internal.cache.VersionedThinDiskLRURegionEntryHeapStringKey2;
import org.apache.geode.internal.cache.VersionedThinDiskLRURegionEntryHeapUUIDKey;

public abstract class VersionedThinDiskLRURegionEntryHeap
extends VersionedThinDiskLRURegionEntry {
    private static final VersionedThinDiskLRURegionEntryHeapFactory factory = new VersionedThinDiskLRURegionEntryHeapFactory();

    public VersionedThinDiskLRURegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedThinDiskLRURegionEntryHeapFactory
    implements RegionEntryFactory {
        private VersionedThinDiskLRURegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedThinDiskLRURegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedThinDiskLRURegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedThinDiskLRURegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedThinDiskLRURegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedThinDiskLRURegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedThinDiskLRURegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VersionedThinDiskLRURegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

