/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.UUID;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.OffHeapRegionEntry;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.VersionedStatsDiskRegionEntry;
import org.apache.geode.internal.cache.VersionedStatsDiskRegionEntryHeap;
import org.apache.geode.internal.cache.VersionedStatsDiskRegionEntryOffHeapIntKey;
import org.apache.geode.internal.cache.VersionedStatsDiskRegionEntryOffHeapLongKey;
import org.apache.geode.internal.cache.VersionedStatsDiskRegionEntryOffHeapObjectKey;
import org.apache.geode.internal.cache.VersionedStatsDiskRegionEntryOffHeapStringKey1;
import org.apache.geode.internal.cache.VersionedStatsDiskRegionEntryOffHeapStringKey2;
import org.apache.geode.internal.cache.VersionedStatsDiskRegionEntryOffHeapUUIDKey;

public abstract class VersionedStatsDiskRegionEntryOffHeap
extends VersionedStatsDiskRegionEntry
implements OffHeapRegionEntry {
    private static final VersionedStatsDiskRegionEntryOffHeapFactory factory = new VersionedStatsDiskRegionEntryOffHeapFactory();

    public VersionedStatsDiskRegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedStatsDiskRegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VersionedStatsDiskRegionEntryOffHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedStatsDiskRegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedStatsDiskRegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedStatsDiskRegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedStatsDiskRegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedStatsDiskRegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedStatsDiskRegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VersionedStatsDiskRegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VersionedStatsDiskRegionEntryHeap.getEntryFactory();
        }
    }
}

