/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.geode.internal.InternalStatisticsDisabledException;
import org.apache.geode.internal.cache.AbstractDiskRegionEntry;
import org.apache.geode.internal.cache.DiskEntry;
import org.apache.geode.internal.cache.DiskId;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.VMStatsDiskRegionEntryHeap;
import org.apache.geode.internal.cache.lru.EnableLRU;
import org.apache.geode.internal.cache.persistence.DiskRecoveryStore;
import org.apache.geode.internal.util.concurrent.CustomEntryConcurrentHashMap;

public class VMStatsDiskRegionEntryHeapUUIDKey
extends VMStatsDiskRegionEntryHeap {
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> next;
    private volatile long lastModified;
    private static final AtomicLongFieldUpdater<VMStatsDiskRegionEntryHeapUUIDKey> lastModifiedUpdater = AtomicLongFieldUpdater.newUpdater(VMStatsDiskRegionEntryHeapUUIDKey.class, "lastModified");
    private volatile Object value;
    protected DiskId id;
    private volatile long lastAccessed;
    private volatile int hitCount;
    private volatile int missCount;
    private static final AtomicIntegerFieldUpdater<VMStatsDiskRegionEntryHeapUUIDKey> hitCountUpdater = AtomicIntegerFieldUpdater.newUpdater(VMStatsDiskRegionEntryHeapUUIDKey.class, "hitCount");
    private static final AtomicIntegerFieldUpdater<VMStatsDiskRegionEntryHeapUUIDKey> missCountUpdater = AtomicIntegerFieldUpdater.newUpdater(VMStatsDiskRegionEntryHeapUUIDKey.class, "missCount");
    private final long keyMostSigBits;
    private final long keyLeastSigBits;

    public VMStatsDiskRegionEntryHeapUUIDKey(RegionEntryContext context, UUID key, Object value) {
        super(context, value instanceof DiskEntry.RecoveredEntry ? null : value);
        this.initialize(context, value);
        this.keyMostSigBits = key.getMostSignificantBits();
        this.keyLeastSigBits = key.getLeastSignificantBits();
    }

    @Override
    protected final Object getValueField() {
        return this.value;
    }

    @Override
    protected void setValueField(Object v) {
        this.value = v;
    }

    @Override
    protected long getlastModifiedField() {
        return lastModifiedUpdater.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return lastModifiedUpdater.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public final int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int v) {
        this.hash = v;
    }

    @Override
    public final CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.next;
    }

    @Override
    public final void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> n) {
        this.next = n;
    }

    protected void initialize(RegionEntryContext context, Object value) {
        this.diskInitialize(context, value);
    }

    @Override
    public int updateAsyncEntrySize(EnableLRU capacityController) {
        throw new IllegalStateException("should never be called");
    }

    private void diskInitialize(RegionEntryContext context, Object value) {
        DiskRecoveryStore drs = (DiskRecoveryStore)((Object)context);
        DiskStoreImpl ds = drs.getDiskStore();
        long maxOplogSize = ds.getMaxOplogSize();
        this.id = DiskId.createDiskId(maxOplogSize, true, ds.needsLinkedList());
        DiskEntry.Helper.initialize(this, drs, value);
    }

    @Override
    public DiskId getDiskId() {
        return this.id;
    }

    @Override
    void setDiskId(RegionEntry old) {
        this.id = ((AbstractDiskRegionEntry)old).getDiskId();
    }

    @Override
    public final void updateStatsForGet(boolean hit, long time) {
        this.setLastAccessed(time);
        if (hit) {
            this.incrementHitCount();
        } else {
            this.incrementMissCount();
        }
    }

    @Override
    protected final void setLastModifiedAndAccessedTimes(long lastModified, long lastAccessed) {
        this._setLastModified(lastModified);
        if (!DISABLE_ACCESS_TIME_UPDATE_ON_PUT) {
            this.setLastAccessed(lastAccessed);
        }
    }

    @Override
    public final long getLastAccessed() throws InternalStatisticsDisabledException {
        return this.lastAccessed;
    }

    private void setLastAccessed(long lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    @Override
    public final long getHitCount() throws InternalStatisticsDisabledException {
        return (long)this.hitCount & 0xFFFFFFFFL;
    }

    @Override
    public final long getMissCount() throws InternalStatisticsDisabledException {
        return (long)this.missCount & 0xFFFFFFFFL;
    }

    private void incrementHitCount() {
        hitCountUpdater.incrementAndGet(this);
    }

    private void incrementMissCount() {
        missCountUpdater.incrementAndGet(this);
    }

    @Override
    public final void resetCounts() throws InternalStatisticsDisabledException {
        hitCountUpdater.set(this, 0);
        missCountUpdater.set(this, 0);
    }

    @Override
    public final void txDidDestroy(long currTime) {
        this.setLastModified(currTime);
        this.setLastAccessed(currTime);
        this.hitCount = 0;
        this.missCount = 0;
    }

    @Override
    public boolean hasStats() {
        return true;
    }

    @Override
    public final Object getKey() {
        return new UUID(this.keyMostSigBits, this.keyLeastSigBits);
    }

    @Override
    public boolean isKeyEqual(Object k) {
        if (k instanceof UUID) {
            UUID uuid = (UUID)k;
            return uuid.getLeastSignificantBits() == this.keyLeastSigBits && uuid.getMostSignificantBits() == this.keyMostSigBits;
        }
        return false;
    }
}

