/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.TransactionDataNotColocatedException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.RemoteOperationException;
import org.apache.geode.internal.cache.RemoteOperationMessage;
import org.apache.geode.internal.cache.TXCommitMessage;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXMessage;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class TXRemoteCommitMessage
extends TXMessage {
    private static final Logger logger = LogService.getLogger();

    public TXRemoteCommitMessage() {
    }

    public TXRemoteCommitMessage(int txUniqId, InternalDistributedMember onBehalfOfClientMember, ReplyProcessor21 processor) {
        super(txUniqId, onBehalfOfClientMember, processor);
    }

    @Override
    public int getProcessorType() {
        return 77;
    }

    public static RemoteCommitResponse send(Cache cache, int txUniqId, InternalDistributedMember onBehalfOfClientMember, DistributedMember recipient) {
        InternalDistributedSystem system = (InternalDistributedSystem)cache.getDistributedSystem();
        Set<DistributedMember> recipients = Collections.singleton(recipient);
        RemoteCommitResponse p = new RemoteCommitResponse(system, recipients);
        TXRemoteCommitMessage msg = new TXRemoteCommitMessage(txUniqId, onBehalfOfClientMember, p);
        msg.setRecipients(recipients);
        system.getDistributionManager().putOutgoing(msg);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean operateOnTx(TXId txId, DistributionManager dm) throws RemoteOperationException {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        TXManagerImpl txMgr = cache.getTXMgr();
        if (logger.isDebugEnabled()) {
            logger.debug("TX: Committing: {}", (Object)txId);
        }
        TXStateProxy txState = txMgr.getTXState();
        TXCommitMessage cmsg = null;
        try {
            if (txMgr.isHostedTxRecentlyCompleted(txId)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("TX: found a previously committed transaction:{}", (Object)txId);
                }
                if (txMgr.isExceptionToken(cmsg = txMgr.getRecentlyCompletedMessage(txId))) {
                    throw txMgr.getExceptionForToken(cmsg, txId);
                }
            } else if (txState != null) {
                txState.setCommitOnBehalfOfRemoteStub(true);
                txMgr.commit();
                cmsg = txState.getCommitMessage();
            }
        }
        finally {
            txMgr.removeHostedTXState(txId);
        }
        TXRemoteCommitReplyMessage.send(this.getSender(), this.getProcessorId(), cmsg, this.getReplySender(dm));
        return false;
    }

    @Override
    public int getDSFID() {
        return -112;
    }

    @Override
    public boolean canStartRemoteTransaction() {
        return true;
    }

    public static class RemoteCommitResponse
    extends RemoteOperationMessage.RemoteOperationResponse {
        private volatile TXCommitMessage commitMessage;
        private volatile long start;

        public RemoteCommitResponse(InternalDistributedSystem ds, Set recipients) {
            super(ds, (Collection)recipients, true);
        }

        public TXCommitMessage getCommitMessage() {
            return this.commitMessage;
        }

        @Override
        public void process(DistributionMessage msg) {
            if (DistributionStats.enableClockStats) {
                this.start = DistributionStats.getStatTime();
            }
            if (msg instanceof TXRemoteCommitReplyMessage) {
                TXRemoteCommitReplyMessage reply = (TXRemoteCommitReplyMessage)msg;
                this.commitMessage = reply.getCommitMessage();
            }
            super.process(msg);
        }

        public TXCommitMessage waitForResponse() throws RemoteOperationException {
            try {
                this.waitForCacheException();
                if (DistributionStats.enableClockStats) {
                    this.getDistributionManager().getStats().incReplyHandOffTime(this.start);
                }
            }
            catch (RemoteOperationException e) {
                String msg = "RemoteCommitResponse got RemoteOperationException; rethrowing";
                logger.debug("RemoteCommitResponse got RemoteOperationException; rethrowing", (Throwable)e);
                throw e;
            }
            catch (TransactionDataNotColocatedException e) {
                throw e;
            }
            return this.commitMessage;
        }
    }

    public static final class TXRemoteCommitReplyMessage
    extends ReplyMessage {
        private transient TXCommitMessage commitMessage;
        public transient byte[] valueInBytes;

        public TXRemoteCommitReplyMessage() {
        }

        public TXRemoteCommitReplyMessage(DataInput in) throws IOException, ClassNotFoundException {
            this.fromData(in);
        }

        private TXRemoteCommitReplyMessage(int processorId, TXCommitMessage val) {
            this.setProcessorId(processorId);
            this.commitMessage = val;
        }

        @Override
        public boolean getInlineProcess() {
            return true;
        }

        public static void send(InternalDistributedMember recipient, int processorId, TXCommitMessage val, ReplySender replySender) throws RemoteOperationException {
            Assert.assertTrue(recipient != null, "TXRemoteCommitReply NULL reply message");
            TXRemoteCommitReplyMessage m = new TXRemoteCommitReplyMessage(processorId, val);
            m.setRecipient(recipient);
            replySender.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "TXRemoteCommitReply process invoking reply processor with processorId:{}", (Object)this.processorId);
            }
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "TXRemoteCommitReply processor not found");
                }
                return;
            }
            processor.process(this);
        }

        @Override
        public int getDSFID() {
            return -39;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.commitMessage, out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.commitMessage = (TXCommitMessage)DataSerializer.readObject(in);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("TXRemoteCommitReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender());
            return sb.toString();
        }

        public TXCommitMessage getCommitMessage() {
            return this.commitMessage;
        }
    }
}

