/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.geode.InvalidDeltaException;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.CommitConflictException;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.TransactionDataRebalancedException;
import org.apache.geode.cache.TransactionWriter;
import org.apache.geode.cache.TransactionWriterException;
import org.apache.geode.cache.UnsupportedOperationInTransactionException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.AbstractBucketRegionQueue;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.DataLocationException;
import org.apache.geode.internal.cache.DistTXAdjunctCommitMessage;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRemoveAllOperation;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.KeyInfo;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PrimaryBucketException;
import org.apache.geode.internal.cache.TXBucketRegionState;
import org.apache.geode.internal.cache.TXCommitMessage;
import org.apache.geode.internal.cache.TXEntryState;
import org.apache.geode.internal.cache.TXRegionState;
import org.apache.geode.internal.cache.TXState;
import org.apache.geode.internal.cache.TXStateInterface;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.partitioned.PutAllPRMessage;
import org.apache.geode.internal.cache.partitioned.RemoveAllPRMessage;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.tx.DistTxEntryEvent;
import org.apache.geode.internal.cache.tx.DistTxKeyInfo;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class DistTXState
extends TXState {
    private boolean updatingTxStateDuringPreCommit = false;

    public DistTXState(TXStateProxy proxy, boolean onBehalfOfRemoteStub) {
        super(proxy, onBehalfOfRemoteStub);
    }

    @Override
    protected void cleanup() {
        super.cleanup();
    }

    public void updateRegionVersions() {
        for (Map.Entry me : this.regions.entrySet()) {
            LocalRegion r = (LocalRegion)me.getKey();
            TXRegionState txrs = (TXRegionState)me.getValue();
            if (txrs.isCreatedDuringCommit()) continue;
            try {
                Set entries = txrs.getEntryKeys();
                if (entries.isEmpty()) continue;
                for (Object key : entries) {
                    TXEntryState txes = txrs.getTXEntryState(key);
                    RegionVersionVector rvv = r.getVersionVector();
                    if (rvv == null) continue;
                    long v = rvv.getNextVersion();
                    txes.getDistTxEntryStates().setRegionVersion(v);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Set next region version to " + v + " for region=" + r.getName() + "in TXEntryState for key" + key);
                }
            }
            catch (DiskAccessException dae) {
                r.handleDiskAccessException(dae);
                throw dae;
            }
        }
    }

    public void generateTailKeysForParallelDispatcherEvents() {
        for (Map.Entry me : this.regions.entrySet()) {
            Set entries;
            BucketRegion bRegion;
            LocalRegion r = (LocalRegion)me.getKey();
            TXRegionState txrs = (TXRegionState)me.getValue();
            LocalRegion region = txrs.getRegion();
            if (!region.isUsedForPartitionedRegionBucket() || (bRegion = (BucketRegion)region) instanceof AbstractBucketRegionQueue || !bRegion.getBucketAdvisor().isPrimary() || (entries = txrs.getEntryKeys()).isEmpty()) continue;
            for (Object key : entries) {
                TXEntryState txes = txrs.getTXEntryState(key);
                long tailKey = ((BucketRegion)region).generateTailKey();
                txes.getDistTxEntryStates().setTailKey(tailKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void precommit() throws CommitConflictException, UnsupportedOperationInTransactionException {
        if (logger.isDebugEnabled()) {
            logger.debug("DistTXState.precommit transaction {} is closed {} ", (Object)this.getTransactionId(), (Object)this.closed, (Object)new Throwable());
        }
        if (this.closed) {
            return;
        }
        Object object = this.completionGuard;
        synchronized (object) {
            this.completionStarted = true;
        }
        if (this.onBehalfOfRemoteStub && !this.proxy.isCommitOnBehalfOfRemoteStub()) {
            throw new UnsupportedOperationInTransactionException(LocalizedStrings.TXState_CANNOT_COMMIT_REMOTED_TRANSACTION.toLocalizedString());
        }
        this.cleanupNonDirtyRegions();
        try {
            this.lockBucketRegions();
        }
        catch (PrimaryBucketException pbe) {
            TransactionDataRebalancedException re = new TransactionDataRebalancedException(LocalizedStrings.PartitionedRegion_TRANSACTIONAL_DATA_MOVED_DUE_TO_REBALANCING.toLocalizedString());
            re.initCause(pbe);
            throw re;
        }
        if (this.locks == null) {
            this.reserveAndCheck();
        }
        if (this.internalAfterConflictCheck != null) {
            this.internalAfterConflictCheck.run();
        }
        this.updateRegionVersions();
        this.generateTailKeysForParallelDispatcherEvents();
        TransactionWriter writer = this.proxy.getTxMgr().getWriter();
        if (!this.firedWriter && writer != null) {
            try {
                this.firedWriter = true;
                writer.beforeCommit(this.getEvent());
            }
            catch (TransactionWriterException twe) {
                this.cleanup();
                throw new CommitConflictException(twe);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                this.cleanup();
                SystemFailure.checkFailure();
                throw new CommitConflictException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws CommitConflictException {
        if (logger.isDebugEnabled()) {
            logger.debug("DistTXState.commit transaction {} is closed {} ", (Object)this.getTransactionId(), (Object)this.closed, (Object)new Throwable());
        }
        if (this.closed) {
            return;
        }
        try {
            List entries = this.generateEventOffsets();
            if (logger.isDebugEnabled()) {
                logger.debug("commit entries " + entries);
            }
            TXCommitMessage msg = null;
            try {
                this.attachFilterProfileInformation(entries);
                if (GemFireCacheImpl.internalBeforeApplyChanges != null) {
                    GemFireCacheImpl.internalBeforeApplyChanges.run();
                }
                this.applyChanges(entries);
                if (this.internalAfterApplyChanges != null) {
                    this.internalAfterApplyChanges.run();
                }
                msg = this.buildMessageForAdjunctReceivers();
                msg.send(this.locks.getDistributedLockId());
                this.firePendingCallbacks();
                this.commitMessage = this.buildCompleteMessage();
            }
            finally {
                if (msg != null) {
                    msg.releaseViewVersions();
                }
                this.locks.releaseLocal();
                if (this.internalAfterReleaseLocalLocks != null) {
                    this.internalAfterReleaseLocalLocks.run();
                }
            }
        }
        finally {
            this.cleanup();
        }
    }

    protected TXCommitMessage buildMessageForAdjunctReceivers() {
        DistTXAdjunctCommitMessage msg = new DistTXAdjunctCommitMessage(this.proxy.getTxId(), this.proxy.getTxMgr().getDM(), this);
        for (Map.Entry me : this.regions.entrySet()) {
            LocalRegion r = (LocalRegion)me.getKey();
            TXRegionState txrs = (TXRegionState)me.getValue();
            if (!r.isUsedForPartitionedRegionBucket() || txrs.isCreatedDuringCommit()) continue;
            txrs.buildMessageForAdjunctReceivers(r, msg);
        }
        return msg;
    }

    @Override
    public void rollback() {
        super.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean applyOpsOnRedundantCopy(DistributedMember sender, ArrayList<DistTxEntryEvent> secondaryTransactionalOperations) {
        boolean returnValue = true;
        try {
            boolean result = true;
            this.setUpdatingTxStateDuringPreCommit(true);
            if (logger.isDebugEnabled()) {
                logger.debug("DistTXState.applyOpOnRedundantCopy: size of secondaryTransactionalOperations = {}", (Object)secondaryTransactionalOperations.size());
            }
            for (DistTxEntryEvent dtop : secondaryTransactionalOperations) {
                if (logger.isDebugEnabled()) {
                    logger.debug("DistTXState.applyOpOnRedundantCopy: processing dist tx operation {}", (Object)dtop);
                }
                dtop.setDistributedMember(sender);
                dtop.setOriginRemote(false);
                String failureReason = null;
                try {
                    if (dtop.getKeyInfo().isDistKeyInfo()) {
                        dtop.getKeyInfo().setCheckPrimary(false);
                    } else {
                        dtop.setKeyInfo(new DistTxKeyInfo(dtop.getKeyInfo()));
                        dtop.getKeyInfo().setCheckPrimary(false);
                    }
                    result = this.applyIndividualOp(dtop);
                    if (!result) {
                        dtop.getRegion().checkReadiness();
                    }
                }
                catch (CacheWriterException cwe) {
                    result = false;
                    failureReason = "CacheWriterException";
                }
                catch (PrimaryBucketException pbe) {
                    result = false;
                    failureReason = "PrimaryBucketException";
                }
                catch (InvalidDeltaException ide) {
                    result = false;
                    failureReason = "InvalidDeltaException";
                }
                catch (DataLocationException e) {
                    result = false;
                    failureReason = "DataLocationException";
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("DistTXState.applyOpOnRedundantCopy {} ##op {},  ##region {}, ##key {}", (Object)(result ? " sucessfully applied op " : " failed to apply op due to " + failureReason), (Object)dtop.getOperation(), (Object)dtop.getRegion().getName(), dtop.getKey());
                }
                if (result) continue;
                returnValue = false;
                break;
            }
        }
        finally {
            this.setUpdatingTxStateDuringPreCommit(false);
        }
        return returnValue;
    }

    protected boolean applyIndividualOp(DistTxEntryEvent dtop) throws DataLocationException {
        boolean result = true;
        if (dtop.op.isUpdate() || dtop.op.isCreate()) {
            if (dtop.op.isPutAll()) {
                assert (dtop.getPutAllOperation() != null);
                VersionedObjectList versions = new VersionedObjectList(dtop.getPutAllOperation().putAllDataSize, true, dtop.region.concurrencyChecksEnabled);
                this.postPutAll(dtop.getPutAllOperation(), versions, dtop.region);
            } else {
                result = this.putEntryOnRemote(dtop, false, false, null, false, 0L, true);
            }
        } else if (dtop.op.isDestroy()) {
            if (dtop.op.isRemoveAll()) {
                assert (dtop.getRemoveAllOperation() != null);
                VersionedObjectList versions = new VersionedObjectList(dtop.getRemoveAllOperation().removeAllDataSize, true, dtop.region.concurrencyChecksEnabled);
                this.postRemoveAll(dtop.getRemoveAllOperation(), versions, dtop.region);
            } else {
                this.destroyOnRemote(dtop, false, null);
            }
        } else if (dtop.op.isInvalidate()) {
            this.invalidateOnRemote(dtop, true, false);
        } else {
            logger.debug("DistTXCommitPhaseOneMessage: unsupported TX operation {}", (Object)dtop);
            assert (false);
        }
        return result;
    }

    public boolean isUpdatingTxStateDuringPreCommit() {
        return this.updatingTxStateDuringPreCommit;
    }

    private void setUpdatingTxStateDuringPreCommit(boolean updatingTxState) throws UnsupportedOperationInTransactionException {
        this.updatingTxStateDuringPreCommit = updatingTxState;
        if (logger.isDebugEnabled()) {
            logger.debug("DistTXState setUpdatingTxStateDuringPreCommit incoming {} final {} ", (Object)updatingTxState, (Object)this.updatingTxStateDuringPreCommit, (Object)new Throwable());
        }
    }

    @Override
    public TXRegionState writeRegion(LocalRegion r) {
        TXRegionState result = this.readRegion(r);
        if (result == null) {
            result = r instanceof BucketRegion ? new TXBucketRegionState((BucketRegion)r, (TXState)this) : new TXRegionState(r, this);
            result.setCreatedDuringCommit(this.updatingTxStateDuringPreCommit);
            this.regions.put(r, result);
            if (logger.isDebugEnabled()) {
                logger.debug("DistTXState writeRegion flag {} new region-state {} ", (Object)this.updatingTxStateDuringPreCommit, (Object)result);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("DistTXState writeRegion flag {} region-state {} ", (Object)this.updatingTxStateDuringPreCommit, (Object)result);
        }
        return result;
    }

    @Override
    public void postPutAll(final DistributedPutAllOperation putallOp, final VersionedObjectList successfulPuts, LocalRegion reg) {
        final LocalRegion theRegion = reg instanceof BucketRegion ? ((BucketRegion)reg).getPartitionedRegion() : reg;
        theRegion.syncBulkOp(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InternalDistributedMember myId = theRegion.getDistributionManager().getDistributionManagerId();
                for (int i = 0; i < putallOp.putAllDataSize; ++i) {
                    EntryEventImpl ev = PutAllPRMessage.getEventFromEntry(theRegion, myId, myId, i, putallOp.putAllData, false, putallOp.getBaseEvent().getContext(), false, !putallOp.getBaseEvent().isGenerateCallbacks());
                    try {
                        if (DistTXState.this.isUpdatingTxStateDuringPreCommit()) {
                            KeyInfo keyInfo = ev.getKeyInfo();
                            DistTxKeyInfo distKeyInfo = new DistTxKeyInfo(keyInfo);
                            distKeyInfo.setCheckPrimary(false);
                            ev.setKeyInfo(distKeyInfo);
                        }
                        if (!(theRegion.getDataView() instanceof TXStateInterface)) {
                            if (!DistTXState.this.putEntry(ev, false, false, null, false, 0L, false)) continue;
                            successfulPuts.addKeyAndVersion(putallOp.putAllData[i].key, null);
                            continue;
                        }
                        if (!theRegion.basicPut(ev, false, false, null, false)) continue;
                        successfulPuts.addKeyAndVersion(putallOp.putAllData[i].key, null);
                        continue;
                    }
                    finally {
                        ev.release();
                    }
                }
            }
        }, putallOp.getBaseEvent().getEventId());
    }

    @Override
    public void postRemoveAll(final DistributedRemoveAllOperation op, final VersionedObjectList successfulOps, LocalRegion reg) {
        final LocalRegion theRegion = reg instanceof BucketRegion ? ((BucketRegion)reg).getPartitionedRegion() : reg;
        theRegion.syncBulkOp(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InternalDistributedMember myId = theRegion.getDistributionManager().getDistributionManagerId();
                for (int i = 0; i < op.removeAllDataSize; ++i) {
                    EntryEventImpl ev = RemoveAllPRMessage.getEventFromEntry(theRegion, myId, myId, i, op.removeAllData, false, op.getBaseEvent().getContext(), false, !op.getBaseEvent().isGenerateCallbacks());
                    try {
                        ev.setRemoveAllOperation(op);
                        if (DistTXState.this.isUpdatingTxStateDuringPreCommit()) {
                            KeyInfo keyInfo = ev.getKeyInfo();
                            DistTxKeyInfo distKeyInfo = new DistTxKeyInfo(keyInfo);
                            distKeyInfo.setCheckPrimary(false);
                            ev.setKeyInfo(distKeyInfo);
                        }
                        try {
                            if (!(theRegion.getDataView() instanceof TXStateInterface)) {
                                DistTXState.this.destroyExistingEntry(ev, true, null);
                            } else {
                                theRegion.basicDestroy(ev, true, null);
                            }
                        }
                        catch (EntryNotFoundException entryNotFoundException) {
                            // empty catch block
                        }
                        successfulOps.addKeyAndVersion(op.removeAllData[i].key, null);
                        continue;
                    }
                    finally {
                        ev.release();
                    }
                }
            }
        }, op.getBaseEvent().getEventId());
    }

    @Override
    public boolean isDistTx() {
        return true;
    }

    public boolean populateDistTxEntryStateList(TreeMap<String, ArrayList<TXEntryState.DistTxThinEntryState>> entryStateSortedMap) {
        for (Map.Entry me : this.regions.entrySet()) {
            LocalRegion r = (LocalRegion)me.getKey();
            TXRegionState txrs = (TXRegionState)me.getValue();
            String regionFullPath = r.getFullPath();
            if (!txrs.isCreatedDuringCommit()) {
                ArrayList<TXEntryState.DistTxThinEntryState> entryStateList = new ArrayList<TXEntryState.DistTxThinEntryState>();
                boolean returnValue = txrs.populateDistTxEntryStateList(entryStateList);
                if (returnValue) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("DistTxState.populateDistTxEntryStateList Adding entries  with count=" + entryStateList.size() + " for region " + regionFullPath + " . Added list=" + entryStateList);
                    }
                    entryStateSortedMap.put(regionFullPath, entryStateList);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("DistTxState.populateDistTxEntryStateList Got exception for region " + regionFullPath);
                }
                return false;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("DistTxState.populateDistTxEntryStateList Not adding entries for region " + regionFullPath);
        }
        return true;
    }

    public void setDistTxEntryStates(ArrayList<ArrayList<TXEntryState.DistTxThinEntryState>> entryEventList) {
        TreeMap<String, TXRegionState> regionSortedMap = new TreeMap<String, TXRegionState>();
        for (TXRegionState txrs : this.regions.values()) {
            if (!txrs.isCreatedDuringCommit()) continue;
            regionSortedMap.put(txrs.getRegion().getFullPath(), txrs);
        }
        int index = 0;
        for (Map.Entry me : regionSortedMap.entrySet()) {
            String regionFullPath = (String)me.getKey();
            TXRegionState txrs = (TXRegionState)me.getValue();
            ArrayList<TXEntryState.DistTxThinEntryState> entryEvents = entryEventList.get(index++);
            if (logger.isDebugEnabled()) {
                logger.debug("DistTxState.setDistTxEntryStates For region=" + regionFullPath + " ,index=" + index + " ,entryEvents=(" + entryEvents.size() + ")=" + entryEvents + " ,regionSortedMap=" + regionSortedMap.keySet());
            }
            txrs.setDistTxEntryStates(entryEvents);
        }
    }
}

