/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.geode.CancelCriterion;
import org.apache.geode.SystemFailure;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.internal.cache.ColocationHelper;
import org.apache.geode.internal.cache.PRHARedundancyProvider;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;

public class ColocationLogger
implements Runnable {
    private static final Logger logger = LogService.getLogger();
    private final PartitionedRegion region;
    private final List<String> missingChildren = new ArrayList<String>();
    private final Thread loggerThread;
    private final Object loggerLock = new Object();
    private static final int DEFAULT_LOG_INTERVAL = 30000;
    private static int LOG_INTERVAL = 30000;

    public ColocationLogger(PartitionedRegion region) {
        this.region = region;
        this.loggerThread = new Thread((Runnable)this, "ColocationLogger for " + region.getName());
        this.loggerThread.start();
    }

    @Override
    public void run() {
        block4: {
            CancelCriterion stopper = this.region.getGemFireCache().getDistributedSystem().getCancelCriterion();
            DistributedSystem.setThreadsSocketPolicy(true);
            SystemFailure.checkFailure();
            if (stopper.cancelInProgress() != null) {
                return;
            }
            try {
                this.run2();
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                if (!logger.isDebugEnabled()) break block4;
                logger.debug("Unexpected exception in colocation", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run2() throws InterruptedException {
        boolean firstLogIteration = true;
        Object object = this.loggerLock;
        synchronized (object) {
            while (true) {
                int sleepMillis = ColocationLogger.getLogInterval();
                if (firstLogIteration) {
                    firstLogIteration = false;
                    sleepMillis /= 2;
                }
                this.loggerLock.wait(sleepMillis);
                PRHARedundancyProvider rp = this.region.getRedundancyProvider();
                if (rp != null && rp.isPersistentRecoveryComplete() || this.missingChildren.isEmpty()) break;
                this.logMissingRegions(this.region);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopLogger() {
        Object object = this.loggerLock;
        synchronized (object) {
            this.missingChildren.clear();
            this.loggerLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMissingChildRegion(String childFullPath) {
        Object object = this.loggerLock;
        synchronized (object) {
            if (!this.missingChildren.contains(childFullPath)) {
                this.missingChildren.add(childFullPath);
            }
        }
    }

    public void addMissingChildRegions(PartitionedRegion childRegion) {
        List<String> missingDescendants = childRegion.getMissingColocatedChildren();
        for (String name : missingDescendants) {
            this.addMissingChildRegion(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> updateAndGetMissingChildRegions() {
        Object object = this.loggerLock;
        synchronized (object) {
            Set<String> childRegions = ColocationHelper.getAllColocationRegions(this.region).keySet();
            this.missingChildren.removeAll(childRegions);
        }
        return new ArrayList<String>(this.missingChildren);
    }

    private void logMissingRegions(PartitionedRegion region) {
        String namesOfMissing = "";
        if (!this.missingChildren.isEmpty()) {
            namesOfMissing = String.join((CharSequence)"\n\t", this.missingChildren);
        }
        String singular = "";
        String plural = "s";
        String multipleChildren = this.missingChildren.size() > 1 ? plural : singular;
        namesOfMissing = String.join((CharSequence)"\n\t", multipleChildren, namesOfMissing);
        logger.warn(LocalizedMessage.create(LocalizedStrings.ColocationLogger_PERSISTENT_DATA_RECOVERY_OF_REGION_PREVENTED_BY_OFFLINE_COLOCATED_CHILDREN, new Object[]{region.getFullPath(), namesOfMissing}));
    }

    public static int getLogInterval() {
        return LOG_INTERVAL;
    }

    public static synchronized int testhookSetLogInterval(int sleepMillis) {
        int currentSleep = LOG_INTERVAL;
        LOG_INTERVAL = sleepMillis;
        return currentSleep;
    }

    public static synchronized void testhookResetLogInterval() {
        LOG_INTERVAL = 30000;
    }
}

