/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.GemFireIOException;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.cache.query.IndexMaintenanceException;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.cache.query.internal.index.IndexManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.AbstractOplogDiskRegionEntry;
import org.apache.geode.internal.cache.AbstractRegionEntry;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.DiskEntry;
import org.apache.geode.internal.cache.DiskInitFile;
import org.apache.geode.internal.cache.DiskRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.FilterProfile;
import org.apache.geode.internal.cache.FilterRoutingInfo;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.HARegion;
import org.apache.geode.internal.cache.ImageState;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.OffHeapRegionEntry;
import org.apache.geode.internal.cache.OrderedTombstoneMap;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PlaceHolderDiskRegion;
import org.apache.geode.internal.cache.RegionClearedException;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.RegionMap;
import org.apache.geode.internal.cache.TXEntryState;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXRmtEvent;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.lru.LRUEntry;
import org.apache.geode.internal.cache.region.entry.RegionEntryFactoryBuilder;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.versions.ConcurrentCacheModificationException;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.cache.versions.VersionHolder;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.versions.VersionStamp;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.cache.wan.GatewaySenderEventImpl;
import org.apache.geode.internal.concurrent.MapCallbackAdapter;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.offheap.OffHeapHelper;
import org.apache.geode.internal.offheap.OffHeapRegionEntryHelper;
import org.apache.geode.internal.offheap.ReferenceCountHelper;
import org.apache.geode.internal.offheap.StoredObject;
import org.apache.geode.internal.sequencelog.EntryLogger;
import org.apache.geode.internal.util.concurrent.CustomEntryConcurrentHashMap;
import org.apache.logging.log4j.Logger;

public abstract class AbstractRegionMap
implements RegionMap {
    private static final Logger logger = LogService.getLogger();
    protected CustomEntryConcurrentHashMap<Object, Object> map;
    static Runnable testHookRunnableFor48182 = null;
    private RegionEntryFactory entryFactory;
    private RegionMap.Attributes attr;
    private transient Object owner;
    public static boolean FORCE_INVALIDATE_EVENT = Boolean.getBoolean("gemfire.FORCE_INVALIDATE_EVENT");
    private ARMLockTestHook armLockTestHook;

    protected AbstractRegionMap(InternalRegionArguments internalRegionArgs) {
    }

    protected void initialize(Object owner, RegionMap.Attributes attr, InternalRegionArguments internalRegionArgs, boolean isLRU) {
        boolean isDisk;
        this._setAttributes(attr);
        this.setOwner(owner);
        this._setMap(this.createConcurrentMap(attr.initialCapacity, attr.loadFactor, attr.concurrencyLevel, false, new AbstractRegionEntry.HashRegionEntryCreator()));
        boolean withVersioning = false;
        boolean offHeap = false;
        if (owner instanceof LocalRegion) {
            LocalRegion region = (LocalRegion)owner;
            isDisk = region.getDiskRegion() != null;
            GemFireCacheImpl cache = region.getGemFireCache();
            withVersioning = region.getConcurrencyChecksEnabled();
            offHeap = region.getOffHeap();
        } else if (owner instanceof PlaceHolderDiskRegion) {
            offHeap = ((PlaceHolderDiskRegion)owner).getOffHeap();
            isDisk = true;
            withVersioning = ((PlaceHolderDiskRegion)owner).getFlags().contains((Object)DiskInitFile.DiskRegionFlag.IS_WITH_VERSIONING);
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        } else {
            throw new IllegalStateException("expected LocalRegion or PlaceHolderDiskRegion");
        }
        this.setEntryFactory(new RegionEntryFactoryBuilder().getRegionEntryFactoryOrNull(attr.statisticsEnabled, isLRU, isDisk, withVersioning, offHeap));
    }

    protected CustomEntryConcurrentHashMap<Object, Object> createConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel, boolean isIdentityMap, CustomEntryConcurrentHashMap.HashEntryCreator<Object, Object> entryCreator) {
        if (entryCreator != null) {
            return new CustomEntryConcurrentHashMap<Object, Object>(initialCapacity, loadFactor, concurrencyLevel, isIdentityMap, entryCreator);
        }
        return new CustomEntryConcurrentHashMap<Object, Object>(initialCapacity, loadFactor, concurrencyLevel, isIdentityMap);
    }

    @Override
    public void changeOwner(LocalRegion r) {
        if (r == this._getOwnerObject()) {
            return;
        }
        this.setOwner(r);
    }

    @Override
    public final void setEntryFactory(RegionEntryFactory f) {
        this.entryFactory = f;
    }

    @Override
    public final RegionEntryFactory getEntryFactory() {
        return this.entryFactory;
    }

    protected final void _setAttributes(RegionMap.Attributes a) {
        this.attr = a;
    }

    @Override
    public final RegionMap.Attributes getAttributes() {
        return this.attr;
    }

    protected final LocalRegion _getOwner() {
        return (LocalRegion)this.owner;
    }

    protected boolean _isOwnerALocalRegion() {
        return this.owner instanceof LocalRegion;
    }

    protected final Object _getOwnerObject() {
        return this.owner;
    }

    @Override
    public final void setOwner(Object r) {
        this.owner = r;
    }

    protected final CustomEntryConcurrentHashMap<Object, Object> _getMap() {
        return this.map;
    }

    protected final void _setMap(CustomEntryConcurrentHashMap<Object, Object> m) {
        this.map = m;
    }

    @Override
    public int size() {
        return this._getMap().size();
    }

    @Override
    public int sizeInVM() {
        return this._getMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this._getMap().isEmpty();
    }

    @Override
    public Set keySet() {
        return this._getMap().keySet();
    }

    @Override
    public Collection<RegionEntry> regionEntries() {
        return this._getMap().values();
    }

    @Override
    public Collection<RegionEntry> regionEntriesInVM() {
        return this._getMap().values();
    }

    @Override
    public final boolean containsKey(Object key) {
        RegionEntry re = this.getEntry(key);
        if (re == null) {
            return false;
        }
        return !re.isRemoved();
    }

    @Override
    public RegionEntry getEntry(Object key) {
        RegionEntry re = (RegionEntry)this._getMap().get(key);
        return re;
    }

    protected RegionEntry getEntry(EntryEventImpl event) {
        return this.getEntry(event.getKey());
    }

    @Override
    public final RegionEntry getEntryInVM(Object key) {
        return (RegionEntry)this._getMap().get(key);
    }

    @Override
    public final RegionEntry putEntryIfAbsent(Object key, RegionEntry re) {
        Object v;
        RegionEntry oldRe = (RegionEntry)this._getMap().putIfAbsent(key, re);
        if (oldRe == null && re instanceof OffHeapRegionEntry && this._isOwnerALocalRegion() && this._getOwner().isThisRegionBeingClosedOrDestroyed() && (v = re._getValue()) != Token.REMOVED_PHASE1 && v != Token.REMOVED_PHASE2 && v instanceof StoredObject && ((StoredObject)v).hasRefCount() && this._getMap().remove(key, re)) {
            ((OffHeapRegionEntry)re).release();
        }
        return oldRe;
    }

    @Override
    public final RegionEntry getOperationalEntryInVM(Object key) {
        RegionEntry re = (RegionEntry)this._getMap().get(key);
        return re;
    }

    @Override
    public final void removeEntry(Object key, RegionEntry re, boolean updateStat) {
        if (re.isTombstone() && this._getMap().get(key) == re) {
            logger.fatal(LocalizedMessage.create(LocalizedStrings.AbstractRegionMap_ATTEMPT_TO_REMOVE_TOMBSTONE), (Throwable)new Exception("stack trace"));
            return;
        }
        if (this._getMap().remove(key, re)) {
            re.removePhase2();
            if (updateStat) {
                this.incEntryCount(-1);
            }
        }
    }

    @Override
    public final void removeEntry(Object key, RegionEntry re, boolean updateStat, EntryEventImpl event, LocalRegion owner) {
        boolean success = false;
        if (re.isTombstone() && this._getMap().get(key) == re) {
            logger.fatal(LocalizedMessage.create(LocalizedStrings.AbstractRegionMap_ATTEMPT_TO_REMOVE_TOMBSTONE), (Throwable)new Exception("stack trace"));
            return;
        }
        if (this._getMap().remove(key, re)) {
            re.removePhase2();
            success = true;
            if (updateStat) {
                this.incEntryCount(-1);
            }
        }
    }

    protected final void incEntryCount(int delta) {
        CachePerfStats stats;
        LocalRegion lr = this._getOwner();
        if (lr != null && (stats = lr.getCachePerfStats()) != null) {
            stats.incEntryCount(delta);
        }
    }

    final void incClearCount(LocalRegion lr) {
        CachePerfStats stats;
        if (lr != null && !(lr instanceof HARegion) && (stats = lr.getCachePerfStats()) != null) {
            stats.incClearCount();
        }
    }

    private void _mapClear() {
        this._getMap().clear();
    }

    @Override
    public void close() {
        this.clear(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<VersionSource> clear(RegionVersionVector rvv) {
        Object lockObj;
        HashSet<VersionSource> result = new HashSet<VersionSource>();
        if (!this._isOwnerALocalRegion()) {
            this._mapClear();
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Clearing entries for {} rvv={}", (Object)this._getOwner(), (Object)(" rvv=" + rvv));
        }
        LocalRegion lr = this._getOwner();
        RegionVersionVector localRvv = lr.getVersionVector();
        this.incClearCount(lr);
        Object object = lockObj = lr.getConcurrencyChecksEnabled() ? lr.getSizeGuard() : new Object();
        synchronized (object) {
            if (rvv == null) {
                int delta = 0;
                try {
                    delta = this.sizeInVM();
                }
                catch (GemFireIOException gemFireIOException) {
                    // empty catch block
                }
                int tombstones = lr.getTombstoneCount();
                this._mapClear();
                this._getOwner().updateSizeOnClearRegion(delta - tombstones);
                this._getOwner().incTombstoneCount(-tombstones);
                if (delta != 0) {
                    this.incEntryCount(-delta);
                }
            } else {
                int delta = 0;
                int tombstones = 0;
                VersionSource myId = this._getOwner().getVersionMember();
                if (localRvv != rvv) {
                    localRvv.recordGCVersions(rvv);
                }
                boolean isTraceEnabled = logger.isTraceEnabled();
                Iterator<RegionEntry> iterator = this.regionEntries().iterator();
                while (iterator.hasNext()) {
                    RegionEntry re;
                    RegionEntry regionEntry = re = iterator.next();
                    synchronized (regionEntry) {
                        Token value = re.getValueAsToken();
                        if (value == Token.REMOVED_PHASE1 || value == Token.REMOVED_PHASE2) {
                            continue;
                        }
                        Object id = re.getVersionStamp().getMemberID();
                        if (id == null) {
                            id = myId;
                        }
                        if (rvv.contains(id, re.getVersionStamp().getRegionVersion())) {
                            if (isTraceEnabled) {
                                logger.trace("region clear op is removing {} {}", re.getKey(), (Object)re.getVersionStamp());
                            }
                            boolean tombstone = re.isTombstone();
                            if (this._getMap().remove(re.getKey(), re)) {
                                if (OffHeapRegionEntryHelper.doesClearNeedToCheckForOffHeap()) {
                                    GatewaySenderEventImpl.release(re._getValue());
                                }
                                try {
                                    re.removePhase1(lr, true);
                                }
                                catch (RegionClearedException regionClearedException) {
                                    // empty catch block
                                }
                                re.removePhase2();
                                this.lruEntryDestroy(re);
                                if (tombstone) {
                                    this._getOwner().incTombstoneCount(-1);
                                    ++tombstones;
                                } else {
                                    ++delta;
                                }
                            }
                        } else {
                            result.add((VersionSource)id);
                        }
                    }
                }
                this._getOwner().updateSizeOnClearRegion(delta);
                this.incEntryCount(-delta);
                this.incEntryCount(-tombstones);
                if (logger.isDebugEnabled()) {
                    logger.debug("Size after clearing = {}", (Object)this._getMap().size());
                }
                if (isTraceEnabled && this._getMap().size() < 20) {
                    this._getOwner().dumpBackingMap();
                }
            }
        }
        return result;
    }

    @Override
    public void lruUpdateCallback() {
    }

    public void lruUpdateCallback(boolean b) {
    }

    @Override
    public void lruUpdateCallback(int i) {
    }

    @Override
    public boolean disableLruUpdateCallback() {
        return false;
    }

    @Override
    public void enableLruUpdateCallback() {
    }

    @Override
    public void resetThreadLocals() {
    }

    protected void lruEntryCreate(RegionEntry e) {
    }

    protected void lruEntryDestroy(RegionEntry e) {
    }

    protected void lruEntryUpdate(RegionEntry e) {
    }

    @Override
    public void decTxRefCount(RegionEntry e) {
        LocalRegion lr = null;
        if (this._isOwnerALocalRegion()) {
            lr = this._getOwner();
        }
        e.decRefCount(null, lr);
    }

    @Override
    public boolean lruLimitExceeded() {
        return false;
    }

    @Override
    public void lruCloseStats() {
    }

    @Override
    public void lruEntryFaultIn(LRUEntry entry) {
    }

    private void processVersionTag(RegionEntry re, EntryEventImpl event) {
        if (re.getVersionStamp() != null) {
            ImageState is;
            re.getVersionStamp().processVersionTag(event);
            VersionTag tag = event.getVersionTag();
            if (tag != null && !event.getRegion().isInitialized() && (is = event.getRegion().getImageState()) != null && !event.getRegion().isUsedForPartitionedRegionBucket()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("recording version tag in image state: {}", (Object)tag);
                }
                is.addVersionTag(event.getKey(), tag);
            }
        }
    }

    private void processVersionTagForGII(RegionEntry re, LocalRegion owner, VersionTag entryVersion, boolean isTombstone, InternalDistributedMember sender, boolean checkConflicts) {
        re.getVersionStamp().processVersionTag(this._getOwner(), entryVersion, isTombstone, false, owner.getMyId(), sender, checkConflicts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyRecoveredEntries(RegionMap rm2) {
        Map.Entry entry;
        OrderedTombstoneMap<RegionEntry> tombstones = new OrderedTombstoneMap<RegionEntry>();
        if (rm2 != null) {
            CustomEntryConcurrentHashMap<Object, Object> other = ((AbstractRegionMap)rm2)._getMap();
            Iterator<Map.Entry<Object, Object>> it = other.entrySetWithReusableEntries().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> me = it.next();
                it.remove();
                RegionEntry oldRe = (RegionEntry)me.getValue();
                Object key = me.getKey();
                Object value = oldRe._getValueRetain((RegionEntryContext)((AbstractRegionMap)rm2)._getOwnerObject(), true);
                try {
                    if (value == Token.NOT_AVAILABLE) {
                        value = null;
                    }
                    if (value == Token.TOMBSTONE && !this._getOwner().getConcurrencyChecksEnabled()) continue;
                    RegionEntry newRe = this.getEntryFactory().createEntry((RegionEntryContext)this._getOwnerObject(), key, value);
                    this.copyRecoveredEntry(oldRe, newRe);
                    if (newRe.isTombstone()) {
                        VersionTag tag = newRe.getVersionStamp().asVersionTag();
                        tombstones.put(tag, newRe);
                    } else {
                        this._getOwner().updateSizeOnCreate(key, this._getOwner().calculateRegionEntryValueSize(newRe));
                    }
                    this.incEntryCount(1);
                    this.lruEntryUpdate(newRe);
                }
                finally {
                    OffHeapHelper.release(value);
                    if (!(oldRe instanceof OffHeapRegionEntry)) continue;
                    ((OffHeapRegionEntry)oldRe).release();
                    continue;
                }
                this.lruUpdateCallback();
            }
        } else {
            Iterator<RegionEntry> iter = this.regionEntries().iterator();
            while (iter.hasNext()) {
                RegionEntry re = iter.next();
                if (re.isTombstone()) {
                    if (re.getVersionStamp() == null) {
                        iter.remove();
                        continue;
                    }
                    tombstones.put(re.getVersionStamp().asVersionTag(), re);
                    continue;
                }
                this._getOwner().updateSizeOnCreate(re.getKey(), this._getOwner().calculateRegionEntryValueSize(re));
            }
            this.incEntryCount(this.size());
            this.lruUpdateCallback();
        }
        while ((entry = tombstones.take()) != null) {
            this._getOwner().scheduleTombstone((RegionEntry)entry.getValue(), entry.getKey());
        }
    }

    protected void copyRecoveredEntry(RegionEntry oldRe, RegionEntry newRe) {
        if (newRe.getVersionStamp() != null) {
            newRe.getVersionStamp().setMemberID((VersionSource)oldRe.getVersionStamp().getMemberID());
            newRe.getVersionStamp().setVersions(oldRe.getVersionStamp().asVersionTag());
        }
        if (newRe instanceof AbstractOplogDiskRegionEntry) {
            ((AbstractOplogDiskRegionEntry)newRe).setDiskId(oldRe);
            this._getOwner().getDiskRegion().replaceIncompatibleEntry((DiskEntry)oldRe, (DiskEntry)newRe);
        }
        this._getMap().put(newRe.getKey(), newRe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final RegionEntry initRecoveredEntry(Object key, DiskEntry.RecoveredEntry value) {
        RegionEntry newRe;
        boolean needsCallback = false;
        RegionEntry regionEntry = newRe = this.getEntryFactory().createEntry((RegionEntryContext)this._getOwnerObject(), key, value);
        synchronized (regionEntry) {
            if (value.getVersionTag() != null && newRe.getVersionStamp() != null) {
                newRe.getVersionStamp().setVersions(value.getVersionTag());
            }
            RegionEntry oldRe = this.putEntryIfAbsent(key, newRe);
            while (oldRe != null) {
                RegionEntry regionEntry2 = oldRe;
                synchronized (regionEntry2) {
                    if (oldRe.isRemoved() && !oldRe.isTombstone()) {
                        if (this._isOwnerALocalRegion()) {
                            this._getOwner().getCachePerfStats().incRetries();
                        }
                    } else {
                        if (newRe instanceof OffHeapRegionEntry) {
                            ((OffHeapRegionEntry)newRe).release();
                        }
                        throw new IllegalStateException("Could not recover entry for key " + key + ".  The entry already exists!");
                    }
                    this._getMap().remove(key, oldRe);
                    oldRe = this.putEntryIfAbsent(key, newRe);
                }
            }
            if (this._isOwnerALocalRegion()) {
                if (newRe.isTombstone()) {
                    this._getOwner().scheduleTombstone(newRe, newRe.getVersionStamp().asVersionTag());
                } else {
                    this._getOwner().updateSizeOnCreate(key, this._getOwner().calculateRegionEntryValueSize(newRe));
                }
                this.incEntryCount(1);
            }
            this.lruEntryUpdate(newRe);
            needsCallback = true;
        }
        if (needsCallback) {
            this.lruUpdateCallback();
        }
        EntryLogger.logRecovery(this._getOwnerObject(), key, value);
        return newRe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final RegionEntry updateRecoveredEntry(Object key, DiskEntry.RecoveredEntry value) {
        boolean needsCallback = false;
        RegionEntry re = this.getEntry(key);
        if (re == null) {
            return null;
        }
        RegionEntry regionEntry = re;
        synchronized (regionEntry) {
            if (re.isRemoved() && !re.isTombstone()) {
                return null;
            }
            if (value.getVersionTag() != null && re.getVersionStamp() != null) {
                re.getVersionStamp().setVersions(value.getVersionTag());
            }
            try {
                if (this._isOwnerALocalRegion()) {
                    boolean oldValueWasTombstone = re.isTombstone();
                    if (oldValueWasTombstone) {
                        this._getOwner().unscheduleTombstone(re);
                    }
                    int oldSize = this._getOwner().calculateRegionEntryValueSize(re);
                    re.setValue(this._getOwner(), value);
                    if (re.isTombstone()) {
                        this._getOwner().scheduleTombstone(re, re.getVersionStamp().asVersionTag());
                        this._getOwner().updateSizeOnRemove(key, oldSize);
                    } else if (oldValueWasTombstone) {
                        this._getOwner().updateSizeOnCreate(key, this._getOwner().calculateRegionEntryValueSize(re));
                    } else {
                        this._getOwner().updateSizeOnPut(key, oldSize, this._getOwner().calculateRegionEntryValueSize(re));
                    }
                } else {
                    DiskEntry.Helper.updateRecoveredEntry((PlaceHolderDiskRegion)this._getOwnerObject(), (DiskEntry)re, value, (RegionEntryContext)this._getOwnerObject());
                }
            }
            catch (RegionClearedException rce) {
                throw new IllegalStateException("RegionClearedException should never happen in this context", rce);
            }
            this.lruEntryUpdate(re);
            needsCallback = true;
        }
        if (needsCallback) {
            this.lruUpdateCallback();
        }
        EntryLogger.logRecovery(this._getOwnerObject(), key, value);
        return re;
    }

    /*
     * Exception decompiling
     */
    @Override
    public final boolean initialImagePut(Object key, long lastModified, Object newValue, boolean wasRecovered, boolean deferLRUCallback, VersionTag entryVersion, InternalDistributedMember sender, boolean isSynchronizing) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 52[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void initialImagePutEntry(RegionEntry newRe) {
    }

    boolean confirmEvictionDestroy(RegionEntry re) {
        Assert.assertTrue(false, "Not an LRU region, can not confirm LRU eviction operation");
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public final boolean destroy(EntryEventImpl event, boolean inTokenMode, boolean duringRI, boolean cacheWrite, boolean isEviction, Object expectedOldValue, boolean removeRecoveredEntry) throws CacheWriterException, EntryNotFoundException, TimeoutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 3[TRYBLOCK], 2[TRYBLOCK]], but top level block is 119[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void txApplyDestroy(Object key, TransactionId txId, TXRmtEvent txEvent, boolean inTokenMode, boolean inRI, Operation op, EventID eventId, Object aCallbackArgument, List<EntryEventImpl> pendingCallbacks, FilterRoutingInfo filterRoutingInfo, ClientProxyMembershipID bridgeContext, boolean isOriginRemote, TXEntryState txEntryState, VersionTag versionTag, long tailKey) {
        block88: {
            boolean isDebugEnabled = logger.isDebugEnabled();
            LocalRegion owner = this._getOwner();
            owner.checkBeforeEntrySync(txEvent);
            boolean isRegionReady = !inTokenMode;
            boolean hasRemoteOrigin = !((TXId)txId).getMemberId().equals(owner.getMyId());
            boolean cbEventInPending = false;
            IndexManager oqlIndexManager = owner.getIndexManager();
            try {
                RegionEntry re = this.getEntry(key);
                if (re != null) {
                    if (oqlIndexManager != null) {
                        oqlIndexManager.waitForIndexInit();
                    }
                    try {
                        RegionEntry regionEntry = re;
                        synchronized (regionEntry) {
                            if (!re.isRemoved() || re.isTombstone()) {
                                Object oldValue = re.getValueInVM(owner);
                                int oldSize = owner.calculateRegionEntryValueSize(re);
                                boolean invokeCallbacks = AbstractRegionMap.shouldCreateCBEvent(owner, isRegionReady || inRI);
                                EntryEventImpl cbEvent = AbstractRegionMap.createCBEvent(owner, op, key, null, txId, txEvent, eventId, aCallbackArgument, filterRoutingInfo, bridgeContext, txEntryState, versionTag, tailKey);
                                try {
                                    if (owner.isUsedForPartitionedRegionBucket()) {
                                        this.txHandleWANEvent(owner, cbEvent, txEntryState);
                                    }
                                    cbEvent.setRegionEntry(re);
                                    cbEvent.setOldValue(oldValue);
                                    if (isDebugEnabled) {
                                        logger.debug("txApplyDestroy cbEvent={}", (Object)cbEvent);
                                    }
                                    this.txRemoveOldIndexEntry(Operation.DESTROY, re);
                                    if (txEvent != null) {
                                        txEvent.addDestroy(owner, re, re.getKey(), aCallbackArgument);
                                    }
                                    boolean clearOccured = false;
                                    try {
                                        this.processAndGenerateTXVersionTag(owner, cbEvent, re, txEntryState);
                                        if (inTokenMode) {
                                            if (oldValue == Token.TOMBSTONE) {
                                                owner.unscheduleTombstone(re);
                                            }
                                            re.setValue(owner, Token.DESTROYED);
                                        } else if (!re.isTombstone()) {
                                            if (this.shouldPerformConcurrencyChecks(owner, cbEvent) && cbEvent.getVersionTag() != null) {
                                                re.makeTombstone(owner, cbEvent.getVersionTag());
                                            } else {
                                                re.removePhase1(owner, false);
                                                re.removePhase2();
                                                this.removeEntry(key, re, false);
                                            }
                                        } else {
                                            owner.rescheduleTombstone(re, re.getVersionStamp().asVersionTag());
                                        }
                                        EntryLogger.logTXDestroy(this._getOwnerObject(), key);
                                        owner.updateSizeOnRemove(key, oldSize);
                                    }
                                    catch (RegionClearedException rce) {
                                        clearOccured = true;
                                    }
                                    owner.txApplyDestroyPart2(re, re.getKey(), inTokenMode, clearOccured);
                                    if (invokeCallbacks) {
                                        AbstractRegionMap.switchEventOwnerAndOriginRemote(cbEvent, hasRemoteOrigin);
                                        if (pendingCallbacks == null) {
                                            owner.invokeTXCallbacks(EnumListenerEvent.AFTER_DESTROY, cbEvent, true);
                                        } else {
                                            pendingCallbacks.add(cbEvent);
                                            cbEventInPending = true;
                                        }
                                    }
                                    if (!clearOccured) {
                                        this.lruEntryDestroy(re);
                                    }
                                    if (owner.concurrencyChecksEnabled && txEntryState != null && cbEvent != null) {
                                        txEntryState.setVersionTag(cbEvent.getVersionTag());
                                    }
                                }
                                finally {
                                    if (!cbEventInPending) {
                                        cbEvent.release();
                                    }
                                }
                            }
                            break block88;
                        }
                    }
                    finally {
                        if (oqlIndexManager != null) {
                            oqlIndexManager.countDownIndexUpdaters();
                        }
                    }
                }
                if (inTokenMode || owner.concurrencyChecksEnabled) {
                    boolean dispatchListenerEvent = inTokenMode;
                    boolean opCompleted = false;
                    RegionEntry newRe = this.getEntryFactory().createEntry(owner, key, Token.DESTROYED);
                    if (oqlIndexManager != null) {
                        oqlIndexManager.waitForIndexInit();
                    }
                    EntryEventImpl cbEvent = null;
                    try {
                        RegionEntry regionEntry = newRe;
                        synchronized (regionEntry) {
                            RegionEntry oldRe = this.putEntryIfAbsent(key, newRe);
                            while (!opCompleted && oldRe != null) {
                                RegionEntry rce = oldRe;
                                synchronized (rce) {
                                    if (oldRe.isRemovedPhase2()) {
                                        owner.getCachePerfStats().incRetries();
                                        this._getMap().remove(key, oldRe);
                                        oldRe = this.putEntryIfAbsent(key, newRe);
                                    } else {
                                        try {
                                            boolean invokeCallbacks = AbstractRegionMap.shouldCreateCBEvent(owner, isRegionReady || inRI);
                                            cbEvent = AbstractRegionMap.createCBEvent(owner, op, key, null, txId, txEvent, eventId, aCallbackArgument, filterRoutingInfo, bridgeContext, txEntryState, versionTag, tailKey);
                                            try {
                                                cbEvent.setRegionEntry(oldRe);
                                                cbEvent.setOldValue(Token.NOT_AVAILABLE);
                                                if (isDebugEnabled) {
                                                    logger.debug("txApplyDestroy token mode cbEvent={}", (Object)cbEvent);
                                                }
                                                if (owner.isUsedForPartitionedRegionBucket()) {
                                                    this.txHandleWANEvent(owner, cbEvent, txEntryState);
                                                }
                                                this.processAndGenerateTXVersionTag(owner, cbEvent, oldRe, txEntryState);
                                                if (invokeCallbacks) {
                                                    AbstractRegionMap.switchEventOwnerAndOriginRemote(cbEvent, hasRemoteOrigin);
                                                    if (pendingCallbacks == null) {
                                                        owner.invokeTXCallbacks(EnumListenerEvent.AFTER_DESTROY, cbEvent, dispatchListenerEvent);
                                                    } else {
                                                        pendingCallbacks.add(cbEvent);
                                                        cbEventInPending = true;
                                                    }
                                                }
                                                int oldSize = 0;
                                                boolean wasTombstone = oldRe.isTombstone();
                                                if (!wasTombstone) {
                                                    oldSize = owner.calculateRegionEntryValueSize(oldRe);
                                                }
                                                oldRe.setValue(owner, Token.DESTROYED);
                                                EntryLogger.logTXDestroy(this._getOwnerObject(), key);
                                                if (wasTombstone) {
                                                    owner.unscheduleTombstone(oldRe);
                                                }
                                                owner.updateSizeOnRemove(oldRe.getKey(), oldSize);
                                                owner.txApplyDestroyPart2(oldRe, oldRe.getKey(), inTokenMode, false);
                                                this.lruEntryDestroy(oldRe);
                                            }
                                            finally {
                                                if (!cbEventInPending) {
                                                    cbEvent.release();
                                                }
                                            }
                                        }
                                        catch (RegionClearedException rce2) {
                                            owner.txApplyDestroyPart2(oldRe, oldRe.getKey(), inTokenMode, true);
                                        }
                                        if (this.shouldPerformConcurrencyChecks(owner, cbEvent) && cbEvent.getVersionTag() != null) {
                                            oldRe.makeTombstone(owner, cbEvent.getVersionTag());
                                        } else if (!inTokenMode) {
                                            oldRe.removePhase1(owner, false);
                                            oldRe.removePhase2();
                                            this.removeEntry(key, oldRe, false);
                                        }
                                        opCompleted = true;
                                    }
                                }
                            }
                            if (!opCompleted) {
                                opCompleted = true;
                                boolean invokeCallbacks = AbstractRegionMap.shouldCreateCBEvent(owner, isRegionReady || inRI);
                                cbEvent = AbstractRegionMap.createCBEvent(owner, op, key, null, txId, txEvent, eventId, aCallbackArgument, filterRoutingInfo, bridgeContext, txEntryState, versionTag, tailKey);
                                try {
                                    cbEvent.setRegionEntry(newRe);
                                    cbEvent.setOldValue(Token.NOT_AVAILABLE);
                                    if (isDebugEnabled) {
                                        logger.debug("txApplyDestroy token mode cbEvent={}", (Object)cbEvent);
                                    }
                                    if (owner.isUsedForPartitionedRegionBucket()) {
                                        this.txHandleWANEvent(owner, cbEvent, txEntryState);
                                    }
                                    this.processAndGenerateTXVersionTag(owner, cbEvent, newRe, txEntryState);
                                    if (invokeCallbacks) {
                                        AbstractRegionMap.switchEventOwnerAndOriginRemote(cbEvent, hasRemoteOrigin);
                                        if (pendingCallbacks == null) {
                                            owner.invokeTXCallbacks(EnumListenerEvent.AFTER_DESTROY, cbEvent, dispatchListenerEvent);
                                        } else {
                                            pendingCallbacks.add(cbEvent);
                                            cbEventInPending = true;
                                        }
                                    }
                                    EntryLogger.logTXDestroy(this._getOwnerObject(), key);
                                    owner.updateSizeOnCreate(newRe.getKey(), 0);
                                    if (this.shouldPerformConcurrencyChecks(owner, cbEvent) && cbEvent.getVersionTag() != null) {
                                        newRe.makeTombstone(owner, cbEvent.getVersionTag());
                                    } else if (!inTokenMode) {
                                        newRe.removePhase1(owner, false);
                                        newRe.removePhase2();
                                        this.removeEntry(key, newRe, false);
                                    }
                                    owner.txApplyDestroyPart2(newRe, newRe.getKey(), inTokenMode, false);
                                }
                                finally {
                                    if (!cbEventInPending) {
                                        cbEvent.release();
                                    }
                                }
                            }
                            if (owner.concurrencyChecksEnabled && txEntryState != null && cbEvent != null) {
                                txEntryState.setVersionTag(cbEvent.getVersionTag());
                            }
                            break block88;
                        }
                    }
                    catch (RegionClearedException regionClearedException) {
                        break block88;
                    }
                    finally {
                        if (oqlIndexManager != null) {
                            oqlIndexManager.countDownIndexUpdaters();
                        }
                    }
                }
                if (re != null) break block88;
                EntryEventImpl cbEvent = AbstractRegionMap.createCBEvent(owner, op, key, null, txId, txEvent, eventId, aCallbackArgument, filterRoutingInfo, bridgeContext, txEntryState, versionTag, tailKey);
                try {
                    if (owner.isUsedForPartitionedRegionBucket()) {
                        this.txHandleWANEvent(owner, cbEvent, txEntryState);
                    }
                    AbstractRegionMap.switchEventOwnerAndOriginRemote(cbEvent, hasRemoteOrigin);
                    if (pendingCallbacks == null) {
                        owner.invokeTXCallbacks(EnumListenerEvent.AFTER_DESTROY, cbEvent, false);
                    } else {
                        pendingCallbacks.add(cbEvent);
                        cbEventInPending = true;
                    }
                }
                finally {
                    if (!cbEventInPending) {
                        cbEvent.release();
                    }
                }
            }
            catch (DiskAccessException dae) {
                owner.handleDiskAccessException(dae);
                throw dae;
            }
        }
    }

    static void forceInvalidateEvent(EntryEventImpl event, LocalRegion owner) {
        if (FORCE_INVALIDATE_EVENT) {
            event.invokeCallbacks(owner, false, false);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public final boolean invalidate(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry, boolean forceCallbacks) throws EntryNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 78[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void invalidateNewEntry(EntryEventImpl event, LocalRegion owner, RegionEntry newRe) throws RegionClearedException {
        this.processVersionTag(newRe, event);
        event.putNewEntry(owner, newRe);
        owner.recordEvent(event);
        owner.updateSizeOnCreate(event.getKey(), event.getNewValueBucketSize());
    }

    protected void invalidateEntry(EntryEventImpl event, RegionEntry re, int oldSize) throws RegionClearedException {
        this.processVersionTag(re, event);
        event.putExistingEntry(this._getOwner(), re);
        EntryLogger.logInvalidate(event);
        this._getOwner().recordEvent(event);
        this._getOwner().updateSizeOnPut(event.getKey(), oldSize, event.getNewValueBucketSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateEntryVersion(EntryEventImpl event) throws EntryNotFoundException {
        DiskRegion dr;
        LocalRegion owner = this._getOwner();
        if (owner == null) {
            Assert.assertTrue(false, "The owner for RegionMap " + this + " is null for event " + event);
        }
        if ((dr = owner.getDiskRegion()) != null) {
            dr.setClearCountReference();
        }
        this.lockForCacheModification(owner, event);
        try {
            RegionEntry re = this.getEntry(event.getKey());
            boolean entryExisted = false;
            if (re != null) {
                RegionEntry regionEntry = re;
                synchronized (regionEntry) {
                    try {
                        if (re.isTombstone() || !re.isRemoved() && !re.isDestroyed()) {
                            entryExisted = true;
                        }
                        this.processVersionTag(re, event);
                        owner.generateAndSetVersionTag(event, re);
                        EntryLogger.logUpdateEntryVersion(event);
                        this._getOwner().recordEvent(event);
                    }
                    catch (ConcurrentCacheModificationException concurrentCacheModificationException) {
                        // empty catch block
                    }
                }
            }
            if (!entryExisted) {
                owner.checkEntryNotFound(event.getKey());
            }
        }
        catch (DiskAccessException dae) {
            this._getOwner().handleDiskAccessException(dae);
            throw dae;
        }
        finally {
            this.releaseCacheModificationLock(owner, event);
            if (dr != null) {
                dr.removeClearCountReference();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void txApplyInvalidate(Object key, Object newValue, boolean didDestroy, TransactionId txId, TXRmtEvent txEvent, boolean localOp, EventID eventId, Object aCallbackArgument, List<EntryEventImpl> pendingCallbacks, FilterRoutingInfo filterRoutingInfo, ClientProxyMembershipID bridgeContext, TXEntryState txEntryState, VersionTag versionTag, long tailKey) {
        block73: {
            LocalRegion owner = this._getOwner();
            owner.checkBeforeEntrySync(txEvent);
            EntryEventImpl cbEvent = null;
            boolean forceNewEntry = !owner.isInitialized() && owner.isAllEvents();
            boolean hasRemoteOrigin = !((TXId)txId).getMemberId().equals(owner.getMyId());
            DiskRegion dr = owner.getDiskRegion();
            IndexManager oqlIndexManager = owner.getIndexManager();
            if (oqlIndexManager != null) {
                oqlIndexManager.waitForIndexInit();
            }
            try {
                if (forceNewEntry) {
                    RegionEntry newRe;
                    boolean opCompleted = false;
                    RegionEntry regionEntry = newRe = this.getEntryFactory().createEntry(owner, key, Token.REMOVED_PHASE1);
                    synchronized (regionEntry) {
                        block72: {
                            try {
                                RegionEntry oldRe = this.putEntryIfAbsent(key, newRe);
                                while (!opCompleted && oldRe != null) {
                                    RegionEntry regionEntry2 = oldRe;
                                    synchronized (regionEntry2) {
                                        if (oldRe.isRemovedPhase2()) {
                                            owner.getCachePerfStats().incRetries();
                                            this._getMap().remove(key, oldRe);
                                            oldRe = this.putEntryIfAbsent(key, newRe);
                                        } else {
                                            opCompleted = true;
                                            boolean oldWasTombstone = oldRe.isTombstone();
                                            int oldSize = owner.calculateRegionEntryValueSize(oldRe);
                                            Object oldValue = oldRe.getValueInVM(owner);
                                            boolean invokeCallbacks = AbstractRegionMap.shouldCreateCBEvent(owner, owner.isInitialized());
                                            boolean cbEventInPending = false;
                                            cbEvent = AbstractRegionMap.createCBEvent(owner, localOp ? Operation.LOCAL_INVALIDATE : Operation.INVALIDATE, key, newValue, txId, txEvent, eventId, aCallbackArgument, filterRoutingInfo, bridgeContext, txEntryState, versionTag, tailKey);
                                            try {
                                                cbEvent.setRegionEntry(oldRe);
                                                cbEvent.setOldValue(oldValue);
                                                if (logger.isDebugEnabled()) {
                                                    logger.debug("txApplyInvalidate cbEvent={}", (Object)cbEvent);
                                                }
                                                this.txRemoveOldIndexEntry(Operation.INVALIDATE, oldRe);
                                                if (didDestroy) {
                                                    oldRe.txDidDestroy(owner.cacheTimeMillis());
                                                }
                                                if (txEvent != null) {
                                                    txEvent.addInvalidate(owner, oldRe, oldRe.getKey(), newValue, aCallbackArgument);
                                                }
                                                oldRe.setValueResultOfSearch(false);
                                                this.processAndGenerateTXVersionTag(owner, cbEvent, oldRe, txEntryState);
                                                boolean clearOccured = false;
                                                try {
                                                    oldRe.setValue(owner, oldRe.prepareValueForCache(owner, newValue, true));
                                                    EntryLogger.logTXInvalidate(this._getOwnerObject(), key);
                                                    owner.updateSizeOnPut(key, oldSize, 0);
                                                    if (oldWasTombstone) {
                                                        owner.unscheduleTombstone(oldRe);
                                                    }
                                                }
                                                catch (RegionClearedException rce) {
                                                    clearOccured = true;
                                                }
                                                owner.txApplyInvalidatePart2(oldRe, oldRe.getKey(), didDestroy, true, clearOccured);
                                                if (invokeCallbacks) {
                                                    AbstractRegionMap.switchEventOwnerAndOriginRemote(cbEvent, hasRemoteOrigin);
                                                    if (pendingCallbacks == null) {
                                                        owner.invokeTXCallbacks(EnumListenerEvent.AFTER_INVALIDATE, cbEvent, true);
                                                    } else {
                                                        pendingCallbacks.add(cbEvent);
                                                        cbEventInPending = true;
                                                    }
                                                }
                                                if (!clearOccured) {
                                                    this.lruEntryUpdate(oldRe);
                                                }
                                                if (this.shouldPerformConcurrencyChecks(owner, cbEvent) && txEntryState != null) {
                                                    txEntryState.setVersionTag(cbEvent.getVersionTag());
                                                }
                                            }
                                            finally {
                                                if (!cbEventInPending) {
                                                    cbEvent.release();
                                                }
                                            }
                                        }
                                    }
                                }
                                if (opCompleted) break block72;
                                boolean invokeCallbacks = AbstractRegionMap.shouldCreateCBEvent(owner, owner.isInitialized());
                                boolean cbEventInPending = false;
                                cbEvent = AbstractRegionMap.createCBEvent(owner, localOp ? Operation.LOCAL_INVALIDATE : Operation.INVALIDATE, key, newValue, txId, txEvent, eventId, aCallbackArgument, filterRoutingInfo, bridgeContext, txEntryState, versionTag, tailKey);
                                try {
                                    cbEvent.setRegionEntry(newRe);
                                    this.txRemoveOldIndexEntry(Operation.INVALIDATE, newRe);
                                    newRe.setValueResultOfSearch(false);
                                    boolean clearOccured = false;
                                    try {
                                        this.processAndGenerateTXVersionTag(owner, cbEvent, newRe, txEntryState);
                                        newRe.setValue(owner, newRe.prepareValueForCache(owner, newValue, true));
                                        EntryLogger.logTXInvalidate(this._getOwnerObject(), key);
                                        owner.updateSizeOnCreate(newRe.getKey(), 0);
                                    }
                                    catch (RegionClearedException rce) {
                                        clearOccured = true;
                                    }
                                    owner.txApplyInvalidatePart2(newRe, newRe.getKey(), didDestroy, true, clearOccured);
                                    if (invokeCallbacks) {
                                        AbstractRegionMap.switchEventOwnerAndOriginRemote(cbEvent, hasRemoteOrigin);
                                        if (pendingCallbacks == null) {
                                            owner.invokeTXCallbacks(EnumListenerEvent.AFTER_INVALIDATE, cbEvent, true);
                                        } else {
                                            pendingCallbacks.add(cbEvent);
                                            cbEventInPending = true;
                                        }
                                    }
                                    opCompleted = true;
                                    if (!clearOccured) {
                                        this.lruEntryCreate(newRe);
                                        this.incEntryCount(1);
                                    }
                                    if (this.shouldPerformConcurrencyChecks(owner, cbEvent) && txEntryState != null) {
                                        txEntryState.setVersionTag(cbEvent.getVersionTag());
                                    }
                                }
                                finally {
                                    if (!cbEventInPending) {
                                        cbEvent.release();
                                    }
                                }
                            }
                            finally {
                                if (!opCompleted) {
                                    this.removeEntry(key, newRe, false);
                                }
                            }
                        }
                        break block73;
                    }
                }
                RegionEntry re = this.getEntry(key);
                if (re != null) {
                    RegionEntry newRe = re;
                    synchronized (newRe) {
                        int oldSize = owner.calculateRegionEntryValueSize(re);
                        boolean wasTombstone = re.isTombstone();
                        Object oldValue = re.getValueInVM(owner);
                        boolean invokeCallbacks = AbstractRegionMap.shouldCreateCBEvent(owner, owner.isInitialized());
                        boolean cbEventInPending = false;
                        cbEvent = AbstractRegionMap.createCBEvent(owner, localOp ? Operation.LOCAL_INVALIDATE : Operation.INVALIDATE, key, newValue, txId, txEvent, eventId, aCallbackArgument, filterRoutingInfo, bridgeContext, txEntryState, versionTag, tailKey);
                        try {
                            cbEvent.setRegionEntry(re);
                            cbEvent.setOldValue(oldValue);
                            this.txRemoveOldIndexEntry(Operation.INVALIDATE, re);
                            if (didDestroy) {
                                re.txDidDestroy(owner.cacheTimeMillis());
                            }
                            if (txEvent != null) {
                                txEvent.addInvalidate(owner, re, re.getKey(), newValue, aCallbackArgument);
                            }
                            re.setValueResultOfSearch(false);
                            this.processAndGenerateTXVersionTag(owner, cbEvent, re, txEntryState);
                            boolean clearOccured = false;
                            try {
                                re.setValue(owner, re.prepareValueForCache(owner, newValue, true));
                                EntryLogger.logTXInvalidate(this._getOwnerObject(), key);
                                if (wasTombstone) {
                                    owner.unscheduleTombstone(re);
                                }
                                owner.updateSizeOnPut(key, oldSize, 0);
                            }
                            catch (RegionClearedException rce) {
                                clearOccured = true;
                            }
                            owner.txApplyInvalidatePart2(re, re.getKey(), didDestroy, true, clearOccured);
                            if (invokeCallbacks) {
                                AbstractRegionMap.switchEventOwnerAndOriginRemote(cbEvent, hasRemoteOrigin);
                                if (pendingCallbacks == null) {
                                    owner.invokeTXCallbacks(EnumListenerEvent.AFTER_INVALIDATE, cbEvent, true);
                                } else {
                                    pendingCallbacks.add(cbEvent);
                                    cbEventInPending = true;
                                }
                            }
                            if (!clearOccured) {
                                this.lruEntryUpdate(re);
                            }
                            if (this.shouldPerformConcurrencyChecks(owner, cbEvent) && txEntryState != null) {
                                txEntryState.setVersionTag(cbEvent.getVersionTag());
                            }
                        }
                        finally {
                            if (!cbEventInPending) {
                                cbEvent.release();
                            }
                        }
                        break block73;
                    }
                }
                boolean cbEventInPending = false;
                cbEvent = AbstractRegionMap.createCBEvent(owner, localOp ? Operation.LOCAL_INVALIDATE : Operation.INVALIDATE, key, newValue, txId, txEvent, eventId, aCallbackArgument, filterRoutingInfo, bridgeContext, txEntryState, versionTag, tailKey);
                try {
                    AbstractRegionMap.switchEventOwnerAndOriginRemote(cbEvent, hasRemoteOrigin);
                    if (pendingCallbacks == null) {
                        owner.invokeTXCallbacks(EnumListenerEvent.AFTER_INVALIDATE, cbEvent, false);
                    } else {
                        pendingCallbacks.add(cbEvent);
                        cbEventInPending = true;
                    }
                }
                finally {
                    if (!cbEventInPending) {
                        cbEvent.release();
                    }
                }
            }
            catch (DiskAccessException dae) {
                owner.handleDiskAccessException(dae);
                throw dae;
            }
            finally {
                if (oqlIndexManager != null) {
                    oqlIndexManager.countDownIndexUpdaters();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evictValue(Object key) {
        LocalRegion owner = this._getOwner();
        RegionEntry re = this.getEntry(key);
        if (re != null) {
            RegionEntry regionEntry = re;
            synchronized (regionEntry) {
                if (!re.isValueNull()) {
                    re.setValueToNull();
                    owner.getDiskRegion().incNumEntriesInVM(-1L);
                    owner.getDiskRegion().incNumOverflowOnDisk(1L);
                    if (owner instanceof BucketRegion) {
                        ((BucketRegion)owner).incNumEntriesInVM(-1L);
                        ((BucketRegion)owner).incNumOverflowOnDisk(1L);
                    }
                }
            }
        }
    }

    private RegionEntry getOrCreateRegionEntry(Object ownerRegion, EntryEventImpl event, Object value, MapCallbackAdapter<Object, Object, Object, Object> valueCreator, boolean onlyExisting, boolean returnTombstone) {
        RegionEntry oldRe;
        Object key = event.getKey();
        RegionEntry retVal = null;
        retVal = this.getEntry(event);
        if (onlyExisting) {
            if (!returnTombstone && retVal != null && retVal.isTombstone()) {
                return null;
            }
            return retVal;
        }
        if (retVal != null) {
            return retVal;
        }
        if (valueCreator != null) {
            value = valueCreator.newValue(key, ownerRegion, value, null);
        }
        if ((oldRe = this.putEntryIfAbsent(key, retVal = this.getEntryFactory().createEntry((RegionEntryContext)ownerRegion, key, value))) != null) {
            if (retVal instanceof OffHeapRegionEntry) {
                ((OffHeapRegionEntry)retVal).release();
            }
            return oldRe;
        }
        return retVal;
    }

    /*
     * Exception decompiling
     */
    @Override
    public RegionEntry basicPut(EntryEventImpl event, long lastModified, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, boolean overwriteDestroyed) throws CacheWriterException, TimeoutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isOpComplete(RegionEntry re, EntryEventImpl event) {
        return re.getValueAsToken() != Token.REMOVED_PHASE1;
    }

    private boolean satisfiesExpectedOldValue(EntryEventImpl event, RegionEntry re, Object expectedOldValue, boolean replaceOnClient) {
        if (expectedOldValue != null && !replaceOnClient) {
            assert (event.getOperation().guaranteesOldValue());
            Object v = event.getRawOldValue();
            if (!AbstractRegionEntry.checkExpectedOldValue(expectedOldValue, v, event.getLocalRegion())) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOldValueInEvent(EntryEventImpl event, RegionEntry re, boolean cacheWrite, boolean requireOldValue) {
        boolean needToSetOldValue;
        boolean bl = needToSetOldValue = cacheWrite || requireOldValue || event.getOperation().guaranteesOldValue();
        if (needToSetOldValue) {
            if (event.getOperation().guaranteesOldValue()) {
                ReferenceCountHelper.skipRefCountTracking();
                Object oldValueInVMOrDisk = re.getValueOffHeapOrDiskWithoutFaultIn(event.getLocalRegion());
                ReferenceCountHelper.unskipRefCountTracking();
                try {
                    event.setOldValue(oldValueInVMOrDisk, needToSetOldValue);
                }
                finally {
                    OffHeapHelper.releaseWithNoTracking(oldValueInVMOrDisk);
                }
            } else {
                ReferenceCountHelper.skipRefCountTracking();
                Object oldValueInVM = re._getValueRetain(event.getLocalRegion(), true);
                ReferenceCountHelper.unskipRefCountTracking();
                try {
                    event.setOldValue(oldValueInVM, needToSetOldValue);
                }
                finally {
                    OffHeapHelper.releaseWithNoTracking(oldValueInVM);
                }
            }
        } else {
            Object ov = re._getValue();
            if (ov instanceof GatewaySenderEventImpl) {
                event.setOldValue(ov, true);
            }
        }
    }

    protected void createEntry(EntryEventImpl event, LocalRegion owner, RegionEntry re) throws RegionClearedException {
        boolean wasTombstone = re.isTombstone();
        this.processVersionTag(re, event);
        event.putNewEntry(owner, re);
        this.updateSize(event, 0, false, wasTombstone);
        if (!event.getLocalRegion().isInitialized()) {
            owner.getImageState().removeDestroyedEntry(event.getKey());
        }
    }

    protected void updateEntry(EntryEventImpl event, boolean requireOldValue, Object oldValueForDelta, RegionEntry re) throws RegionClearedException {
        int oldSize = event.getLocalRegion().calculateRegionEntryValueSize(re);
        boolean wasTombstone = re.isTombstone();
        this.processVersionTag(re, event);
        event.putExistingEntry(event.getLocalRegion(), re, requireOldValue, oldValueForDelta);
        EntryLogger.logPut(event);
        this.updateSize(event, oldSize, true, wasTombstone);
    }

    private void updateLru(boolean clearOccured, RegionEntry re, EntryEventImpl event) {
        if (!clearOccured) {
            if (event.getOperation().isCreate()) {
                this.lruEntryCreate(re);
            } else {
                this.lruEntryUpdate(re);
            }
        }
    }

    private void updateSize(EntryEventImpl event, int oldSize, boolean isUpdate, boolean wasTombstone) {
        if (isUpdate && !wasTombstone) {
            this._getOwner().updateSizeOnPut(event.getKey(), oldSize, event.getNewValueBucketSize());
        } else {
            this._getOwner().updateSizeOnCreate(event.getKey(), event.getNewValueBucketSize());
            if (!wasTombstone) {
                this.incEntryCount(1);
            }
        }
    }

    private void notifyIndex(RegionEntry re, boolean isUpdating) {
        if (this._getOwner().indexMaintenanceSynchronous) {
            re.setUpdateInProgress(isUpdating);
        }
    }

    private void invokeCacheWriter(RegionEntry re, EntryEventImpl event, boolean cacheWrite, CacheWriter cacheWriter, Set netWriteRecipients, boolean requireOldValue, Object expectedOldValue, boolean replaceOnClient) {
        if (this._getOwner().isInitialized() && cacheWrite) {
            if (!replaceOnClient) {
                if (re.isDestroyedOrRemoved()) {
                    event.makeCreate();
                } else {
                    event.makeUpdate();
                }
            }
            this._getOwner().cacheWriteBeforePut(event, netWriteRecipients, cacheWriter, requireOldValue, expectedOldValue);
        }
        if (!this._getOwner().isInitialized() && !cacheWrite) {
            event.oldValueNotAvailable();
        }
    }

    private boolean continueOverwriteDestroyed(RegionEntry re, EntryEventImpl event, boolean overwriteDestroyed, boolean ifNew) {
        Token oldValueInVM = re.getValueAsToken();
        if (!(overwriteDestroyed || this._getOwner().isInitialized() || oldValueInVM != Token.DESTROYED && oldValueInVM != Token.TOMBSTONE)) {
            event.setOldValueDestroyedToken();
            return false;
        }
        return !ifNew || Token.isRemoved(oldValueInVM);
    }

    private boolean continueUpdate(RegionEntry re, EntryEventImpl event, boolean ifOld, boolean replaceOnClient) {
        if (ifOld) {
            if (re.isTombstone() && event.getVersionTag() != null) {
                this.processVersionTag(re, event);
                try {
                    re.setValue(this._getOwner(), Token.TOMBSTONE);
                }
                catch (RegionClearedException regionClearedException) {
                    // empty catch block
                }
                this._getOwner().rescheduleTombstone(re, re.getVersionStamp().asVersionTag());
                return false;
            }
            if (re.isRemoved() && !replaceOnClient) {
                return false;
            }
        }
        return true;
    }

    protected boolean destroyEntry(RegionEntry re, EntryEventImpl event, boolean inTokenMode, boolean cacheWrite, Object expectedOldValue, boolean forceDestroy, boolean removeRecoveredEntry) throws CacheWriterException, TimeoutException, EntryNotFoundException, RegionClearedException {
        this.processVersionTag(re, event);
        int oldSize = this._getOwner().calculateRegionEntryValueSize(re);
        boolean retVal = re.destroy(event.getLocalRegion(), event, inTokenMode, cacheWrite, expectedOldValue, forceDestroy, removeRecoveredEntry);
        if (retVal) {
            EntryLogger.logDestroy(event);
            this._getOwner().updateSizeOnRemove(event.getKey(), oldSize);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void txApplyPut(Operation p_putOp, Object key, Object nv, boolean didDestroy, TransactionId txId, TXRmtEvent txEvent, EventID eventId, Object aCallbackArgument, List<EntryEventImpl> pendingCallbacks, FilterRoutingInfo filterRoutingInfo, ClientProxyMembershipID bridgeContext, TXEntryState txEntryState, VersionTag versionTag, long tailKey) {
        LocalRegion owner = this._getOwner();
        if (owner == null) {
            Assert.assertTrue(false, "The owner for RegionMap " + this + " is null");
        }
        Operation putOp = p_putOp;
        owner.checkBeforeEntrySync(txEvent);
        Object newValue = nv;
        boolean hasRemoteOrigin = !((TXId)txId).getMemberId().equals(owner.getMyId());
        boolean isTXHost = txEntryState != null;
        boolean isClientTXOriginator = owner.cache.isClient() && !hasRemoteOrigin;
        boolean isRegionReady = owner.isInitialized();
        EntryEventImpl cbEvent = null;
        boolean invokeCallbacks = AbstractRegionMap.shouldCreateCBEvent(owner, isRegionReady);
        boolean cbEventInPending = false;
        cbEvent = AbstractRegionMap.createCBEvent(owner, putOp, key, newValue, txId, txEvent, eventId, aCallbackArgument, filterRoutingInfo, bridgeContext, txEntryState, versionTag, tailKey);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("txApplyPut cbEvent={}", (Object)cbEvent);
            }
            if (owner.isUsedForPartitionedRegionBucket()) {
                newValue = EntryEventImpl.getCachedDeserializable(nv, cbEvent);
                this.txHandleWANEvent(owner, cbEvent, txEntryState);
            }
            boolean opCompleted = false;
            IndexManager oqlIndexManager = owner.getIndexManager();
            if (oqlIndexManager != null) {
                oqlIndexManager.waitForIndexInit();
            }
            try {
                RegionEntry newRe;
                if (hasRemoteOrigin && !isTXHost && !isClientTXOriginator && (!owner.isAllEvents() || !putOp.isCreate() && isRegionReady)) {
                    RegionEntry re = this.getEntry(key);
                    if (re != null) {
                        RegionEntry regionEntry = re;
                        synchronized (regionEntry) {
                            if (!re.isRemoved()) {
                                opCompleted = true;
                                putOp = putOp.getCorrespondingUpdateOp();
                                int oldSize = owner.calculateRegionEntryValueSize(re);
                                if (cbEvent != null) {
                                    cbEvent.setRegionEntry(re);
                                    cbEvent.setOldValue(re.getValueInVM(owner));
                                }
                                boolean clearOccured = false;
                                if (owner.indexMaintenanceSynchronous) {
                                    re.setUpdateInProgress(true);
                                }
                                try {
                                    this.txRemoveOldIndexEntry(putOp, re);
                                    if (didDestroy) {
                                        re.txDidDestroy(owner.cacheTimeMillis());
                                    }
                                    if (txEvent != null) {
                                        txEvent.addPut(putOp, owner, re, re.getKey(), newValue, aCallbackArgument);
                                    }
                                    re.setValueResultOfSearch(putOp.isNetSearch());
                                    try {
                                        this.processAndGenerateTXVersionTag(owner, cbEvent, re, txEntryState);
                                        re.setValue(owner, re.prepareValueForCache(owner, newValue, cbEvent, !putOp.isCreate()));
                                        if (putOp.isCreate()) {
                                            owner.updateSizeOnCreate(key, owner.calculateRegionEntryValueSize(re));
                                        } else if (putOp.isUpdate()) {
                                            owner.updateSizeOnPut(key, oldSize, owner.calculateRegionEntryValueSize(re));
                                        }
                                    }
                                    catch (RegionClearedException rce) {
                                        clearOccured = true;
                                    }
                                    long lastMod = owner.cacheTimeMillis();
                                    EntryLogger.logTXPut(this._getOwnerObject(), key, nv);
                                    re.updateStatsForPut(lastMod, lastMod);
                                    owner.txApplyPutPart2(re, re.getKey(), newValue, lastMod, false, didDestroy, clearOccured);
                                }
                                finally {
                                    if (re != null && owner.indexMaintenanceSynchronous) {
                                        re.setUpdateInProgress(false);
                                    }
                                }
                                if (invokeCallbacks) {
                                    cbEvent.makeUpdate();
                                    AbstractRegionMap.switchEventOwnerAndOriginRemote(cbEvent, hasRemoteOrigin);
                                    if (pendingCallbacks == null) {
                                        owner.invokeTXCallbacks(EnumListenerEvent.AFTER_UPDATE, cbEvent, hasRemoteOrigin);
                                    } else {
                                        pendingCallbacks.add(cbEvent);
                                        cbEventInPending = true;
                                    }
                                }
                                if (!clearOccured) {
                                    this.lruEntryUpdate(re);
                                }
                            }
                        }
                        if (didDestroy && !opCompleted) {
                            owner.txApplyInvalidatePart2(re, re.getKey(), true, false, false);
                        }
                    }
                    if (owner.concurrencyChecksEnabled && txEntryState != null && cbEvent != null) {
                        txEntryState.setVersionTag(cbEvent.getVersionTag());
                    }
                    return;
                }
                RegionEntry regionEntry = newRe = this.getEntryFactory().createEntry(owner, key, Token.REMOVED_PHASE1);
                synchronized (regionEntry) {
                    block91: {
                        try {
                            RegionEntry oldRe = this.putEntryIfAbsent(key, newRe);
                            while (!opCompleted && oldRe != null) {
                                RegionEntry clearOccured = oldRe;
                                synchronized (clearOccured) {
                                    if (oldRe.isRemovedPhase2()) {
                                        owner.getCachePerfStats().incRetries();
                                        this._getMap().remove(key, oldRe);
                                        oldRe = this.putEntryIfAbsent(key, newRe);
                                    } else {
                                        opCompleted = true;
                                        if (!oldRe.isRemoved()) {
                                            putOp = putOp.getCorrespondingUpdateOp();
                                        }
                                        int oldSize = owner.calculateRegionEntryValueSize(oldRe);
                                        boolean oldIsRemoved = oldRe.isDestroyedOrRemoved();
                                        if (cbEvent != null) {
                                            cbEvent.setRegionEntry(oldRe);
                                            cbEvent.setOldValue(oldRe.getValueInVM(owner));
                                        }
                                        boolean clearOccured2 = false;
                                        if (owner.indexMaintenanceSynchronous) {
                                            oldRe.setUpdateInProgress(true);
                                        }
                                        try {
                                            this.txRemoveOldIndexEntry(putOp, oldRe);
                                            if (didDestroy) {
                                                oldRe.txDidDestroy(owner.cacheTimeMillis());
                                            }
                                            if (txEvent != null) {
                                                txEvent.addPut(putOp, owner, oldRe, oldRe.getKey(), newValue, aCallbackArgument);
                                            }
                                            oldRe.setValueResultOfSearch(putOp.isNetSearch());
                                            try {
                                                this.processAndGenerateTXVersionTag(owner, cbEvent, oldRe, txEntryState);
                                                boolean wasTombstone = oldRe.isTombstone();
                                                oldRe.setValue(owner, oldRe.prepareValueForCache(owner, newValue, cbEvent, !putOp.isCreate()));
                                                if (wasTombstone) {
                                                    owner.unscheduleTombstone(oldRe);
                                                }
                                                if (putOp.isCreate()) {
                                                    owner.updateSizeOnCreate(key, owner.calculateRegionEntryValueSize(oldRe));
                                                } else if (putOp.isUpdate()) {
                                                    owner.updateSizeOnPut(key, oldSize, owner.calculateRegionEntryValueSize(oldRe));
                                                }
                                            }
                                            catch (RegionClearedException rce) {
                                                clearOccured2 = true;
                                            }
                                            long lastMod = owner.cacheTimeMillis();
                                            EntryLogger.logTXPut(this._getOwnerObject(), key, nv);
                                            oldRe.updateStatsForPut(lastMod, lastMod);
                                            owner.txApplyPutPart2(oldRe, oldRe.getKey(), newValue, lastMod, false, didDestroy, clearOccured2);
                                        }
                                        finally {
                                            if (oldRe != null && owner.indexMaintenanceSynchronous) {
                                                oldRe.setUpdateInProgress(false);
                                            }
                                        }
                                        if (invokeCallbacks) {
                                            if (!oldIsRemoved) {
                                                cbEvent.makeUpdate();
                                            }
                                            AbstractRegionMap.switchEventOwnerAndOriginRemote(cbEvent, hasRemoteOrigin);
                                            if (pendingCallbacks == null) {
                                                owner.invokeTXCallbacks(cbEvent.op.isCreate() ? EnumListenerEvent.AFTER_CREATE : EnumListenerEvent.AFTER_UPDATE, cbEvent, true);
                                            } else {
                                                pendingCallbacks.add(cbEvent);
                                                cbEventInPending = true;
                                            }
                                        }
                                        if (!clearOccured2) {
                                            this.lruEntryUpdate(oldRe);
                                        }
                                    }
                                }
                            }
                            if (opCompleted) break block91;
                            putOp = putOp.getCorrespondingCreateOp();
                            if (cbEvent != null) {
                                cbEvent.setRegionEntry(newRe);
                                cbEvent.setOldValue(null);
                            }
                            boolean clearOccured = false;
                            if (owner.indexMaintenanceSynchronous) {
                                newRe.setUpdateInProgress(true);
                            }
                            try {
                                this.txRemoveOldIndexEntry(putOp, newRe);
                                if (didDestroy) {
                                    newRe.txDidDestroy(owner.cacheTimeMillis());
                                }
                                if (txEvent != null) {
                                    txEvent.addPut(putOp, owner, newRe, newRe.getKey(), newValue, aCallbackArgument);
                                }
                                newRe.setValueResultOfSearch(putOp.isNetSearch());
                                try {
                                    this.processAndGenerateTXVersionTag(owner, cbEvent, newRe, txEntryState);
                                    newRe.setValue(owner, newRe.prepareValueForCache(owner, newValue, cbEvent, !putOp.isCreate()));
                                    owner.updateSizeOnCreate(newRe.getKey(), owner.calculateRegionEntryValueSize(newRe));
                                }
                                catch (RegionClearedException rce) {
                                    clearOccured = true;
                                }
                                long lastMod = owner.cacheTimeMillis();
                                EntryLogger.logTXPut(this._getOwnerObject(), key, nv);
                                newRe.updateStatsForPut(lastMod, lastMod);
                                owner.txApplyPutPart2(newRe, newRe.getKey(), newValue, lastMod, true, didDestroy, clearOccured);
                            }
                            finally {
                                if (newRe != null && owner.indexMaintenanceSynchronous) {
                                    newRe.setUpdateInProgress(false);
                                }
                            }
                            opCompleted = true;
                            if (invokeCallbacks) {
                                cbEvent.makeCreate();
                                cbEvent.setOldValue(null);
                                AbstractRegionMap.switchEventOwnerAndOriginRemote(cbEvent, hasRemoteOrigin);
                                if (pendingCallbacks == null) {
                                    owner.invokeTXCallbacks(EnumListenerEvent.AFTER_CREATE, cbEvent, true);
                                } else {
                                    pendingCallbacks.add(cbEvent);
                                    cbEventInPending = true;
                                }
                            }
                            if (!clearOccured) {
                                this.lruEntryCreate(newRe);
                                this.incEntryCount(1);
                            }
                        }
                        finally {
                            if (!opCompleted) {
                                this.removeEntry(key, newRe, false);
                            }
                        }
                    }
                }
                if (owner.concurrencyChecksEnabled && txEntryState != null && cbEvent != null) {
                    txEntryState.setVersionTag(cbEvent.getVersionTag());
                }
            }
            catch (DiskAccessException dae) {
                owner.handleDiskAccessException(dae);
                throw dae;
            }
            finally {
                if (oqlIndexManager != null) {
                    oqlIndexManager.countDownIndexUpdaters();
                }
            }
        }
        finally {
            if (!cbEventInPending) {
                cbEvent.release();
            }
        }
    }

    private void txHandleWANEvent(LocalRegion owner, EntryEventImpl cbEvent, TXEntryState txEntryState) {
        ((BucketRegion)owner).handleWANEvent(cbEvent);
        if (txEntryState != null) {
            txEntryState.setTailKey(cbEvent.getTailKey());
        }
    }

    private void processAndGenerateTXVersionTag(LocalRegion owner, EntryEventImpl cbEvent, RegionEntry re, TXEntryState txEntryState) {
        if (this.shouldPerformConcurrencyChecks(owner, cbEvent)) {
            try {
                if (txEntryState != null && txEntryState.getRemoteVersionTag() != null) {
                    VersionTag remoteTag = txEntryState.getRemoteVersionTag();
                    if (re instanceof VersionStamp) {
                        VersionStamp stamp = (VersionStamp)((Object)re);
                        stamp.setVersions(remoteTag);
                    }
                }
                this.processVersionTag(re, cbEvent);
            }
            catch (ConcurrentCacheModificationException concurrentCacheModificationException) {
                // empty catch block
            }
            if (cbEvent != null && txEntryState != null && txEntryState.getDistTxEntryStates() != null) {
                cbEvent.setNextRegionVersion(txEntryState.getDistTxEntryStates().getRegionVersion());
            }
            owner.generateAndSetVersionTag(cbEvent, re);
        }
    }

    private boolean shouldPerformConcurrencyChecks(LocalRegion owner, EntryEventImpl cbEvent) {
        return owner.getConcurrencyChecksEnabled() && cbEvent != null;
    }

    static EntryEventImpl switchEventOwnerAndOriginRemote(EntryEventImpl event, boolean originRemote) {
        assert (event != null);
        if (event.getRegion().isUsedForPartitionedRegionBucket()) {
            PartitionedRegion pr = event.getRegion().getPartitionedRegion();
            event.setRegion(pr);
        }
        event.setOriginRemote(originRemote);
        return event;
    }

    private void txRemoveOldIndexEntry(Operation op, RegionEntry entry) {
        IndexManager idxManager;
        if ((op.isUpdate() && !entry.isInvalid() || op.isInvalidate() || op.isDestroy()) && (idxManager = this._getOwner().getIndexManager()) != null) {
            try {
                idxManager.updateIndexes(entry, 3, op.isUpdate() ? 1 : 0);
            }
            catch (QueryException e) {
                throw new IndexMaintenanceException(e);
            }
        }
    }

    public void dumpMap() {
        logger.debug("dump of concurrent map of size {} for region {}", (Object)this._getMap().size(), (Object)this._getOwner());
        Iterator<Object> it = this._getMap().values().iterator();
        while (it.hasNext()) {
            logger.trace("dumpMap:" + it.next().toString());
        }
    }

    static boolean shouldCreateCBEvent(LocalRegion owner, boolean isInitialized) {
        LocalRegion lr = owner;
        boolean isPartitioned = lr.isUsedForPartitionedRegionBucket();
        if (isPartitioned) {
            lr = owner.getPartitionedRegion();
        }
        return !(!isPartitioned && !isInitialized || !lr.shouldDispatchListenerEvent() && !lr.shouldNotifyBridgeClients() && !lr.getConcurrencyChecksEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final EntryEventImpl createCBEvent(LocalRegion re, Operation op, Object key, Object newValue, TransactionId txId, TXRmtEvent txEvent, EventID eventId, Object aCallbackArgument, FilterRoutingInfo filterRoutingInfo, ClientProxyMembershipID bridgeContext, TXEntryState txEntryState, VersionTag versionTag, long tailKey) {
        InternalDistributedMember originator = null;
        Assert.assertTrue(txId != null);
        originator = ((TXId)txId).getMemberId();
        LocalRegion eventRegion = re;
        if (eventRegion.isUsedForPartitionedRegionBucket()) {
            eventRegion = re.getPartitionedRegion();
        }
        EntryEventImpl retVal = EntryEventImpl.create(re, op, key, newValue, aCallbackArgument, txEntryState == null, originator);
        boolean returnedRetVal = false;
        try {
            if (bridgeContext != null) {
                retVal.setContext(bridgeContext);
            }
            if (eventRegion.generateEventID()) {
                retVal.setEventId(eventId);
            }
            if (versionTag != null) {
                retVal.setVersionTag(versionTag);
            }
            retVal.setTailKey(tailKey);
            FilterRoutingInfo.FilterInfo localRouting = null;
            boolean computeFilterInfo = false;
            if (filterRoutingInfo == null) {
                computeFilterInfo = true;
            } else {
                localRouting = filterRoutingInfo.getLocalFilterInfo();
                if (localRouting != null) {
                    computeFilterInfo = !filterRoutingInfo.hasLocalInterestBeenComputed();
                } else {
                    localRouting = filterRoutingInfo.getFilterInfo(re.getMyId());
                }
                if (localRouting != null) {
                    if (!computeFilterInfo) {
                        retVal.setLocalFilterInfo(localRouting);
                    }
                } else {
                    computeFilterInfo = true;
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace("createCBEvent filterRouting={} computeFilterInfo={} local routing={}", (Object)filterRoutingInfo, (Object)computeFilterInfo, (Object)localRouting);
            }
            if (re.isUsedForPartitionedRegionBucket()) {
                BucketRegion bucket = (BucketRegion)re;
                if (BucketRegion.FORCE_LOCAL_LISTENERS_INVOCATION || bucket.getBucketAdvisor().isPrimary()) {
                    retVal.setInvokePRCallbacks(true);
                } else {
                    retVal.setInvokePRCallbacks(false);
                }
                if (computeFilterInfo && bucket.getBucketAdvisor().isPrimary()) {
                    FilterRoutingInfo fri;
                    FilterProfile fp;
                    if (logger.isTraceEnabled()) {
                        logger.trace("createCBEvent computing routing for primary bucket");
                    }
                    if ((fp = ((BucketRegion)re).getPartitionedRegion().getFilterProfile()) != null && (fri = fp.getFilterRoutingInfoPart2(filterRoutingInfo, retVal)) != null) {
                        retVal.setLocalFilterInfo(fri.getLocalFilterInfo());
                    }
                }
            } else if (computeFilterInfo) {
                FilterProfile fp;
                if (logger.isTraceEnabled()) {
                    logger.trace("createCBEvent computing routing for non-bucket");
                }
                if ((fp = re.getFilterProfile()) != null) {
                    retVal.setLocalFilterInfo(fp.getLocalFilterRouting(retVal));
                }
            }
            retVal.setTransactionId(txId);
            returnedRetVal = true;
            EntryEventImpl entryEventImpl = retVal;
            return entryEventImpl;
        }
        finally {
            if (!returnedRetVal) {
                retVal.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void writeSyncIfPresent(Object key, Runnable runner) {
        RegionEntry re = this.getEntry(key);
        if (re != null) {
            boolean disabled = this.disableLruUpdateCallback();
            try {
                RegionEntry regionEntry = re;
                synchronized (regionEntry) {
                    if (!re.isRemoved()) {
                        runner.run();
                    }
                }
            }
            finally {
                if (disabled) {
                    this.enableLruUpdateCallback();
                }
                try {
                    this.lruUpdateCallback();
                }
                catch (DiskAccessException dae) {
                    this._getOwner().handleDiskAccessException(dae);
                    throw dae;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeIfDestroyed(Object key) {
        LocalRegion owner = this._getOwner();
        DiskRegion dr = owner.getDiskRegion();
        RegionEntry re = this.getEntry(key);
        if (re != null && re.isDestroyed()) {
            RegionEntry regionEntry = re;
            synchronized (regionEntry) {
                if (re.isDestroyed()) {
                    re.removePhase2();
                    this.removeEntry(key, re, true);
                }
            }
        }
    }

    void lockForCacheModification(LocalRegion owner, EntryEventImpl event) {
        RegionVersionVector vector;
        boolean lockedByBulkOp;
        boolean bl = lockedByBulkOp = event.isBulkOpInProgress() && owner.dataPolicy.withReplication();
        if (this.armLockTestHook != null) {
            this.armLockTestHook.beforeLock(owner, event);
        }
        if (!(event.isOriginRemote() || lockedByBulkOp || owner.hasServerProxy() || (vector = owner.getVersionVector()) == null)) {
            vector.lockForCacheModification();
        }
        if (this.armLockTestHook != null) {
            this.armLockTestHook.afterLock(owner, event);
        }
    }

    void releaseCacheModificationLock(LocalRegion owner, EntryEventImpl event) {
        RegionVersionVector vector;
        boolean lockedByBulkOp;
        boolean bl = lockedByBulkOp = event.isBulkOpInProgress() && owner.dataPolicy.withReplication();
        if (this.armLockTestHook != null) {
            this.armLockTestHook.beforeRelease(owner, event);
        }
        if (!(event.isOriginRemote() || lockedByBulkOp || owner.hasServerProxy() || (vector = owner.getVersionVector()) == null)) {
            vector.releaseCacheModificationLock();
        }
        if (this.armLockTestHook != null) {
            this.armLockTestHook.afterRelease(owner, event);
        }
    }

    @Override
    public void lockRegionForAtomicTX(LocalRegion r) {
        RegionVersionVector vector;
        if (this.armLockTestHook != null) {
            this.armLockTestHook.beforeLock(r, null);
        }
        if ((vector = r.getVersionVector()) != null) {
            vector.lockForCacheModification();
        }
        if (this.armLockTestHook != null) {
            this.armLockTestHook.afterLock(r, null);
        }
    }

    @Override
    public void unlockRegionForAtomicTX(LocalRegion r) {
        RegionVersionVector vector;
        if (this.armLockTestHook != null) {
            this.armLockTestHook.beforeRelease(r, null);
        }
        if ((vector = r.getVersionVector()) != null) {
            vector.releaseCacheModificationLock();
        }
        if (this.armLockTestHook != null) {
            this.armLockTestHook.afterRelease(r, null);
        }
    }

    protected final RegionEntry putEntryIfAbsentForTest(RegionEntry entry) {
        return this.putEntryIfAbsent(entry.getKey(), entry);
    }

    @Override
    public boolean isTombstoneNotNeeded(RegionEntry re, int destroyedVersion) {
        if (this.getEntry(re.getKey()) != re) {
            return true;
        }
        if (!re.isTombstone()) {
            return true;
        }
        VersionStamp vs = re.getVersionStamp();
        if (vs == null) {
            logger.error("Unexpected RegionEntry scheduled as tombstone: re.getClass {} destroyedVersion {}", (Object)re.getClass(), (Object)destroyedVersion);
            return true;
        }
        return vs.getEntryVersion() != destroyedVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean removeTombstone(RegionEntry re, VersionHolder version, boolean isEviction, boolean isScheduledTombstone) {
        boolean result = false;
        int destroyedVersion = version.getEntryVersion();
        Object object = this._getOwner().getSizeGuard();
        synchronized (object) {
            RegionEntry regionEntry = re;
            synchronized (regionEntry) {
                int entryVersion = re.getVersionStamp().getEntryVersion();
                if (!re.isTombstone() || entryVersion > destroyedVersion) {
                    if (logger.isTraceEnabled(LogMarker.TOMBSTONE_COUNT)) {
                        logger.trace(LogMarker.TOMBSTONE_COUNT, "tombstone for {} was resurrected with v{}; destroyed version was v{}; count is {}; entryMap size is {}", re.getKey(), (Object)re.getVersionStamp().getEntryVersion(), (Object)destroyedVersion, (Object)this._getOwner().getTombstoneCount(), (Object)this.size());
                    }
                } else {
                    if (logger.isTraceEnabled(LogMarker.TOMBSTONE_COUNT)) {
                        if (entryVersion == destroyedVersion) {
                            logger.trace(LogMarker.TOMBSTONE_COUNT, "removing tombstone for {} with v{} rv{}; count is {}", re.getKey(), (Object)destroyedVersion, (Object)version.getRegionVersion(), (Object)(this._getOwner().getTombstoneCount() - 1));
                        } else {
                            logger.trace(LogMarker.TOMBSTONE_COUNT, "removing entry (v{}) that is older than an expiring tombstone (v{} rv{}) for {}", (Object)entryVersion, (Object)destroyedVersion, (Object)version.getRegionVersion(), re.getKey());
                        }
                    }
                    try {
                        re.setValue(this._getOwner(), Token.REMOVED_PHASE2);
                        if (this.removeTombstone(re)) {
                            RegionVersionVector vector;
                            this._getOwner().cancelExpiryTask(re);
                            result = true;
                            this.incEntryCount(-1);
                            if (isScheduledTombstone) {
                                this._getOwner().incTombstoneCount(-1);
                            }
                            if ((vector = this._getOwner().getVersionVector()) != null) {
                                vector.recordGCVersion(version.getMemberID(), version.getRegionVersion());
                            }
                        }
                    }
                    catch (RegionClearedException regionClearedException) {
                    }
                    catch (RegionDestroyedException regionDestroyedException) {
                        // empty catch block
                    }
                }
            }
        }
        return result;
    }

    protected boolean removeTombstone(RegionEntry re) {
        return this._getMap().remove(re.getKey(), re);
    }

    public boolean verifyTombstoneCount(AtomicInteger numTombstones) {
        int deadEntries = 0;
        try {
            for (RegionEntry regionEntry : this._getMap().values()) {
                if (!regionEntry.isTombstone()) continue;
                ++deadEntries;
            }
            if (deadEntries != numTombstones.get()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("tombstone count ({}) does not match actual number of tombstones ({})", (Object)numTombstones, (Object)deadEntries, (Object)new Exception());
                }
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("tombstone count verified");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public ARMLockTestHook getARMLockTestHook() {
        return this.armLockTestHook;
    }

    public void setARMLockTestHook(ARMLockTestHook theHook) {
        this.armLockTestHook = theHook;
    }

    public static interface ARMLockTestHook {
        public void beforeBulkLock(LocalRegion var1);

        public void afterBulkLock(LocalRegion var1);

        public void beforeBulkRelease(LocalRegion var1);

        public void afterBulkRelease(LocalRegion var1);

        public void beforeLock(LocalRegion var1, CacheEvent var2);

        public void afterLock(LocalRegion var1, CacheEvent var2);

        public void beforeRelease(LocalRegion var1, CacheEvent var2);

        public void afterRelease(LocalRegion var1, CacheEvent var2);

        public void beforeStateFlushWait();
    }
}

