/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.admin.remote.AdminResponse;

public final class VersionInfoResponse
extends AdminResponse {
    private String verInfo;

    public static VersionInfoResponse create(DistributionManager dm, InternalDistributedMember recipient) {
        VersionInfoResponse m = new VersionInfoResponse();
        m.setRecipient(recipient);
        m.verInfo = GemFireVersion.asString();
        return m;
    }

    public String getVersionInfo() {
        return this.verInfo;
    }

    @Override
    public int getDSFID() {
        return 1064;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString(this.verInfo, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.verInfo = DataSerializer.readString(in);
    }

    @Override
    public String toString() {
        return "VersionInfoResponse from " + this.getSender();
    }
}

