/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.Instantiator;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.SerialDistributionMessage;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.PoolManagerImpl;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheServerHelper;
import org.apache.geode.internal.cache.tier.sockets.ClientInstantiatorMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;

public class InternalInstantiator {
    private static final Logger logger = LogService.getLogger();
    private static final ConcurrentMap dsMap = new ConcurrentHashMap();
    private static final ConcurrentMap idsToInstantiators = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, InstantiatorAttributesHolder> classNamesToHolders = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Integer, InstantiatorAttributesHolder> idsToHolders = new ConcurrentHashMap();
    private static final String SERVER_CONNECTION_THREAD = "ServerConnection";

    public static void register(Instantiator instantiator, boolean distribute) {
        if (!distribute || InternalInstantiator.checkForThread()) {
            InternalInstantiator._register(instantiator, distribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _register(Instantiator instantiator, boolean distribute) {
        if (instantiator == null) {
            throw new NullPointerException(LocalizedStrings.InternalInstantiator_CANNOT_REGISTER_A_NULL_INSTANTIATOR.toLocalizedString());
        }
        int classId = instantiator.getId();
        if (classId == 0) {
            throw new IllegalArgumentException(LocalizedStrings.Instantiator_INSTANTIATOR_ID_CANNOT_BE_ZERO.toLocalizedString());
        }
        Class<? extends DataSerializable> c = instantiator.getInstantiatedClass();
        String cName = c.getName();
        int oldId = InternalInstantiator.getClassId(c);
        if (oldId != 0 && oldId != classId) {
            throw new IllegalStateException(LocalizedStrings.InternalInstantiator_CLASS_0_IS_ALREADY_REGISTERED_WITH_ID_1_SO_IT_CANNOT_BE_REGISTERED_WTH_ID_2.toLocalizedString(c.getName(), oldId, classId));
        }
        Integer idx = classId;
        Class<InternalInstantiator> clazz = InternalInstantiator.class;
        synchronized (InternalInstantiator.class) {
            boolean retry;
            do {
                retry = false;
                Instantiator oldInst = idsToInstantiators.putIfAbsent(idx, instantiator);
                if (oldInst != null) {
                    if (oldInst instanceof Marker) {
                        boolean bl = retry = !idsToInstantiators.replace(idx, oldInst, instantiator);
                        if (retry) continue;
                        dsMap.put(cName, instantiator);
                        ((Marker)((Object)oldInst)).setInstantiator(instantiator);
                        continue;
                    }
                    Class<? extends DataSerializable> oldClass = oldInst.getInstantiatedClass();
                    if (!oldClass.getName().equals(cName)) {
                        throw new IllegalStateException(LocalizedStrings.InternalInstantiator_CLASS_ID_0_IS_ALREADY_REGISTERED_FOR_CLASS_1_SO_IT_COULD_NOT_BE_REGISTED_FOR_CLASS_2.toLocalizedString(classId, oldClass.getName(), cName));
                    }
                    // ** MonitorExit[var6_7] (shouldn't be in output)
                    return;
                }
                dsMap.put(cName, instantiator);
            } while (retry);
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            if (cache != null && instantiator.getEventId() == null) {
                instantiator.setEventId(new EventID(cache.getDistributedSystem()));
            }
            logger.info(LocalizedMessage.create(LocalizedStrings.InternalInstantiator_REGISTERED, new Object[]{classId, c.getName()}));
            // ** MonitorExit[var6_7] (shouldn't be in output)
            if (distribute) {
                InternalInstantiator.sendRegistrationMessage(instantiator);
                InternalInstantiator.sendRegistrationMessageToServers(instantiator);
            }
            InternalInstantiator.sendRegistrationMessageToClients(instantiator);
            InternalDataSerializer.fireNewInstantiator(instantiator);
            return;
        }
    }

    private static boolean checkForThread() {
        String name = Thread.currentThread().getName();
        return !name.startsWith("Cache Client Updater Thread ") && !name.startsWith(SERVER_CONNECTION_THREAD);
    }

    public static EventID generateEventId() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache == null) {
            return null;
        }
        return new EventID(InternalDistributedSystem.getAnyInstance());
    }

    private static void sendRegistrationMessageToServers(Instantiator instantiator) {
        PoolManagerImpl.allPoolsRegisterInstantiator(instantiator);
    }

    private static void sendRegistrationMessageToServers(InstantiatorAttributesHolder holder) {
        PoolManagerImpl.allPoolsRegisterInstantiator(holder);
    }

    private static void sendRegistrationMessageToClients(Instantiator instantiator) {
        byte[][] serializedInstantiators;
        block3: {
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            if (cache == null) {
                return;
            }
            serializedInstantiators = new byte[3][];
            try {
                serializedInstantiators[0] = CacheServerHelper.serialize(instantiator.getClass().toString().substring(6));
                serializedInstantiators[1] = CacheServerHelper.serialize(instantiator.getInstantiatedClass().toString().substring(6));
                byte[] idBytes = new byte[4];
                Part.encodeInt(instantiator.getId(), idBytes);
                serializedInstantiators[2] = idBytes;
            }
            catch (IOException e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("IOException encountered while serializing instantiators using CacheServerHelper.serialize() method");
            }
        }
        ClientInstantiatorMessage clientInstantiatorMessage = new ClientInstantiatorMessage(EnumListenerEvent.AFTER_REGISTER_INSTANTIATOR, serializedInstantiators, (ClientProxyMembershipID)instantiator.getContext(), (EventID)instantiator.getEventId());
        CacheClientNotifier.routeClientMessage(clientInstantiatorMessage);
    }

    public static void register(Class instantiatorClass, Class instantiatedClass, int id, boolean distribute) {
        if (InternalInstantiator.checkForThread()) {
            Instantiator inst = InternalInstantiator.newInstance(instantiatorClass, instantiatedClass, id);
            InternalInstantiator._register(inst, distribute);
        }
    }

    public static void register(Class instantiatorClass, Class instantiatedClass, int id, boolean distribute, EventID eventId, ClientProxyMembershipID context) {
        Instantiator inst = InternalInstantiator.newInstance(instantiatorClass, instantiatedClass, id);
        inst.setEventId(eventId);
        inst.setContext(context);
        InternalInstantiator._register(inst, distribute);
    }

    public static void register(String instantiatorClass, String instantiatedClass, int id, boolean distribute) {
        if (InternalInstantiator.checkForThread()) {
            InternalInstantiator.register(instantiatorClass, new InstantiatorAttributesHolder(instantiatorClass, instantiatedClass, id), distribute);
        }
    }

    public static void register(String instantiatorClass, String instantiatedClass, int id, boolean distribute, EventID eventId, ClientProxyMembershipID context) {
        InternalInstantiator.register(instantiatorClass, new InstantiatorAttributesHolder(instantiatorClass, instantiatedClass, id, eventId, context), distribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void register(String instantiatorClassName, InstantiatorAttributesHolder holder, boolean distribute) {
        Object inst = null;
        Class<InternalInstantiator> clazz = InternalInstantiator.class;
        synchronized (InternalInstantiator.class) {
            Class<?> instantiatedClass;
            Class<?> instantiatorClass;
            block17: {
                inst = idsToInstantiators.get(holder.getId());
                if (inst == null) {
                    if (instantiatorClassName == null || instantiatorClassName.trim().equals("")) {
                        throw new IllegalArgumentException("Instantiator class name cannot be null or empty.");
                    }
                    if (holder.getId() == 0) {
                        throw new IllegalArgumentException(LocalizedStrings.Instantiator_INSTANTIATOR_ID_CANNOT_BE_ZERO.toLocalizedString());
                    }
                    InstantiatorAttributesHolder iah = classNamesToHolders.putIfAbsent(holder.getInstantiatedClassName(), holder);
                    if (iah != null && iah.getId() != holder.getId()) {
                        throw new IllegalStateException(LocalizedStrings.InternalInstantiator_CLASS_0_IS_ALREADY_REGISTERED_WITH_ID_1_SO_IT_CANNOT_BE_REGISTERED_WTH_ID_2.toLocalizedString(instantiatorClassName, iah.getId(), holder.getId()));
                    }
                    idsToHolders.putIfAbsent(holder.getId(), holder);
                    logger.info(LocalizedMessage.create(LocalizedStrings.InternalInstantiator_REGISTERED_HOLDER, new Object[]{holder.getId(), holder.getInstantiatedClassName()}));
                    if (!distribute) return;
                    InternalInstantiator.sendRegistrationMessageToServers(holder);
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                if (!(inst instanceof Marker)) return;
                instantiatorClass = null;
                instantiatedClass = null;
                try {
                    instantiatorClass = InternalDataSerializer.getCachedClass(holder.getInstantiatorClassName());
                    instantiatedClass = InternalDataSerializer.getCachedClass(holder.getInstantiatedClassName());
                }
                catch (ClassNotFoundException cnfe) {
                    GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                    if (cache == null || cache.getLoggerI18n() == null || !cache.getLoggerI18n().infoEnabled()) break block17;
                    cache.getLoggerI18n().info(LocalizedStrings.InternalInstantiator_COULD_NOT_LOAD_INSTANTIATOR_CLASS_0, new Object[]{cnfe.getMessage()});
                }
            }
            Class<InternalInstantiator> clazz2 = InternalInstantiator.class;
            synchronized (InternalInstantiator.class) {
                Object inst2 = idsToInstantiators.get(holder.getId());
                if (inst2 == inst) {
                    InternalInstantiator.register(instantiatorClass, instantiatedClass, holder.getId(), distribute, holder.getEventId(), holder.getContext());
                } else {
                    if (inst2 != null && !(inst2 instanceof Marker)) return;
                    InternalInstantiator.register(instantiatorClassName, holder, distribute);
                }
                // ** MonitorExit[var6_9] (shouldn't be in output)
                return;
            }
        }
    }

    public static synchronized void unregister(Class c, int classId) {
        if (c == null) {
            throw new NullPointerException(LocalizedStrings.InternalInstantiator_CANNOT_UNREGISTER_A_NULL_CLASS.toLocalizedString());
        }
        Integer idx = classId;
        Instantiator i = (Instantiator)idsToInstantiators.remove(idx);
        if (i == null) {
            throw new IllegalArgumentException(LocalizedStrings.InternalInstantiator_CLASS_0_WAS_NOT_REGISTERED_WITH_ID_1.toLocalizedString(c.getName(), classId));
        }
        dsMap.remove(c.getName(), i);
        idsToHolders.remove(idx);
        classNamesToHolders.remove(i.getInstantiatedClass().getName());
    }

    public static void reinitialize() {
        idsToInstantiators.clear();
        dsMap.clear();
        idsToHolders.clear();
        classNamesToHolders.clear();
    }

    public static int getClassId(Class c) {
        int result = 0;
        Instantiator i = (Instantiator)dsMap.get(c.getName());
        if (i != null) {
            result = i.getId();
        } else {
            InstantiatorAttributesHolder iah = classNamesToHolders.get(c.getName());
            if (iah != null) {
                result = iah.getId();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Instantiator getInstantiator(int classId) {
        Marker marker;
        boolean retry;
        Integer idx = classId;
        Object v = idsToInstantiators.get(idx);
        do {
            void var4_3;
            retry = false;
            if (var4_3 == null) {
                marker = new Marker();
                Marker marker2 = idsToInstantiators.putIfAbsent(idx, marker);
                retry = marker2 != null;
                continue;
            }
            if (!(var4_3 instanceof Marker)) return (Instantiator)var4_3;
            marker = (Marker)var4_3;
        } while (retry);
        Instantiator instantiator = null;
        if (idsToHolders.get(classId) == null) {
            instantiator = marker.getInstantiator();
        }
        if (instantiator != null) {
            return instantiator;
        }
        InstantiatorAttributesHolder holder = idsToHolders.get(classId);
        if (holder == null) return instantiator;
        try {
            Class<?> instantiatorClass = InternalDataSerializer.getCachedClass(holder.getInstantiatorClassName());
            Class<?> instantiatedClass = InternalDataSerializer.getCachedClass(holder.getInstantiatedClassName());
            Class<InternalInstantiator> clazz = InternalInstantiator.class;
            synchronized (InternalInstantiator.class) {
                InternalInstantiator.register(instantiatorClass, instantiatedClass, holder.getId(), false, holder.getEventId(), holder.getContext());
                classNamesToHolders.remove(holder.getInstantiatedClassName());
                idsToHolders.remove(classId);
                return (Instantiator)idsToInstantiators.get(classId);
            }
        }
        catch (ClassNotFoundException cnfe) {
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            if (cache == null) return instantiator;
            if (cache.getLoggerI18n() == null) return instantiator;
            if (!cache.getLoggerI18n().infoEnabled()) return instantiator;
            cache.getLoggerI18n().info(LocalizedStrings.InternalInstantiator_COULD_NOT_LOAD_INSTANTIATOR_CLASS_0, new Object[]{cnfe.getMessage()});
        }
        return instantiator;
    }

    private static void sendRegistrationMessage(Instantiator s) {
        InternalDistributedSystem system = InternalDistributedSystem.getAnyInstance();
        if (system != null) {
            RegistrationMessage m = null;
            m = s.getContext() == null ? new RegistrationMessage(s) : new RegistrationContextMessage(s);
            system.getDistributionManager().putOutgoing(m);
        }
    }

    protected static Instantiator newInstance(Class instantiatorClass, Class instantiatedClass, int id) {
        Instantiator s;
        Constructor init;
        if (!Instantiator.class.isAssignableFrom(instantiatorClass)) {
            throw new IllegalArgumentException(LocalizedStrings.InternalInstantiator_0_DOES_NOT_EXTEND_INSTANTIATOR.toLocalizedString(instantiatorClass.getName()));
        }
        boolean intConstructor = false;
        try {
            Class[] types = new Class[]{Class.class, Integer.TYPE};
            init = instantiatorClass.getDeclaredConstructor(types);
            intConstructor = true;
        }
        catch (NoSuchMethodException ex) {
            try {
                Class[] types = new Class[]{Class.class, Byte.TYPE};
                init = instantiatorClass.getDeclaredConstructor(types);
            }
            catch (NoSuchMethodException ex2) {
                StringId msg = LocalizedStrings.InternalInstantiator_CLASS_0_DOES_NOT_HAVE_A_TWOARGUMENT_CLASS_INT_CONSTRUCTOR;
                Object[] msgArgs = new Object[]{instantiatorClass.getName()};
                if (instantiatorClass.getDeclaringClass() != null) {
                    msg = LocalizedStrings.InternalInstantiator_CLASS_0_DOES_NOT_HAVE_A_TWOARGUMENT_CLASS_INT_CONSTRUCTOR_IT_IS_AN_INNER_CLASS_OF_1_SHOULD_IT_BE_A_STATIC_INNER_CLASS;
                    msgArgs = new Object[]{instantiatorClass.getName(), instantiatorClass.getDeclaringClass()};
                }
                throw new IllegalArgumentException(msg.toLocalizedString(msgArgs));
            }
        }
        try {
            init.setAccessible(true);
            Object[] args = new Object[]{instantiatedClass, intConstructor ? (Number)id : (Number)((byte)id)};
            s = (Instantiator)init.newInstance(args);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(LocalizedStrings.InternalInstantiator_COULD_NOT_ACCESS_ZEROARGUMENT_CONSTRUCTOR_OF_0.toLocalizedString(instantiatorClass.getName()));
        }
        catch (InstantiationException ex) {
            IllegalArgumentException ex2 = new IllegalArgumentException(LocalizedStrings.InternalInstantiator_COULD_NOT_INSTANTIATE_AN_INSTANCE_OF_0.toLocalizedString(instantiatorClass.getName()));
            ex2.initCause(ex);
            throw ex2;
        }
        catch (InvocationTargetException ex) {
            IllegalArgumentException ex2 = new IllegalArgumentException(LocalizedStrings.InternalInstantiator_WHILE_INSTANTIATING_AN_INSTANCE_OF_0.toLocalizedString(instantiatorClass.getName()));
            ex2.initCause(ex);
            throw ex2;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Instantiator[] getInstantiators() {
        ArrayList coll = new ArrayList();
        if (!classNamesToHolders.isEmpty()) {
            Iterator<InstantiatorAttributesHolder> it = classNamesToHolders.values().iterator();
            while (it.hasNext()) {
                try {
                    InstantiatorAttributesHolder holder = it.next();
                    Class<?> instantiatorClass = InternalDataSerializer.getCachedClass(holder.getInstantiatorClassName());
                    Class<?> instantiatedClass = InternalDataSerializer.getCachedClass(holder.getInstantiatedClassName());
                    Class<InternalInstantiator> clazz = InternalInstantiator.class;
                    // MONITORENTER : org.apache.geode.internal.InternalInstantiator.class
                    if (!idsToInstantiators.containsKey(holder.getId())) {
                        InternalInstantiator.register(instantiatorClass, instantiatedClass, holder.getId(), false, holder.getEventId(), holder.getContext());
                    }
                    classNamesToHolders.remove(holder.getInstantiatedClassName());
                    idsToHolders.remove(holder.getId());
                    // MONITOREXIT : clazz
                }
                catch (ClassNotFoundException cnfe) {
                    GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                    if (cache == null || cache.getLoggerI18n() == null || !cache.getLoggerI18n().infoEnabled()) continue;
                    cache.getLoggerI18n().info(LocalizedStrings.InternalInstantiator_COULD_NOT_LOAD_INSTANTIATOR_CLASS_0, new Object[]{cnfe.getMessage()});
                }
            }
        }
        coll.addAll(dsMap.values());
        return coll.toArray(new Instantiator[coll.size()]);
    }

    public static Object[] getInstantiatorsForSerialization() {
        ArrayList<Object> coll = new ArrayList<Object>(dsMap.size() + idsToHolders.size());
        coll.addAll(dsMap.values());
        coll.addAll(classNamesToHolders.values());
        return coll.toArray(new Object[coll.size()]);
    }

    public static int getIdsToHoldersSize() {
        return idsToHolders.size();
    }

    public static int getNamesToHoldersSize() {
        return classNamesToHolders.size();
    }

    public static void saveRegistrations(DataOutput out) throws IOException {
        for (Instantiator inst : InternalInstantiator.getInstantiators()) {
            out.writeInt(inst.getId());
            DataSerializer.writeClass(inst.getClass(), out);
            DataSerializer.writeClass(inst.getInstantiatedClass(), out);
        }
        out.writeInt(0);
    }

    public static void loadRegistrations(DataInput in) throws IOException {
        int instId;
        while ((instId = in.readInt()) != 0) {
            Class<?> instClass = null;
            Class<?> instantiatedClass = null;
            boolean skip = false;
            try {
                instClass = DataSerializer.readClass(in);
            }
            catch (ClassNotFoundException ex) {
                skip = true;
            }
            try {
                instantiatedClass = DataSerializer.readClass(in);
            }
            catch (ClassNotFoundException ex) {
                skip = true;
            }
            if (skip) continue;
            InternalInstantiator.register(InternalInstantiator.newInstance(instClass, instantiatedClass, instId), true);
        }
    }

    public static void logInstantiators() {
        for (Instantiator instantiator : dsMap.values()) {
            logger.info(LocalizedMessage.create(LocalizedStrings.InternalInstantiator_REGISTERED, new Object[]{instantiator.getId(), instantiator.getInstantiatedClass().getName()}));
        }
        for (InstantiatorAttributesHolder holder : idsToHolders.values()) {
            logger.info(LocalizedMessage.create(LocalizedStrings.InternalInstantiator_REGISTERED_HOLDER, new Object[]{holder.getId(), holder.getInstantiatedClassName()}));
        }
    }

    public static final class RegistrationContextMessage
    extends RegistrationMessage {
        private transient ClientProxyMembershipID context;

        public RegistrationContextMessage() {
        }

        public RegistrationContextMessage(Instantiator s) {
            this.instantiatorClass = s.getClass();
            this.instantiatedClass = s.getInstantiatedClass();
            this.id = s.getId();
            this.eventId = (EventID)s.getEventId();
            this.context = (ClientProxyMembershipID)s.getContext();
        }

        @Override
        protected void process(DistributionManager dm) {
            if (this.fromDataProblems != null && logger.isDebugEnabled()) {
                logger.debug(this.fromDataProblems);
            }
            if (this.instantiatorClass != null && this.instantiatedClass != null) {
                Instantiator s = InternalInstantiator.newInstance(this.instantiatorClass, this.instantiatedClass, this.id);
                s.setEventId(this.eventId);
                s.setContext(this.context);
                InternalInstantiator.register(s, false);
            } else if (this.instantiatorClassName != null && this.instantiatedClassName != null) {
                InternalInstantiator.register(this.instantiatorClassName, this.instantiatedClassName, this.id, false, this.eventId, this.context);
            }
        }

        @Override
        public int getDSFID() {
            return 13;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.context = ClientProxyMembershipID.readCanonicalized(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.context, out);
        }
    }

    public static class RegistrationMessage
    extends SerialDistributionMessage {
        protected Class instantiatorClass;
        protected Class instantiatedClass;
        protected int id;
        protected EventID eventId;
        protected transient StringBuffer fromDataProblems;
        protected String instantiatorClassName;
        protected String instantiatedClassName;

        public RegistrationMessage() {
        }

        public RegistrationMessage(Instantiator s) {
            this.instantiatorClass = s.getClass();
            this.instantiatedClass = s.getInstantiatedClass();
            this.id = s.getId();
            this.eventId = (EventID)s.getEventId();
        }

        @Override
        protected void process(DistributionManager dm) {
            if (this.fromDataProblems != null && logger.isDebugEnabled()) {
                logger.debug(this.fromDataProblems);
            }
            if (this.instantiatorClass != null && this.instantiatedClass != null) {
                Instantiator s = InternalInstantiator.newInstance(this.instantiatorClass, this.instantiatedClass, this.id);
                s.setEventId(this.eventId);
                InternalInstantiator.register(s, false);
            } else if (this.instantiatorClassName != null && this.instantiatedClassName != null) {
                InternalInstantiator.register(this.instantiatorClassName, this.instantiatedClassName, this.id, false, this.eventId, null);
            }
        }

        @Override
        public int getDSFID() {
            return 12;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeNonPrimitiveClassName(this.instantiatorClass.getName(), out);
            DataSerializer.writeNonPrimitiveClassName(this.instantiatedClass.getName(), out);
            out.writeInt(this.id);
            DataSerializer.writeObject(this.eventId, out);
        }

        private void fromDataProblem(String s) {
            if (this.fromDataProblems == null) {
                this.fromDataProblems = new StringBuffer();
            }
            this.fromDataProblems.append(s);
            this.fromDataProblems.append("\n\n");
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.instantiatorClassName = DataSerializer.readNonPrimitiveClassName(in);
            this.instantiatedClassName = DataSerializer.readNonPrimitiveClassName(in);
            if (CacheClientNotifier.getInstance() != null) {
                try {
                    this.instantiatorClass = InternalDataSerializer.getCachedClass(this.instantiatorClassName);
                }
                catch (ClassNotFoundException ex) {
                    this.fromDataProblem(LocalizedStrings.InternalInstantiator_COULD_NOT_LOAD_INSTANTIATOR_CLASS_0.toLocalizedString(ex));
                    this.instantiatorClass = null;
                }
                try {
                    this.instantiatedClass = InternalDataSerializer.getCachedClass(this.instantiatedClassName);
                }
                catch (ClassNotFoundException ex) {
                    this.fromDataProblem(LocalizedStrings.InternalInstantiator_COULD_NOT_LOAD_INSTANTIATED_CLASS_0.toLocalizedString(ex));
                    this.instantiatedClass = null;
                }
            }
            this.id = in.readInt();
            this.eventId = (EventID)DataSerializer.readObject(in);
        }

        @Override
        public String toString() {
            String instatiatorName = this.instantiatorClass == null ? this.instantiatorClassName : this.instantiatorClass.getName();
            String instatiatedName = this.instantiatedClass == null ? this.instantiatedClassName : this.instantiatedClass.getName();
            return LocalizedStrings.InternalInstantiator_REGISTER_INSTANTIATOR_0_OF_CLASS_1_THAT_INSTANTIATES_A_2.toLocalizedString(this.id, instatiatorName, instatiatedName);
        }
    }

    static class Marker {
        private volatile Instantiator instantiator = null;

        Marker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Instantiator getInstantiator() {
            Marker marker = this;
            synchronized (marker) {
                if (this.instantiator == null) {
                    try {
                        this.wait(InternalDataSerializer.GetMarker.WAIT_MS);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                }
                return this.instantiator;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setInstantiator(Instantiator instantiator) {
            Marker marker = this;
            synchronized (marker) {
                this.instantiator = instantiator;
                this.notifyAll();
            }
        }
    }

    public static class InstantiatorAttributesHolder {
        private String instantiatorName;
        private String instantiatedName;
        private int id;
        private EventID eventId;
        private ClientProxyMembershipID context;

        public InstantiatorAttributesHolder(String instantiatorClass, String instantiatedClass, int id) {
            this.instantiatorName = instantiatorClass;
            this.instantiatedName = instantiatedClass;
            this.id = id;
        }

        public InstantiatorAttributesHolder(String instantiatorClass, String instantiatedClass, int id, EventID eventId, ClientProxyMembershipID context) {
            this.instantiatorName = instantiatorClass;
            this.instantiatedName = instantiatedClass;
            this.id = id;
            this.eventId = eventId;
            this.context = context;
        }

        public String getInstantiatorClassName() {
            return this.instantiatorName;
        }

        public String getInstantiatedClassName() {
            return this.instantiatedName;
        }

        public int getId() {
            return this.id;
        }

        public EventID getEventId() {
            return this.eventId;
        }

        public ClientProxyMembershipID getContext() {
            return this.context;
        }

        public String toString() {
            return "InstantiatorAttributesHolder[irName=" + this.instantiatorName + ",idName=" + this.instantiatedName + ",id=" + this.id + (this.eventId != null ? ",this.eventId=" + this.eventId : "") + (this.context != null ? ",this.context=" + this.context : "") + "]";
        }
    }
}

