/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.security.CodeSource;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.SystemFailure;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.SmHelper;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.net.SocketCreator;

public class GemFireVersion {
    private static String RESOURCE_NAME = "GemFireVersion.properties";
    private static VersionDescription description;

    private GemFireVersion() {
    }

    private static synchronized VersionDescription getDescription() {
        if (description == null) {
            String name = GemFireVersion.class.getPackage().getName().replace('.', '/') + "/" + RESOURCE_NAME;
            description = new VersionDescription(name);
        }
        return description;
    }

    public static void main(String[] args) {
        System.out.println(GemFireVersion.asString());
    }

    public static String getProductName() {
        return GemFireVersion.getDescription().getProperty("Product-Name");
    }

    public static String getGemFireVersion() {
        return GemFireVersion.getDescription().getProperty("Product-Version");
    }

    public static String getSourceDate() {
        return GemFireVersion.getDescription().getProperty("Source-Date");
    }

    public static String getSourceRepository() {
        return GemFireVersion.getDescription().getProperty("Source-Repository");
    }

    public static String getSourceRevision() {
        return GemFireVersion.getDescription().getProperty("Source-Revision");
    }

    public static String getBuildId() {
        return GemFireVersion.getDescription().getProperty("Build-Id");
    }

    public static String getBuildDate() {
        return GemFireVersion.getDescription().getProperty("Build-Date");
    }

    public static String getBuildPlatform() {
        return GemFireVersion.getDescription().getProperty("Build-Platform");
    }

    public static String getBuildJavaVersion() {
        return GemFireVersion.getDescription().getProperty("Build-Java-Version");
    }

    public static String getGemFireJarFileName() {
        return "geode-core-" + GemFireVersion.getGemFireVersion() + ".jar";
    }

    public static void print(PrintWriter pw) {
        GemFireVersion.getDescription().print(pw);
    }

    public static void print(PrintStream ps) {
        GemFireVersion.print(new PrintWriter(ps, true));
    }

    public static String asString() {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter(sw);
        GemFireVersion.print(pw);
        pw.flush();
        return sw.toString();
    }

    public static URL getJarURL() {
        File gemfireJar;
        String jar;
        CodeSource cs = GemFireVersion.class.getProtectionDomain().getCodeSource();
        if (cs != null) {
            return cs.getLocation();
        }
        URL csLoc = null;
        StringTokenizer tokenizer = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            jar = tokenizer.nextToken();
            if (jar.indexOf(GemFireVersion.getGemFireJarFileName()) == -1) continue;
            gemfireJar = new File(jar);
            try {
                csLoc = gemfireJar.toURL();
            }
            catch (Exception exception) {}
            break;
        }
        if (csLoc != null) {
            return csLoc;
        }
        tokenizer = new StringTokenizer(System.getProperty("sun.boot.class.path"), File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            jar = tokenizer.nextToken();
            if (jar.indexOf(GemFireVersion.getGemFireJarFileName()) == -1) continue;
            gemfireJar = new File(jar);
            try {
                csLoc = gemfireJar.toURL();
            }
            catch (Exception exception) {}
            break;
        }
        return csLoc;
    }

    static class VersionDescription {
        static final String PRODUCT_NAME = "Product-Name";
        static final String GEMFIRE_VERSION = "Product-Version";
        static final String SOURCE_DATE = "Source-Date";
        static final String SOURCE_REVISION = "Source-Revision";
        static final String SOURCE_REPOSITORY = "Source-Repository";
        static final String BUILD_DATE = "Build-Date";
        static final String BUILD_ID = "Build-Id";
        static final String BUILD_PLATFORM = "Build-Platform";
        static final String BUILD_JAVA_VERSION = "Build-Java-Version";
        private final Properties description;
        private final Optional<String> error;

        public VersionDescription(String name) {
            InputStream is = ClassPathLoader.getLatest().getResourceAsStream(this.getClass(), name);
            if (is == null) {
                this.error = Optional.of(LocalizedStrings.GemFireVersion_COULD_NOT_FIND_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_0.toLocalizedString(name));
                this.description = null;
                return;
            }
            this.description = new Properties();
            try {
                this.description.load(is);
            }
            catch (Exception ex) {
                this.error = Optional.of(LocalizedStrings.GemFireVersion_COULD_NOT_READ_PROPERTIES_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_0_BECAUSE_1.toLocalizedString(name, ex));
                return;
            }
            this.error = this.validate(this.description);
        }

        public String getProperty(String key) {
            return this.error.orElseGet(() -> this.description.getProperty(key));
        }

        public String getNativeCodeVersion() {
            return SmHelper.getNativeVersion();
        }

        void print(PrintWriter pw) {
            if (this.error.isPresent()) {
                pw.println(this.error.get());
            } else {
                for (Map.Entry<Object, Object> props : new TreeMap<Object, Object>(this.description).entrySet()) {
                    pw.println(props.getKey() + ": " + props.getValue());
                }
            }
            pw.println("Native version: " + this.getNativeCodeVersion());
            this.printHostInfo(pw);
        }

        private void printHostInfo(PrintWriter pw) throws InternalGemFireError, Error, VirtualMachineError {
            try {
                StringBuffer sb = new StringBuffer(SocketCreator.getLocalHost().toString()).append(", ").append(Runtime.getRuntime().availableProcessors()).append(" cpu(s), ").append(System.getProperty("os.arch")).append(' ').append(System.getProperty("os.name")).append(' ').append(System.getProperty("os.version")).append(' ');
                pw.println(LocalizedStrings.GemFireVersion_RUNNING_ON_0.toLocalizedString(sb.toString()));
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
            }
        }

        private Optional<String> validate(Properties props) {
            if (props.get(PRODUCT_NAME) == null) {
                return Optional.of(LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(PRODUCT_NAME, RESOURCE_NAME));
            }
            if (props.get(GEMFIRE_VERSION) == null) {
                return Optional.of(LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(GEMFIRE_VERSION, RESOURCE_NAME));
            }
            if (props.get(SOURCE_DATE) == null) {
                return Optional.of(LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(SOURCE_DATE, RESOURCE_NAME));
            }
            if (props.get(SOURCE_REVISION) == null) {
                return Optional.of(LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(SOURCE_REVISION, RESOURCE_NAME));
            }
            if (props.get(SOURCE_REPOSITORY) == null) {
                return Optional.of(LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(SOURCE_REPOSITORY, RESOURCE_NAME));
            }
            if (props.get(BUILD_DATE) == null) {
                return Optional.of(LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(BUILD_DATE, RESOURCE_NAME));
            }
            if (props.get(BUILD_ID) == null) {
                return Optional.of(LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(BUILD_ID, RESOURCE_NAME));
            }
            if (props.get(BUILD_PLATFORM) == null) {
                return Optional.of(LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(BUILD_PLATFORM, RESOURCE_NAME));
            }
            if (props.get(BUILD_JAVA_VERSION) == null) {
                return Optional.of(LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(BUILD_JAVA_VERSION, RESOURCE_NAME));
            }
            return Optional.empty();
        }
    }
}

