/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.locator;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.gms.locator.PeerLocatorRequest;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Version;

public class FindCoordinatorRequest
extends HighPriorityDistributionMessage
implements PeerLocatorRequest {
    private InternalDistributedMember memberID;
    private Collection<InternalDistributedMember> rejectedCoordinators;
    private int lastViewId;
    private byte[] myPublicKey;
    private int requestId;
    private String dhalgo;

    public FindCoordinatorRequest(InternalDistributedMember myId) {
        this.memberID = myId;
        this.dhalgo = "";
    }

    public FindCoordinatorRequest(InternalDistributedMember myId, Collection<InternalDistributedMember> rejectedCoordinators, int lastViewId, byte[] pk, int requestId, String dhalgo) {
        this.memberID = myId;
        this.rejectedCoordinators = rejectedCoordinators;
        this.lastViewId = lastViewId;
        this.myPublicKey = pk;
        this.requestId = requestId;
        this.dhalgo = dhalgo;
    }

    public FindCoordinatorRequest() {
    }

    public InternalDistributedMember getMemberID() {
        return this.memberID;
    }

    public byte[] getMyPublicKey() {
        return this.myPublicKey;
    }

    public String getDHAlgo() {
        return this.dhalgo;
    }

    public Collection<InternalDistributedMember> getRejectedCoordinators() {
        return this.rejectedCoordinators;
    }

    public int getLastViewId() {
        return this.lastViewId;
    }

    @Override
    public String toString() {
        if (this.rejectedCoordinators != null) {
            return "FindCoordinatorRequest(memberID=" + this.memberID + ", rejected=" + this.rejectedCoordinators + ", lastViewId=" + this.lastViewId + ")";
        }
        return "FindCoordinatorRequest(memberID=" + this.memberID + ")";
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public int getDSFID() {
        return -145;
    }

    public int getRequestId() {
        return this.requestId;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject(this.memberID, out);
        if (this.rejectedCoordinators != null) {
            out.writeInt(this.rejectedCoordinators.size());
            for (InternalDistributedMember mbr : this.rejectedCoordinators) {
                DataSerializer.writeObject(mbr, out);
            }
        } else {
            out.writeInt(0);
        }
        out.writeInt(this.lastViewId);
        out.writeInt(this.requestId);
        InternalDataSerializer.writeString(this.dhalgo, out);
        InternalDataSerializer.writeByteArray(this.myPublicKey, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.memberID = (InternalDistributedMember)DataSerializer.readObject(in);
        int size = in.readInt();
        this.rejectedCoordinators = new ArrayList<InternalDistributedMember>(size);
        for (int i = 0; i < size; ++i) {
            this.rejectedCoordinators.add((InternalDistributedMember)DataSerializer.readObject(in));
        }
        this.lastViewId = in.readInt();
        this.requestId = in.readInt();
        this.dhalgo = InternalDataSerializer.readString(in);
        this.myPublicKey = InternalDataSerializer.readByteArray(in);
    }

    @Override
    protected void process(DistributionManager dm) {
        throw new IllegalStateException("this message should not be executed");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.lastViewId;
        result = 31 * result + (this.dhalgo == null ? 0 : this.dhalgo.hashCode());
        result = 31 * result + (this.memberID == null ? 0 : this.memberID.hashCode());
        result = 31 * result + (this.rejectedCoordinators == null ? 0 : this.rejectedCoordinators.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FindCoordinatorRequest other = (FindCoordinatorRequest)obj;
        if (this.lastViewId != other.lastViewId) {
            return false;
        }
        if (!this.dhalgo.equals(other.dhalgo)) {
            return false;
        }
        if (this.memberID == null ? other.memberID != null : !this.memberID.equals(other.memberID)) {
            return false;
        }
        return !(this.rejectedCoordinators == null ? other.rejectedCoordinators != null : !this.rejectedCoordinators.equals(other.rejectedCoordinators));
    }
}

