/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.util.Collection;
import java.util.Set;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.i18n.LogWriterI18n;

public class StartupMessageReplyProcessor
extends ReplyProcessor21 {
    private boolean receivedRejectionMessage;
    private boolean receivedAcceptance;
    private DM dm;

    public StartupMessageReplyProcessor(DM dm, Set recipients) {
        super(dm, (Collection)recipients);
        this.dm = dm;
    }

    @Override
    protected boolean removeMember(InternalDistributedMember m, boolean departed) {
        boolean result = super.removeMember(m, departed);
        this.dm.removeUnfinishedStartup(m, true);
        return result;
    }

    protected boolean getReceivedRejectionMessage() {
        return this.receivedRejectionMessage;
    }

    protected boolean getReceivedAcceptance() {
        return this.receivedAcceptance;
    }

    protected void setReceivedRejectionMessage(boolean v) {
        this.receivedRejectionMessage = v;
    }

    protected void setReceivedAcceptance(boolean v) {
        this.receivedAcceptance = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void collectUnresponsiveMembers(Set s) {
        InternalDistributedMember[] memberList;
        if (!this.stillWaiting()) return;
        InternalDistributedMember[] internalDistributedMemberArray = memberList = this.getMembers();
        synchronized (memberList) {
            for (int i = 0; i < memberList.length; ++i) {
                InternalDistributedMember m = memberList[i];
                if (m == null) continue;
                s.add(m);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void process(DistributionMessage msg) {
        LogWriterI18n log = this.system.getLogWriter().convertToLogWriterI18n();
        super.process(msg);
        if (log.fineEnabled()) {
            log.fine(this.toString() + " done processing " + msg + " from " + msg.getSender());
        }
    }

    @Override
    protected void preWait() {
        this.waiting = true;
        DM mgr = this.getDistributionManager();
        this.statStart = mgr.getStats().startReplyWait();
        mgr.addMembershipListener(this);
    }
}

