/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.AmbiguousNameException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.CompiledBindArgument;
import org.apache.geode.cache.query.internal.CompiledID;
import org.apache.geode.cache.query.internal.CompiledIndexOperation;
import org.apache.geode.cache.query.internal.CompiledIteratorDef;
import org.apache.geode.cache.query.internal.CompiledOperation;
import org.apache.geode.cache.query.internal.CompiledPath;
import org.apache.geode.cache.query.internal.CompiledRegion;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.QRegion;
import org.apache.geode.cache.query.internal.QScope;
import org.apache.geode.cache.query.internal.QueryUtils;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.Support;
import org.apache.geode.cache.query.internal.index.IndexManager;
import org.apache.geode.cache.query.internal.index.IndexUtils;
import org.apache.geode.cache.query.internal.types.TypeUtils;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.pdx.internal.PdxString;

public class ExecutionContext {
    protected Object[] bindArguments;
    private final Stack scopes = new Stack();
    private final Cache cache;
    private int scopeNum = 0;
    Map dependencyGraph = new HashMap();
    private final Map itrDefToIndpndtRuntimeItrMap = new HashMap();
    private final Map indpndtItrToRgnMap = new HashMap();
    private BucketRegion bukRgn = null;
    private PartitionedRegion pr = null;
    private boolean distinct = false;
    private Object currentProjectionField = null;
    private boolean isPRQueryNode = false;

    public ExecutionContext(Object[] bindArguments, Cache cache) {
        this.bindArguments = bindArguments;
        this.cache = cache;
    }

    public ExecutionContext(Object[] bindArguments, Cache cache, SelectResults results) {
        this.bindArguments = bindArguments;
        this.cache = cache;
    }

    public ExecutionContext(Object[] bindArguments, Cache cache, Query query) {
        this.bindArguments = bindArguments;
        this.cache = cache;
    }

    public CachePerfStats getCachePerfStats() {
        return ((GemFireCacheImpl)this.cache).getCachePerfStats();
    }

    Set addDependency(CompiledValue cv, RuntimeIterator itr) {
        Set ds = this.getDependencySet(cv, false);
        ds.add(itr);
        return ds;
    }

    public Set addDependencies(CompiledValue cv, Set set) {
        if (set.isEmpty()) {
            return this.getDependencySet(cv, true);
        }
        Set ds = this.getDependencySet(cv, false);
        ds.addAll(set);
        return ds;
    }

    boolean isDependentOnCurrentScope(CompiledValue cv) {
        Set setRItr = this.getDependencySet(cv, true);
        boolean isDependent = false;
        if (!setRItr.isEmpty()) {
            int currScopeID = this.currentScope().getScopeID();
            for (RuntimeIterator ritr : setRItr) {
                if (currScopeID != ritr.getScopeID()) continue;
                isDependent = true;
                break;
            }
        }
        return isDependent;
    }

    boolean isDependentOnAnyIterator(CompiledValue cv) {
        return !this.getDependencySet(cv, true).isEmpty();
    }

    boolean isDependentOn(CompiledValue cv, RuntimeIterator itr) {
        return this.getDependencySet(cv, true).contains(itr);
    }

    Set getDependencySet(CompiledValue cv, boolean readOnly) {
        HashSet set = (HashSet)this.dependencyGraph.get(cv);
        if (set == null) {
            if (readOnly) {
                return Collections.EMPTY_SET;
            }
            set = new HashSet(1);
            this.dependencyGraph.put(cv, set);
        }
        return set;
    }

    public Map getDependencyGraph() {
        return this.dependencyGraph;
    }

    public void setDependencyGraph(Map dependencyGraph) {
        this.dependencyGraph = dependencyGraph;
    }

    public Object getBindArgument(int index) {
        if (index > this.bindArguments.length) {
            throw new IllegalArgumentException(LocalizedStrings.ExecutionContext_TOO_FEW_QUERY_PARAMETERS.toLocalizedString());
        }
        return this.bindArguments[index - 1];
    }

    public void bindIterator(RuntimeIterator itr) {
        QScope currentScope = this.currentScope();
        int currScopeID = currentScope.getScopeID();
        itr.setScopeID(currScopeID);
        currentScope.bindIterator(itr);
    }

    public CompiledValue resolve(String name) throws TypeMismatchException, AmbiguousNameException {
        CompiledValue value = this.resolveAsVariable(name);
        if (value != null) {
            return value;
        }
        value = this.resolveImplicitPath(name);
        if (value == null) {
            throw new TypeMismatchException(LocalizedStrings.ExecutionContext_THE_ATTRIBUTE_OR_METHOD_NAME_0_COULD_NOT_BE_RESOLVED.toLocalizedString(name));
        }
        return value;
    }

    private CompiledValue resolveAsVariable(String name) {
        CompiledValue value = null;
        for (int i = this.scopes.size() - 1; i >= 0; --i) {
            QScope scope = (QScope)this.scopes.get(i);
            value = scope.resolve(name);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public void newScope(int scopeID) {
        this.scopes.push(new QScope(scopeID));
    }

    public void popScope() {
        this.scopes.pop();
    }

    int assosciateScopeID() {
        return ++this.scopeNum;
    }

    public QScope currentScope() {
        return (QScope)this.scopes.peek();
    }

    public List getCurrentIterators() {
        return this.currentScope().getIterators();
    }

    public List getCurrScopeDpndntItrsBasedOnSingleIndpndntItr(RuntimeIterator rIter) {
        Iterator iter = this.currentScope().getIterators().iterator();
        ArrayList<RuntimeIterator> list = new ArrayList<RuntimeIterator>();
        list.add(rIter);
        while (iter.hasNext()) {
            RuntimeIterator iteratorInCurrentScope = (RuntimeIterator)iter.next();
            Set itrSet = (Set)this.itrDefToIndpndtRuntimeItrMap.get(iteratorInCurrentScope.getCmpIteratorDefn());
            if (rIter == iteratorInCurrentScope || itrSet.size() != 1 || (RuntimeIterator)itrSet.iterator().next() != rIter) continue;
            list.add(iteratorInCurrentScope);
        }
        return list;
    }

    public List getAllIterators() {
        int numScopes = this.scopes.size();
        ArrayList iterators = new ArrayList();
        for (int i = 1; i <= numScopes; ++i) {
            iterators.addAll(((QScope)this.scopes.get(numScopes - i)).getIterators());
        }
        return iterators;
    }

    void setOneIndexLookup(boolean b) {
        QScope scope = this.currentScope();
        Support.Assert(scope != null, "must be called within valid scope");
        scope._oneIndexLookup = b;
    }

    void setCurrent(RuntimeIterator iter, Object obj) {
        this.currentScope().setCurrent(iter, obj);
    }

    public Cache getCache() {
        return this.cache;
    }

    private CompiledValue resolveImplicitPath(String name) throws AmbiguousNameException {
        RuntimeIterator result = this.resolveImplicitOperationName(name, 0, false);
        return result == null ? null : new CompiledPath(result, name);
    }

    RuntimeIterator resolveImplicitOperationName(String name, int numArgs, boolean mustBeMethod) throws AmbiguousNameException {
        RuntimeIterator oneUnknown = null;
        ArrayList<RuntimeIterator> hits = new ArrayList<RuntimeIterator>(2);
        boolean foundOneUnknown = false;
        block0: for (int i = this.scopes.size() - 1; i >= 0; --i) {
            QScope scope = (QScope)this.scopes.get(i);
            for (RuntimeIterator itr : scope.getIterators()) {
                Assert.assertTrue(itr != null);
                if (scope.getLimit() == itr) continue block0;
                if (!TypeUtils.OBJECT_TYPE.equals(itr.getElementType()) && itr.containsProperty(name, numArgs, mustBeMethod)) {
                    hits.add(itr);
                    continue;
                }
                if (!TypeUtils.OBJECT_TYPE.equals(itr.getElementType())) continue;
                if (foundOneUnknown) {
                    oneUnknown = null;
                    continue;
                }
                foundOneUnknown = true;
                oneUnknown = itr;
            }
        }
        if (hits.size() == 1) {
            return (RuntimeIterator)hits.get(0);
        }
        if (hits.size() > 1) {
            if (mustBeMethod) {
                throw new AmbiguousNameException(LocalizedStrings.ExecutionContext_METHOD_NAMED_0_WITH_1_ARGUMENTS_IS_AMBIGUOUS_BECAUSE_IT_CAN_APPLY_TO_MORE_THAN_ONE_VARIABLE_IN_SCOPE.toLocalizedString(name, numArgs));
            }
            throw new AmbiguousNameException(LocalizedStrings.ExecutionContext_ATTRIBUTE_NAMED_0_IS_AMBIGUOUS_BECAUSE_IT_CAN_APPLY_TO_MORE_THAN_ONE_VARIABLE_IN_SCOPE.toLocalizedString(name));
        }
        Assert.assertTrue(hits.isEmpty());
        return oneUnknown;
    }

    protected CompiledValue resolveScopeVariable(String name) {
        QScope scope;
        CompiledValue value = null;
        for (int i = this.scopes.size() - 1; i >= 0 && (value = (scope = (QScope)this.scopes.get(i)).resolve(name)) == null; --i) {
        }
        return value;
    }

    public RuntimeIterator findRuntimeIterator(CompiledValue expr) {
        if (expr instanceof RuntimeIterator) {
            RuntimeIterator rIter = (RuntimeIterator)expr;
            return rIter;
        }
        return (RuntimeIterator)this.findIterator(expr);
    }

    private CompiledValue findIterator(CompiledValue path) {
        try {
            if (path == null) {
                return null;
            }
            if (path instanceof RuntimeIterator) {
                return path;
            }
            if (path instanceof CompiledPath) {
                CompiledValue rec = ((CompiledPath)path).getReceiver();
                return this.findIterator(rec);
            }
            if (path instanceof CompiledOperation) {
                CompiledOperation operation = (CompiledOperation)path;
                CompiledValue rec = operation.getReceiver(this);
                if (rec == null) {
                    RuntimeIterator rcvrItr = this.resolveImplicitOperationName(operation.getMethodName(), operation.getArguments().size(), true);
                    return rcvrItr;
                }
                return this.findIterator(rec);
            }
            if (path instanceof CompiledIndexOperation) {
                CompiledIndexOperation cio = (CompiledIndexOperation)path;
                CompiledValue rec = cio.getReceiver();
                return this.findIterator(rec);
            }
            if (path instanceof CompiledID) {
                CompiledValue expr = this.resolve(((CompiledID)path).getId());
                return this.findIterator(expr);
            }
        }
        catch (TypeMismatchException typeMismatchException) {
        }
        catch (NameResolutionException nameResolutionException) {
            // empty catch block
        }
        return null;
    }

    int getScopeCount() {
        return this.scopes.size();
    }

    public void computeUtlimateDependencies(CompiledValue cv, Set set) {
        Set dependencySet = this.getDependencySet(cv, true);
        if (dependencySet != Collections.EMPTY_SET) {
            for (RuntimeIterator rIter : dependencySet) {
                Set indRuntimeIterators = (Set)this.itrDefToIndpndtRuntimeItrMap.get(rIter.getCmpIteratorDefn());
                if (indRuntimeIterators == null) continue;
                set.addAll(indRuntimeIterators);
            }
        }
    }

    public void addToIndependentRuntimeItrMap(CompiledIteratorDef itrDef) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        HashSet<RuntimeIterator> set = new HashSet<RuntimeIterator>();
        this.computeUtlimateDependencies(itrDef, set);
        RuntimeIterator itr = null;
        String rgnPath = null;
        if (set.isEmpty()) {
            CompiledBindArgument cba;
            Object rgn;
            itr = itrDef.getRuntimeIterator(this);
            set.add(itr);
            CompiledValue startVal = QueryUtils.obtainTheBottomMostCompiledValue(itrDef.getCollectionExpr());
            if (startVal.getType() == 35) {
                rgnPath = ((QRegion)((CompiledRegion)startVal).evaluate(this)).getFullPath();
                this.indpndtItrToRgnMap.put(itr, rgnPath);
            } else if (startVal.getType() == 47 && (rgn = (cba = (CompiledBindArgument)startVal).evaluate(this)) instanceof Region) {
                rgnPath = ((Region)rgn).getFullPath();
                this.indpndtItrToRgnMap.put(itr, rgnPath);
            }
        }
        this.itrDefToIndpndtRuntimeItrMap.put(itrDef, set);
        IndexManager mgr = null;
        if (set.size() == 1) {
            if (itr == null && (itr = (RuntimeIterator)set.iterator().next()).getScopeID() == this.currentScope().getScopeID()) {
                rgnPath = (String)this.indpndtItrToRgnMap.get(itr);
            }
            if (rgnPath != null && null == (mgr = IndexUtils.getIndexManager(this.cache.getRegion(rgnPath), false)) && null != this.bukRgn) {
                mgr = IndexUtils.getIndexManager(this.cache.getRegion(this.bukRgn.getFullPath()), false);
            }
        }
        String tempIndexID = null;
        RuntimeIterator currItr = itrDef.getRuntimeIterator(this);
        currItr.setIndexInternalID(mgr == null || (tempIndexID = mgr.getCanonicalizedIteratorName(itrDef.genFromClause(this))) == null ? currItr.getInternalId() : tempIndexID);
    }

    public List getAllIndependentIteratorsOfCurrentScope() {
        ArrayList<RuntimeIterator> independentIterators = new ArrayList<RuntimeIterator>(this.indpndtItrToRgnMap.size());
        Iterator itr = this.indpndtItrToRgnMap.keySet().iterator();
        int currentScopeId = this.currentScope().getScopeID();
        while (itr.hasNext()) {
            RuntimeIterator rIter = (RuntimeIterator)itr.next();
            if (rIter.getScopeID() != currentScopeId) continue;
            independentIterators.add(rIter);
        }
        return independentIterators;
    }

    String getRegionPathForIndependentRuntimeIterator(RuntimeIterator riter) {
        return (String)this.indpndtItrToRgnMap.get(riter);
    }

    public void addToIndependentRuntimeItrMapForIndexCreation(CompiledIteratorDef itrDef) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        HashSet<RuntimeIterator> set = new HashSet<RuntimeIterator>();
        this.computeUtlimateDependencies(itrDef, set);
        RuntimeIterator itr = null;
        if (set.isEmpty()) {
            itr = itrDef.getRuntimeIterator(this);
            set.add(itr);
        }
        this.itrDefToIndpndtRuntimeItrMap.put(itrDef, set);
    }

    public void setBindArguments(Object[] bindArguments) {
        this.bindArguments = bindArguments;
    }

    public int getScopeNum() {
        return this.scopeNum;
    }

    public void reset() {
        this.scopes.clear();
    }

    public BucketRegion getBucketRegion() {
        return this.bukRgn;
    }

    public void setBucketRegion(PartitionedRegion pr, BucketRegion bukRgn) {
        this.bukRgn = bukRgn;
        this.pr = pr;
    }

    public PartitionedRegion getPartitionedRegion() {
        return this.pr;
    }

    void cachePut(Object key, Object value) {
    }

    public Object cacheGet(Object key) {
        return null;
    }

    public Object cacheGet(Object key, Object defaultValue) {
        return defaultValue;
    }

    public boolean isCqQueryContext() {
        return false;
    }

    public List getBucketList() {
        return null;
    }

    public void pushExecCache(int scopeNum) {
        throw new UnsupportedOperationException("Method should not have been called");
    }

    public void popExecCache() {
        throw new UnsupportedOperationException("Method should not have been called");
    }

    int nextFieldNum() {
        throw new UnsupportedOperationException("Method should not have been called");
    }

    public void setCqQueryContext(boolean cqQuery) {
        throw new UnsupportedOperationException("Method should not have been called");
    }

    public Query getQuery() {
        throw new UnsupportedOperationException("Method should not have been called");
    }

    public void setBucketList(List list) {
        throw new UnsupportedOperationException("Method should not have been called");
    }

    public void addToSuccessfulBuckets(int bId) {
        throw new UnsupportedOperationException("Method should not have been called");
    }

    public int[] getSuccessfulBuckets() {
        throw new UnsupportedOperationException("Method should not have been called");
    }

    public PdxString getSavedPdxString(int index) {
        throw new UnsupportedOperationException("Method should not have been called");
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isBindArgsSet() {
        return this.bindArguments != null;
    }

    public void setCurrentProjectionField(Object field) {
        this.currentProjectionField = field;
    }

    public Object getCurrentProjectionField() {
        return this.currentProjectionField;
    }

    public void setIsPRQueryNode(boolean isPRQueryNode) {
        this.isPRQueryNode = isPRQueryNode;
    }

    public boolean getIsPRQueryNode() {
        return this.isPRQueryNode;
    }
}

