/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal.locator;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.cache.client.internal.locator.ClientConnectionRequest;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.InternalDataSerializer;

public class ClientReplacementRequest
extends ClientConnectionRequest {
    private ServerLocation currentServer;

    public ClientReplacementRequest() {
    }

    public ClientReplacementRequest(ServerLocation currentServer, Set excludedServers, String serverGroup) {
        super(excludedServers, serverGroup);
        this.currentServer = currentServer;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.currentServer = new ServerLocation();
        InternalDataSerializer.invokeFromData(this.currentServer, in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        InternalDataSerializer.invokeToData(this.currentServer, out);
    }

    public ServerLocation getCurrentServer() {
        return this.currentServer;
    }

    @Override
    public String toString() {
        return "ClientReplacementRequest{group=" + this.getServerGroup() + ", excluded=" + this.getExcludedServers() + ", currentServer=" + this.getCurrentServer() + "}";
    }

    @Override
    public int getDSFID() {
        return -48;
    }
}

