/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class InvalidateOp {
    private static final Logger logger = LogService.getLogger();
    public static final int HAS_VERSION_TAG = 1;

    public static void execute(ExecutablePool pool, String region, EntryEventImpl event) {
        InvalidateOpImpl op = new InvalidateOpImpl(region, event);
        pool.execute(op);
    }

    private InvalidateOp() {
    }

    private static class InvalidateOpImpl
    extends AbstractOp {
        private EntryEventImpl event;

        public InvalidateOpImpl(String region, EntryEventImpl event) {
            super(83, event.getCallbackArgument() != null ? 4 : 3);
            Object callbackArg = event.getCallbackArgument();
            this.event = event;
            this.getMessage().addStringPart(region);
            this.getMessage().addStringOrObjPart(event.getKeyInfo().getKey());
            this.getMessage().addBytesPart(event.getEventId().calcBytes());
            if (callbackArg != null) {
                this.getMessage().addObjPart(callbackArg);
            }
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Object processResponse(Message msg, Connection con) throws Exception {
            this.processAck(msg, "invalidate");
            boolean isReply = msg.getMessageType() == 6;
            int partIdx = 0;
            int flags = 0;
            if (isReply) {
                if (((flags = msg.getPart(partIdx++).getInt()) & 1) != 0) {
                    VersionTag tag = (VersionTag)msg.getPart(partIdx++).getObject();
                    tag.replaceNullIDs((InternalDistributedMember)con.getEndpoint().getMemberId());
                    this.event.setVersionTag(tag);
                    if (logger.isDebugEnabled()) {
                        logger.debug("received Invalidate response with {}", (Object)tag);
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug("received Invalidate response");
                }
            }
            return null;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 84;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startInvalidate();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endInvalidateSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endInvalidate(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

