/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geode.CancelCriterion;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.Endpoint;
import org.apache.geode.cache.client.internal.EndpointManager;
import org.apache.geode.cache.client.internal.PdxRegistryRecoveryListener;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.ProxyCache;
import org.apache.geode.cache.client.internal.UserAttributes;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.cache.PoolStats;
import org.apache.geode.internal.cache.tier.InternalClientMembership;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.statistics.DummyStatisticsFactory;
import org.apache.logging.log4j.Logger;

public class EndpointManagerImpl
implements EndpointManager {
    private static final Logger logger = LogService.getLogger();
    private volatile Map<ServerLocation, Endpoint> endpointMap = Collections.emptyMap();
    private final Map<ServerLocation, ConnectionStats> statMap = new HashMap<ServerLocation, ConnectionStats>();
    private final DistributedSystem ds;
    private final String poolName;
    private final EndpointListenerBroadcaster listener = new EndpointListenerBroadcaster();
    protected final CancelCriterion cancelCriterion;
    private final PoolStats poolStats;

    public EndpointManagerImpl(String poolName, DistributedSystem ds, CancelCriterion cancelCriterion, PoolStats poolStats) {
        this.ds = ds;
        this.poolName = poolName;
        this.cancelCriterion = cancelCriterion;
        this.poolStats = poolStats;
        this.listener.addListener(new EndpointListenerForBridgeMembership());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Endpoint referenceEndpoint(ServerLocation server, DistributedMember memberId) {
        Endpoint endpoint = this.endpointMap.get(server);
        boolean addedEndpoint = false;
        if (endpoint == null || endpoint.isClosed()) {
            EndpointManagerImpl endpointManagerImpl = this;
            synchronized (endpointManagerImpl) {
                endpoint = this.endpointMap.get(server);
                if (endpoint == null || endpoint.isClosed()) {
                    ConnectionStats stats = this.getStats(server);
                    HashMap<ServerLocation, Endpoint> endpointMapTemp = new HashMap<ServerLocation, Endpoint>(this.endpointMap);
                    endpoint = new Endpoint(this, this.ds, server, stats, memberId);
                    this.listener.clearPdxRegistry(endpoint);
                    endpointMapTemp.put(server, endpoint);
                    this.endpointMap = Collections.unmodifiableMap(endpointMapTemp);
                    addedEndpoint = true;
                    this.poolStats.setServerCount(this.endpointMap.size());
                }
            }
        }
        endpoint.addReference();
        if (addedEndpoint) {
            this.listener.endpointNowInUse(endpoint);
        }
        return endpoint;
    }

    @Override
    public void serverCrashed(Endpoint endpoint) {
        this.removeEndpoint(endpoint, true);
    }

    void endpointNotInUse(Endpoint endpoint) {
        this.removeEndpoint(endpoint, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEndpoint(Endpoint endpoint, boolean crashed) {
        endpoint.close();
        boolean removedEndpoint = false;
        EndpointManagerImpl endpointManagerImpl = this;
        synchronized (endpointManagerImpl) {
            HashMap<ServerLocation, Endpoint> endpointMapTemp = new HashMap<ServerLocation, Endpoint>(this.endpointMap);
            endpoint = (Endpoint)endpointMapTemp.remove(endpoint.getLocation());
            if (endpoint != null) {
                this.endpointMap = Collections.unmodifiableMap(endpointMapTemp);
                removedEndpoint = true;
            }
            this.poolStats.setServerCount(this.endpointMap.size());
        }
        if (removedEndpoint) {
            PoolImpl pool = (PoolImpl)PoolManager.find(this.poolName);
            if (pool != null && pool.getMultiuserAuthentication()) {
                Long userId;
                ArrayList<ProxyCache> proxyCaches;
                int size = 0;
                ArrayList<ProxyCache> arrayList = proxyCaches = pool.getProxyCacheList();
                synchronized (arrayList) {
                    for (ProxyCache proxyCache : proxyCaches) {
                        try {
                            Long userId2 = proxyCache.getUserAttributes().getServerToId().remove(endpoint.getLocation());
                            if (userId2 == null) continue;
                            ++size;
                        }
                        catch (CacheClosedException cacheClosedException) {}
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("EndpointManagerImpl.removeEndpoint() Removed server {} from {} user's ProxyCache", (Object)endpoint.getLocation(), (Object)size);
                    }
                }
                UserAttributes ua = UserAttributes.userAttributes.get();
                if (ua != null && (userId = ua.getServerToId().remove(endpoint.getLocation())) != null && logger.isDebugEnabled()) {
                    logger.debug("EndpointManagerImpl.removeEndpoint() Removed server {} from thread local variable", (Object)endpoint.getLocation());
                }
            } else if (pool != null && !pool.getMultiuserAuthentication()) {
                endpoint.getLocation().setUserId(-1L);
            }
            if (crashed) {
                this.listener.endpointCrashed(endpoint);
            } else {
                this.listener.endpointNoLongerInUse(endpoint);
            }
        }
    }

    @Override
    public Map<ServerLocation, Endpoint> getEndpointMap() {
        return this.endpointMap;
    }

    @Override
    public synchronized void close() {
        for (ConnectionStats stats : this.statMap.values()) {
            stats.close();
        }
        this.statMap.clear();
        this.endpointMap = Collections.emptyMap();
        this.listener.clear();
    }

    @Override
    public void addListener(EndpointManager.EndpointListener listener) {
        this.listener.addListener(listener);
    }

    @Override
    public void removeListener(EndpointManager.EndpointListener listener) {
        this.listener.removeListener(listener);
    }

    private synchronized ConnectionStats getStats(ServerLocation location) {
        ConnectionStats stats = this.statMap.get(location);
        if (stats == null) {
            String statName = this.poolName + "-" + location.toString();
            PoolImpl pool = (PoolImpl)PoolManager.find(this.poolName);
            if (pool != null && pool.getGatewaySender() != null) {
                stats = new ConnectionStats(new DummyStatisticsFactory(), statName, this.poolStats);
            }
            if (stats == null) {
                stats = new ConnectionStats(this.ds, statName, this.poolStats);
            }
            this.statMap.put(location, stats);
        }
        return stats;
    }

    @Override
    public synchronized Map<ServerLocation, ConnectionStats> getAllStats() {
        return new HashMap<ServerLocation, ConnectionStats>(this.statMap);
    }

    @Override
    public int getConnectedServerCount() {
        return this.getEndpointMap().size();
    }

    public static void loadEmergencyClasses() {
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    public class EndpointListenerForBridgeMembership
    implements EndpointManager.EndpointListener {
        @Override
        public void endpointCrashed(Endpoint endpoint) {
            if (EndpointManagerImpl.this.cancelCriterion.isCancelInProgress()) {
                return;
            }
            InternalClientMembership.notifyServerCrashed(endpoint.getLocation());
        }

        @Override
        public void endpointNoLongerInUse(Endpoint endpoint) {
            if (EndpointManagerImpl.this.cancelCriterion.isCancelInProgress()) {
                return;
            }
            InternalClientMembership.notifyServerLeft(endpoint.getLocation());
        }

        @Override
        public void endpointNowInUse(Endpoint endpoint) {
            if (EndpointManagerImpl.this.cancelCriterion.isCancelInProgress()) {
                return;
            }
            InternalClientMembership.notifyServerJoined(endpoint.getLocation());
        }
    }

    protected static class EndpointListenerBroadcaster
    implements EndpointManager.EndpointListener {
        private volatile Set<EndpointManager.EndpointListener> endpointListeners = Collections.emptySet();

        protected EndpointListenerBroadcaster() {
        }

        public synchronized void addListener(EndpointManager.EndpointListener listener) {
            HashSet<EndpointManager.EndpointListener> tmpListeners = new HashSet<EndpointManager.EndpointListener>(this.endpointListeners);
            tmpListeners.add(listener);
            this.endpointListeners = Collections.unmodifiableSet(tmpListeners);
        }

        public synchronized void clear() {
            this.endpointListeners = Collections.emptySet();
        }

        public void removeListener(EndpointManager.EndpointListener listener) {
            HashSet<EndpointManager.EndpointListener> tmpListeners = new HashSet<EndpointManager.EndpointListener>(this.endpointListeners);
            tmpListeners.remove(listener);
            this.endpointListeners = Collections.unmodifiableSet(tmpListeners);
        }

        @Override
        public void endpointCrashed(Endpoint endpoint) {
            for (EndpointManager.EndpointListener listener : this.endpointListeners) {
                listener.endpointCrashed(endpoint);
            }
        }

        @Override
        public void endpointNoLongerInUse(Endpoint endpoint) {
            for (EndpointManager.EndpointListener listener : this.endpointListeners) {
                listener.endpointNoLongerInUse(endpoint);
            }
        }

        @Override
        public void endpointNowInUse(Endpoint endpoint) {
            for (EndpointManager.EndpointListener listener : this.endpointListeners) {
                if (listener instanceof PdxRegistryRecoveryListener) continue;
                listener.endpointNowInUse(endpoint);
            }
        }

        public void clearPdxRegistry(Endpoint endpoint) {
            for (EndpointManager.EndpointListener listener : this.endpointListeners) {
                if (!(listener instanceof PdxRegistryRecoveryListener)) continue;
                listener.endpointNowInUse(endpoint);
            }
        }
    }
}

