/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.FixedPartitionResolver;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.PartitionResolver;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.client.internal.ClientPartitionAdvisor;
import org.apache.geode.cache.client.internal.GetClientPRMetaDataOp;
import org.apache.geode.cache.client.internal.GetClientPartitionAttributesOp;
import org.apache.geode.cache.client.internal.InternalPool;
import org.apache.geode.cache.client.internal.SingleHopClientExecutor;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.cache.BucketServerLocation66;
import org.apache.geode.internal.cache.EntryOperationImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public final class ClientMetadataService {
    private static final Logger logger = LogService.getLogger();
    private final Cache cache;
    private final Set<String> nonPRs = new HashSet<String>();
    private boolean HONOUR_SERVER_GROUP_IN_PR_SINGLE_HOP = Boolean.getBoolean("gemfire.PoolImpl.honourServerGroupsInPRSingleHop");
    public static final int SIZE_BYTES_ARRAY_RECEIVED = 2;
    public static final int INITIAL_VERSION = 0;
    private final Random rand = new Random();
    private volatile boolean isMetadataStable = true;
    private boolean isMetadataRefreshed_TEST_ONLY = false;
    private int refreshTaskCount = 0;
    private Set<String> regionsBeingRefreshed = new HashSet<String>();
    private final Object fetchTaskCountLock = new Object();
    private final Map<String, ClientPartitionAdvisor> clientPRAdvisors = new ConcurrentHashMap<String, ClientPartitionAdvisor>();
    private final Map<String, Set<ClientPartitionAdvisor>> colocatedPRAdvisors = new ConcurrentHashMap<String, Set<ClientPartitionAdvisor>>();

    public ClientMetadataService(Cache cache) {
        this.cache = cache;
    }

    private PartitionResolver getResolver(Region r, Object key, Object callbackArgument) {
        String regionFullPath = r.getFullPath();
        ClientPartitionAdvisor advisor = this.getClientPartitionAdvisor(regionFullPath);
        PartitionResolver result = null;
        if (advisor != null) {
            result = advisor.getPartitionResolver();
        }
        if (result != null) {
            return result;
        }
        if (key != null && key instanceof PartitionResolver) {
            return (PartitionResolver)key;
        }
        if (callbackArgument != null && callbackArgument instanceof PartitionResolver) {
            return (PartitionResolver)callbackArgument;
        }
        return null;
    }

    public ServerLocation getBucketServerLocation(Region region, Operation operation, Object key, Object value, Object callbackArg) {
        int bucketId;
        Object resolveKey;
        ClientPartitionAdvisor prAdvisor = this.getClientPartitionAdvisor(region.getFullPath());
        if (prAdvisor == null) {
            return null;
        }
        int totalNumberOfBuckets = prAdvisor.getTotalNumBuckets();
        PartitionResolver resolver = this.getResolver(region, key, callbackArg);
        EntryOperationImpl entryOp = null;
        if (resolver == null) {
            resolveKey = key;
        } else {
            entryOp = new EntryOperationImpl(region, operation, key, value, callbackArg);
            resolveKey = resolver.getRoutingObject(entryOp);
            if (resolveKey == null) {
                throw new IllegalStateException(LocalizedStrings.PartitionedRegionHelper_THE_ROUTINGOBJECT_RETURNED_BY_PARTITIONRESOLVER_IS_NULL.toLocalizedString());
            }
        }
        if (resolver instanceof FixedPartitionResolver) {
            String partition;
            if (entryOp == null) {
                entryOp = new EntryOperationImpl(region, Operation.FUNCTION_EXECUTION, key, null, null);
            }
            if ((partition = ((FixedPartitionResolver)resolver).getPartitionName(entryOp, prAdvisor.getFixedPartitionNames())) == null) {
                Object[] prms = new Object[]{region.getName(), resolver};
                throw new IllegalStateException(LocalizedStrings.PartitionedRegionHelper_FOR_REGION_0_PARTITIONRESOLVER_1_RETURNED_PARTITION_NAME_NULL.toLocalizedString(prms));
            }
            bucketId = prAdvisor.assignFixedBucketId(region, partition, resolveKey);
            if (bucketId == -1) {
                return null;
            }
        } else {
            bucketId = PartitionedRegionHelper.getHashKey(resolveKey, totalNumberOfBuckets);
        }
        ServerLocation bucketServerLocation = this.getServerLocation(region, operation, bucketId);
        ServerLocation location = null;
        if (bucketServerLocation != null) {
            location = new ServerLocation(bucketServerLocation.getHostName(), bucketServerLocation.getPort());
        }
        return location;
    }

    private ServerLocation getServerLocation(Region region, Operation operation, int bucketId) {
        String regionFullPath = region.getFullPath();
        ClientPartitionAdvisor prAdvisor = this.getClientPartitionAdvisor(regionFullPath);
        if (prAdvisor == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("ClientMetadataService#getServerLocation : Region {} prAdvisor does not exist.", (Object)regionFullPath);
            }
            return null;
        }
        if (operation.isGet()) {
            return prAdvisor.adviseServerLocation(bucketId);
        }
        return prAdvisor.advisePrimaryServerLocation(bucketId);
    }

    public Map<ServerLocation, HashSet> getServerToFilterMap(Collection routingKeys, Region region, boolean primaryMembersNeeded) {
        return this.getServerToFilterMap(routingKeys, region, primaryMembersNeeded, false);
    }

    public Map<ServerLocation, HashSet> getServerToFilterMap(Collection routingKeys, Region region, boolean primaryMembersNeeded, boolean bucketsAsFilter) {
        String regionFullPath = region.getFullPath();
        ClientPartitionAdvisor prAdvisor = this.getClientPartitionAdvisor(regionFullPath);
        if (prAdvisor == null || prAdvisor.adviseRandomServerLocation() == null) {
            this.scheduleGetPRMetaData((LocalRegion)region, false);
            return null;
        }
        HashMap<Integer, HashSet> bucketToKeysMap = this.groupByBucketOnClientSide(region, prAdvisor, routingKeys, bucketsAsFilter);
        HashMap<ServerLocation, HashSet> serverToKeysMap = new HashMap<ServerLocation, HashSet>();
        HashMap<ServerLocation, HashSet<Integer>> serverToBuckets = this.groupByServerToBuckets(prAdvisor, bucketToKeysMap.keySet(), primaryMembersNeeded);
        if (serverToBuckets == null) {
            return null;
        }
        for (Map.Entry<ServerLocation, HashSet<Integer>> entry : serverToBuckets.entrySet()) {
            ServerLocation server = entry.getKey();
            HashSet<Integer> buckets = entry.getValue();
            for (Integer bucket : buckets) {
                LinkedHashSet keys = (LinkedHashSet)serverToKeysMap.get(server);
                if (keys == null) {
                    keys = new LinkedHashSet();
                }
                keys.addAll(bucketToKeysMap.get(bucket));
                serverToKeysMap.put(server, keys);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Returning server to keys map : {}", (Object)serverToKeysMap);
        }
        return serverToKeysMap;
    }

    public HashMap<ServerLocation, HashSet<Integer>> groupByServerToAllBuckets(Region region, boolean primaryOnly) {
        String regionFullPath = region.getFullPath();
        ClientPartitionAdvisor prAdvisor = this.getClientPartitionAdvisor(regionFullPath);
        if (prAdvisor == null || prAdvisor.adviseRandomServerLocation() == null) {
            this.scheduleGetPRMetaData((LocalRegion)region, false);
            return null;
        }
        int totalNumberOfBuckets = prAdvisor.getTotalNumBuckets();
        HashSet<Integer> allBucketIds = new HashSet<Integer>();
        for (int i = 0; i < totalNumberOfBuckets; ++i) {
            allBucketIds.add(i);
        }
        return this.groupByServerToBuckets(prAdvisor, allBucketIds, primaryOnly);
    }

    private HashMap<ServerLocation, HashSet<Integer>> groupByServerToBuckets(ClientPartitionAdvisor prAdvisor, Set<Integer> bucketSet, boolean primaryOnly) {
        if (primaryOnly) {
            HashMap<ServerLocation, HashSet<Integer>> serverToBucketsMap = new HashMap<ServerLocation, HashSet<Integer>>();
            for (Integer bucketId : bucketSet) {
                ServerLocation server = prAdvisor.advisePrimaryServerLocation(bucketId);
                if (server == null) {
                    return null;
                }
                HashSet<Integer> buckets = serverToBucketsMap.get(server);
                if (buckets == null) {
                    buckets = new HashSet();
                    serverToBucketsMap.put(server, buckets);
                }
                buckets.add(bucketId);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("ClientMetadataService: The server to bucket map is : {}", (Object)serverToBucketsMap);
            }
            return serverToBucketsMap;
        }
        return this.pruneNodes(prAdvisor, bucketSet);
    }

    private HashMap<ServerLocation, HashSet<Integer>> pruneNodes(ClientPartitionAdvisor prAdvisor, Set<Integer> buckets) {
        ServerLocation server;
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("ClientMetadataService: The buckets to be pruned are: {}", (Object)buckets);
        }
        HashMap<ServerLocation, HashSet> serverToBucketsMap = new HashMap<ServerLocation, HashSet>();
        HashMap<ServerLocation, HashSet<Integer>> prunedServerToBucketsMap = new HashMap<ServerLocation, HashSet<Integer>>();
        for (Integer bucketId : buckets) {
            List<BucketServerLocation66> serversList = prAdvisor.adviseServerLocations(bucketId);
            if (isDebugEnabled) {
                logger.debug("ClientMetadataService: For bucketId {} the server list is {}", (Object)bucketId, (Object)serversList);
            }
            if (serversList == null || serversList.size() == 0) {
                return null;
            }
            if (isDebugEnabled) {
                logger.debug("ClientMetadataService: The buckets owners of the bucket: {} are: {}", (Object)bucketId, (Object)serversList);
            }
            for (ServerLocation serverLocation : serversList) {
                HashSet bucketSet;
                if (serverToBucketsMap.get(serverLocation) == null) {
                    bucketSet = new HashSet();
                    bucketSet.add(bucketId);
                    serverToBucketsMap.put(serverLocation, bucketSet);
                    continue;
                }
                bucketSet = (HashSet)serverToBucketsMap.get(serverLocation);
                bucketSet.add(bucketId);
                serverToBucketsMap.put(serverLocation, bucketSet);
            }
        }
        if (isDebugEnabled) {
            logger.debug("ClientMetadataService: The server to buckets map is : {}", (Object)serverToBucketsMap);
        }
        HashSet<Integer> currentBucketSet = new HashSet<Integer>();
        ServerLocation randomFirstServer = null;
        if (serverToBucketsMap.isEmpty()) {
            return null;
        }
        int size = serverToBucketsMap.size();
        randomFirstServer = (ServerLocation)serverToBucketsMap.keySet().toArray()[this.rand.nextInt(size)];
        HashSet bucketSet = (HashSet)serverToBucketsMap.get(randomFirstServer);
        if (isDebugEnabled) {
            logger.debug("ClientMetadataService: Adding the server : {} which is random and buckets {} to prunedMap", (Object)randomFirstServer, (Object)bucketSet);
        }
        currentBucketSet.addAll(bucketSet);
        prunedServerToBucketsMap.put(randomFirstServer, bucketSet);
        serverToBucketsMap.remove(randomFirstServer);
        while (!currentBucketSet.equals(buckets) && (server = this.findNextServer(serverToBucketsMap.entrySet(), currentBucketSet)) != null) {
            HashSet hashSet = (HashSet)serverToBucketsMap.get(server);
            hashSet.removeAll(currentBucketSet);
            if (hashSet.isEmpty()) {
                serverToBucketsMap.remove(server);
                continue;
            }
            currentBucketSet.addAll(hashSet);
            prunedServerToBucketsMap.put(server, hashSet);
            if (isDebugEnabled) {
                logger.debug("ClientMetadataService: Adding the server : {} and buckets {} to prunedServer.", (Object)server, (Object)hashSet);
            }
            serverToBucketsMap.remove(server);
        }
        if (isDebugEnabled) {
            logger.debug("ClientMetadataService: The final prunedServerToBucket calculated is : {}", (Object)prunedServerToBucketsMap);
        }
        return prunedServerToBucketsMap;
    }

    private ServerLocation findNextServer(Set<Map.Entry<ServerLocation, HashSet<Integer>>> entrySet, HashSet<Integer> currentBucketSet) {
        ServerLocation server = null;
        int max = -1;
        ArrayList<ServerLocation> nodesOfEqualSize = new ArrayList<ServerLocation>();
        for (Map.Entry<ServerLocation, HashSet<Integer>> entry : entrySet) {
            HashSet buckets = new HashSet();
            buckets.addAll(entry.getValue());
            buckets.removeAll(currentBucketSet);
            if (max < buckets.size()) {
                max = buckets.size();
                server = entry.getKey();
                nodesOfEqualSize.clear();
                nodesOfEqualSize.add(server);
                continue;
            }
            if (max != buckets.size()) continue;
            nodesOfEqualSize.add(server);
        }
        Random r = new Random();
        if (nodesOfEqualSize.size() > 0) {
            return (ServerLocation)nodesOfEqualSize.get(r.nextInt(nodesOfEqualSize.size()));
        }
        return null;
    }

    private HashMap<Integer, HashSet> groupByBucketOnClientSide(Region region, ClientPartitionAdvisor prAdvisor, Collection routingKeys, boolean bucketsAsFilter) {
        HashMap<Integer, HashSet> bucketToKeysMap = new HashMap<Integer, HashSet>();
        int totalNumberOfBuckets = prAdvisor.getTotalNumBuckets();
        for (Object key : routingKeys) {
            int bucketId = bucketsAsFilter ? ((Integer)key).intValue() : this.extractBucketID(region, prAdvisor, totalNumberOfBuckets, key);
            HashSet bucketKeys = bucketToKeysMap.get(bucketId);
            if (bucketKeys == null) {
                bucketKeys = new HashSet();
                bucketToKeysMap.put(bucketId, bucketKeys);
            }
            bucketKeys.add(key);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Bucket to keys map : {}", (Object)bucketToKeysMap);
        }
        return bucketToKeysMap;
    }

    private int extractBucketID(Region region, ClientPartitionAdvisor prAdvisor, int totalNumberOfBuckets, Object key) {
        Object resolveKey;
        int bucketId = -1;
        PartitionResolver resolver = this.getResolver(region, key, null);
        EntryOperationImpl entryOp = null;
        if (resolver == null) {
            resolveKey = key;
        } else {
            entryOp = new EntryOperationImpl(region, Operation.FUNCTION_EXECUTION, key, null, null);
            resolveKey = resolver.getRoutingObject(entryOp);
            if (resolveKey == null) {
                throw new IllegalStateException(LocalizedStrings.PartitionedRegionHelper_THE_ROUTINGOBJECT_RETURNED_BY_PARTITIONRESOLVER_IS_NULL.toLocalizedString());
            }
        }
        if (resolver instanceof FixedPartitionResolver) {
            String partition;
            if (entryOp == null) {
                entryOp = new EntryOperationImpl(region, Operation.FUNCTION_EXECUTION, key, null, null);
            }
            if ((partition = ((FixedPartitionResolver)resolver).getPartitionName(entryOp, prAdvisor.getFixedPartitionNames())) == null) {
                Object[] prms = new Object[]{region.getName(), resolver};
                throw new IllegalStateException(LocalizedStrings.PartitionedRegionHelper_FOR_REGION_0_PARTITIONRESOLVER_1_RETURNED_PARTITION_NAME_NULL.toLocalizedString(prms));
            }
            bucketId = prAdvisor.assignFixedBucketId(region, partition, resolveKey);
            if (bucketId == -1) {
                this.scheduleGetPRMetaData((LocalRegion)region, true);
            }
        } else {
            bucketId = PartitionedRegionHelper.getHashKey(resolveKey, totalNumberOfBuckets);
        }
        return bucketId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void scheduleGetPRMetaData(final LocalRegion region, boolean isRecursive) {
        if (this.nonPRs.contains(region.getFullPath())) {
            return;
        }
        this.setMetadataStable(false);
        if (isRecursive) {
            try {
                this.getClientPRMetadata(region);
                return;
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure(e);
                throw e;
            }
            catch (Throwable e) {
                SystemFailure.checkFailure();
                if (!logger.isDebugEnabled()) return;
                logger.debug("An exception occurred while fetching metadata", e);
                return;
            }
        }
        Object e = this.fetchTaskCountLock;
        synchronized (e) {
            ++this.refreshTaskCount;
        }
        Runnable fetchTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ClientMetadataService.this.getClientPRMetadata(region);
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure(e);
                    throw e;
                }
                catch (Throwable e) {
                    SystemFailure.checkFailure();
                    if (logger.isDebugEnabled()) {
                        logger.debug("An exception occurred while fetching metadata", e);
                    }
                }
                finally {
                    Object object = ClientMetadataService.this.fetchTaskCountLock;
                    synchronized (object) {
                        ClientMetadataService.this.refreshTaskCount--;
                    }
                }
            }
        };
        SingleHopClientExecutor.submitTask(fetchTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void getClientPRMetadata(LocalRegion region) {
        String regionFullPath = region.getFullPath();
        ClientPartitionAdvisor advisor = null;
        InternalPool pool = region.getServerProxy().getPool();
        if (region.clientMetaDataLock.tryLock()) {
            try {
                advisor = this.getClientPartitionAdvisor(regionFullPath);
                if (advisor == null) {
                    advisor = GetClientPartitionAttributesOp.execute(pool, regionFullPath);
                    if (advisor == null) {
                        this.nonPRs.add(regionFullPath);
                        return;
                    }
                    this.addClientPartitionAdvisor(regionFullPath, advisor);
                } else if (advisor.getFixedPAMap() != null && !advisor.isFPAAttrsComplete()) {
                    ClientPartitionAdvisor newAdvisor = GetClientPartitionAttributesOp.execute(pool, regionFullPath);
                    advisor.updateFixedPAMap(newAdvisor.getFixedPAMap());
                }
                String colocatedWith = advisor.getColocatedWith();
                if (colocatedWith == null) {
                    this.isMetadataRefreshed_TEST_ONLY = true;
                    GetClientPRMetaDataOp.execute(pool, regionFullPath, this);
                    region.getCachePerfStats().incMetaDataRefreshCount();
                } else {
                    ClientPartitionAdvisor colocatedAdvisor = this.getClientPartitionAdvisor(colocatedWith);
                    LocalRegion leaderRegion = (LocalRegion)region.getCache().getRegion(colocatedWith);
                    if (colocatedAdvisor == null) {
                        this.scheduleGetPRMetaData(leaderRegion, true);
                        return;
                    }
                    this.isMetadataRefreshed_TEST_ONLY = true;
                    GetClientPRMetaDataOp.execute(pool, colocatedWith, this);
                    leaderRegion.getCachePerfStats().incMetaDataRefreshCount();
                }
            }
            finally {
                region.clientMetaDataLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void scheduleGetPRMetaData(final LocalRegion region, boolean isRecursive, byte nwHopType) {
        if (this.nonPRs.contains(region.getFullPath())) {
            return;
        }
        ClientPartitionAdvisor advisor = this.getClientPartitionAdvisor(region.getFullPath());
        if (advisor != null && advisor.getServerGroup().length() != 0 && this.HONOUR_SERVER_GROUP_IN_PR_SINGLE_HOP) {
            if (logger.isDebugEnabled()) {
                logger.debug("Scheduling metadata refresh: {} region: {}", (Object)nwHopType, (Object)region.getName());
            }
            if (nwHopType == 2) {
                return;
            }
        }
        Object object = this.fetchTaskCountLock;
        synchronized (object) {
            if (this.regionsBeingRefreshed.contains(region.getFullPath())) {
                return;
            }
        }
        if (isRecursive) {
            try {
                this.getClientPRMetadata(region);
                return;
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure(e);
                throw e;
            }
            catch (Throwable e) {
                SystemFailure.checkFailure();
                if (!logger.isDebugEnabled()) return;
                logger.debug("An exception occurred while fetching metadata", e);
                return;
            }
        }
        Object e = this.fetchTaskCountLock;
        synchronized (e) {
            if (this.regionsBeingRefreshed.contains(region.getFullPath())) {
                return;
            }
            this.regionsBeingRefreshed.add(region.getFullPath());
            ++this.refreshTaskCount;
        }
        Runnable fetchTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ClientMetadataService.this.getClientPRMetadata(region);
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure(e);
                    throw e;
                }
                catch (Throwable e) {
                    SystemFailure.checkFailure();
                    if (logger.isDebugEnabled()) {
                        logger.debug("An exception occurred while fetching metadata", e);
                    }
                }
                finally {
                    Object object = ClientMetadataService.this.fetchTaskCountLock;
                    synchronized (object) {
                        ClientMetadataService.this.regionsBeingRefreshed.remove(region.getFullPath());
                        ClientMetadataService.this.refreshTaskCount--;
                    }
                }
            }
        };
        SingleHopClientExecutor.submitTask(fetchTask);
    }

    public void removeBucketServerLocation(ServerLocation serverLocation) {
        Set<String> keys = this.getAllRegionFullPaths();
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("ClientMetadataService removing a ServerLocation :{}{}", (Object)serverLocation, (Object)keys);
        }
        if (keys != null) {
            for (String regionPath : keys) {
                ClientPartitionAdvisor prAdvisor = this.getClientPartitionAdvisor(regionPath);
                if (isDebugEnabled) {
                    logger.debug("ClientMetadataService removing from {}{}", (Object)regionPath, (Object)prAdvisor);
                }
                if (prAdvisor == null) continue;
                prAdvisor.removeBucketServerLocation(serverLocation);
            }
        }
    }

    public byte getMetaDataVersion(Region region, Operation operation, Object key, Object value, Object callbackArg) {
        int bucketId;
        Object resolveKey;
        ClientPartitionAdvisor prAdvisor = this.getClientPartitionAdvisor(region.getFullPath());
        if (prAdvisor == null) {
            return 0;
        }
        int totalNumberOfBuckets = prAdvisor.getTotalNumBuckets();
        PartitionResolver resolver = this.getResolver(region, key, callbackArg);
        EntryOperationImpl entryOp = null;
        if (resolver == null) {
            resolveKey = key;
        } else {
            entryOp = new EntryOperationImpl(region, operation, key, value, callbackArg);
            resolveKey = resolver.getRoutingObject(entryOp);
            if (resolveKey == null) {
                throw new IllegalStateException(LocalizedStrings.PartitionedRegionHelper_THE_ROUTINGOBJECT_RETURNED_BY_PARTITIONRESOLVER_IS_NULL.toLocalizedString());
            }
        }
        if (resolver instanceof FixedPartitionResolver) {
            String partition;
            if (entryOp == null) {
                entryOp = new EntryOperationImpl(region, Operation.FUNCTION_EXECUTION, key, null, null);
            }
            if ((partition = ((FixedPartitionResolver)resolver).getPartitionName(entryOp, prAdvisor.getFixedPartitionNames())) == null) {
                Object[] prms = new Object[]{region.getName(), resolver};
                throw new IllegalStateException(LocalizedStrings.PartitionedRegionHelper_FOR_REGION_0_PARTITIONRESOLVER_1_RETURNED_PARTITION_NAME_NULL.toLocalizedString(prms));
            }
            bucketId = prAdvisor.assignFixedBucketId(region, partition, resolveKey);
        } else {
            bucketId = PartitionedRegionHelper.getHashKey(resolveKey, totalNumberOfBuckets);
        }
        BucketServerLocation66 bsl = (BucketServerLocation66)this.getPrimaryServerLocation(region, bucketId);
        if (bsl == null) {
            return 0;
        }
        return bsl.getVersion();
    }

    private ServerLocation getPrimaryServerLocation(Region region, int bucketId) {
        String regionFullPath = region.getFullPath();
        ClientPartitionAdvisor prAdvisor = this.getClientPartitionAdvisor(regionFullPath);
        if (prAdvisor == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("ClientMetadataService#getServerLocation : Region {} prAdvisor does not exist.", (Object)regionFullPath);
            }
            return null;
        }
        if (prAdvisor.getColocatedWith() != null && (prAdvisor = this.getClientPartitionAdvisor(prAdvisor.getColocatedWith())) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("ClientMetadataService#getServerLocation : Region {} prAdvisor does not exist.", (Object)regionFullPath);
            }
            return null;
        }
        return prAdvisor.advisePrimaryServerLocation(bucketId);
    }

    private void addClientPartitionAdvisor(String regionFullPath, ClientPartitionAdvisor advisor) {
        if (this.cache.isClosed() || this.clientPRAdvisors == null) {
            return;
        }
        try {
            this.clientPRAdvisors.put(regionFullPath, advisor);
            if (advisor.getColocatedWith() != null) {
                String parentRegionPath = advisor.getColocatedWith();
                Set<ClientPartitionAdvisor> colocatedAdvisors = this.colocatedPRAdvisors.get(parentRegionPath);
                if (colocatedAdvisors == null) {
                    colocatedAdvisors = new CopyOnWriteArraySet<ClientPartitionAdvisor>();
                    this.colocatedPRAdvisors.put(parentRegionPath, colocatedAdvisors);
                }
                colocatedAdvisors.add(advisor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ClientPartitionAdvisor getClientPartitionAdvisor(String regionFullPath) {
        if (this.cache.isClosed() || this.clientPRAdvisors == null) {
            return null;
        }
        ClientPartitionAdvisor prAdvisor = null;
        try {
            prAdvisor = this.clientPRAdvisors.get(regionFullPath);
        }
        catch (Exception npe) {
            return null;
        }
        return prAdvisor;
    }

    public Set<ClientPartitionAdvisor> getColocatedClientPartitionAdvisor(String regionFullPath) {
        if (this.cache.isClosed() || this.clientPRAdvisors == null || this.colocatedPRAdvisors == null) {
            return null;
        }
        return this.colocatedPRAdvisors.get(regionFullPath);
    }

    private Set<String> getAllRegionFullPaths() {
        if (this.cache.isClosed() || this.clientPRAdvisors == null) {
            return null;
        }
        Set<String> keys = null;
        try {
            keys = this.clientPRAdvisors.keySet();
        }
        catch (Exception npe) {
            return null;
        }
        return keys;
    }

    public void close() {
        this.clientPRAdvisors.clear();
        this.colocatedPRAdvisors.clear();
    }

    public boolean isRefreshMetadataTestOnly() {
        return this.isMetadataRefreshed_TEST_ONLY;
    }

    public void satisfyRefreshMetadata_TEST_ONLY(boolean isRefreshMetadataTestOnly) {
        this.isMetadataRefreshed_TEST_ONLY = isRefreshMetadataTestOnly;
    }

    public Map<String, ClientPartitionAdvisor> getClientPRMetadata_TEST_ONLY() {
        return this.clientPRAdvisors;
    }

    public Map<String, ClientPartitionAdvisor> getClientPartitionAttributesMap() {
        return this.clientPRAdvisors;
    }

    public boolean honourServerGroup() {
        return this.HONOUR_SERVER_GROUP_IN_PR_SINGLE_HOP;
    }

    public boolean isMetadataStable() {
        return this.isMetadataStable;
    }

    public void setMetadataStable(boolean isMetadataStable) {
        this.isMetadataStable = isMetadataStable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRefreshTaskCount() {
        Object object = this.fetchTaskCountLock;
        synchronized (object) {
            return this.refreshTaskCount;
        }
    }
}

